/*
 * Copyright © 2021-present Arcade Data Ltd (info@arcadedata.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-FileCopyrightText: 2021-present Arcade Data Ltd (info@arcadedata.com)
 * SPDX-License-Identifier: Apache-2.0
 */
/* Generated By:JJTree: Do not edit this line. OContainsValueCondition.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=false,VISITOR=true,TRACK_TOKENS=true,NODE_PREFIX=O,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_USERTYPE_VISIBILITY_PUBLIC=true */
package com.arcadedb.query.sql.parser;

import com.arcadedb.database.Identifiable;
import com.arcadedb.query.sql.executor.CommandContext;
import com.arcadedb.query.sql.executor.IndexSearchInfo;
import com.arcadedb.query.sql.executor.Result;

import java.util.*;

public class ContainsValueCondition extends BooleanExpression {
  protected Expression            left;
  protected ContainsValueOperator operator;
  protected OrBlock               condition;
  protected Expression            expression;

  public ContainsValueCondition(final int id) {
    super(id);
  }

  @Override
  public Boolean evaluate(final Identifiable currentRecord, final CommandContext context) {
    final Object leftValue = left.execute(currentRecord, context);
    if (leftValue instanceof Map) {
      final Map map = (Map) leftValue;
      if (condition != null) {
        for (final Object o : map.values()) {
          if (condition.evaluate(o, context)) {
            return true;
          }
        }
        return false;
      } else {
        final Object rightValue = expression.execute(currentRecord, context);
        return map.containsValue(rightValue);//TODO type conversions...?
      }

    }
    return false;
  }

  @Override
  public Boolean evaluate(final Result currentRecord, final CommandContext context) {
    final Object leftValue = left.execute(currentRecord, context);
    if (leftValue instanceof Map) {
      final Map map = (Map) leftValue;
      if (condition != null) {
        for (final Object o : map.values()) {
          if (condition.evaluate(o, context)) {
            return true;
          }
        }
        return false;
      } else {
        final Object rightValue = expression.execute(currentRecord, context);
        return map.containsValue(rightValue);//TODO type conversions...?
      }

    }
    return false;
  }

  public void toString(final Map<String, Object> params, final StringBuilder builder) {
    left.toString(params, builder);
    builder.append(" CONTAINSVALUE ");
    if (condition != null) {
      builder.append("(");
      condition.toString(params, builder);
      builder.append(")");
    } else {
      expression.toString(params, builder);
    }
  }

  @Override
  public ContainsValueCondition copy() {
    final ContainsValueCondition result = new ContainsValueCondition(-1);
    result.left = left.copy();
    result.operator = operator;
    result.condition = condition == null ? null : condition.copy();
    result.expression = expression == null ? null : expression.copy();
    return result;
  }

  @Override
  public void extractSubQueries(final SubQueryCollector collector) {
    left.extractSubQueries(collector);
    if (condition != null)
      condition.extractSubQueries(collector);

    if (expression != null)
      expression.extractSubQueries(collector);
  }

  @Override
  protected Object[] getIdentityElements() {
    return new Object[] { left, operator, condition, expression };
  }

  @Override
  public List<String> getMatchPatternInvolvedAliases() {
    final List<String> leftX = left == null ? null : left.getMatchPatternInvolvedAliases();
    final List<String> expressionX = expression == null ? null : expression.getMatchPatternInvolvedAliases();
    final List<String> conditionX = condition == null ? null : condition.getMatchPatternInvolvedAliases();

    final List<String> result = new ArrayList<String>();
    if (leftX != null)
      result.addAll(leftX);

    if (expressionX != null)
      result.addAll(expressionX);

    if (conditionX != null)
      result.addAll(conditionX);

    return result.isEmpty() ? null : result;
  }

  @Override
  protected SimpleNode[] getCacheableElements() {
    return new SimpleNode[] { left, condition, expression };
  }

  public boolean isIndexAware(final IndexSearchInfo info) {
    if (left.isBaseIdentifier()) {
      if (info.getField().equals(left.getDefaultAlias().getStringValue())) {
        return expression != null && expression.isEarlyCalculated(info.getContext()) && info.isMap() && info.isIndexByValue();
      }
    }
    return false;
  }
}
/* JavaCC - OriginalChecksum=6fda752f10c8d8731f43efa706e39459 (do not edit this line) */
