/*
 * Copyright © 2021-present Arcade Data Ltd (info@arcadedata.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-FileCopyrightText: 2021-present Arcade Data Ltd (info@arcadedata.com)
 * SPDX-License-Identifier: Apache-2.0
 */
/* Generated By:JJTree: Do not edit this line. OContainsCondition.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=false,VISITOR=true,TRACK_TOKENS=true,NODE_PREFIX=O,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_USERTYPE_VISIBILITY_PUBLIC=true */
package com.arcadedb.query.sql.parser;

import com.arcadedb.database.Identifiable;
import com.arcadedb.query.sql.executor.CommandContext;
import com.arcadedb.query.sql.executor.IndexSearchInfo;
import com.arcadedb.query.sql.executor.MultiValue;
import com.arcadedb.query.sql.executor.QueryOperatorEquals;
import com.arcadedb.query.sql.executor.Result;
import com.arcadedb.query.sql.executor.ResultInternal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ContainsCondition extends BooleanExpression {

  protected Expression        left;
  protected Expression        right;
  protected BooleanExpression condition;

  public ContainsCondition(final int id) {
    super(id);
  }

  public boolean execute(final Object left, Object right) {
    if (left instanceof Collection) {
      if (right instanceof Collection) {
        if (((Collection<?>) right).size() == 1) {
          Object item = ((Collection<?>) right).iterator().next();
          if (item instanceof Result && ((Result) item).getPropertyNames().size() == 1) {
            final Object propValue = ((Result) item).getProperty(((Result) item).getPropertyNames().iterator().next());
            if (((Collection<?>) left).contains(propValue))
              return true;
          }
          if (((Collection<?>) left).contains(item))
            return true;

          if (item instanceof Result)
            item = ((Result) item).getElement().orElse(null);

          if (item instanceof Identifiable && ((Collection<?>) left).contains(item))
            return true;
        }

        return MultiValue.contains(left, right);
      }

      if (right instanceof Iterable)
        right = ((Iterable<?>) right).iterator();

      if (right instanceof Iterator<?> iterator) {
        while (iterator.hasNext()) {
          final Object next = iterator.next();
          if (!((Collection<?>) left).contains(next))
            return false;
        }
      }
      for (final Object o : (Collection<?>) left) {
        if (equalsInContainsSpace(o, right))
          return true;
      }
      return false;
    }

    Iterator<?> leftIterator = null;
    if (left instanceof Iterable)
      leftIterator = ((Iterable<?>) left).iterator();
    else if (left instanceof Iterator)
      leftIterator = (Iterator<?>) left;

    if (leftIterator != null) {
      if (!(right instanceof Iterable))
        right = Collections.singleton(right);

      right = ((Iterable<?>) right).iterator();

      final Iterator<?> rightIterator = (Iterator<?>) right;
      while (rightIterator.hasNext()) {
        final Object leftItem = rightIterator.next();
        boolean found = false;
        while (leftIterator.hasNext()) {
          final Object rightItem = leftIterator.next();
          if ((leftItem != null && leftItem.equals(rightItem)) || (leftItem == null && rightItem == null)) {
            found = true;
            break;
          }
        }

        if (!found)
          return false;

        // here left iterator should go from beginning, that can be done only for iterable
        // if left at input is iterator result can be invalid
        // TODO what if left is Iterator!!!???, should we make temporary Collection , to be able to
        // iterate from beginning
        if (left instanceof Iterable)
          leftIterator = ((Iterable<?>) left).iterator();
      }
      return true;
    }
    return false;
  }

  private boolean equalsInContainsSpace(final Object left, final Object right) {
    if (left == null && right == null)
      return true;
    else
      return QueryOperatorEquals.equals(left, right);
  }

  @Override
  public Boolean evaluate(final Identifiable currentRecord, final CommandContext context) {
    final Object leftValue = left.execute(currentRecord, context);
    if (right != null) {
      final Object rightValue = right.execute(currentRecord, context);
      return execute(leftValue, rightValue);
    } else {
      if (!MultiValue.isMultiValue(leftValue))
        return false;

      final Iterator<?> iter = MultiValue.getMultiValueIterator(leftValue);
      while (iter.hasNext()) {
        final Object item = iter.next();
        if (item instanceof Identifiable && condition.evaluate((Identifiable) item, context))
          return true;
        else if (item instanceof Result && condition.evaluate((Result) item, context))
          return true;
        else if (item instanceof Map && condition.evaluate(new ResultInternal((Map) item), context))
          return true;
      }
      return false;
    }
  }

  @Override
  public Boolean evaluate(final Result currentRecord, final CommandContext context) {
    final Object leftValue = left.execute(currentRecord, context);
    if (right != null) {
      final Object rightValue = right.execute(currentRecord, context);
      return execute(leftValue, rightValue);
    } else {
      if (!MultiValue.isMultiValue(leftValue))
        return false;

      final Iterator<?> iter = MultiValue.getMultiValueIterator(leftValue);
      while (iter.hasNext()) {
        final Object item = iter.next();
        if (item instanceof Identifiable && condition.evaluate((Identifiable) item, context))
          return true;
        else if (item instanceof Result && condition.evaluate((Result) item, context))
          return true;
        else if (item instanceof Map && condition.evaluate(new ResultInternal((Map) item), context))
          return true;
        else if (condition.evaluate(new ResultInternal(item), context))
          return true;
      }
      return false;
    }
  }

  public void toString(final Map<String, Object> params, final StringBuilder builder) {
    left.toString(params, builder);
    builder.append(" CONTAINS ");
    if (right != null) {
      right.toString(params, builder);
    } else if (condition != null) {
      builder.append("(");
      condition.toString(params, builder);
      builder.append(")");
    }
  }

  @Override
  public ContainsCondition copy() {
    final ContainsCondition result = new ContainsCondition(-1);
    result.left = left == null ? null : left.copy();
    result.right = right == null ? null : right.copy();
    result.condition = condition == null ? null : condition.copy();
    return result;
  }

  @Override
  public void extractSubQueries(final SubQueryCollector collector) {
    if (left != null)
      left.extractSubQueries(collector);

    if (right != null)
      right.extractSubQueries(collector);

    if (condition != null)
      condition.extractSubQueries(collector);
  }

  @Override
  protected Object[] getIdentityElements() {
    return new Object[] { left, right, condition };
  }

  @Override
  public List<String> getMatchPatternInvolvedAliases() {
    final List<String> leftX = left == null ? null : left.getMatchPatternInvolvedAliases();
    final List<String> rightX = right == null ? null : right.getMatchPatternInvolvedAliases();
    final List<String> conditionX = condition == null ? null : condition.getMatchPatternInvolvedAliases();

    final List<String> result = new ArrayList<>();
    if (leftX != null)
      result.addAll(leftX);

    if (rightX != null)
      result.addAll(rightX);

    if (conditionX != null)
      result.addAll(conditionX);

    return result.isEmpty() ? null : result;
  }

  @Override
  protected SimpleNode[] getCacheableElements() {
    return new SimpleNode[] { left, right, condition };
  }

  public boolean isIndexAware(final IndexSearchInfo info) {
    if (left.isBaseIdentifier()) {
      if (info.getField().equals(left.getDefaultAlias().getStringValue())) {
        if (right != null)
          return right.isEarlyCalculated(info.getContext());
      }
    }
    return false;
  }
}
/* JavaCC - OriginalChecksum=bad1118296ea74860e88d66bfe9fa222 (do not edit this line) */
