/*
 * Copyright © 2021-present Arcade Data Ltd (info@arcadedata.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-FileCopyrightText: 2021-present Arcade Data Ltd (info@arcadedata.com)
 * SPDX-License-Identifier: Apache-2.0
 */
/* Generated By:JJTree: Do not edit this line. OBaseIdentifier.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=false,VISITOR=true,TRACK_TOKENS=true,NODE_PREFIX=O,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_USERTYPE_VISIBILITY_PUBLIC=true */
package com.arcadedb.query.sql.parser;

import com.arcadedb.database.Record;
import com.arcadedb.exception.CommandExecutionException;
import com.arcadedb.query.sql.executor.AggregationContext;
import com.arcadedb.query.sql.executor.CommandContext;
import com.arcadedb.query.sql.executor.Result;
import com.arcadedb.query.sql.executor.ResultInternal;

import java.util.*;

public class BaseIdentifier extends SimpleNode {

  protected LevelZeroIdentifier levelZero;
  protected SuffixIdentifier    suffix;

  public BaseIdentifier(final int id) {
    super(id);
  }

  public BaseIdentifier(final Identifier identifier) {
    this.suffix = new SuffixIdentifier(identifier);
  }

  public BaseIdentifier(final RecordAttribute attr) {
    this.suffix = new SuffixIdentifier(attr);
  }

  public void toString(final Map<String, Object> params, final StringBuilder builder) {
    if (levelZero != null)
      levelZero.toString(params, builder);
    else if (suffix != null)
      suffix.toString(params, builder);
  }

  public Object execute(final Record iCurrentRecord, final CommandContext context) {
    if (levelZero != null)
      return levelZero.execute(iCurrentRecord, context);
    if (suffix != null)
      return suffix.execute(iCurrentRecord, context);
    return null;
  }

  public Object execute(final Result iCurrentRecord, final CommandContext context) {
    if (levelZero != null)
      return levelZero.execute(iCurrentRecord, context);
    if (suffix != null)
      return suffix.execute(iCurrentRecord, context);
    return null;
  }

  public boolean isIndexedFunctionCall(final CommandContext context) {
    if (levelZero != null)
      return levelZero.isIndexedFunctionCall(context);
    return false;
  }

  public long estimateIndexedFunction(final FromClause target, final CommandContext context, final BinaryCompareOperator operator, final Object right) {
    if (levelZero != null)
      return levelZero.estimateIndexedFunction(target, context, operator, right);
    return -1;
  }

  public Iterable<Record> executeIndexedFunction(final FromClause target, final CommandContext context, final BinaryCompareOperator operator,
      final Object right) {
    if (levelZero != null)
      return levelZero.executeIndexedFunction(target, context, operator, right);
    return null;
  }

  /**
   * tests if current expression is an indexed function AND that function can also be executed without using the index
   *
   * @param target   the query target
   * @param context  the execution context
   * @param operator
   * @param right
   *
   * @return true if current expression is an indexed function AND that function can also be executed without using the index, false
   * otherwise
   */
  public boolean canExecuteIndexedFunctionWithoutIndex(final FromClause target, final CommandContext context, final BinaryCompareOperator operator,
      final Object right) {
    if (this.levelZero == null)
      return false;
    return levelZero.canExecuteIndexedFunctionWithoutIndex(target, context, operator, right);
  }

  /**
   * tests if current expression is an indexed function AND that function can be used on this target
   *
   * @param target   the query target
   * @param context  the execution context
   * @param operator
   * @param right
   *
   * @return true if current expression involves an indexed function AND that function can be used on this target, false otherwise
   */
  public boolean allowsIndexedFunctionExecutionOnTarget(final FromClause target, final CommandContext context, final BinaryCompareOperator operator,
      final Object right) {
    if (this.levelZero == null)
      return false;
    return levelZero.allowsIndexedFunctionExecutionOnTarget(target, context, operator, right);
  }

  /**
   * tests if current expression is an indexed function AND the function has also to be executed after the index search. In some
   * cases, the index search is accurate, so this condition can be excluded from further evaluation. In other cases the result from
   * the index is a superset of the expected result, so the function has to be executed anyway for further filtering
   *
   * @param target  the query target
   * @param context the execution context
   *
   * @return true if current expression is an indexed function AND the function has also to be executed after the index search.
   */
  public boolean executeIndexedFunctionAfterIndexSearch(final FromClause target, final CommandContext context, final BinaryCompareOperator operator,
      final Object right) {
    if (this.levelZero == null)
      return false;
    return levelZero.executeIndexedFunctionAfterIndexSearch(target, context, operator, right);
  }

  public boolean isBaseIdentifier() {
    return suffix != null && suffix.isBaseIdentifier();
  }

  public boolean isExpand() {
    if (levelZero != null)
      return levelZero.isExpand();
    return false;
  }

  public Expression getExpandContent() {
    return levelZero.getExpandContent();
  }

  public boolean isAggregate(final CommandContext context) {
    if (levelZero != null && levelZero.isAggregate(context))
      return true;
    return suffix != null && suffix.isAggregate(context);
  }

  public boolean isCount() {
    if (levelZero != null && levelZero.isCount())
      return true;
    return suffix != null && suffix.isCount();
  }

  public boolean isEarlyCalculated(final CommandContext context) {
    if (levelZero != null && levelZero.isEarlyCalculated(context))
      return true;
    return suffix != null && suffix.isEarlyCalculated(context);
  }

  public SimpleNode splitForAggregation(final AggregateProjectionSplit aggregateProj, final CommandContext context) {
    if (isAggregate(context)) {
      final BaseIdentifier result = new BaseIdentifier(-1);
      if (levelZero != null) {
        final SimpleNode splitResult = levelZero.splitForAggregation(aggregateProj, context);
        if (splitResult instanceof LevelZeroIdentifier) {
          result.levelZero = (LevelZeroIdentifier) splitResult;
        } else {
          return splitResult;
        }
      } else if (suffix != null) {
        result.suffix = suffix.splitForAggregation(aggregateProj);
      } else {
        throw new IllegalStateException();
      }
      return result;
    } else {
      return this;
    }
  }

  public AggregationContext getAggregationContext(final CommandContext context) {
    if (isAggregate(context)) {
      if (levelZero != null)
        return levelZero.getAggregationContext(context);
      else if (suffix != null)
        return suffix.getAggregationContext(context);
      else
        throw new CommandExecutionException("cannot aggregate on " + this);
    } else {
      throw new CommandExecutionException("cannot aggregate on " + this);
    }
  }

  public void setLevelZero(final LevelZeroIdentifier levelZero) {
    this.levelZero = levelZero;
  }

  public BaseIdentifier copy() {
    final BaseIdentifier result = new BaseIdentifier(-1);
    result.levelZero = levelZero == null ? null : levelZero.copy();
    result.suffix = suffix == null ? null : suffix.copy();
    return result;
  }

  public SuffixIdentifier getSuffix() {
    return suffix;
  }

  public LevelZeroIdentifier getLevelZero() {
    return levelZero;
  }

  public void applyRemove(final ResultInternal result, final CommandContext context) {
    if (suffix != null)
      suffix.applyRemove(result, context);
    else
      throw new CommandExecutionException("cannot apply REMOVE " + this);
  }

  public boolean isDefinedFor(final Result currentRecord) {
    if (suffix != null)
      return suffix.isDefinedFor(currentRecord);
    return true;
  }

  public boolean isDefinedFor(final Record currentRecord) {
    if (suffix != null)
      return suffix.isDefinedFor(currentRecord);
    return true;
  }

  public void extractSubQueries(final Identifier letAlias, final SubQueryCollector collector) {
    if (this.levelZero != null)
      this.levelZero.extractSubQueries(letAlias, collector);
  }

  public void extractSubQueries(final SubQueryCollector collector) {
    if (this.levelZero != null)
      this.levelZero.extractSubQueries(collector);
  }

  @Override
  protected Object[] getIdentityElements() {
    return getCacheableElements();
  }

  @Override
  protected SimpleNode[] getCacheableElements() {
    return new SimpleNode[] { levelZero, suffix };
  }
}
/* JavaCC - OriginalChecksum=ed89af10d8be41a83428c5608a4834f6 (do not edit this line) */
