/*
 * Copyright © 2021-present Arcade Data Ltd (info@arcadedata.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-FileCopyrightText: 2021-present Arcade Data Ltd (info@arcadedata.com)
 * SPDX-License-Identifier: Apache-2.0
 */
/* Generated By:JJTree: Do not edit this line. OAlterDatabaseStatement.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=false,VISITOR=true,TRACK_TOKENS=true,NODE_PREFIX=O,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_USERTYPE_VISIBILITY_PUBLIC=true */
package com.arcadedb.query.sql.parser;

import com.arcadedb.GlobalConfiguration;
import com.arcadedb.database.DatabaseInternal;
import com.arcadedb.database.Identifiable;
import com.arcadedb.exception.CommandExecutionException;
import com.arcadedb.exception.DatabaseOperationException;
import com.arcadedb.query.sql.executor.CommandContext;
import com.arcadedb.query.sql.executor.InternalResultSet;
import com.arcadedb.query.sql.executor.Result;
import com.arcadedb.query.sql.executor.ResultInternal;
import com.arcadedb.query.sql.executor.ResultSet;
import com.arcadedb.schema.LocalSchema;
import com.arcadedb.security.SecurityDatabaseUser;
import com.arcadedb.utility.FileUtils;

import java.io.*;
import java.util.*;

public class AlterDatabaseStatement extends DDLStatement {

  Identifier settingName;
  Expression settingValue;

  public AlterDatabaseStatement(final int id) {
    super(id);
  }

  @Override
  public ResultSet executeDDL(final CommandContext context) {
    final InternalResultSet result = new InternalResultSet();
    result.add(executeSimpleAlter(settingName, settingValue, context));
    return result;
  }

  private Result executeSimpleAlter(final Identifier settingName, final Expression settingValue, final CommandContext context) {
    final DatabaseInternal db = context.getDatabase();
    db.checkPermissionsOnDatabase(SecurityDatabaseUser.DATABASE_ACCESS.UPDATE_DATABASE_SETTINGS);

    final String settingNameAsString = settingName.getStringValue();
    final GlobalConfiguration cfg = GlobalConfiguration.findByKey(settingNameAsString);
    if (cfg == null)
      throw new DatabaseOperationException("Database setting '" + settingNameAsString + "' not found");

    final Object oldValue = db.getConfiguration().getValue(cfg);
    Object finalValue = settingValue.execute((Identifiable) null, context);

    boolean saveInDatabaseConfiguration = false;

    switch (cfg) {
    case DATE_FORMAT:
      db.getSchema().setDateFormat(finalValue.toString());
      ((LocalSchema) db.getSchema()).saveConfiguration();
      break;
    case DATE_TIME_FORMAT:
      db.getSchema().setDateTimeFormat(finalValue.toString());
      ((LocalSchema) db.getSchema()).saveConfiguration();
      break;
    case DATE_IMPLEMENTATION:
      try {
        finalValue = FileUtils.getStringContent(settingValue);
        context.getDatabase().getSerializer().setDateImplementation(Class.forName(finalValue.toString()));
        saveInDatabaseConfiguration = true;
      } catch (ClassNotFoundException e) {
        throw new DatabaseOperationException("Invalid datetime implementation '" + finalValue + "'", e);
      }
      break;
    case DATE_TIME_IMPLEMENTATION:
      try {
        finalValue = FileUtils.getStringContent(settingValue);
        context.getDatabase().getSerializer().setDateTimeImplementation(Class.forName(finalValue.toString()));
        saveInDatabaseConfiguration = true;
      } catch (ClassNotFoundException e) {
        throw new DatabaseOperationException("Invalid datetime implementation '" + finalValue + "'", e);
      }
      break;
    default:
      saveInDatabaseConfiguration = true;
    }

    if (saveInDatabaseConfiguration) {
      db.getConfiguration().setValue(cfg, finalValue);
      try {
        db.saveConfiguration();
      } catch (final IOException e) {
        throw new CommandExecutionException("Error on saving database configuration");
      }
    }

    final ResultInternal result = new ResultInternal(context.getDatabase());
    result.setProperty("operation", "alter database");
    result.setProperty("attribute", settingNameAsString);
    result.setProperty("oldValue", oldValue);
    result.setProperty("newValue", finalValue);
    return result;
  }

  @Override
  public void toString(final Map<String, Object> params, final StringBuilder builder) {
    builder.append("ALTER DATABASE ");
    settingName.toString(params, builder);
    builder.append(" ");
    settingValue.toString(params, builder);
  }

  @Override
  public AlterDatabaseStatement copy() {
    final AlterDatabaseStatement result = new AlterDatabaseStatement(-1);
    result.settingName = settingName == null ? null : settingName.copy();
    result.settingValue = settingValue == null ? null : settingValue.copy();
    return result;
  }

  @Override
  protected Object[] getIdentityElements() {
    return new Object[] { settingName, settingValue };
  }

}
/* JavaCC - OriginalChecksum=8fec57db8dd2a3b52aaa52dec7367cd4 (do not edit this line) */
