/*
 * Copyright © 2021-present Arcade Data Ltd (info@arcadedata.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-FileCopyrightText: 2021-present Arcade Data Ltd (info@arcadedata.com)
 * SPDX-License-Identifier: Apache-2.0
 */
/* Generated By:JJTree: Do not edit this line. OAlterClusterStatement.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=false,VISITOR=true,TRACK_TOKENS=true,NODE_PREFIX=O,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_USERTYPE_VISIBILITY_PUBLIC=true */
package com.arcadedb.query.sql.parser;

import com.arcadedb.query.sql.executor.CommandContext;
import com.arcadedb.query.sql.executor.ResultSet;

import java.util.*;

public class AlterBucketStatement extends DDLStatement {

  protected Identifier name;
  protected boolean    starred = false;
  protected Identifier attributeName;
  protected Expression attributeValue;

  public AlterBucketStatement(final int id) {
    super(id);
  }

  @Override
  public void toString(final Map<String, Object> params, final StringBuilder builder) {
    builder.append("ALTER BUCKET ");
    name.toString(params, builder);
    if (starred) {
      builder.append("*");
    }
    builder.append(" ");
    attributeName.toString(params, builder);
    builder.append(" ");
    attributeValue.toString(params, builder);
  }

  @Override
  public AlterBucketStatement copy() {
    final AlterBucketStatement result = new AlterBucketStatement(-1);
    result.name = name == null ? null : name.copy();
    result.attributeName = attributeName == null ? null : attributeName.copy();
    result.starred = starred;
    result.attributeValue = attributeValue == null ? null : attributeValue.copy();
    return result;
  }

  @Override
  public ResultSet executeDDL(final CommandContext context) {
//    InternalResultSet result = new InternalResultSet();
//    List<com.orientechnologies.orient.core.storage.OCluster> clustersToUpdate = getClusters(context);
//    Object finalValue = attributeValue.execute((PIdentifiable) null, context);
//
//    com.orientechnologies.orient.core.storage.OCluster.ATTRIBUTES attribute;
//    try {
//      attribute = OCluster.ATTRIBUTES.valueOf(attributeName.getStringValue());
//    } catch (IllegalArgumentException e) {
//      throw OException.wrapException(new PCommandExecutionException(
//          "Unknown class attribute '" + attributeName + "'. Supported attributes are: " + Arrays
//              .toString(OCluster.ATTRIBUTES.values())), e);
//    }
//
//    for (com.orientechnologies.orient.core.storage.OCluster bucket : clustersToUpdate) {
//      if (attributeName.getStringValue().equalsIgnoreCase("status") || attributeName.getStringValue().equalsIgnoreCase("name"))
//        // REMOVE CACHE OF COMMAND RESULTS IF ACTIVE
//        getDatabase().getMetadata().getCommandCache().invalidateResultsOfCluster(bucket.getName());
//      try {
//        bucket.set(attribute, finalValue);
//      } catch (IOException e) {
//        OException.wrapException(new PCommandExecutionException("Cannot execute alter cluster"), e);
//      }
//      OResultInternal resultItem = new OResultInternal();
//      resultItem.setProperty("cluster", bucket.getName());
//      result.add(resultItem);
//    }

//    return result;
    throw new UnsupportedOperationException();
  }

  //  private OCluster.ATTRIBUTES getClusterAttribute(OIdentifier attributeName) {
//    return null;
//  }
//
//  private List<com.orientechnologies.orient.core.storage.OCluster> getClusters(OCommandContext context) {
//    OStorage storage = ((ODatabaseDocumentInternal) context.getDatabase()).getStorage();
//    if (starred) {
//      List<com.orientechnologies.orient.core.storage.OCluster> result = new ArrayList<>();
//      for (String bucketName : storage.getClusterNames()) {
//        if (bucketName.startsWith(name.getStringValue())) {
//          result.add(storage.getClusterByName(bucketName));
//        }
//      }
//      return result;
//    } else {
//      int bucketId = context.getDatabase().getClusterIdByName(name.getStringValue());
//      if (bucketId <= 0) {
//        throw new PCommandExecutionException("Cannot find bucket " + name);
//      }
//      com.orientechnologies.orient.core.storage.OCluster bucket = storage.getClusterById(bucketId);
//      return Collections.singletonList(bucket);
//    }
//  }
  @Override
  protected Object[] getIdentityElements() {
    return new Object[] { name, attributeName, starred, attributeValue };
  }
}
/* JavaCC - OriginalChecksum=ed78ea0f1a05b0963db625ed1f338bd6 (do not edit this line) */
