/*
 * Copyright © 2021-present Arcade Data Ltd (info@arcadedata.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-FileCopyrightText: 2021-present Arcade Data Ltd (info@arcadedata.com)
 * SPDX-License-Identifier: Apache-2.0
 */
/* Generated By:JJTree: Do not edit this line. OCommitStatement.java Version 4.3 */
/* JavaCCOptions:MULTI=true,NODE_USES_PARSER=false,VISITOR=true,TRACK_TOKENS=true,NODE_PREFIX=O,NODE_EXTENDS=,NODE_FACTORY=,SUPPORT_USERTYPE_VISIBILITY_PUBLIC=true */
package com.arcadedb.query.sql.executor;

import com.arcadedb.GlobalConfiguration;
import com.arcadedb.exception.NeedRetryException;
import com.arcadedb.exception.TimeoutException;
import com.arcadedb.log.LogManager;
import com.arcadedb.query.sql.parser.Statement;

import java.util.*;
import java.util.logging.*;

public class RetryStep extends AbstractExecutionStep {
  public        List<Statement>       body;
  public        List<Statement>       elseBody;
  public        boolean               elseFail;
  private final int                   retries;
  private final int                   retryDelay;
  private       ExecutionStepInternal finalResult = null;

  public RetryStep(List<Statement> statements, int retries, List<Statement> elseStatements, Boolean elseFail, CommandContext ctx,
      boolean enableProfiling) {
    super(ctx);
    this.body = statements;
    this.retries = retries;
    this.elseBody = elseStatements;
    this.elseFail = !(Boolean.FALSE.equals(elseFail));
    this.retryDelay = GlobalConfiguration.TX_RETRY_DELAY.getValueAsInteger();
  }

  @Override
  public ResultSet syncPull(CommandContext ctx, int nRecords) throws TimeoutException {
    if (prev != null)
      prev.syncPull(ctx, nRecords);

    if (finalResult != null) {
      return finalResult.syncPull(ctx, nRecords);
    }
    for (int attempt = 0; attempt < retries; attempt++) {
      try {
        final ScriptExecutionPlan plan = initPlan(body, ctx);
        final ExecutionStepInternal result = plan.executeFull();
        if (result != null) {
          this.finalResult = result;
          return result.syncPull(ctx, nRecords);
        }
        break;
      } catch (NeedRetryException ex) {
        try {
          ctx.getDatabase().rollback();
        } catch (Exception e) {
          // IGNORE IT
        }

        if (attempt >= retries - 1) {
          if (elseBody != null && elseBody.size() > 0) {
            final ScriptExecutionPlan plan = initPlan(elseBody, ctx);
            final ExecutionStepInternal result = plan.executeFull();
            if (result != null) {
              this.finalResult = result;
              return result.syncPull(ctx, nRecords);
            }
          }
          if (elseFail) {
            throw ex;
          } else {
            return new InternalResultSet();
          }
        }

        delayBetweenRetries();
      }
    }

    finalResult = new EmptyStep(ctx);
    return finalResult.syncPull(ctx, nRecords);
  }

  public ScriptExecutionPlan initPlan(final List<Statement> body, final CommandContext ctx) {
    final BasicCommandContext subCtx1 = new BasicCommandContext();
    subCtx1.setParent(ctx);

    final ScriptExecutionPlan plan = new ScriptExecutionPlan(subCtx1);
    for (Statement stm : body)
      plan.chain(stm.createExecutionPlan(subCtx1));

    return plan;
  }

  private void delayBetweenRetries() {
    if (retryDelay > 0) {
      LogManager.instance()
          .log(this, Level.FINE, "Wait %d ms before the next retry for transaction commit (threadId=%d)", retryDelay,
              Thread.currentThread().getId());

      try {
        Thread.sleep(1 + new Random().nextInt(retryDelay));
      } catch (InterruptedException ex) {
        Thread.currentThread().interrupt();
      }
    }
  }
}
