/*
 * Copyright © 2021-present Arcade Data Ltd (info@arcadedata.com)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * SPDX-FileCopyrightText: 2021-present Arcade Data Ltd (info@arcadedata.com)
 * SPDX-License-Identifier: Apache-2.0
 */
package com.arcadedb.query.sql.executor;

/**
 * Created by luigidellaquila on 08/08/16.
 */

import com.arcadedb.query.sql.parser.WhileStep;

/**
 * @author Luigi Dell'Aquila (luigi.dellaquila-(at)-gmail.com)
 */
public class ForEachExecutionPlan extends UpdateExecutionPlan {
  public ForEachExecutionPlan(final CommandContext context) {
    super(context);
  }

  public boolean containsReturn() {
    for (final ExecutionStep step : getSteps()) {
      if (step instanceof ForEachStep)
        return ((ForEachStep) step).containsReturn();

      if (step instanceof WhileStep)
        return ((WhileStep) step).containsReturn();
    }
    return false;
  }
}
