/*
 * Copyright [2019] [恒宇少年 - 于起宇]
 *
 *      Licensed under the Apache License, Version 2.0 (the "License");
 *      you may not use this file except in compliance with the License.
 *      You may obtain a copy of the License at
 *
 *          http://www.apache.org/licenses/LICENSE-2.0
 *
 *      Unless required by applicable law or agreed to in writing, software
 *      distributed under the License is distributed on an "AS IS" BASIS,
 *      WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *      See the License for the specific language governing permissions and
 *      limitations under the License.
 *
 */

package org.minbox.framework.api.boot.sample.logging;

import lombok.Data;
import org.minbox.framework.logging.client.global.GlobalLogging;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

/**
 * @author：恒宇少年 - 于起宇
 * <p>
 * DateTime：2019-07-15 22:48
 * Blog：http://blog.yuqiyu.com
 * WebSite：http://www.jianshu.com/u/092df3f77bca
 * Gitee：https://gitee.com/hengboy
 * GitHub：https://github.com/hengboy
 */
@RestController
public class IndexController {

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private GlobalLogging logging;

    @GetMapping(value = "/index")
    public String user() {
        logging.info("访问了首页.");
        // 制造测试异常
        try {
            int a = 4 / 0;
        } catch (Exception e) {
            logging.error("执行遇到异常.", e);
        }
        logging.debug("执行完成了吧？");
        return "xxx";
    }

    @PostMapping(value = "/index")
    public User index(@RequestBody User user) throws Exception {
        System.out.println(restTemplate.getInterceptors());
        return user;
    }

    @Data
    public static class User {
        private String name;
        private String email;
        private int age;
    }
}
