import Balancer from 'react-wrap-balancer';
import { Heading } from '../../ui/heading';
import { Paragraph } from '../../ui/paragraph';
import { cn } from '../../utils/utils';

// TODO: Link to docs for feature?
const HomeFeature = (props: {
	featureName: React.ReactNode;
	featureDescription?: React.ReactNode;
}) => {
	return (
		<div className="flex flex-col items-center justify-center rounded-standard border-2 border-gray-300 px-2 py-4 text-center dark:border-white/[.13] md:px-20 md:py-10">
			<Paragraph className="text-xl md:text-2xl">{props.featureName}</Paragraph>
			<Paragraph className="text-lg">{props.featureDescription}</Paragraph>
		</div>
	);
};

export const FeaturesSection = (props: { className?: string }) => {
	return (
		<div className={cn('w-full', props.className)}>
			<Heading.H2 className="text-center md:text-right">
				Tools tailored to your community
			</Heading.H2>
			<Heading.H3 className="pt-0 text-center text-lg md:text-right">
				<Balancer>
					Your community is unique, {"it's"} time you had a bot that matches it
				</Balancer>
			</Heading.H3>

			<div className="mt-2 grid grid-cols-1 grid-rows-1 gap-10 md:grid-cols-2 md:grid-rows-2">
				<HomeFeature
					featureName="🔎 Index Content Into Google"
					featureDescription="Organically gain more users by ranking at the top of Google search results"
				/>
				<HomeFeature
					featureName="🤖 AI Question Answers"
					featureDescription={
						<>
							<b>Automate answering repeat questions</b>, with AI answers
							sourced from your community content.
						</>
					}
				/>
				<HomeFeature
					featureName="📈 Community Insights"
					featureDescription="Understand what your community is asking the most about and where to improve your documentation"
				/>
				<HomeFeature
					featureName="💻 Host On Your Own Domain"
					featureDescription="Boost your website with organic content generated by your community"
				/>
			</div>
		</div>
	);
};
