
<p align='center'>
<a href='https://answeroverflow.com/' target="_blank" rel="noopener">
  <picture>
    <source media="(prefers-color-scheme: dark)" srcset="https://www.answeroverflow.com/AnswerOverflowLogoLight.png" />
    <img alt="Answer Overflow Logo" src="https://www.answeroverflow.com/AnswerOverflowLogoDark.png" />
  </picture>
</a>
</p>

<div align="center">
  <h3>Index your discord help channels to google<br /></h3>
  <a href="https://github.com/AnswerOverflow/AnswerOverflow/blob/main/LICENSE.md">
    <img alt="AGPL License" src="https://img.shields.io/github/license/AnswerOverflow/AnswerOverflow" />
  </a>
  <a href="https://discord.gg/Wny38ap7Tx">
    <img alt="Discord" src="https://img.shields.io/discord/952724385238761475?color=7389D8&label&logo=discord&logoColor=ffffff" />
  </a>

  <br />
  <a href="https://twitter.com/RhysSullivan">
    <img alt="Twitter" src="https://img.shields.io/twitter/url.svg?label=%40RhysSullivan&style=social&url=https%3A%2F%2Ftwitter.com%2RhysSullivan" />
  </a>
  <a href="https://twitter.com/AnswerOverflow">
    <img alt="Twitter" src="https://img.shields.io/twitter/url.svg?label=%40AnswerOverflow&style=social&url=https%3A%2F%2Ftwitter.com%2FAnswerOverflow" />
  </a>
   <a href="https://codecov.io/gh/AnswerOverflow/AnswerOverflow">
    <img alt="codecov" src="https://codecov.io/gh/AnswerOverflow/AnswerOverflow/branch/main/graph/badge.svg?token=8J0AQ77SOG">
  </a>


  <a href="https://www.producthunt.com/posts/answer-overflow?utm_source=badge-featured&utm_medium=badge&utm_souce=badge-answer&#0045;overflow" target="_blank"><img src="https://api.producthunt.com/widgets/embed-image/v1/featured.svg?post_id=386188&theme=light" alt="Answer&#0032;Overflow - Indexing&#0032;Discord&#0032;channels&#0032;into&#0032;Google | Product Hunt" style="width: 180px; height: 39px;" width="180" height="39" /></a>
  [![Deploy on Railway](https://railway.app/button.svg)](https://railway.app?referralCode=Q3ROGt)


  <br />
  <br />
  <figure>
  <a href='https://google.com/search?q=site%3Aansweroverflow.com+c%23' target="_blank" rel="noopener">
    <img src="./assets/search-result-example.png" alt="Search results from Answer Overflow" />
  </a>
    <figcaption>
      <p align="center">
        These results are from questions asked <strong>in Discord help channels</strong> and are now Google indexed so that they can be found by people searching for these questions
      </p>
    </figcaption>
  </figure>
</div>

<br />

## Intro

Answer Overflow lets you index your Discord help channels into Google so that you can:

- Grow your community
- Stop answering repeat questions
- Improve the quality of life of people using your project

### Features

- 🔍&nbsp; Index questions into Google.
- 📈&nbsp; Powerful analytics - Learn what questions are asked the most, who is most helpful, and other community insights
- ✅&nbsp; Improved Help Channels - Mark questions as solved, organize content, and keep discussions on track
- 🐻&nbsp; Easy - Simple menus to control settings

### Roadmap

- 🤖&nbsp; AI question improvement suggestions
- 🤖&nbsp; AI answers based on your community documents
- 🗺️&nbsp; Server browser and discoverability
- ✈️&nbsp; Self Hosting Support
- 📥&nbsp; Automatically redirecting people to correct help channels
- 💖&nbsp; Link the GitHub sponsors page of a person who solves the question
- 📋&nbsp; Question templates

## Star History

<a href="https://star-history.com/#AnswerOverflow/AnswerOverflow"><img src="https://api.star-history.com/svg?repos=AnswerOverflow/AnswerOverflow&type=Date" alt="Star History Chart" width="600" /></a>

## Contributing

Want to contribute? First, read the <a href="https://github.com/AnswerOverflow/AnswerOverflow/blob/main/CONTRIBUTING.md">Contributing Guidelines</a> before creating PRs or issues. Need any help? Join us on <a href="https://discord.gg/Wny38ap7Tx">Discord</a>!

For designing user interfaces, check out our [design guidelines](./DESIGN_GUIDELINES.md).

<div align="left">
  <div>
  <a href="https://gitpod.io/#https://github.com/AnswerOverflow/AnswerOverflow">
      <img src="https://gitpod.io/button/open-in-gitpod.svg" />
    </a>
  </div>
  <div>
    <a href="https://github.com/codespaces/new?hide_repo_select=true&ref=main&repo=533537084&machine=largePremiumLinux&devcontainer_path=.devcontainer%2Fdevcontainer.json&location=EastUs">
      <img src="https://github.com/codespaces/badge.svg">
    </a>
  </div>
  <a href="./CONTRIBUTING.md">
    Remote development tips
  </a>
</div>

### All contributors ✨

> Answer Overflow is developed by [Rhys Sullivan](https://twitter.com/RhysSullivan)

<a href="https://github.com/AnswerOverflow/AnswerOverflow/graphs/contributors">
  <p align="center">
    <img src="https://contrib.rocks/image?repo=AnswerOverflow/AnswerOverflow" alt="A table of avatars from the project's contributors" />
  </p>
</a>
