using System.Collections.ObjectModel;

namespace TableturfBattleServer;
public static class CardDatabase {
	private const Space I = Space.Ink1;
	private const Space S = Space.SpecialInactive1;

	private static readonly Card[] cards = [
		new(  1, "Hero Shot", Rarity.Fresh, "HeroShooter", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, I, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, S, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(  2, "Sploosh-o-matic", Rarity.Common, "ShooterShort00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, S, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(  3, "Splattershot Jr.", Rarity.Common, "ShooterFirst00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, S, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(  4, "Splash-o-matic", Rarity.Common, "ShooterPrecision00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, S, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(  5, "Aerospray MG", Rarity.Common, "ShooterBlaze00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, S, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(  6, "Splattershot", Rarity.Common, "ShooterNormal00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(  7, ".52 Gal", Rarity.Common, "ShooterGravity00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, S, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(  8, "N-ZAP '85", Rarity.Common, "ShooterQuickMiddle00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, S, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(  9, "Splattershot\nPro", Rarity.Common, "ShooterExpert00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 10, ".96 Gal", Rarity.Common, "ShooterHeavy00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, S, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 11, "Jet Squelcher", Rarity.Common, "ShooterLong00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, S, 0, I, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 12, "Luna Blaster", Rarity.Common, "BlasterShort00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, S, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 13, "Blaster", Rarity.Common, "BlasterMiddle00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 14, "Range Blaster", Rarity.Common, "BlasterLong00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 15, "Clash Blaster", Rarity.Common, "BlasterLightShort00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, S, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 16, "Rapid Blaster", Rarity.Common, "BlasterLight00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 17, "Rapid Blaster\nPro", Rarity.Common, "BlasterLightLong00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, S, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 18, "L-3 Nozzlenose", Rarity.Common, "ShooterTripleQuick00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 19, "H-3 Nozzlenose", Rarity.Common, "ShooterTripleMiddle00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, S, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 20, "Squeezer", Rarity.Common, "ShooterFlash00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, S, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 21, "Carbon Roller", Rarity.Common, "RollerCompact00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, S, I, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 22, "Splat Roller", Rarity.Common, "RollerNormal00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, S, I, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 23, "Dynamo Roller", Rarity.Common, "RollerHeavy00", new Space[,] {
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, S, I, I, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 24, "Flingza Roller", Rarity.Common, "RollerHunter00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, S, I, I, I, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 25, "Inkbrush", Rarity.Common, "BrushMini00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, S, I, 0, 0, 0, 0, 0 },
			{ 0, I, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 26, "Octobrush", Rarity.Common, "BrushNormal00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, I, 0 },
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, I, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 27, "Classic Squiffer", Rarity.Common, "ChargerQuick00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, S, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 28, "Splat Charger", Rarity.Common, "ChargerNormal00", new Space[,] {
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, S, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 29, "Splatterscope", Rarity.Common, "ChargerNormalScope00", new Space[,] {
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 30, "E-liter 4K", Rarity.Common, "ChargerLong00", new Space[,] {
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, S, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 31, "E-liter 4K Scope", Rarity.Common, "ChargerLongScope00", new Space[,] {
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 32, "Bamboozler\n14 Mk I", Rarity.Common, "ChargerLight00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, S, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 33, "Goo Tuber", Rarity.Common, "ChargerKeeper00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, S, 0, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 34, "Slosher", Rarity.Common, "SlosherStrong00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, 0, S, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 35, "Tri-Slosher", Rarity.Common, "SlosherDiffusion00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, S, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 36, "Sloshing\nMachine", Rarity.Common, "SlosherLauncher00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, S, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 37, "Bloblobber", Rarity.Common, "SlosherBathtub00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, S, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 38, "Explosher", Rarity.Common, "SlosherWashtub00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, S, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 39, "Mini Splatling", Rarity.Common, "SpinnerQuick00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, S, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 40, "Heavy Splatling", Rarity.Common, "SpinnerStandard00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, I, I, I, 0, 0, 0, 0 },
			{ 0, I, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, S, I, 0 },
			{ 0, 0, 0, 0, 0, 0, I, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 41, "Hydra Splatling", Rarity.Common, "SpinnerHyper00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, S, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 42, "Ballpoint\nSplatling", Rarity.Common, "SpinnerDownpour00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, S, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 43, "Nautilus 47", Rarity.Common, "SpinnerSerein00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, S, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 44, "Dapple Dualies", Rarity.Common, "ManeuverShort00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, I, S, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 45, "Splat Dualies", Rarity.Common, "ManeuverNormal00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, S, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 46, "Glooga Dualies", Rarity.Common, "ManeuverGallon00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, 0, S, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 47, "Dualie\nSquelchers", Rarity.Common, "ManeuverDual00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, S, I, 0, 0 },
			{ 0, 0, I, I, 0, I, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 48, "Dark Tetra\nDualies", Rarity.Common, "ManeuverStepper00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, S, I, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 49, "Splat Brella", Rarity.Common, "ShelterNormal00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, I, I, S, I, I, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 50, "Tenta Brella", Rarity.Common, "ShelterWide00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, I, 0, I, 0, I, 0, 0 },
			{ 0, I, I, S, I, I, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 51, "Undercover\nBrella", Rarity.Common, "ShelterCompact00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, I, 0, I, 0, I, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, 0, S, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 52, "Tri-Stringer", Rarity.Common, "StringerNormal00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, I, I, I, I, I, 0, 0 },
			{ 0, S, 0, I, 0, 0, 0, 0 },
			{ 0, I, I, 0, 0, 0, 0, 0 },
			{ 0, I, 0, 0, 0, 0, 0, 0 },
			{ 0, I, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 53, "REEF-LUX 450", Rarity.Common, "StringerShort00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, I, I, 0, 0 },
			{ 0, 0, 0, S, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 54, "Splatana\nStamper", Rarity.Common, "SaberNormal00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, S, I, I, I, I, I, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 55, "Splatana\nWiper", Rarity.Common, "SaberLight00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, S, I, I, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 56, "Splat Bomb", Rarity.Common, "BombSplash", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, S, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 57, "Suction Bomb", Rarity.Common, "BombSuction", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, S, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 58, "Burst Bomb", Rarity.Common, "BombQuick", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, S, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 59, "Sprinkler", Rarity.Common, "Sprinkler", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, S, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 60, "Splash Wall", Rarity.Common, "Shield", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, S, I, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 61, "Fizzy Bomb", Rarity.Common, "BombFizzy", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, S, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 62, "Curling Bomb", Rarity.Common, "BombCurling", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, S, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 63, "Autobomb", Rarity.Common, "BombRobot", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 64, "Squid Beakon", Rarity.Common, "Beacon", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, I, 0, 0 },
			{ 0, 0, I, S, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 65, "Point Sensor", Rarity.Common, "PointSensor", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, 0, S, 0, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 66, "Ink Mine", Rarity.Common, "Trap", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, I, 0, S, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 67, "Toxic Mist", Rarity.Common, "PoisonMist", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, S, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 68, "Angle Shooter", Rarity.Common, "LineMarker", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, S, 0, 0, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 69, "Torpedo", Rarity.Common, "BombTako", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, S, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 70, "Trizooka", Rarity.Rare, 3, "SpUltraShot", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, I, 0, 0 },
			{ 0, 0, I, 0, I, I, I, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, I, I, 0, 0, 0, 0, 0 },
			{ 0, I, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 71, "Big Bubbler", Rarity.Rare, 3, "SpGreatBarrier", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, 0, 0, I, 0, 0 },
			{ 0, I, 0, 0, 0, 0, I, 0 },
			{ 0, I, 0, 0, 0, 0, I, 0 },
			{ 0, 0, I, 0, 0, I, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 72, "Zipcaster", Rarity.Rare, 3, "SpSuperHook", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, 0, 0, I, I, I, 0 },
			{ 0, 0, 0, I, 0, I, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, I, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 73, "Tenta Missiles", Rarity.Rare, 3, "SpMultiMissile", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 74, "Ink Storm", Rarity.Rare, 3, "SpInkStorm", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, I, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 75, "Booyah Bomb", Rarity.Rare, 3, "SpNiceBall", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 76, "Wave Breaker", Rarity.Rare, 3, "ShockSonar", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, I, 0, I, 0, I, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, I, 0, 0, 0, I, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, I, 0, I, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 77, "Ink Vac", Rarity.Rare, 3, "Kyuinki", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 78, "Killer Wail 5.1", Rarity.Rare, 3, "SpMegaphoneLaser51", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, I, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, I, I, 0, 0, I, I, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, 0, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 79, "Inkjet", Rarity.Rare, 3, "Jetpack", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 80, "Ultra Stamp", Rarity.Rare, 3, "SpUltraStamp", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 81, "Crab Tank", Rarity.Rare, 3, "Kanitank", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, I, 0, I, 0, I, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, I, 0, I, 0, I, 0, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 82, "Reefslider", Rarity.Rare, 3, "Chidori", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 83, "Triple Inkstrike", Rarity.Rare, 3, "TripleTornado", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 84, "Tacticooler", Rarity.Rare, 3, "EnergyStand", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, I, I, 0, I, 0, 0, 0 },
			{ 0, I, 0, I, I, I, 0, 0 },
			{ 0, I, I, 0, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new( 85, "Sheldon", Rarity.Rare, "Bukichi", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, S, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, I, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(181, 115, 85), InkColour2 = new(125, 157, 60) },
		new( 86, "Gnarly Eddy", Rarity.Rare, "Omura", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, I, 0, I, 0, I, 0, 0 },
			{ 0, I, I, I, I, I, 0, 0 },
			{ 0, S, 0, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(169, 113, 230), InkColour2 = new(205, 113, 74) },
		new( 87, "Jel La Fleur", Rarity.Rare, "Hanagasa", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, I, 0, 0 },
			{ 0, I, I, I, S, 0, 0, 0 },
			{ 0, 0, I, I, 0, I, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(130, 154, 233), InkColour2 = new(129, 106, 219) },
		new( 88, "Mr. Coco", Rarity.Rare, "Yashiganisan", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, S, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, I, I, I, I, I, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(218, 101, 63), InkColour2 = new(124, 159, 234) },
		new( 89, "Harmony", Rarity.Rare, "Paruko", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, I, 0 },
			{ 0, I, I, 0, I, I, 0, 0 },
			{ 0, I, I, I, 0, 0, 0, 0 },
			{ 0, I, I, S, 0, 0, 0, 0 },
			{ 0, 0, I, 0, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, I, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(107, 217, 175), InkColour2 = new(239, 160, 194) },
		new( 90, "Murch", Rarity.Rare, "Spiky", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, I, 0, I, 0, I, 0, 0 },
			{ 0, 0, I, 0, S, 0, 0, 0 },
			{ 0, I, 0, I, 0, I, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(177, 121, 190), InkColour2 = new(131, 110, 211) },
		new( 91, "Mr. Grizz", Rarity.Rare, "Kumasan", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, S, 0, I, I, 0, 0 },
			{ 0, I, 0, I, I, I, I, 0 },
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, I, I, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(196, 106, 52), InkColour2 = new(98, 145, 107) },
		new( 92, "Marigold", Rarity.Rare, "Mother", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, 0, I, I, 0, 0 },
			{ 0, I, I, I, S, I, 0, 0 },
			{ 0, 0, I, 0, I, I, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(190, 136, 200), InkColour2 = new(230, 139, 122) },
		new( 93, "Smallfry", Rarity.Fresh, "Kojake", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, S, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(203, 99, 123), InkColour2 = new(98, 140, 146) },
		new( 94, "Cuttlefish", Rarity.Fresh, "Atarime", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, I, 0 },
			{ 0, 0, I, 0, I, I, 0, 0 },
			{ 0, I, I, I, I, I, S, 0 },
			{ 0, 0, I, 0, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, I, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(113, 190, 218), InkColour2 = new(198, 126, 148) },
		new( 95, "Captain", Rarity.Fresh, "Shirei", new Space[,] {
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, I, I, I, 0, 0, 0, 0 },
			{ 0, I, I, S, I, 0, 0, 0 },
			{ 0, I, I, I, 0, I, 0, 0 },
			{ 0, 0, I, 0, 0, 0, I, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(249, 172, 127), InkColour2 = new(244, 231, 129) },
		new( 96, "Callie", Rarity.Fresh, "Aori", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, I, I, 0, 0, I, 0, 0 },
			{ 0, I, I, I, 0, 0, I, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, I, S, 0, 0, I, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(246, 78, 171), InkColour2 = new(188, 89, 252) },
		new( 97, "Marie", Rarity.Fresh, "Hotaru", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, I, S, 0, 0, I, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, I, I, I, 0, 0, I, 0 },
			{ 0, I, I, 0, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(181, 214, 121), InkColour2 = new(222, 242, 122) },
		new( 98, "Shiver", Rarity.Fresh, "Fuka", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, S, I, 0, 0, 0 },
			{ 0, 0, I, 0, I, I, I, 0 },
			{ I, I, I, I, 0, I, 0, 0 },
			{ 0, 0, I, 0, I, I, I, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(146, 95, 251), InkColour2 = new(116, 112, 250) },
		new( 99, "Frye", Rarity.Fresh, "Utsuho", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ I, I, 0, I, I, I, 0, 0 },
			{ 0, I, I, 0, 0, 0, I, 0 },
			{ I, I, 0, I, I, I, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(246, 165, 119), InkColour2 = new(245, 229, 130) },
		new(100, "Big Man", Rarity.Fresh, "Mantaro", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, I, 0, 0 },
			{ 0, I, 0, I, I, I, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, I, 0 },
			{ 0, I, I, 0, 0, S, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(124, 231, 161), InkColour2 = new(220, 241, 141) },
		new(101, "Judd", Rarity.Fresh, "Judgekun", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, I, I, 0, I, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, S, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(219, 185, 137), InkColour2 = new(228, 241, 130) },
		new(102, "Li'l Judd", Rarity.Fresh, "KoJudgekun", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, I, S, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(168, 76, 253), InkColour2 = new(130, 103, 253) },
		new(103, "SquidForce", Rarity.Rare, "Batoroika", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, I, I, I, I, I, 0, 0 },
			{ 0, 0, 0, I, S, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(230, 247, 75), InkColour2 = new(228, 117, 56) },
		new(104, "Zink", Rarity.Rare, "Ironic", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, I, 0, I, 0, I, 0, 0 },
			{ 0, I, I, 0, S, 0, 0, 0 },
			{ 0, I, I, I, 0, 0, 0, 0 },
			{ 0, I, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(122, 192, 195), InkColour2 = new(244, 124, 130) },
		new(105, "Krak-On", Rarity.Rare, "Kuraagesu", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, S, I, I, I, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(245, 149, 68), InkColour2 = new(97, 125, 234) },
		new(106, "Rockenberg", Rarity.Rare, "Rokkenberugu", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, 0, S, 0, I, 0, 0 },
			{ 0, 0, I, 0, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(229, 124, 59), InkColour2 = new(171, 98, 57) },
		new(107, "Zekko", Rarity.Rare, "Ezokko", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, S, I, I, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(229, 123, 74), InkColour2 = new(98, 95, 224) },
		new(108, "Forge", Rarity.Rare, "Forima", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, S, I, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(103, 101, 58), InkColour2 = new(238, 189, 60) },
		new(109, "Firefin", Rarity.Rare, "Hokkorii", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, 0, S, 0, I, I, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(225, 113, 64), InkColour2 = new(183, 93, 73) },
		new(110, "Skalop", Rarity.Rare, "Hotakkusu", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, S, I, I, I, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(180, 102, 190), InkColour2 = new(128, 200, 165) },
		new(111, "Splash Mob", Rarity.Rare, "Jimon", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, S, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(180, 102, 190), InkColour2 = new(105, 143, 62) },
		new(112, "Inkline", Rarity.Rare, "Shigureni", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, S, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(115, 130, 234), InkColour2 = new(214, 96, 188) },
		new(113, "Tentatek", Rarity.Rare, "Arome", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, S, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(88, 187, 167), InkColour2 = new(222, 98, 119) },
		new(114, "Takoroka", Rarity.Rare, "Yako", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, S, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(154, 208, 48), InkColour2 = new(221, 123, 65) },
		new(115, "Annaki", Rarity.Rare, "Anaaki", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, I, I, I, S, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(110, 106, 105), InkColour2 = new(176, 92, 77) },
		new(116, "Enperry", Rarity.Rare, "Enperii", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, I, 0, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, 0, 0, S, I, I, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, 0, I, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(204, 102, 56), InkColour2 = new(98, 98, 200) },
		new(117, "Toni Kensa", Rarity.Rare, "Tatakikensaki", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, 0, I, 0, S, 0, 0 },
			{ 0, 0, 0, I, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(103, 101, 58), InkColour2 = new(246, 92, 57) },
		new(118, "Barazushi", Rarity.Rare, "Barazushi", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, 0, 0, I, 0, I, 0, 0 },
			{ 0, 0, I, I, S, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(113, 112, 76), InkColour2 = new(244, 243, 232) },
		new(119, "Emberz", Rarity.Rare, "Shichirin", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, I, 0, I, 0, I, 0, 0 },
			{ 0, 0, 0, 0, S, 0, 0, 0 },
			{ 0, I, 0, I, 0, I, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(239, 106, 55), InkColour2 = new(97, 187, 234) },
		new(120, "Octotrooper", Rarity.Common, "TakoTrooper", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, I, S, I, I, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(121, 111, 174), InkColour2 = new(166, 105, 169) },
		new(121, "Shielded\nOctotrooper", Rarity.Common, "TateTakoTrooper", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, I, S, I, I, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(121, 111, 174), InkColour2 = new(166, 105, 169) },
		new(122, "Twintacle\nOctotrooper", Rarity.Common, "BaiTakoTrooper", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, I, S, I, I, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(121, 111, 174), InkColour2 = new(166, 105, 169) },
		new(123, "Octohopper", Rarity.Common, "TakoHopper", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, I, S, I, I, I, I, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(121, 111, 174), InkColour2 = new(166, 105, 169) },
		new(124, "Octocopter", Rarity.Common, "Takopter", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, S, I, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(121, 111, 174), InkColour2 = new(166, 105, 169) },
		new(125, "Octobomber", Rarity.Common, "BombTakopter", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, S, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(121, 111, 174), InkColour2 = new(166, 105, 169) },
		new(126, "Octodisco", Rarity.Common, "BarrierTakopter", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, S, I, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, I, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(121, 111, 174), InkColour2 = new(166, 105, 169) },
		new(127, "Octopod", Rarity.Common, "TakoPod", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, S, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(121, 111, 174), InkColour2 = new(166, 105, 169) },
		new(128, "Oversized\nOctopod", Rarity.Rare, "TakopodDEV", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, I, 0, 0 },
			{ 0, 0, I, I, S, 0, 0, 0 },
			{ 0, 0, I, I, 0, I, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(121, 111, 174), InkColour2 = new(166, 105, 169) },
		new(129, "Tentakook", Rarity.Common, "Sutakoraa", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, 0, 0, 0, S, I, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(121, 111, 174), InkColour2 = new(166, 105, 169) },
		new(130, "Octosniper", Rarity.Rare, "TakoSniper", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, I, I, I, I, I, 0, 0 },
			{ 0, I, 0, S, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(121, 111, 174), InkColour2 = new(166, 105, 169) },
		new(131, "Octocommander", Rarity.Rare, "TakoCommander", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, I, I, I, I, I, 0, 0 },
			{ 0, I, 0, S, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(121, 111, 174), InkColour2 = new(166, 105, 169) },
		new(132, "Octomissile", Rarity.Common, "TakoMissile", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, S, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(121, 111, 174), InkColour2 = new(166, 105, 169) },
		new(133, "Octozeppelin", Rarity.Rare, "TakopperinGo", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, S, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(121, 111, 174), InkColour2 = new(166, 105, 169) },
		new(134, "Squee-G", Rarity.Common, "Incleaner", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, I, 0, 0 },
			{ 0, 0, I, I, S, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(121, 111, 174), InkColour2 = new(166, 105, 169) },
		new(135, "Octostamp", Rarity.Common, "TakoStamp", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, S, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(121, 111, 174), InkColour2 = new(166, 105, 169) },
		new(136, "Amped\nOctostamp", Rarity.Rare, "StampWave", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, I, 0, S, 0, I, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(121, 111, 174), InkColour2 = new(166, 105, 169) },
		new(137, "Flooder", Rarity.Common, "TakoDozer", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, S, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(121, 111, 174), InkColour2 = new(166, 105, 169) },
		new(138, "Octoballer", Rarity.Common, "TakoStrike", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, I, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, I, I, I, S, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(121, 111, 174), InkColour2 = new(166, 105, 169) },
		new(139, "Octoling", Rarity.Rare, "TakoZonesu", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, S, I, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(121, 111, 174), InkColour2 = new(166, 105, 169) },
		new(140, "DJ Octavio", Rarity.Fresh, "TakowasaShogun", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, I, I, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, I, 0 },
			{ 0, 0, I, I, S, I, 0, 0 },
			{ 0, 0, 0, 0, I, 0, I, 0 },
			{ 0, 0, 0, I, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(121, 111, 174), InkColour2 = new(166, 105, 169) },
		new(141, "Chum", Rarity.Common, "Shake", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, S, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(193, 111, 98), InkColour2 = new(84, 142, 122) },
		new(142, "Cohock", Rarity.Common, "Dosukoi", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, S, 0, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(193, 111, 98), InkColour2 = new(84, 142, 122) },
		new(143, "Snatcher", Rarity.Common, "Tamahiroi", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, I, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, S, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(193, 111, 98), InkColour2 = new(84, 142, 122) },
		new(144, "Steelhead", Rarity.Common, "Bakudan", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, S, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(193, 111, 98), InkColour2 = new(84, 142, 122) },
		new(145, "Steel Eel", Rarity.Common, "Hebi", new Space[,] {
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, S, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(193, 111, 98), InkColour2 = new(84, 142, 122) },
		new(146, "Scrapper", Rarity.Common, "Teppan", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, S, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(193, 111, 98), InkColour2 = new(84, 142, 122) },
		new(147, "Stinger", Rarity.Common, "Tower", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, S, 0, 0, 0, 0, 0, 0 },
			{ 0, I, I, I, I, I, I, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(193, 111, 98), InkColour2 = new(84, 142, 122) },
		new(148, "Maws", Rarity.Common, "Mogura", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, I, I, S, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(193, 111, 98), InkColour2 = new(84, 142, 122) },
		new(149, "Drizzler", Rarity.Common, "Koumori", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, S, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(193, 111, 98), InkColour2 = new(84, 142, 122) },
		new(150, "Flyfish", Rarity.Common, "Katapaddo", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, S, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(193, 111, 98), InkColour2 = new(84, 142, 122) },
		new(151, "Fish Stick", Rarity.Common, "Buranko", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, I, 0, 0, 0, 0, 0, 0 },
			{ 0, I, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, S, I, 0 },
			{ 0, I, 0, 0, 0, 0, 0, 0 },
			{ 0, I, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(193, 111, 98), InkColour2 = new(84, 142, 122) },
		new(152, "Flipper-Flopper", Rarity.Common, "Iruka", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, I, 0, I, I, S, 0, 0 },
			{ 0, 0, I, I, I, I, I, 0 },
			{ 0, I, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(193, 111, 98), InkColour2 = new(84, 142, 122) },
		new(153, "Slammin' Lid", Rarity.Common, "Nabebuta", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, S, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(193, 111, 98), InkColour2 = new(84, 142, 122) },
		new(154, "Big Shot", Rarity.Common, "Taihou", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, S, I, 0, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(193, 111, 98), InkColour2 = new(84, 142, 122) },
		new(155, "Goldie", Rarity.Rare, "Kinshake", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, I, 0, 0, S, I, 0, 0 },
			{ 0, 0, 0, I, 0, I, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(193, 111, 98), InkColour2 = new(84, 142, 122) },
		new(156, "Griller", Rarity.Rare, "Grill", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, S, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, I, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(193, 111, 98), InkColour2 = new(84, 142, 122) },
		new(157, "Mothership", Rarity.Rare, "Hakobiya", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, S, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(193, 111, 98), InkColour2 = new(84, 142, 122) },
		new(158, "Mudmouth", Rarity.Rare, "Tamaire", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, I, I, 0 },
			{ 0, I, 0, 0, 0, S, I, 0 },
			{ 0, 0, I, I, I, I, I, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(193, 111, 98), InkColour2 = new(84, 142, 122) },
		new(159, "Zapfish", Rarity.Common, "Denchinamazu", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, S, I, 0, 0 },
			{ 0, 0, I, 0, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(160, "Tower Control\nTower", Rarity.Rare, "GachiYagura", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, I, I, S, I, I, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(161, "Rainmaker", Rarity.Rare, "GachiHoko", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, I, 0, S, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, 0, I, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(162, "Power Clam", Rarity.Rare, "GachiAsari", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, S, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(163, "Custom\nSplattershot Jr.", Rarity.Common, "ShooterFirst01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, S, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 3 },
		new(164, "Aerospray RG", Rarity.Common, "ShooterBlaze01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, S, I, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(165, "Tentatek\nSplattershot", Rarity.Common, "ShooterNormal01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 5 },
		new(166, "Forge\nSplattershot Pro", Rarity.Common, "ShooterExpert01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 9 },
		new(167, "Splattershot Nova", Rarity.Common, "ShooterQuickLong00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, S, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(168, "Luna Blaster\nNeo", Rarity.Common, "BlasterShort01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, S, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 12 },
		new(169, "Carbon Roller\nDeco", Rarity.Common, "RollerCompact01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, S, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 21 },
		new(170, "Big Swig Roller", Rarity.Common, "RollerWide00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(171, "Inkbrush\nNouveau", Rarity.Common, "BrushMini01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, I, I, 0, 0, 0, 0, 0 },
			{ 0, S, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 25 },
		new(172, "Snipewriter 5H", Rarity.Common, "ChargerPencil00", new Space[,] {
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, S, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(173, "Slosher Deco", Rarity.Common, "SlosherStrong01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, S, I, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 34 },
		new(174, "Zink Mini\nSplatling", Rarity.Common, "SpinnerQuick01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, S, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 39 },
		new(175, "Dapple Dualies\nNouveau", Rarity.Common, "ManeuverShort01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, S, I, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 44 },
		new(176, "Neo Sploosh-\no-matic", Rarity.Common, "ShooterShort01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, S, I, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 2 },
		new(177, "Neo Splash-\no-matic", Rarity.Common, "ShooterPrecision01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, S, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 4 },
		new(178, "N-ZAP '89", Rarity.Common, "ShooterQuickMiddle01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, S, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 8 },
		new(179, ".96 Gal Deco", Rarity.Common, "ShooterHeavy01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, S, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 10 },
		new(180, "Custom Jet\nSquelcher", Rarity.Common, "ShooterLong01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, S, 0, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 11 },
		new(181, "Clash Blaster\nNeo", Rarity.Common, "BlasterLightShort01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, S, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 15 },
		new(182, "Rapid Blaster\nDeco", Rarity.Common, "BlasterLight01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 16 },
		new(183, "L-3 Nozzlenose D", Rarity.Common, "ShooterTripleQuick01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 18 },
		new(184, "Krak-On Splat\nRoller", Rarity.Common, "RollerNormal01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, S, I, I, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 22 },
		new(185, "Z+F Splat\nCharger", Rarity.Common, "ChargerNormal01", new Space[,] {
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, S, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 28 },
		new(186, "Z+F\nSplatterscope", Rarity.Common, "ChargerNormalScope01", new Space[,] {
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 29 },
		new(187, "Tri-Slosher\nNouveau", Rarity.Common, "SlosherDiffusion01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, S, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 35 },
		new(188, "Kraken Royale", Rarity.Rare, 3, "SpCastle", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, I, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, 0, I, I, 0, 0 },
			{ 0, 0, 0, 0, I, 0, I, 0 },
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(189, "Super Chump", Rarity.Rare, 3, "SpFirework", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, I, I, I, 0, 0, 0, 0 },
			{ 0, I, I, I, 0, 0, 0, 0 },
			{ 0, I, I, I, 0, I, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(190, "Shelly &\nDonny", Rarity.Rare, "MametsubuBukichi", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, I, I, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, I, S, I, 0, 0, 0, 0 },
			{ 0, I, I, 0, 0, 0, 0, 0 },
			{ 0, I, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(205, 244, 126), InkColour2 = new(235, 244, 120) },
		new(191, "Annie", Rarity.Rare, "Anemo", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, I, 0, I, 0, I, 0, 0 },
			{ 0, 0, S, 0, I, 0, 0, 0 },
			{ 0, I, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, I, 0, I, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(203, 168, 230), InkColour2 = new(245, 171, 233) },
		new(192, "Jelonzo", Rarity.Rare, "Echizen", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, I, S, 0, I, 0, 0 },
			{ 0, I, I, I, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, I, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(149, 119, 220), InkColour2 = new(106, 178, 215) },
		new(193, "Fred Crumbs", Rarity.Rare, "Ajio", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, I, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, 0, S, I, I, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(235, 218, 71), InkColour2 = new(107, 130, 225) },
		new(194, "Spyke", Rarity.Rare, "Daunii", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, I, 0, I, 0, I, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, I, 0, I, 0, I, 0, 0 },
			{ 0, 0, I, 0, S, 0, 0, 0 },
			{ 0, I, 0, I, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(204, 139, 67), InkColour2 = new(154, 100, 234) },
		new(195, "The Eel\nDeal - Frye", Rarity.Fresh, "Utsuho1", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, S, 0, I, 0, 0 },
			{ 0, 0, I, I, 0, I, 0, 0 },
			{ 0, 0, 0, I, 0, I, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(245, 229, 130), InkColour2 = new(246, 165, 119) },
		new(196, "The Cold-Blooded\nBandit - Shiver", Rarity.Fresh, "Fuka1", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, S, I, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, I, 0, 0 }
		}) { InkColour1 = new(116, 112, 250), InkColour2 = new(146, 95, 251) },
		new(197, "The Hype Manta\nStorm - Big Man", Rarity.Fresh, "Mantaro1", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, S, I, 0, 0, 0 },
			{ 0, I, I, 0, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, I, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(220, 241, 141), InkColour2 = new(124, 231, 161) },
		new(198, "Z+F", Rarity.Rare, "Ezokkorii", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, I, 0, S, I, 0, 0 },
			{ 0, 0, I, 0, I, I, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(246, 243, 219), InkColour2 = new(100, 103, 157) },
		new(199, "Annaki\nSplattershot Nova", Rarity.Common, "ShooterQuickLong01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, S, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 167 },
		new(200, "Rapid Blaster\nPro Deco", Rarity.Common, "BlasterLightLong01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, S, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 17 },
		new(201, "S-BLAST '92", Rarity.Common, "BlasterPrecision00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(202, "H-3 Nozzlenose D", Rarity.Common, "ShooterTripleMiddle01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, S, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 19 },
		new(203, "Big Swig\nRoller Express", Rarity.Common, "RollerWide01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 170 },
		new(204, "Painbrush", Rarity.Common, "BrushHeavy00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, I, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, I, I, I, 0, 0, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(205, "Heavy Splatling\nDeco", Rarity.Common, "SpinnerStandard01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, I, 0 },
			{ 0, 0, 0, 0, 0, S, I, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, I, I, I, I, 0, 0, 0 },
			{ 0, I, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 40 },
		new(206, "Custom Dualie\nSquelchers", Rarity.Common, "ManeuverDual01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, I, 0, 0 },
			{ 0, 0, I, I, S, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 47 },
		new(207, "Light Tetra\nDualies", Rarity.Common, "ManeuverStepper01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, S, I, I, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 48 },
		new(208, "Tenta Sorella\nBrella", Rarity.Common, "ShelterWide01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, I, I, S, I, I, 0, 0 },
			{ 0, I, 0, I, 0, I, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 50 },
		new(209, "Splatana\nWiper Deco", Rarity.Common, "SaberLight01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, I, S, I, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 55 },
		new(210,  -6, "Gold Dynamo\nRoller", Rarity.Common, "RollerHeavy01", new Space[,] {
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, S, I, I, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 23 },
		new(211,  -5, "Octobrush\nNouveau", Rarity.Common, "BrushNormal01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, I, I, I, 0, 0, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, I, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 26 },
		new(212,  -1, "Custom Goo\nTuber", Rarity.Common, "ChargerKeeper01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, I, S, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 33 },
		new(213,  -2, "Sloshing\nMachine Neo", Rarity.Common, "SlosherLauncher01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, S, I, I, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 36 },
		new(214,  -8, "Bloblobber\nDeco", Rarity.Common, "SlosherBathtub01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, S, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 37 },
		new(215,  -4, "Dread Wringer", Rarity.Common, "SlosherDouble00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, I, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, 0, 0, S, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(216, -12, "Ballpoint Splatling\nNouveau", Rarity.Common, "SpinnerDownpour01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, I, S, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 42 },
		new(217,  -3, "Heavy Edit\nSplatling", Rarity.Common, "SpinnerHyperShort00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, I, S, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(218, -11, "Sorella Brella", Rarity.Common, "ShelterNormal01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, I, I, S, I, I, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 49 },
		new(219,  -7, "Inkline\nTri-Stringer", Rarity.Common, "StringerNormal01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, I, 0, 0, 0, 0, 0, 0 },
			{ 0, I, 0, 0, 0, 0, 0, 0 },
			{ 0, I, I, 0, 0, 0, 0, 0 },
			{ 0, S, 0, I, 0, 0, 0, 0 },
			{ 0, I, I, I, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 52 },
		new(220, -10, "Cohozuna", Rarity.Fresh, "Yokozuna", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, I, 0, I, I, 0, 0, 0 },
			{ 0, I, I, I, I, I, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, 0, 0, S, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(193, 111, 98), InkColour2 = new(84, 142, 122) },
		new(221,  -9, "Horrorboros", Rarity.Fresh, "Tatsu", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, S, 0, 0, 0, 0, 0 },
			{ 0, I, 0, I, 0, 0, 0, 0 },
			{ 0, I, I, 0, I, I, I, 0 },
			{ I, 0, I, 0, I, 0, I, 0 },
			{ 0, 0, I, I, I, 0, I, 0 },
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(193, 111, 98), InkColour2 = new(84, 142, 122) },
		new(222, -17, "Custom Blaster", Rarity.Common, "BlasterMiddle01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 13 },
		new(223, -13, "Foil Squeezer", Rarity.Common, "ShooterFlash01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, S, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 20 },
		new(224, -15, "Enperry Splat\nDualies", Rarity.Common, "ManeuverNormal01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, S, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 45 },
		new(225, -16, "Undercover\nSorella Brella", Rarity.Common, "ShelterCompact01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, S, 0, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, I, 0, I, 0, I, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 51 },
		new(226, -21, "REEF-LUX\n450 Deco", Rarity.Common, "StringerShort01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, S, 0, I, I, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 53 },
		new(227, -20, "Splatana\nStamper Nouveau", Rarity.Common, "SaberNormal01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, I, S, I, I, I, I, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 54 },
		new(228, -14, "Snipewriter 5B", Rarity.Common, "ChargerPencil01", new Space[,] {
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, S, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 172 },
		new(229, -18, "S-BLAST '91", Rarity.Common, "BlasterPrecision01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 201 },
		new(230, -19, "Painbrush\nNouveau", Rarity.Common, "BrushHeavy01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, I, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, I, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 204 },
		new(231, -23, "Triple Splashdown", Rarity.Rare, 3, "SpPogo", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, I, I, I, I, 0, 0, 0 },
			{ 0, I, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(232, -22, "Splattercolor\nScreen", Rarity.Rare, 3, "SpChimney", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, I, I, 0 },
			{ 0, 0, 0, I, 0, I, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, I, 0, I, 0, 0, 0, 0 },
			{ 0, I, I, 0, 0, 0, 0, 0 },
			{ 0, I, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(233, -24, "Order Dualies", Rarity.Fresh, 2, "ManeuverSdodr", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, S, 0, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(255, 219, 219), InkColour2 = new(216, 154, 167) },
		new(234, -35, ".52 Gal Deco", Rarity.Common, "ShooterGravity01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, S, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 7 },
		new(235, -36, "Foil Flingza\nRoller", Rarity.Common, "RollerHunter01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, S, I, I, I, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 24 },
		new(236, -37, "New Squiffer", Rarity.Common, "ChargerQuick01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, S, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 27 },
		new(237, -38, "Custom E-liter\n4K", Rarity.Common, "ChargerLong01", new Space[,] {
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, S, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 30 },
		new(238, -39, "Custom E-liter\n4K Scope", Rarity.Common, "ChargerLongScope01", new Space[,] {
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 31 },
		new(239, -40, "Custom\nExplosher", Rarity.Common, "SlosherWashtub01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, S, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 38 },
		new(240, -41, "Dread Wringer D", Rarity.Common, "SlosherDouble01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, S, I, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, 0, I, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 215 },
		new(241, -42, "Nautilus 79", Rarity.Common, "SpinnerSerein01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, S, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 43 },
		new(242, -43, "Glooga\nDualies Deco", Rarity.Common, "ManeuverGallon01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, S, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 46 },
		new(243, -33, "Douser\nDualies FF", Rarity.Common, "ManeuverLong00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, S, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(244, -34, "Recycled Brella\n24 Mk I", Rarity.Common, "ShelterFocus00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, I, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(245, -30, "Flow", Rarity.Rare, "Miura", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, I, 0, I, 0, I, 0, 0 },
			{ 0, 0, S, I, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, I, 0, I, 0, I, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(199, 97, 147), InkColour2 = new(218, 75, 58) },
		new(246, -31, "Jelfonzo", Rarity.Rare, "Bizen", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, I, 0, 0 },
			{ 0, I, I, I, I, 0, 0, 0 },
			{ 0, 0, I, S, 0, I, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(114, 223, 158), InkColour2 = new(167, 123, 198) },
		new(247, -32, "Bisk", Rarity.Rare, "Shiganii", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, I, I, I, I, 0, 0, 0 },
			{ 0, 0, I, S, 0, I, 0, 0 },
			{ 0, 0, I, 0, I, 0, I, 0 },
			{ 0, 0, 0, I, 0, I, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(236, 105, 37), InkColour2 = new(224, 136, 30) },
		new(248, -28, "Acht", Rarity.Rare, "Mizuta", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, I, 0, 0 },
			{ 0, I, 0, I, I, 0, 0, 0 },
			{ 0, I, I, 0, I, S, 0, 0 },
			{ 0, I, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(103, 90, 206), InkColour2 = new(201, 62, 95) },
		new(249, -29, "Cipher", Rarity.Rare, "Yumeebi", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, I, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, I, 0, S, I, I, 0 },
			{ 0, I, 0, 0, I, I, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(145, 147, 198), InkColour2 = new(195, 102, 85) },
		new(250, -27, "Pearl Drone", Rarity.Fresh, 2, "HimeDrone", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, 0, S, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(243, 139, 176), InkColour2 = new(243, 201, 223) },
		new(251, -26, "Pearl", Rarity.Fresh, "Hime", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, I, 0, I, 0, 0, I, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, I, I, 0, 0, I, I, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, 0, I, 0, 0, S, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(238, 98, 205), InkColour2 = new(245, 224, 135) },
		new(252, -25, "Marina", Rarity.Fresh, "Iida", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, I, 0, 0 },
			{ 0, I, I, I, I, 0, 0, 0 },
			{ 0, I, 0, 0, I, I, 0, 0 },
			{ 0, I, I, I, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, I, 0, 0 },
			{ 0, S, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(170, 99, 253), InkColour2 = new(254, 151, 146) },
		new(253, "Custom\nRange Blaster", Rarity.Common, "BlasterLong01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 14 },
		new(254, "Bamboozler\n14 Mk II", Rarity.Common, "ChargerLight01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, S, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 32 },
		new(255, "Custom Hydra\nSplatling", Rarity.Common, "SpinnerHyper01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, S, 0, 0, 0 },
			{ 0, 0, 0, 0, I, 0, 0, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 41 },
		new(256, "Heavy Edit\nSplatling Nouveau", Rarity.Common, "SpinnerHyperShort01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, I, I, S, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 217 },
		new(257, "Custom Douser\nDualies FF", Rarity.Common, "ManeuverLong01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, I, 0, S, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 243 },
		new(258, "Recycled Brella\n24 Mk II", Rarity.Common, "ShelterFocus01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, I, I, I, I, 0, 0 },
			{ 0, 0, S, I, 0, 0, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, 0, I, 0, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 244 },
		new(259, "Wellstring V", Rarity.Common, "StringerExplosion00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, 0, I, I, 0, 0 },
			{ 0, I, 0, S, I, 0, 0, 0 },
			{ 0, I, I, I, I, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(260, "Custom\nWellstring V", Rarity.Common, "StringerExplosion01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, 0, 0, 0 },
			{ 0, 0, I, 0, I, I, 0, 0 },
			{ 0, I, 0, I, I, 0, 0, 0 },
			{ 0, I, I, I, S, 0, 0, 0 },
			{ 0, 0, I, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 259 },
		new(261, "Mint Decavitator", Rarity.Common, "SaberHeavy00", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, S, 0, 0 },
			{ 0, I, I, I, I, I, I, 0 },
			{ 0, I, I, I, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}),
		new(262, "Charcoal\nDecavitator", Rarity.Common, "SaberHeavy01", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, I, I, I, I, I, 0, 0 },
			{ 0, I, I, I, I, I, I, 0 },
			{ 0, 0, 0, 0, 0, S, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { IsVariantOf = 261 },
		new(263, "Crusty Sean", Rarity.Rare, "Robu", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, S, I, 0, I, I, 0, 0 },
			{ 0, I, I, 0, I, 0, 0, 0 },
			{ 0, 0, 0, I, 0, 0, 0, 0 },
			{ 0, I, I, 0, I, 0, 0, 0 },
			{ 0, I, 0, 0, 0, I, I, 0 },
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(125, 93, 223), InkColour2 = new(238, 106, 30) },
		new(264, "The Ursine\nAnomaly - #03", Rarity.Fresh, "Kumasan1", new Space[,] {
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, I, 0, I, I, I, 0, 0 },
			{ 0, 0, I, 0, I, 0, 0, 0 },
			{ 0, I, 0, I, S, I, 0, 0 },
			{ 0, 0, I, I, I, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(132, 84, 227), InkColour2 = new(213, 88, 252) },
		new(265, "Megalodontia", Rarity.Fresh, "Jaw", new Space[,] {
			{ 0, I, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, I, I, I, 0, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, 0, 0, I, I, 0, 0 },
			{ 0, 0, 0, I, S, I, 0, 0 },
			{ 0, I, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(193, 111, 98), InkColour2 = new(84, 142, 122) },
		new(266, "Overlorder", Rarity.Fresh, "Odako", new Space[,] {
			{ 0, 0, 0, 0, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, I, 0, 0 },
			{ 0, 0, I, I, I, 0, I, 0 },
			{ 0, 0, I, I, I, 0, I, 0 },
			{ 0, 0, I, S, I, I, 0, 0 },
			{ 0, I, 0, 0, I, 0, 0, 0 },
			{ 0, 0, I, I, 0, 0, 0, 0 },
			{ 0, 0, 0, 0, 0, 0, 0, 0 }
		}) { InkColour1 = new(254, 220, 210), InkColour2 = new(102, 91, 147) }
	];

	private static readonly Dictionary<int, Card> byAltNumber;

	public static int LastOfficialCardNumber { get; }

	public static Version Version { get; } = new(8, 0, 0, 0);
	public static DateTime LastModified { get; } = new(2024, 6, 2, 10, 0, 0, DateTimeKind.Utc);
	public static string JSON { get; }
	public static ReadOnlyCollection<Card> Cards { get; }

	static CardDatabase() {
		Cards = Array.AsReadOnly(cards);
		JSON = JsonUtils.Serialise(cards);
		LastOfficialCardNumber = cards.Last(c => c.Number > 0).Number;
		byAltNumber = new(from c in cards where c.Number < 0 || c.AltNumber is not null select new KeyValuePair<int, Card>(c.Number < 0 ? c.Number : c.AltNumber ?? 0, c));
	}

	// Upcoming cards are identified with a negative number, as their actual numbers aren't known until their release.
	// The placeholder numbers will be kept as alternate numbers then, to avoid breaking replay and saved deck data that uses them.
	public static Card GetCard(int number) => number switch {
		> 0 => --number < LastOfficialCardNumber ? cards[number] : throw new ArgumentOutOfRangeException(nameof(number)),
		< 0 => byAltNumber.TryGetValue(number, out var card) ? card : throw new ArgumentOutOfRangeException(nameof(number)),
		_ => throw new ArgumentOutOfRangeException(nameof(number))
	};

	public static bool IsValidCardNumber(int number) => number switch {
		> 0 => number <= LastOfficialCardNumber,
		< 0 => byAltNumber.ContainsKey(number),
		_ => false
	};
}
