[[ZH]](README.md) [EN]

# Lawyer LLaMA

Through fine-tuning via instructions, the LLaMA model has demonstrated very good performance in the general domain. However, due to a lack of appropriate data, few have explored LLaMA's capabilities in the field of law. To fill this gap, we have introduced Lawyer LLaMA, a model that has undergone additional training on legal domain data.

Lawyer LLaMA first underwent continual pretraining on a large-scale legal corpus, enabling it to systematically learn about the legal knowledge system in China. Based on this, we have collected a batch of analyses for the Chinese National Judicial Examination objective questions and answers to legal consultations using ChatGPT, using the collected data to fine-tune the model via instructions, allowing the model to acquire the ability to apply legal knowledge to specific scenarios.

Our model is capable of:

1. **Mastering Chinese Legal Knowledge**: It can correctly understand legal concepts in common areas such as civil law, criminal law, administrative law, procedural law, etc. For instance, it has grasped the theory of crime formation in criminal law and can identify the perpetrator, victim, criminal act, subjective mental state, and other components of crime from the factual descriptions of criminal cases. The model, using the legal concepts and theories it has learned, can answer most questions in the legal exam fairly well.

2. **Application in Chinese Legal Practice**: It can explain legal concepts in easy-to-understand language and provide basic legal consultation, covering areas such as marriage, lending, maritime, criminal, etc.

To contribute to the open research of the Chinese legal large-scale model, this project will open-source a series of **legal domain instruction tuning data** and **parameters of the Chinese legal large-scale model trained based on LLaMA**.

## News
[2024/4/25] 🆕 Released a new version of [**Lawyer LLaMA 2 (lawyer-llama-13b-v2)**](https://github.com/AndrewZhe/lawyer-llama/blob/main/demo/run_inference_v2.md) model parameters, as well as higher quality legal instruction fine-tuning data.

[2023/10/14] Updated the report [**Lawyer LLaMA: Enhancing LLMs with Legal Knowledge**](https://arxiv.org/abs/2305.15062), providing more technical details and findings.

[2023/6/8] Open-sourced the [`lawyer-llama-13b-beta1.0`](https://github.com/AndrewZhe/lawyer-llama/blob/main/demo/run_inference.md) model parameters.

[2023/5/25] Open-sourced larger-scale instruction fine-tuning data, released dialogue data related to legal articles and user questions.

[2023/5/25] Published [Lawyer LLaMA Technical Report](https://arxiv.org/abs/2305.15062).

[2023/4/13] Open-sourced instruction fine-tuning data generated by ChatGPT, including 2k legal exam question answers and 5k legal consultation replies.


## Training Data

### Legal-domain corpus

We collected some public legal data for the continual training of the model, including legal provisions, judgment documents, etc.

### General instruction tunining data

[Alpaca-GPT4](https://github.com/Instruction-Tuning-with-GPT-4/GPT-4-LLM) 52k in Chinese，52k in English。

### Legal instruction tuning data

#### Overview of open-source data
| File | Size | Description |
| -- | -- | -- |
| 🆕 **fakao_gpt4.json** | 1,000 | **Answers to law exam questions generated by GPT-4** |
| 🆕 **zixun_gpt4.json** | 1,000 | **Legal counsel responses generated by GPT-4 based on legal articles** |
| judical_examination.json | 2,000 | Answers to law exam questions generated by GPT-3.5 |
| judical_examination_v2.json | 5,000 | Answers to law exam questions generated by GPT-3.5 (the second batch) |
| legal_advice.json | 5,000 | Legal counsel responses generated by GPT-3.5 |
| legal_counsel_v2.json | 8,000 | Legal counsel responses generated by GPT-3.5 (the second batch)|
| legal_counsel_with_article_v2.json | 1,000 | Legal counsel responses generated by GPT-3.5 based on legal articles |
| legal_counsel_multi_turn_with_article_v2.json | 476 | GPT-3.5 generates multi-turn legal consultation dialogues based on legal articles |

#### National Judicial Examination
We input the test questions in the [JEC-QA Chinsese National Judicial Examination](https://jecqa.thunlp.org/) into ChatGPT and let it generate an analysis of each answer.

    Human:

    根据《物权法》，下列关于物权变动的特别规定，表述正确吗？
    因继承或者受遗赠取得物权的，自继承或者受遗赠开始时发生效力
    请给出详细的推理过程之后再给出答案。

    Assistant:

    这个表述是正确的。
    根据《物权法》第X条规定：“因继承或者受遗赠取得物权的，自继承或者受遗赠开始时发生效力。”这意味着，当一个人通过继承或受遗赠获得物权时，这个物权的效力是从继承或受遗赠开始时就生效的，而不是从物权转移的时间开始生效。这是因为，继承或受遗赠是一种法定的方式来获得物权，因此，物权的效力应该从这个法定的时间点开始生效。

#### Legal Consultation
We collected some consulting questions from [a open-source dataset](https://opendata.pku.edu.cn/dataset.xhtml?persistentId=doi:10.18170/DVN/OLO4G8), input ChatGPT, let ChatGPT act as a lawyer to answer questions .

    Human:

    是这么个回事，关于我儿子今年2月27日背着我们大人买了一台轻便女式摩托车麻烦你帮忙看怎么解决？

    Assistant:

    首先，根据法律规定，未满18岁的未成年人是无法独立签订合同的，因此你的儿子在未经你的同意的情况下购买摩托车是无效的。
    其次，根据《中华人民共和国道路交通安全法》的规定，未满18周岁的人不得驾驶摩托车，因此你的儿子也无权驾驶这辆摩托车。
    建议你尽快联系卖家，说明情况并要求退货。如果卖家不同意，你可以向消费者协会或相关部门投诉，寻求法律帮助。同时，你也需要对你的儿子进行教育，让他了解道路交通安全法规，避免再次发生类似的情况。

We try to input relevant laws and regulations together, which can improve the quality of ChatGPT generation.
    
    Related Legal Articles:
    
    《民法典》第一千零八十七条：离婚时，夫妻的共同财产由双方协议处理；协议不成的，由人民法院根据财产的具体情况，按照照顾子女、女方和无过错方权益的原则判决。对夫或者妻在家庭土地承包经营中享有的权益等，应当依法予以保护。
    《民法典》第一千零六十三条：下列财产为夫妻一方的个人财产：（一）一方的婚前财产；（二）一方因受到人身损害获得的赔偿或者补偿；（三）遗嘱或者赠与合同中确定只归一方的财产；（四）一方专用的生活用品；（五）其他应当归一方的财产。
    《民法典》第一千零六十二条：夫妻在婚姻关系存续期间所得的下列财产，为夫妻的共同财产，归夫妻共同所有：（一）工资、奖金、劳务报酬；（二）生产、经营、投资的收益；（三）知识产权的收益；（四）继承或者受赠的财产，但是本法第一千零六十三条第三项规定的除外；（五）其他应当归共同所有的财产。夫妻对共同财产，有平等的处理权。
    
    Human:

    你好，离婚后夫妻的财产是怎么分配的

    Assistant:

    您好，根据《民法典》的相关规定，离婚后夫妻的财产分配可以通过夫妻双方协商处理，如果没有协商一致，则需要由法院根据财产的具体情况，按照照顾子女、女方和无过错方权益的原则进行判决。对于夫妻在婚姻关系存续期间所得的共同财产，包括工资、奖金、劳务报酬、生产、经营、投资的收益、知识产权的收益、继承或者受赠的财产以及其他应当归共同所有的财产，应当平分。而夫妻在婚姻关系存续期间所获得的个人财产，包括婚前财产、因受到人身损害获得的赔偿或者补偿、遗嘱或者赠与合同中确定只归一方的财产、一方专用的生活用品，应当归该方所有。请问你们在婚姻关系存续期间所得的财产情况如何呢？

## Model Parameters

The following versions of Lawyer LLaMA are currently publicly available:
* 🆕 `lawyer-llama-13b-v2`: 以[quzhe/llama_chinese_13B](https://huggingface.co/quzhe/llama_chinese_13B), without legal corpus continual training, using general instruction and legal instruction for SFT, equipped with a marriage-related legal article retrieval module.[`demo/run_inference_v2.md`](https://github.com/AndrewZhe/lawyer-llama/blob/main/demo/run_inference_v2.md)。
* `lawyer-llama-13b-beta1.0`: Based on [Chinese-LLaMA-13B](https://github.com/ymcui/Chinese-LLaMA-Alpaca), without legal corpus continual training, using general instruction and legal instruction for SFT, equipped with a marriage-related legal article retrieval module.

For the download address and usage method, see [`demo/run_inference.md`](https://github.com/AndrewZhe/lawyer-llama/blob/main/demo/run_inference.md).

## **Case Study**

We selected LLaMA 13B as the base model, used the legal domain corpus for further pre-training, and fine-tuned in the general domain and legal domain instructions.

The following compares the model and ChatGPT's responses to some input samples:

<details>
<summary><b>Understanding of legal concepts</b></summary>

**Input:** 什么是夫妻共同财产

| **BELLE (13B)** | **ChatGLM (6B)** | **Lawyer LLaMA (13B)** |
| -- | -- | -- |
| 夫妻共同财产是指夫妻在婚姻关系中取得的任何财产，包括但不限于工资、奖金、股票、房产等。 | 夫妻共同财产是指夫妻双方在婚姻期间共同积累的财产，包括夫妻共同居住的房屋、共同拥有的财产、共同支付的工资、奖金等收入，以及共同承担的债务等。<br/>根据中国法律，夫妻共同财产是夫妻双方在婚姻期间共同积累的财产，除非有特别约定，否则属于夫妻共同财产。在离婚时，夫妻共同财产应当平等分割。<br/>夫妻共同财产的分割比例由夫妻双方协商确定，如果无法协商，则按照下列比例分割：<br/>(一)妻子获得财产的比例应当低于丈夫；<br/>(二)妻子获得财产的比例应当低于丈夫获得财产的比例；<br/>(三)妻子获得财产的比例应当低于丈夫获得财产的比例，但妻子获得的财产超过丈夫获得的财产的部分不在此限制。<br/>在分割夫妻共同财产时，应当尊重妻子的权利，保护妻子的利益，不得虐待、家庭暴力等。 | 夫妻共同财产是指夫妻在婚姻关系存续期间所得的工资、奖金、劳务报酬、生产、经营、投资的收益、知识产权的收益、继承或者受赠的财产等，以及其他应当归共同所有的财产。根据《民法典》第一千零六十二条规定，夫妻共同财产归夫妻共同所有，夫妻对共同财产有平等的处理权。因此，夫妻共同财产是夫妻共同所有，夫妻双方都有权享有和管理。|

---

**Input:** 离婚和无效婚姻的区别

| **BELLE (13B)** | **ChatGLM (6B)** | **Lawyer LLaMA (13B)** |
| -- | -- | -- |
| 离婚和无效婚姻的区别在于，离婚是指夫妻关系已经结束，而无效婚姻是指夫妻关系从未存在过。 | 离婚和无效婚姻是指在婚姻制度中的两种不同状态。<br/>离婚是指婚姻关系已经无效或被撤销，双方可以通过法律程序结束婚姻关系。离婚的效力取决于婚姻无效的原因，如果婚姻无效是因为双方没有感情或没有按照法律规定结婚，那么离婚就是有效的。如果婚姻无效是因为婚姻本身存在问题，例如违反了法律规定或没有感情，那么离婚就无效。<br/>无效婚姻是指婚姻关系没有依法成立，或者依法成立的婚姻关系本身存在缺陷。无效婚姻的效力取决于婚姻无效的原因。如果婚姻无效是因为双方没有感情或没有按照法律规定结婚，那么婚姻就是无效的。如果婚姻无效是因为婚姻本身存在问题，例如违反了法律规定或没有感情，那么婚姻就是无效的。<br/>因此，离婚和无效婚姻之间的区别在于婚姻的无效原因和婚姻的效力。离婚是婚姻关系已经无效或被撤销，而无效婚姻是指婚姻关系没有依法成立或依法成立的婚姻关系本身存在缺陷。| 离婚和无效婚姻是两种不同的情况。离婚是指夫妻双方自愿解除婚姻关系，而无效婚姻是指在一定情况下，婚姻关系从一开始就没有成立或被认定无效。<br/>根据《民法典》第一千零五十一条规定，如果存在以下情形之一，婚姻将被视为无效：重婚、有禁止结婚的亲属关系、未到法定婚龄。如果婚姻被认定为无效，那么夫妻双方并不具备夫妻的权利和义务，也就不存在离婚的问题。<br/>而对于无效婚姻的财产处理，根据《民法典》第一千零五十四条规定，无效的或者被撤销的婚姻自始没有法律约束力，同居期间所得的财产，由当事人协议处理；协议不成的，由人民法院根据照顾无过错方的原则判决。同时，对于重婚导致的无效婚姻的财产处理，不得侵害合法婚姻当事人的财产权益。<br/>此外，《民法典》第一千零六十三条规定了夫妻共同财产和个人财产的范围，其中一方的婚前财产属于个人财产。因此，如果婚姻被认定为无效，夫妻双方的婚前财产仍属于各自所有。<br/>综上所述，离婚和无效婚姻是两种不同的情况，需要根据具体情况进行判断。如果您需要进一步了解相关法律问题，建议您咨询专业律师。|

</details>


<details>
<summary><b>Legal Consultation</b></summary>

**Input:** 分析案例：徐某（男）与李某（女）婚后育有一子（1岁半）、一女（8岁），两人准备离婚，都想争取孩子抚养权。徐某经济状况较好，工资收入是李某的数倍，认为自己胜券在握。李某虽收入不高，但女儿更愿意随其生活。

| **BELLE (13B)** | **ChatGLM (6B)** | **Lawyer LLaMA (13B)** |
| -- | -- | -- |
| 好的，根据你提供的信息，徐某和李某准备离婚，并且两人都想争取孩子抚养权。徐某的经济状况较好，工资收入是李某的数倍，他认为自己胜券在握。而李某虽然收入不高，但女儿更愿意随其生活。<br/>首先，我们需要了解在中国离婚案件中，孩子的抚养权通常是由法院决定的。法院会根据孩子的年龄、性别、父母的经济状况、父母的行为、父母之间的矛盾等因素来做出决定。在这个案例中，徐某的经济状况较好，但女儿更愿意随其生活。这意味着，如果徐某能够证明他能够提供更好的生活条件，法院可能会给他孩子的抚养权。<br/>然而，如果李某能够证明她能够提供更好的家庭环境，法院也可能会给她孩子的抚养权。 因此，在这个案例中，法院可能会考虑多种因素来做出决定，而孩子的意愿只是其中之一。| 这个案例涉及到孩子抚养权的问题，需要考虑多个因素来做出决定。以下是一些分析和建议：<br/>1. 孩子的年龄和需求：孩子在不同的年龄段有不同的需求和特点。1岁半的孩子通常需要关注他们的日常生活，如饮食、睡眠、安全等。8岁的孩子已经进入了青春期，需要更多的关 注和支持，以帮助他们发展社交技能和情感健康。因此，抚养权的归属需要考虑孩子的需求和年龄。<br/>2. 孩子的抚养权归属需要考虑父母之间的差异：徐某和李某的收入和职业背景差异可能会 对抚养权的归属产生影响。但更重要的是，孩子应该由最适合他们的人抚养。因此，需要比较双方的性格、习惯、教育方式、家庭环境等因素，以确定谁更适合抚养孩子。<br/>3. 孩子的意愿：尽管李某的女儿更愿意随其生活，但这并不代表孩子本人会同意跟徐某生 活。因此，抚养权的归属需要考虑孩子的意愿和意愿。如果孩子愿意跟李某生活，那么这可能会更有利于孩子的健康成长。<br/>4. 法律因素：根据中国的法律，孩子的抚养权应该根据有利于孩子成长的原则进行裁决。 这意味着，徐某的经济状况可能会对抚养权的归属产生影响。但是，最终裁决的应该是法律程序，而不是个人意见。<br/>综合以上因素，如果徐某的经济状况更好，并且孩子更愿意跟李某生活，那么李某可能会获得孩子的抚养权。但最终结果还需要根据法律程序来裁决，因此，建议双方在法律框架内进行沟通和协商，以达成一个最好的解决方案。| 根据《中华人民共和国婚姻法》的规定，子女抚养权的判决应当以未成年子女的利益为出发点，综合考虑父母的经济条件、身体情况、家庭环境等情况，最终确定抚养人。因此，在本案中，法院会综合考虑双方的经济能力、工作时间、居住环境等因素来判断抚养权归属问题。<br/>首先，徐某的经济条件好，收入水平较高，可以为孩子的成长提供更好的物质条件。但是，如果李某能够证明自己有更好的照顾孩子的能力，或者孩子的身心健康需要由她来照顾，那么她也有可能获得抚养权。<br/>其次，女儿年龄较大，已经八岁，对于她的意愿也应该有所考虑。如果女儿表示愿意随母亲生活，法院也会考虑到这一因素。<br/>综上所述，在本案中，法院会综合考虑双方的经济能力、照顾孩子的能力、女儿的意愿等因素来判决抚养权归属问题。建议双方积极沟通协商，尽量达成一致意见，并在法律程序中维护自己的合法权益。|

---

**Input:** 21 岁女子甲与25 岁男子乙在网上聊天后产生好感，乙将甲发给其的私密照片保存。后乙要求与甲结婚,甲不同意。乙威胁要公布其照片，甲只好同意结婚并办理了登记。甲是否可以自婚姻登记之日起 1年内请求撤销该婚姻？


| **BELLE (13B)** | **ChatGLM (6B)** | **Lawyer LLaMA (13B)** |
| -- | -- | -- |
| 根据《中华人民共和国婚姻法》规定，婚姻登记满一年后，双方可以提出离婚，但需要满足一定的条件。因此，甲可以在婚姻登记一年后申请离婚。| 根据中国《婚姻法》的规定，婚姻关系是自婚姻开始时即存在的，非经法定程序而不能消灭。婚姻无效的原因有：(一)重婚的；(二)有禁止结婚的疾病而结婚无效的；(三)因胁迫而结婚无效的；(四)自始没有感情而结婚无效的；(五)因欺诈而结婚无效的。婚姻无效、可依法撤销。甲可以自婚姻登记之日起 1 年内向当地人民法院提起撤销婚姻的诉讼。| 依据《民法典》第一千零五十二条规定，因胁迫结婚的，受胁迫的一方可以向人民法院请求撤销婚姻。因此，如果甲是在受到胁迫的情况下同意结婚的，那么甲可以在自婚姻登记之日起一年内向人民法院请求撤销婚姻。但是，需要进一步了解的是，是否存在胁迫的情况，以及胁迫的方式和手段等。<br/>另外，根据《民法典》第一千零四十六条规定，结婚应当男女双方完全自愿，禁止任何一方对另一方加以强迫，禁止任何组织或者个人加以干涉。如果甲是在完全自愿的情况下同意结婚的，那么甲无法请求撤销婚姻。<br/>综上所述，需要进一步了解甲同意结婚的具体情况，以及是否存在胁迫的情况。建议甲咨询专业律师，寻求专业的法律帮助。|

</details>

## Acknowledgement

Our project have received help from the following projects, and we would like to express our gratitude.

https://jecqa.thunlp.org/

https://opendata.pku.edu.cn/dataset.xhtml?persistentId=doi:10.18170/DVN/OLO4G8

https://github.com/tatsu-lab/stanford_alpaca

https://github.com/LianjiaTech/BELLE

https://github.com/ymcui/Chinese-LLaMA-Alpaca

https://github.com/pointnetwork/point-alpaca

Constributors of Lawyer LLaMA：

[Quzhe Huang](https://andrewzhe.github.io/)\*, Mingxu Tao\*, Zhenwei An*, [Chen Zhang](https://luciusssss.github.io/)\*, Cong Jiang, [Zhibin Chen](https://zacharychenpk.github.io/), [Zirui Wu](https://williamzr.github.io/), [Yansong Feng](https://sites.google.com/site/ysfeng/home)

\* Equal Contribution

This project is carried out under the guidance of Prof. Yansong Feng.

## **Limitations and Usage Restrictions**

The content of this project is only for academic research and should not be used for commercial purposes or any other uses that could harm society. When using parts involving third-party code, please strictly follow the corresponding open-source agreements.

The data used in this project is generated by ChatGPT, has not been rigorously validated, and may contain errors. Please be cautious and discerning when using it.

The model outputs in this project are not professional legal consultation results and may contain errors. If you need legal assistance, please seek help from professionals.

## Citation

If you use the contents of this project, or believe that this project has been helpful for your research, please cite this project.

```Plaintext
@misc{huang2023lawyer,
      title={Lawyer LLaMA Technical Report}, 
      author={Quzhe Huang and Mingxu Tao and Chen Zhang and Zhenwei An and Cong Jiang and Zhibin Chen and Zirui Wu and Yansong Feng},
      year={2023},
      eprint={2305.15062},
      archivePrefix={arXiv},
      primaryClass={cs.CL}
}

@misc{Lawyer-LLama,
  title={Lawyer Llama},
  author={Quzhe Huang and Mingxu Tao and Chen Zhang and Zhenwei An and Cong Jiang and Zhibin Chen and Zirui Wu and Yansong Feng},
  year={2023},
  publisher={GitHub},
  journal={GitHub repository},
  howpublished={\url{https://github.com/AndrewZhe/lawyer-llama}},
}
```
