# Contributing to Wishing Plan

We love your input! we want to make contributing to this project as easy and transparent as possible, whether it's:

- Reporting a bug
- Discussing the current state of the code
- Submitting a fix
- Proposing new features
- Becoming a maintainer

## We Develop with Github

We use github to host code, to track issues and feature requests, as well as accept pull requests.

## We Use [Github Flow](https://guides.github.com/introduction/flow/index.html), So All Code Changes Happen Through Pull Requests

Pull requests are the best way to propose changes to the codebase (We use [Github Flow](https://guides.github.com/introduction/flow/index.html)). We actively welcome your pull requests:

1. Create an issue, if you'd like a new feature or find a bug.
2. If you like to work on an issue, you can leave a comment on the issue to let us know.
   - We will then be able to assign you to the issue to let others know what is being worked on.
3. Fork the repo and create your branch from `master`.
4. If you've added code that should be tested, add tests.
5. If you've changed APIs, update the documentation.
6. Ensure the test suite passes.
7. [Create a pull request](https://docs.github.com/en/pull-requests/collaborating-with-pull-requests/proposing-changes-to-your-work-with-pull-requests/creating-a-pull-request-from-a-fork) from your forked repo to the `master` branch of the main repo
8. Remember to link issues to pull requests, if one is relevant.

## Report bugs using Github's [issues](https://github.com/Andreasgdp/Wishing-Plan/issues)

We use GitHub issues to track public bugs. Report a bug by [opening a new issue](https://github.com/Andreasgdp/Wishing-Plan/issues/new/choose); it's that easy!

## Write bug reports with detail, background, and sample code

**Great Bug Reports** tend to have:

- What actually happens
- What you expected would happen
- Steps to reproduce
  - Be specific!
  - Give sample code if you can.
- Notes (possibly including why you think this might be happening, or stuff you tried that didn't work)

People _love_ thorough bug reports. We're not even kidding.

## Use a Consistent Coding Style

- Use prettier to format your code before committing.

## License

By contributing, you agree that your contributions will be licensed under its GNU Affero General Public License v3.0.