# Contributor Covenant Code of Conduct

# Purpose

The purpose of this Code of Conduct is to ensure a positive, respectful, and constructive environment for all contributors to this project. We value the participation of every individual and strive to create an inclusive and harassment-free experience, both within the project spaces and when representing the community in public. We pledge to act in ways that foster an open, welcoming, diverse, inclusive, and professional community.

## Our Pledge
We as members, contributors, and leaders pledge to make participation in our community a harassment-free experience for everyone, regardless of age, body size, visible or invisible disability, ethnicity, sex characteristics, gender identity and expression, level of experience, education, socioeconomic status, nationality, personal appearance, race, religion, or sexual identity and orientation.

We pledge to act and interact in ways that contribute to a respectful, inclusive, and healthy community.

# Our Standards

# Acceptable Behavior

Examples of behavior that contributes to a positive environment for our community include:

* Respectful Communication: Being polite, empathetic, and supportive in all interactions.
* Inclusivity: Welcoming different perspectives and experiences.
* Constructive Criticism: Giving and gracefully accepting feedback while focusing on improvements.
* Accountability: Acknowledging mistakes, apologizing to those affected, and learning from the experience.
* Community First: Prioritizing what is best for the overall community.

# Unacceptable Behavior

Examples of unacceptable behavior include:

* The use of sexualized language or imagery, and sexual attention or advances of any kind.
* Trolling, insulting, or derogatory comments, and personal or political attacks.
* Public or private harassment.
* Publishing others' private information without their explicit permission.
* Any other conduct that could reasonably be considered inappropriate in a professional setting.
* Intimidation, threats, or aggressive behavior.
* Discrimination or exclusion based on individual characteristics.

# Reporting Violations
If you experience or witness unacceptable behavior, you can report it by submitting a Report:

Email a detailed report to admin.

# Information to Include: 

When submitting a report, include your contact information, a detailed account of the incident (including dates, times, and individuals involved), and any relevant supporting materials.
Confidentiality Assurance: All reports will be treated confidentially. We prioritize the safety and well-being of everyone involved.
Enforcement Responsibilities.Community leaders are responsible for clarifying and enforcing our standards of acceptable behavior and will take appropriate and fair corrective action in response to any behavior that they deem inappropriate, threatening, offensive, or harmful.

Community leaders have the right and responsibility to remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not aligned with this Code of Conduct, and will communicate reasons for moderation decisions when appropriate.

# Enforcement Guidelines
Community leaders will follow these Community Impact Guidelines to determine the consequences for any action they deem in violation of this Code of Conduct:

1. Correction
* Community Impact: Minor unprofessional or unwelcome behavior.
* Consequence: A private written warning from community leaders, providing clarity around the nature of the violation and an explanation of why the behavior was inappropriate. A public apology may be requested.
2. Warning
* Community Impact: A violation through a single incident or series of actions.
* Consequence: A warning with consequences for continued behavior. No interaction with the people involved, including unsolicited interaction with those enforcing the Code of Conduct, for a specified period of time. Violating these terms may lead to a temporary or permanent ban.
3. Temporary Ban
* Community Impact: A serious violation of community standards.
* Consequence: A temporary ban from any sort of interaction or public communication with the community for a specified period of time. No public or private interaction with the people involved, including unsolicited interaction with those enforcing the Code of Conduct, is allowed during this period. Violating these terms may lead to a permanent ban.
4. Permanent Ban
* Community Impact: Repeated violations, harassment, or aggression.
* Consequence: A permanent ban from any sort of public interaction within the community.

## Scope

This Code of Conduct applies within all project spaces, including repositories, issue trackers, chat channels, mailing lists, and any other forms of communication. It also applies when an individual is officially representing the community in public spaces. Examples of representation include using an official e-mail address, posting via an official social media account, or acting as an appointed representative at an event.

## Attribution

This Code of Conduct is adapted from the [Contributor
Covenant][homepage], version 2.0, available at
https://www.contributor-covenant.org/version/2/0/code_of_conduct.html.

Community Impact Guidelines were inspired by [Mozilla's code of
conduct enforcement ladder](https://github.com/mozilla/diversity).

[homepage]: https://www.contributor-covenant.org

For answers to common questions about this code of conduct, see the
FAQ at https://www.contributor-covenant.org/faq. Translations are
available at https://www.contributor-covenant.org/translations.


## Contact Information

For any questions or further clarification, please contact admin.