package com.nonononoki.alovoa.html;

import com.nonononoki.alovoa.component.TextEncryptorConverter;
import com.nonononoki.alovoa.entity.User;
import com.nonononoki.alovoa.entity.user.UserDeleteToken;
import com.nonononoki.alovoa.model.AlovoaException;
import com.nonononoki.alovoa.model.UserDto;
import com.nonononoki.alovoa.service.AuthService;
import com.nonononoki.alovoa.service.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Date;

@Controller
@RequestMapping("/")
public class DeleteAccountResource {

    @Autowired
    private TextEncryptorConverter textEncryptor;

    @Value("${app.user.delete.duration.valid}")
    private long accountDeleteDuration;

    @GetMapping("/delete-account/{tokenString}")
    public ModelAndView deleteAccount(@PathVariable String tokenString) {
        ModelAndView mav = new ModelAndView("delete-account");
        mav.addObject("tokenString", tokenString);
        return mav;
    }

    @GetMapping("/delete-account-request")
    public ModelAndView deleteAccountRequest() {
        return new ModelAndView("delete-account-request");
    }
}
