package main

import "fmt"

// darwin

func darwinPlist(name string) string {
	return fmt.Sprintf(`<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE plist PUBLIC "-//Apple//DTD PLIST 1.0//EN" "http://www.apple.com/DTDs/PropertyList-1.0.dtd">
<plist version="1.0">
<dict>
	<key>CFBundleExecutable</key>
	<string>%[1]v</string>
	<key>CFBundleGetInfoString</key>
	<string>Created by giu</string>
	<key>CFBundleIconFile</key>
	<string>%[1]v.icns</string>
	<key>CFBundleIdentifier</key>
	<string>com.yourcompany.%[1]v</string>
	<key>CFBundleName</key>
	<string>%[1]v</string>
	<key>CFBundlePackageType</key>
	<string>APPL</string>
	<key>CFBundleShortVersionString</key>
	<string>1.0.0</string>
	<key>CFBundleSignature</key>
	<string>????</string>
	<key>LSMinimumSystemVersion</key>
	<string>10.11</string>
	<key>NOTE</key>
	<string>This file was generated by giu.</string>
	<key>NSPrincipalClass</key>
	<string>NSApplication</string>
	<key>NSHighResolutionCapable</key>
	<true/>
	<key>NSSupportsAutomaticGraphicsSwitching</key>
	<true/>
</dict>
</plist>
`, name)
}

func darwinPkginfo() string {
	return "APPL????\n"
}

// linux

func linuxDesktop(name string, hasIcon bool) string {
	result := fmt.Sprintf(`[Desktop Entry]
Name=%s
Exec=%s
`, name, name,
	)

	if hasIcon {
		result += fmt.Sprintf(
			"Icon=%s\n", name,
		)
	}

	result += `Terminal=false
Type=Application
`

	return result
}
