package giu

import (
	"github.com/AllenDang/cimgui-go/imgui"
	"github.com/AllenDang/cimgui-go/implot"
)

// Here are the style IDs for styling imgui apps.
// For details about each of attributes read comment above them.

// go-generate String() andStringToEnum methods
//go:generate go run github.com/dmarkham/enumer@latest -linecomment -type=StyleColorID .
//go:generate go run github.com/dmarkham/enumer@latest -linecomment -type=StyleVarID .
//go:generate go run github.com/dmarkham/enumer@latest -linecomment -type=StylePlotColorID .
//go:generate go run github.com/dmarkham/enumer@latest -linecomment -type=StylePlotVarID .

// StyleColorID identifies a color in the UI style.
type StyleColorID imgui.Col

// StyleColor identifier.
// NOTE: comments are used for CSS conversion and are generated by stringer and string2enum.
const (
	StyleColorText                  StyleColorID = StyleColorID(imgui.ColText)                  // color
	StyleColorTextDisabled          StyleColorID = StyleColorID(imgui.ColTextDisabled)          // disabled-color
	StyleColorWindowBg              StyleColorID = StyleColorID(imgui.ColWindowBg)              // background-color
	StyleColorChildBg               StyleColorID = StyleColorID(imgui.ColChildBg)               // child-background-color
	StyleColorPopupBg               StyleColorID = StyleColorID(imgui.ColPopupBg)               // popup-background-color
	StyleColorBorder                StyleColorID = StyleColorID(imgui.ColBorder)                // border-color
	StyleColorBorderShadow          StyleColorID = StyleColorID(imgui.ColBorderShadow)          // border-shadow-color
	StyleColorFrameBg               StyleColorID = StyleColorID(imgui.ColFrameBg)               // frame-background-color
	StyleColorFrameBgHovered        StyleColorID = StyleColorID(imgui.ColFrameBgHovered)        // frame-background-hovered-color
	StyleColorFrameBgActive         StyleColorID = StyleColorID(imgui.ColFrameBgActive)         // frame-background-active-color
	StyleColorTitleBg               StyleColorID = StyleColorID(imgui.ColTitleBg)               // title-background-color
	StyleColorTitleBgActive         StyleColorID = StyleColorID(imgui.ColTitleBgActive)         // title-background-active-color
	StyleColorTitleBgCollapsed      StyleColorID = StyleColorID(imgui.ColTitleBgCollapsed)      // title-background-collapsed-color
	StyleColorMenuBarBg             StyleColorID = StyleColorID(imgui.ColMenuBarBg)             // menu-bar-background-color
	StyleColorScrollbarBg           StyleColorID = StyleColorID(imgui.ColScrollbarBg)           // scrollbar-background-color
	StyleColorScrollbarGrab         StyleColorID = StyleColorID(imgui.ColScrollbarGrab)         // scrollbar-grab-color
	StyleColorScrollbarGrabHovered  StyleColorID = StyleColorID(imgui.ColScrollbarGrabHovered)  // scrollbar-grab-hovered-color
	StyleColorScrollbarGrabActive   StyleColorID = StyleColorID(imgui.ColScrollbarGrabActive)   // scrollbar-grab-active-color
	StyleColorCheckMark             StyleColorID = StyleColorID(imgui.ColCheckMark)             // checkmark-color
	StyleColorSliderGrab            StyleColorID = StyleColorID(imgui.ColSliderGrab)            // slider-grab-color
	StyleColorSliderGrabActive      StyleColorID = StyleColorID(imgui.ColSliderGrabActive)      // slider-grab-active-color
	StyleColorButton                StyleColorID = StyleColorID(imgui.ColButton)                // button-color
	StyleColorButtonHovered         StyleColorID = StyleColorID(imgui.ColButtonHovered)         // button-hovered-color
	StyleColorButtonActive          StyleColorID = StyleColorID(imgui.ColButtonActive)          // button-active-color
	StyleColorHeader                StyleColorID = StyleColorID(imgui.ColHeader)                // header-color
	StyleColorHeaderHovered         StyleColorID = StyleColorID(imgui.ColHeaderHovered)         // header-hovered-color
	StyleColorHeaderActive          StyleColorID = StyleColorID(imgui.ColHeaderActive)          // header-active-color
	StyleColorSeparator             StyleColorID = StyleColorID(imgui.ColSeparator)             // separator-color
	StyleColorSeparatorHovered      StyleColorID = StyleColorID(imgui.ColSeparatorHovered)      // separator-hovered-color
	StyleColorSeparatorActive       StyleColorID = StyleColorID(imgui.ColSeparatorActive)       // separator-active-color
	StyleColorResizeGrip            StyleColorID = StyleColorID(imgui.ColResizeGrip)            // resize-grip-color
	StyleColorResizeGripHovered     StyleColorID = StyleColorID(imgui.ColResizeGripHovered)     // resize-grip-hovered-color
	StyleColorResizeGripActive      StyleColorID = StyleColorID(imgui.ColResizeGripActive)      // resize-grip-active-color
	StyleColorTab                   StyleColorID = StyleColorID(imgui.ColTab)                   // tab-color
	StyleColorTabHovered            StyleColorID = StyleColorID(imgui.ColTabHovered)            // tab-hovered-color
	StyleColorTabActive             StyleColorID = StyleColorID(imgui.ColTabSelected)           // tab-active-color
	StyleColorTabUnfocused          StyleColorID = StyleColorID(imgui.ColTabDimmed)             // tab-unfocused-color
	StyleColorTabUnfocusedActive    StyleColorID = StyleColorID(imgui.ColTabDimmedSelected)     // tab-unfocused-active-color
	StyleColorPlotLines             StyleColorID = StyleColorID(imgui.ColPlotLines)             // plot-lines-color
	StyleColorPlotLinesHovered      StyleColorID = StyleColorID(imgui.ColPlotLinesHovered)      // plot-lines-hovered-color
	StyleColorProgressBarActive     StyleColorID = StyleColorPlotLinesHovered                   // progress-bar-active-color
	StyleColorPlotHistogram         StyleColorID = StyleColorID(imgui.ColPlotHistogram)         // plot-histogram-color
	StyleColorPlotHistogramHovered  StyleColorID = StyleColorID(imgui.ColPlotHistogramHovered)  // plot-histogram-hovered-color
	StyleColorTableHeaderBg         StyleColorID = StyleColorID(imgui.ColTableHeaderBg)         // table-header-background-color
	StyleColorTableBorderStrong     StyleColorID = StyleColorID(imgui.ColTableBorderStrong)     // table-border-strong-color
	StyleColorTableBorderLight      StyleColorID = StyleColorID(imgui.ColTableBorderLight)      // table-border-light-color
	StyleColorTableRowBg            StyleColorID = StyleColorID(imgui.ColTableRowBg)            // table-row-background-color
	StyleColorTableRowBgAlt         StyleColorID = StyleColorID(imgui.ColTableRowBgAlt)         // table-row-alternate-background-color
	StyleColorTextSelectedBg        StyleColorID = StyleColorID(imgui.ColTextSelectedBg)        // text-selected-background-color
	StyleColorDragDropTarget        StyleColorID = StyleColorID(imgui.ColDragDropTarget)        // drag-drop-target-color
	StyleColorNavHighlight          StyleColorID = StyleColorID(imgui.ColNavWindowingHighlight) // navigation-highlight-color
	StyleColorNavWindowingHighlight StyleColorID = StyleColorID(imgui.ColNavWindowingHighlight) // windowing-highlight-color
	StyleColorNavWindowingDimBg     StyleColorID = StyleColorID(imgui.ColNavWindowingDimBg)     // windowing-dim-background-color
	StyleColorModalWindowDimBg      StyleColorID = StyleColorID(imgui.ColModalWindowDimBg)      // modal-window-dim-background-color
)

// StyleVarID identifies a style variable in the UI style.
type StyleVarID imgui.StyleVar

// Style IDs.
// comments at same line is a CSS name.
const (
	// StyleVarAlpha is a float.
	StyleVarAlpha StyleVarID = StyleVarID(imgui.StyleVarAlpha) // alpha
	// StyleVarDisabledAlpha is a float.
	StyleVarDisabledAlpha StyleVarID = StyleVarID(imgui.StyleVarDisabledAlpha) // disabled-alpha
	// StyleVarWindowPadding is a Vec2.
	StyleVarWindowPadding StyleVarID = StyleVarID(imgui.StyleVarWindowPadding) // window-padding
	// StyleVarWindowRounding is a float.
	StyleVarWindowRounding StyleVarID = StyleVarID(imgui.StyleVarWindowRounding) // window-rounding
	// StyleVarWindowBorderSize is a float.
	StyleVarWindowBorderSize StyleVarID = StyleVarID(imgui.StyleVarWindowBorderSize) // window-border-size
	// StyleVarWindowMinSize is a Vec2.
	StyleVarWindowMinSize StyleVarID = StyleVarID(imgui.StyleVarWindowMinSize) // window-minValue-size
	// StyleVarWindowTitleAlign is a Vec2.
	StyleVarWindowTitleAlign StyleVarID = StyleVarID(imgui.StyleVarWindowTitleAlign) // window-title-align
	// StyleVarChildRounding is a float.
	StyleVarChildRounding StyleVarID = StyleVarID(imgui.StyleVarChildRounding) // child-rounding
	// StyleVarChildBorderSize is a float.
	StyleVarChildBorderSize StyleVarID = StyleVarID(imgui.StyleVarChildBorderSize) // child-border-size
	// StyleVarPopupRounding is a float.
	StyleVarPopupRounding StyleVarID = StyleVarID(imgui.StyleVarPopupRounding) // popup-rounding
	// StyleVarPopupBorderSize is a float.
	StyleVarPopupBorderSize StyleVarID = StyleVarID(imgui.StyleVarPopupBorderSize) // popup-border-size
	// StyleVarFramePadding is a Vec2.
	StyleVarFramePadding StyleVarID = StyleVarID(imgui.StyleVarFramePadding) // frame-padding
	// StyleVarFrameRounding is a float.
	StyleVarFrameRounding StyleVarID = StyleVarID(imgui.StyleVarFrameRounding) // frame-rounding
	// StyleVarFrameBorderSize is a float.
	StyleVarFrameBorderSize StyleVarID = StyleVarID(imgui.StyleVarFrameBorderSize) // frame-border-size
	// StyleVarItemSpacing is a Vec2.
	StyleVarItemSpacing StyleVarID = StyleVarID(imgui.StyleVarItemSpacing) // item-spacing
	// StyleVarItemInnerSpacing is a Vec2.
	StyleVarItemInnerSpacing StyleVarID = StyleVarID(imgui.StyleVarItemInnerSpacing) // item-inner-spacing
	// StyleVarIndentSpacing is a float.
	StyleVarIndentSpacing StyleVarID = StyleVarID(imgui.StyleVarIndentSpacing) // indent-spacing
	// StyleVarCellPadding is a Vec2.
	StyleVarCellPadding StyleVarID = StyleVarID(imgui.StyleVarCellPadding)
	// StyleVarScrollbarSize is a float.
	StyleVarScrollbarSize StyleVarID = StyleVarID(imgui.StyleVarScrollbarSize) // scrollbar-size
	// StyleVarScrollbarRounding is a float.
	StyleVarScrollbarRounding StyleVarID = StyleVarID(imgui.StyleVarScrollbarRounding) // scrollbar-rounding
	// StyleVarGrabMinSize is a float.
	StyleVarGrabMinSize StyleVarID = StyleVarID(imgui.StyleVarGrabMinSize) // grab-minValue-size
	// StyleVarGrabRounding is a float.
	StyleVarGrabRounding StyleVarID = StyleVarID(imgui.StyleVarGrabRounding) // grab-rounding
	// StyleVarTabRounding is a float.
	StyleVarTabRounding StyleVarID = StyleVarID(imgui.StyleVarTabRounding) // tab-rounding
	// StyleVarTabBarBorderSize is a float.
	StyleVarTabBarBorderSize StyleVarID = StyleVarID(imgui.StyleVarTabBarBorderSize)
	// StyleVarButtonTextAlign is a Vec2.
	StyleVarButtonTextAlign StyleVarID = StyleVarID(imgui.StyleVarButtonTextAlign) // button-text-align
	// StyleVarSelectableTextAlign is a Vec2.
	StyleVarSelectableTextAlign StyleVarID = StyleVarID(imgui.StyleVarSelectableTextAlign) // selectable-text-align
	// StyleVarSeparatorTextBorderSize is a float.
	StyleVarSeparatorTextBorderSize StyleVarID = StyleVarID(imgui.StyleVarSeparatorTextBorderSize)
	// SeparatorTextAlign is an ImVec2.
	StyleVarSeparatorTextAlign StyleVarID = StyleVarID(imgui.StyleVarSeparatorTextAlign)
	// SeparatorTextPadding is an ImVec2.
	StyleVarSeparatorTextPadding StyleVarID = StyleVarID(imgui.StyleVarSeparatorTextPadding)
	// DockingSeparatorSize is a float.
	StyleVarDockingSeparatorSize StyleVarID = StyleVarID(imgui.StyleVarDockingSeparatorSize)
)

// IsVec2 returns true if the style var id should be processed as imgui.Vec2
// if not, it is interpreted as float32.
func (i StyleVarID) IsVec2() bool {
	lookup := map[StyleVarID]bool{
		// StyleVarWindowPadding is a Vec2.
		StyleVarWindowPadding:    true,
		StyleVarWindowMinSize:    true,
		StyleVarWindowTitleAlign: true,
		StyleVarFramePadding:     true,
		StyleVarItemSpacing:      true,
		// StyleVarItemInnerSpacing is a Vec2.
		StyleVarItemInnerSpacing:    true,
		StyleVarButtonTextAlign:     true,
		StyleVarSelectableTextAlign: true,
	}

	result, ok := lookup[i]

	return result && ok
}

// StylePlotColorID represents an ID of plot color.
type StylePlotColorID int

// List of plot color IDs.
const (
	StylePlotColorLine          StylePlotColorID = StylePlotColorID(implot.ColLine)          // plot-line
	StylePlotColorFill          StylePlotColorID = StylePlotColorID(implot.ColFill)          // plot-fill
	StylePlotColorMarkerOutline StylePlotColorID = StylePlotColorID(implot.ColMarkerOutline) // plot-marker-outline
	StylePlotColorMarkerFill    StylePlotColorID = StylePlotColorID(implot.ColMarkerFill)    // plot-Marker-Fill
	StylePlotColorErrorBar      StylePlotColorID = StylePlotColorID(implot.ColErrorBar)      // plot-error-bar
	StylePlotColorFrameBg       StylePlotColorID = StylePlotColorID(implot.ColFrameBg)       // plot-frame-bg
	StylePlotColorPlotBg        StylePlotColorID = StylePlotColorID(implot.ColPlotBg)        // plot-plot-bg
	StylePlotColorPlotBorder    StylePlotColorID = StylePlotColorID(implot.ColPlotBorder)    // plot-plot-border
	StylePlotColorLegendBg      StylePlotColorID = StylePlotColorID(implot.ColLegendBg)      // plot-legend-bg
	StylePlotColorLegendBorder  StylePlotColorID = StylePlotColorID(implot.ColLegendBorder)  // plot-legend-border
	StylePlotColorLegendText    StylePlotColorID = StylePlotColorID(implot.ColLegendText)    // plot-legend-text
	StylePlotColorTitleText     StylePlotColorID = StylePlotColorID(implot.ColTitleText)     // plot-title-text
	StylePlotColorInlayText     StylePlotColorID = StylePlotColorID(implot.ColInlayText)     // plot-inlay-text
	StylePlotColorAxisText      StylePlotColorID = StylePlotColorID(implot.ColAxisText)      // plot-axis-text
	StylePlotColorAxisGrid      StylePlotColorID = StylePlotColorID(implot.ColAxisGrid)      // plot-axis-grid
	StylePlotColorAxisTick      StylePlotColorID = StylePlotColorID(implot.ColAxisTick)      // plot-axis-tick
	StylePlotColorAxisBg        StylePlotColorID = StylePlotColorID(implot.ColAxisBg)        // plot-axis-bg
	StylePlotColorAxisBgHovered StylePlotColorID = StylePlotColorID(implot.ColAxisBgHovered) // plot-axis-bg-hovered
	StylePlotColorAxisBgActive  StylePlotColorID = StylePlotColorID(implot.ColAxisBgActive)  // plot-axis-bg-active
	StylePlotColorSelection     StylePlotColorID = StylePlotColorID(implot.ColSelection)     // plot-selection
	StylePlotColorCrosshairs    StylePlotColorID = StylePlotColorID(implot.ColCrosshairs)    // plot-crosshairs
)

// StylePlotVarID represents an ID of plot style variable.
type StylePlotVarID imgui.StyleVar

// List of plot style variable IDs.
const (
	StylePlotVarLineWeight         StylePlotVarID = StylePlotVarID(implot.StyleVarLineWeight)         // plot-line-weight
	StylePlotVarMarker             StylePlotVarID = StylePlotVarID(implot.StyleVarMarker)             // plot-marker
	StylePlotVarMarkerSize         StylePlotVarID = StylePlotVarID(implot.StyleVarMarkerSize)         // plot-marker-size
	StylePlotVarMarkerWeight       StylePlotVarID = StylePlotVarID(implot.StyleVarMarkerWeight)       // plot-marker-weight
	StylePlotVarFillAlpha          StylePlotVarID = StylePlotVarID(implot.StyleVarFillAlpha)          // plot-fill-alpha
	StylePlotVarErrorBarSize       StylePlotVarID = StylePlotVarID(implot.StyleVarErrorBarSize)       // plot-error-bar-size
	StylePlotVarErrorBarWeight     StylePlotVarID = StylePlotVarID(implot.StyleVarErrorBarWeight)     // plot-error-bar-weight
	StylePlotVarDigitalBitHeight   StylePlotVarID = StylePlotVarID(implot.StyleVarDigitalBitHeight)   // plot-digital-bit-height
	StylePlotVarDigitalBitGap      StylePlotVarID = StylePlotVarID(implot.StyleVarDigitalBitGap)      // plot-digital-bit-gap
	StylePlotVarPlotBorderSize     StylePlotVarID = StylePlotVarID(implot.StyleVarPlotBorderSize)     // plot-border-size
	StylePlotVarMinorAlpha         StylePlotVarID = StylePlotVarID(implot.StyleVarMinorAlpha)         // plot-minor-alpha
	StylePlotVarMajorTickLen       StylePlotVarID = StylePlotVarID(implot.StyleVarMajorTickLen)       // plot-major-tick-len
	StylePlotVarMinorTickLen       StylePlotVarID = StylePlotVarID(implot.StyleVarMinorTickLen)       // plot-minor-tick-len
	StylePlotVarMajorTickSize      StylePlotVarID = StylePlotVarID(implot.StyleVarMajorTickSize)      // plot-major-tick-size
	StylePlotVarMinorTickSize      StylePlotVarID = StylePlotVarID(implot.StyleVarMinorTickSize)      // plot-minor-tick-size
	StylePlotVarMajorGridSize      StylePlotVarID = StylePlotVarID(implot.StyleVarMajorGridSize)      // plot-major-grid-size
	StylePlotVarMinorGridSize      StylePlotVarID = StylePlotVarID(implot.StyleVarMinorGridSize)      // plot-minor-grid-size
	StylePlotVarPlotPadding        StylePlotVarID = StylePlotVarID(implot.StyleVarPlotPadding)        // plot-padding
	StylePlotVarLabelPadding       StylePlotVarID = StylePlotVarID(implot.StyleVarLabelPadding)       // plot-label-padding
	StylePlotVarLegendPadding      StylePlotVarID = StylePlotVarID(implot.StyleVarLegendPadding)      // plot-legend-padding
	StylePlotVarLegendInnerPadding StylePlotVarID = StylePlotVarID(implot.StyleVarLegendInnerPadding) // plot-legend-inner-padding
	StylePlotVarLegendSpacing      StylePlotVarID = StylePlotVarID(implot.StyleVarLegendSpacing)      // plot-legend-spacing
	StylePlotVarMousePosPadding    StylePlotVarID = StylePlotVarID(implot.StyleVarMousePosPadding)    // plot-mouse-pos-padding
	StylePlotVarAnnotationPadding  StylePlotVarID = StylePlotVarID(implot.StyleVarAnnotationPadding)  // plot-annotation-padding
	StylePlotVarFitPadding         StylePlotVarID = StylePlotVarID(implot.StyleVarFitPadding)         // plot-fit-padding
	StylePlotVarPlotDefaultSize    StylePlotVarID = StylePlotVarID(implot.StyleVarPlotDefaultSize)    // plot-default-size
	StylePlotVarPlotMinSize        StylePlotVarID = StylePlotVarID(implot.StyleVarPlotMinSize)        // plot-min-size
	StylePlotVarCOUNT              StylePlotVarID = StylePlotVarID(implot.StyleVarCOUNT)
)

// IsVec2 returns true if the style plot var id should be processed as imgui.Vec2
// if not, it is interpreted as float32.
func (i StylePlotVarID) IsVec2() bool {
	lookup := map[StylePlotVarID]bool{
		StylePlotVarMajorTickLen:       true,
		StylePlotVarMinorTickLen:       true,
		StylePlotVarMajorTickSize:      true,
		StylePlotVarMinorTickSize:      true,
		StylePlotVarMajorGridSize:      true,
		StylePlotVarMinorGridSize:      true,
		StylePlotVarPlotPadding:        true,
		StylePlotVarLabelPadding:       true,
		StylePlotVarLegendPadding:      true,
		StylePlotVarLegendInnerPadding: true,
		StylePlotVarLegendSpacing:      true,
		StylePlotVarMousePosPadding:    true,
		StylePlotVarAnnotationPadding:  true,
		StylePlotVarFitPadding:         true,
		StylePlotVarPlotDefaultSize:    true,
		StylePlotVarPlotMinSize:        true,
	}

	result, ok := lookup[i]

	return result && ok
}
