# Thorium Code of Conduct <img src="https://github.com/Alex313031/thorium/blob/main/logos/NEW/COC_Light.png#gh-dark-mode-only" width="32"> <img src="https://github.com/Alex313031/thorium/blob/main/logos/NEW/COC_Dark.png#gh-light-mode-only" width="32">

<img src="https://github.com/Alex313031/thorium/blob/main/logos/NEW/Thorium_COC_Light.png#gh-dark-mode-only" width="256"> <img src="https://github.com/Alex313031/thorium/blob/main/logos/NEW/Thorium_COC_Dark.png#gh-light-mode-only" width="256">

The Thorium Authors and the Chromium team are committed to preserving and fostering a
diverse, welcoming community. Below is our community code of conduct, which
applies to the Thorium repository, the Chromium repository, Alex313031 blog content, and any other Chromium-supported communication group or Thorium discussion board, as well as any private communication initiated in the context of these
spaces, including GitHub Issues. This code of conduct must be followed by everyone contributing to or engaging with
the Thorium project, regardless of affiliation or position.

Simply put, community discussions should be

 * respectful and kind;
 * about Thorium and/or Chromium;
 * about features and code, not the individuals involved (although friendly personal joking or discussion about individual matters is allowed).

## Be respectful and constructive.

Treat everyone with respect. Build on each other's ideas. Each of us has the
right to enjoy our developer experience and participate without fear of harassment,
discrimination, or condescension, whether blatant or subtle. Remember that
Thorium and Chromium is a geographically distributed team and that you may not be
communicating with someone in their primary language. We all get frustrated
when working on hard problems, but we cannot allow that frustration to turn
into personal attacks.

## Speak up if you see or hear something.

You are empowered to politely engage when you feel that you or others are
disrespected. The person making you feel uncomfortable may not be aware of what
they are doing - politely bringing their behavior to their attention is
encouraged.

## Contacting
If you are uncomfortable speaking up, or feel that your concerns are not being
duly considered, you can email me at Alex313031@gmail.com, or if it is specific to Chromium, at community@chromium.org to request involvement
from a community manager. Please note that without a way to contact you, an anonymous report may be
difficult to act on. You may also create a throwaway account to report. In
cases where a public response is deemed necessary, the identities of victims
and reporters will remain confidential unless those individuals instruct us
otherwise.

I will always respond in some way, but also keep in mind that while all reports will be taken seriously, I or the Chromium community managers may
not act on complaints that we feel are not violations of this code of conduct.

## We will not tolerate harassment of any kind, including but not limited to:

 * Harassing comments
 * Intimidation
 * Encouraging a person to engage in self-harm.
 * Sustained disruption or derailing of threads, channels, lists, etc.
 * Offensive or violent comments, jokes or otherwise
 * Sustained disruption of discussion
 * Inappropriate sexual content
 * Unwelcome sexual or otherwise aggressive attention
 * Continued one-on-one communication after requests to cease
 * Distribution or threat of distribution of people's personally identifying
   information, AKA “doxing”

## Consequences for failing to comply with this policy

Consequences for failing to comply with this policy may include, at the sole
discretion of the a Thorium Maintainer or the Chromium community managers:

 * a request for an apology;
 * a private or public warning or reprimand;
 * a temporary ban from the mailing list, blog, Chromium repository or
   organization, or other Chromium-supported communication group, including
   loss of committer status;
 * a temporary ban from the Thorium repository, discussion groups, or blog.
 * a permanent ban from any of the above, or from all current and future
   Thorium-supported or Chromium-supported communities, including loss of
   committer/maintainer status.

Participants warned to stop any harassing behavior are expected to comply
immediately; failure to do so will result in an escalation of consequences.

## Acknowledgements

This Code of Conduct is based on the Chromium Code of Conduct > https://chromium.googlesource.com/chromium/src/+/master/CODE_OF_CONDUCT.md, which is based on the Geek Feminism Code of Conduct > https://geekfeminismdotorg.wordpress.com/about/code-of-conduct/, the Django
Code of Conduct > https://www.djangoproject.com/conduct/, and the Geek Feminism Wiki "Effective codes of conduct" guide > https://geekfeminism.fandom.com/wiki/Code_of_conduct_evaluations.

## License

This Code of Conduct is available for reuse under the Creative Commons Zero
(CC0) license. https://creativecommons.org/publicdomain/zero/1.0/legalcode
