# Awesome Semantic-Search [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)  [![Conventional Commits](https://img.shields.io/badge/Conventional%20Commits-1.0.0-yellow.svg)](https://conventionalcommits.org)



<img src ="logo.svg" />


Logo hecho por [@createdbytango](https://instagram.com/createdbytango). 

Este repositorio intenta ser un meta-repositorio para los temas relacionados [Búsqueda Semántica](https://en.wikipedia.org/wiki/Semantic_search) and [Similaridad Semántica](http://nlpprogress.com/english/semantic_textual_similarity.html).

La búsqueda semántica no está limitada solamente a texto! Puede hacerse con imágenes, discursos, etcétera. Es por eso que hay muchos casos en los que la búsqueda semántica se puede aplicar.

## Índice

- [Papers](#papers)
    - [2014](#2014)
    - [2015](#2015)
    - [2016](#2016)
    - [2017](#2017)
    - [2018](#2018)
    - [2019](#2019)
    - [2020](#2020)
    - [2021](#2021)
- [Artículos](#articulos)
- [Librerías y Herramientas](#librerías-y-herramientas)
- [Conjuntos de datos](#conjuntos-de-datos)
- [Hitos](#hitos)

## Papers
### 2014 
- [Un modelo semántico latente con  estructura Pooling Convolucional para la recopilación de información](https://www.microsoft.com/en-us/research/wp-content/uploads/2016/02/cikm2014_cdssm_final.pdf) 📄

### 2015
- [Vectores Skip-Thought](https://arxiv.org/pdf/1506.06726.pdf) 📄

### 2016
- [Bolsa de trucos para la clasificación eficiente de textos](https://arxiv.org/abs/1607.01759) 📄
- [Vectores de palabras enrriquecedores con información Subword](https://arxiv.org/abs/1607.04606) 📄
- [Aproximaciones robustas y eficientes para la búsqueda del vecino mas cercano usando grafos Jerárquicos Navegables de Mundos Pequeños](https://arxiv.org/abs/1603.09320)
- [Sobre la aproximación al buscar Embeddings de Palabras Similares](https://www.aclweb.org/anthology/P16-1214.pdf) 
- [Aprendiendo las Distribuciones de Representaciones de Oraciones a partir de Información Sin Clasificar](https://arxiv.org/abs/1602.03483)📄

### 2017
- [Aprendizaje supervisado de las Representaciones de Oraciones Universales a partir de  el Lenguaje Natural de los Datos de Inferencia](https://research.fb.com/wp-content/uploads/2017/09/emnlp2017.pdf) 📄

### 2018
- [Codificador de Oraciones Universal](https://arxiv.org/pdf/1803.11175.pdf) 📄
- [Aprendiendo la Similaridad Semántica Textual a partir de conversaciones](https://arxiv.org/pdf/1804.07754.pdf) 📄
- [Blog de IA de Google: Avances en la Similaridad Textual Semántica](https://ai.googleblog.com/2018/05/advances-in-semantic-textual-similarity.html) 📄
- [Optimización de la Indexación basada en los k Vecinos más Cercanos por Proximidad en Búsqueda en Datos de Varias Dimensiones](https://arxiv.org/abs/1810.07355)

### 2019
- [ROAL: Representaciones de Oraciones Agnósticas del Lenguaje](https://engineering.fb.com/2019/01/22/ai-research/laser-multilingual-sentence-embeddings/) 📄
- [Expansión de Documentos por Predicción de Consultas](https://arxiv.org/abs/1904.08375) 📄
- [Oraciones-BERT: Embeddings de Oraciones usando Redes Siamesas BERT](https://arxiv.org/pdf/1908.10084.pdf) 📄
- [Ranking de Oraciones Multi Fase con BERT](https://arxiv.org/abs/1910.14424) 📄
- [Recuperación Latente para Respuestas a preguntas de dominio abierto Débilmente Supervisadas](https://arxiv.org/abs/1906.00300)
- [End-to-End Respuestas a Preguntas de Dominio Abierto con BERTserini](https://www.aclweb.org/anthology/N19-4013/)

### 2020
- [Desplegando Rapidamente un Mecanismo de Búsqueda Neuronal para los Conjuntos de Datos de Investigación Abiertos de  COVID-19: Pensamientos Preeliminares y Lecciones Aprendidas](https://arxiv.org/abs/2004.05125) 📄
- [RE-CLASIFICACIÓN DE PASAJE CON BERT](https://arxiv.org/pdf/1901.04085.pdf) 📄
- [CO-Búsqueda: Recuperación de infomación de COVID-19 con Búsqueda Semántica, Respondiendo Preguntas y Resumen Abstracto.](https://arxiv.org/pdf/2006.09595.pdf) 📄
- [EOALaB: Embedding de Oraciones Agnósticas del lenguaje BERTLanguage-agnostic BERT Sentence Embedding](https://arxiv.org/abs/2007.01852) 📄
- [Covidex: Modelos de Ranking Neural e Infraestructura de Búsqueda de Palabras Clave para los Conjuntos de Datos abiertos de COVID-19](https://arxiv.org/abs/2007.07846) 📄
- [DeText: Un framework profundo de NLP para entender textos inteligentes](https://engineering.linkedin.com/blog/2020/open-sourcing-detext) 📄
- [Haciendo Embeddings de Oraciones Monolinguales Multilinguales usando Destilación de Conocimiento](https://arxiv.org/pdf/2004.09813.pdf) 📄
- [Transformadores Preentrenados para Ranking de textos: BERT y más allá](https://arxiv.org/abs/2010.06467) 📄
- [LMPRA: Language de Modelo Preentrenado para Recuperacion Aumentada](https://arxiv.org/abs/2002.08909)
- [ELECTRA: PREENTRENANDO CODIFICADORES DE TEXTOS COMO DISCRIMINADORES EN VEZ DE COMO GENERADORES](https://openreview.net/pdf?id=r1xMH1BtvB)📄
### 2021
- [SBERT Aumentado](https://arxiv.org/pdf/2010.08240.pdf) 📄
- [BEIR: Un Punto de Referencia Homogéneo para Evaluaciones Zero-shot de Modelos de Recuperación de Información](https://arxiv.org/abs/2104.08663) 📄
- [Búsquedas Visuales Conscientes de Compatibilidad Heterogénea](https://arxiv.org/abs/2105.06047) 📷
- [Aprendiendo el Estilo Personal a partir de Pocos Ejempos](https://chuanenlin.com/personalstyle)📷
- [TSDAE: Usando Codificadores  Automáticos de Eliminación del ruido Basados en Transformaciones para Aprendizaje Sin Supervisión de Embedding de Oraciones](https://arxiv.org/abs/2104.06979)📄
- [Una Encuesta sobre Transformaciones](https://arxiv.org/abs/2106.04554)📄📷

## Artículos

- [Abordando la Búsqueda Semántica](https://adityamalte.substack.com/p/tackle-semantic-search/)
- [Búsqueda Semántica en Azure Congnitive Search](https://docs.microsoft.com/en-us/azure/search/semantic-search-overview)
- [Como usamos búsqueda semántica pra hacer nuestras búsquedas 10x más rápidas](https://zilliz.com/blog/How-we-used-semantic-search-to-make-our-search-10-x-smarter)
- [Construyendo un sistema de búsqueda semántico con doble embedding de palabras](https://m.mage.ai/building-a-semantic-search-engine-with-dual-space-word-embeddings-f5a596eb6d90)
- [Búsqueda de similaridad semántica de escala un Millón FAISS+SBERT](https://towardsdatascience.com/billion-scale-semantic-similarity-search-with-faiss-sbert-c845614962e2)
- [Algunas observaciones sobre umbrales de búsqueda de similiridades](https://greglandrum.github.io/rdkit-blog/similarity/reference/2021/05/26/similarity-threshold-observations1.html)
## Librerías y Herramientas
- [fastText](https://fasttext.cc/)
- [Universal Sentence Encoder](https://tfhub.dev/google/universal-sentence-encoder/4)
- [SBERT](https://www.sbert.net/)
- [ELECTRA](https://github.com/google-research/electra)
- [LaBSE](https://tfhub.dev/google/LaBSE/2)
- [LASER](https://github.com/facebookresearch/LASER)
- [Haystack](https://github.com/deepset-ai/haystack/)
- [Jina.AI](https://jina.ai/)
- [SentEval Toolkit](https://github.com/facebookresearch/SentEval?utm_source=catalyzex.com)
- [BEIR :Benchmarking IR](https://github.com/UKPLab/beir)
- [matchzoo-py](https://github.com/NTMC-Community/MatchZoo-py)
- [Which Frame?](http://whichframe.com/)
- [PySerini](https://github.com/castorini/pyserini)
- [BERTSerini](https://github.com/rsvp-ai/bertserini)
- [BERTSimilarity](https://github.com/Brokenwind/BertSimilarity)
- [milvus](https://www.milvus.io/)
- [weaviate](https://github.com/semi-technologies/weaviate)
- [natural-language-youtube-search](https://github.com/haltakov/natural-language-youtube-search)
- [same.energy](https://www.same.energy/about)
- [scaNN](https://github.com/google-research/google-research/tree/master/scann)
- [REALM](https://github.com/google-research/language/tree/master/language/realm)
- [annoy](https://github.com/spotify/annoy)
- [faiss](https://github.com/facebookresearch/faiss)
- [DPR](https://github.com/facebookresearch/DPR)
- [rank_BM25](https://github.com/dorianbrown/rank_bm25)
- [nearPy](http://pixelogik.github.io/NearPy/)
- [vearch](https://github.com/vearch/vearch)
- [PyNNDescent](https://github.com/lmcinnes/pynndescent)
- [pgANN](https://github.com/netrasys/pgANN)
- [opensemanticsearch.org](https://www.opensemanticsearch.org/)
- [GPT3 Semantic Search](https://gpt3demo.com/category/semantic-search)
- [searchy](https://github.com/lubianat/searchy)
## Conjuntos de Datos
- [Conjunto de Datos de Textos de Similaridad Semántica](https://github.com/brmson/dataset-sts)

## Hitos

Mira el [projecto](https://github.com/Agrover112/awesome-semantic-search/projects/1) para ver la lista de tareas a contribuir para cualquiera de los Issues abiertos.
