# Busca Semântica Incrível [![Incrível](https://awesome.re/badge.svg)](https://awesome.re) [![Commits Convencionais](https://img.shields.io/badge/Commits%20Convencionais-1.0.0-amarelo.svg)](https://conventionalcommits.org)

<img src="logo.svg" />

Logo feito por [@createdbytango](https://instagram.com/createdbytango).

**À procura de mais adições de artigos.
PS: Abra um PR (Pedido de Pull)**

Este repositório visa servir como um meta-repositório para tarefas relacionadas com [Busca Semântica](https://pt.wikipedia.org/wiki/Busca_semântica) e [Similaridade Semântica](http://nlpprogress.com/english/semantic_textual_similarity.html).

A busca semântica não se limita a texto! Pode ser feito com imagens, voz, etc. Existem inúmeros casos de uso e diferentes aplicações de busca semântica.

Sinta-se à vontade para abrir um PR neste repositório!

## Conteúdo

-   [Artigos](#artigos)
    -   [2014](#2014)
    -   [2015](#2015)
    -   [2016](#2016)
    -   [2017](#2017)
    -   [2018](#2018)
    -   [2019](#2019)
    -   [2020](#2020)
    -   [2021](#2021)
    -   [2022](#2022)
    -   [2023](#2023)
-   [Artigos](#artigos)
-   [Bibliotecas e Ferramentas](#bibliotecas-e-ferramentas)
-   [Conjuntos de Dados](#conjuntos-de-dados)
-   [Marcos](#marcos)

## Artigos

### 2010

-   [Priority Range Trees](https://arxiv.org/abs/1009.3527)

### 2014

-   [Um Modelo Semântico Latente com Estrutura de Convolutional-Pooling para Recuperação de Informação](https://www.microsoft.com/en-us/research/wp-content/uploads/2016/02/cikm2014_cdssm_final.pdf) 📄

### 2015

-   [Vetores de Skip-Thought](https://arxiv.org/pdf/1506.06726.pdf) 📄
-   [LSH Prático e Ótimo para Distância Angular](https://proceedings.neurips.cc/paper/2015/hash/2823f4797102ce1a1aec05359cc16dd9-Abstract.html)

### 2016

-   [Saco de truques para classificação eficiente de texto](https://arxiv.org/abs/1607.01759) 📄
-   [Enriquecendo vetores de palavras com informações de subpalavras](https://arxiv.org/abs/1607.04606) 📄
-   [Pesquisa aproximada de vizinho mais próximo eficiente e robusta usando gráficos hierárquicos navegáveis ​​de pequenos mundos](https://arxiv.org/abs/1603.09320)
-   [Sobre a pesquisa aproximada de incorporações de palavras semelhantes](https://www.aclweb.org/anthology/P16-1214.pdf)
-   [Aprendendo representações distribuídas de sentenças a partir de dados não rotulados](https://arxiv.org/abs/1602.03483)📄
-   [Pesquisa aproximada do vizinho mais próximo em dados de alta dimensão --- Experimentos, análises e melhorias](https://arxiv.org/abs/1610.02455)

### 2017

-   [Aprendizagem supervisionada de representações de frases universais a partir de dados de inferência de linguagem natural](https://research.fb.com/wp-content/uploads/2017/09/emnlp2017.pdf) 📄
-   [Semelhança textual semântica para hindi] (https://www.semanticscholar.org/paper/Semantic-Textual-Similarity-For-Hindi-Mujadia-Mamidi/372f615ce36d7543512b8e40d6de51d17f316e0b)📄
-   [Sugestão eficiente de resposta em linguagem natural para resposta inteligente](https://arxiv.org/abs/1705.00652)📃

### 2018

-   [Codificador de frases universais](https://arxiv.org/pdf/1803.11175.pdf) 📄
-   [Aprendendo similaridade textual semântica em conversas](https://arxiv.org/pdf/1804.07754.pdf) 📄
-   [Blog de IA do Google: avanços na similaridade textual semântica](https://ai.googleblog.com/2018/05/advances-in-semantic-textual-similarity.html) 📄
-   [Speech2Vec: uma estrutura de sequência a sequência para aprender incorporações de palavras a partir da fala](https://arxiv.org/abs/1803.08976))🔊
-   [Otimização da indexação com base no gráfico k-vizinho mais próximo para pesquisa de proximidade em dados de alta dimensão](https://arxiv.org/abs/1810.07355) 🔊
-   [Pesquisa rápida aproximada do vizinho mais próximo com o
    Navegando no gráfico de dispersão](http://www.vldb.org/pvldb/vol12/p461-fu.pdf)
-   [O caso das estruturas de índice aprendidas](https://dl.acm.org/doi/10.1145/3183713.3196909)

### 2019

-   [LASER: representações de frases agnósticas de linguagem](https://engineering.fb.com/2019/01/22/ai-research/laser-multilingual-sentence-embeddings/) 📄
-   [Expansão de documentos por previsão de consulta](https://arxiv.org/abs/1904.08375) 📄
-   [Sentence-BERT: Embeddings de frases usando redes BERT siamesas](https://arxiv.org/pdf/1908.10084.pdf) 📄
-   [Classificação de documentos em vários estágios com BERT](https://arxiv.org/abs/1910.14424) 📄
-   [Recuperação latente para resposta a perguntas de domínio aberto com supervisão fraca](https://arxiv.org/abs/1906.00300)
-   [Resposta completa de perguntas de domínio aberto com BERTserini](https://www.aclweb.org/anthology/N19-4013/)
-   [BioBERT: um modelo de representação de linguagem biomédica pré-treinado para mineração de texto biomédico](https://arxiv.org/abs/1901.08746)📄
-   [Analisando e melhorando representações com a perda suave do vizinho mais próximo](https://arxiv.org/pdf/1902.01889.pdf)📷
-   [DiskANN: rápido e preciso bilhão de pontos mais próximo
    Pesquisa de vizinho em um único nó](https://proceedings.neurips.cc/paper/2019/file/09853c7fb1d3f8ee67a61b6bf4a7f8e6-Paper.pdf)

### 2020

-   [Implantando rapidamente um mecanismo de pesquisa neural para o conjunto de dados de pesquisa aberta COVID-19: reflexões preliminares e lições aprendidas](https://arxiv.org/abs/2004.05125) 📄
-   [RE-RANKING DA PASSAGEM COM BERT](https://arxiv.org/pdf/1901.04085.pdf) 📄
-   [CO-Search: recuperação de informações sobre COVID-19 com pesquisa semântica, resposta a perguntas e resumo abstrativo](https://arxiv.org/pdf/2006.09595.pdf) 📄
-   [LaBSE: Incorporação de frase BERT independente de idioma](https://arxiv.org/abs/2007.01852) 📄
-   [Covidex: Modelos de classificação neural e infraestrutura de pesquisa de palavras-chave para o conjunto de dados de pesquisa aberta COVID-19](https://arxiv.org/abs/2007.07846) 📄
-   [DeText: uma estrutura profunda de PNL para compreensão inteligente de texto](https://engineering.linkedin.com/blog/2020/open-sourcing-detext) 📄
-   [Fazendo incorporações de frases monolíngues multilíngues usando destilação de conhecimento](https://arxiv.org/pdf/2004.09813.pdf) 📄
-   [Transformadores pré-treinados para classificação de texto: BERT e além](https://arxiv.org/abs/2010.06467) 📄
-   [REALM: Pré-treinamento de modelo de linguagem aumentada de recuperação](https://arxiv.org/abs/2002.08909)
-   [ELECTRA: CODIFICADORES DE TEXTO DE PRÉ-TREINAMENTO COMO DISCRIMINADORES EM VEZ DE GERADORES](https://openreview.net/pdf?id=r1xMH1BtvB)📄
-   [Melhorando o aprendizado profundo para pesquisa no Airbnb](https://arxiv.org/pdf/2002.05515)
-   [Gerenciando a Diversidade na Pesquisa Airbnb](https://arxiv.org/abs/2004.02621)📄
-   [Aprendizagem contrastiva negativa aproximada do vizinho mais próximo para recuperação de texto denso](https://arxiv.org/abs/2007.00808v1)📄
-   [Incorporações de estilo de imagem não supervisionado para tarefas de recuperação e reconhecimento](https://openaccess.thecvf.com/content_WACV_2020/papers/Gairola_Unsupervised_Image_Style_Embeddings_for_Retrieval_and_Recognition_Tasks_WACV_2020_paper.pdf)📷
-   [DeCLUTR: Aprendizagem Contrastiva Profunda para Representações Textuais Não Supervisionadas](https://arxiv.org/abs/2006.03659)📄

### 2021

-   [Abordagem híbrida para cálculo de similaridade semântica entre palavras Tamil](https://www.researchgate.net/publication/350112163_Hybrid_approach_for_semantic_similarity_calculation_between_Tamil_words) 📄
-   [SBERT aumentado](https://arxiv.org/pdf/2010.08240.pdf) 📄
-   [BEIR: um benchmark heterogêneo para avaliação zero-shot de modelos de recuperação de informações](https://arxiv.org/abs/2104.08663) 📄
-   [Pesquisa visual heterogênea com reconhecimento de compatibilidade](https://arxiv.org/abs/2105.06047) 📷
-   [Aprendendo estilo pessoal com alguns exemplos](https://chuanenlin.com/personalstyle)📷
-   [TSDAE: Usando codificador automático de eliminação de ruído sequencial baseado em transformador para aprendizagem não supervisionada de incorporação de frases](https://arxiv.org/abs/2104.06979)📄
-   [Uma Pesquisa de Transformadores](https://arxiv.org/abs/2106.04554)📄📷
-   [SPLADE: modelo lexical esparso e de expansão para classificação de primeiro estágio](https://dl.acm.org/doi/10.1145/3404835.3463098)📄
-   [Sugestões de consulta de pesquisa relacionada de alta qualidade usando Deep Reinforcement Learning](https://arxiv.org/abs/2108.04452v1)
-   [Recuperação de produto baseada em incorporação na pesquisa Taobao](https://arxiv.org/pdf/2106.09297.pdf)📄📷
-   [TPRM: um modelo de classificação personalizado baseado em tópicos para pesquisa na Web](https://arxiv.org/abs/2108.06014)📄
-   [mMARCO: uma versão multilíngue do conjunto de dados de classificação de passagens MS MARCO](https://arxiv.org/abs/2108.13897)📄
-   [Raciocínio de banco de dados sobre texto](https://aclanthology.org/2021.acl-long.241.pdf)📄
-   [Como o ajuste fino adversário beneficia o BERT?](https://arxiv.org/abs/2108.13602))📄
-   [Treinar curto, testar longo: atenção com polarizações lineares permite extrapolação de comprimento de entrada](https://arxiv.org/abs/2108.12409)📄
-   [Primer: Procurando Transformadores Eficientes para Modelagem de Linguagem](https://arxiv.org/abs/2109.08668)📄
-   [Quão familiar isso parece? Representacional Multilíngue
    Análise de similaridade de incorporações acústicas de palavras](https://arxiv.org/pdf/2109.10179.pdf)🔊
-   [SimCSE: Aprendizagem contrastiva simples de incorporações de frases](https://arxiv.org/abs/2104.08821#)📄
-   [Atenção Composicional: Desembaraçando Pesquisa e Recuperação](https://arxiv.org/abs/2110.09419)📄📷
-   [SPANN: pesquisa aproximada de vizinho mais próximo em escala de bilhões de dólares altamente eficiente](https://arxiv.org/abs/2111.08566)
-   [GPL: Pseudo-rotulagem generativa para adaptação de domínio não supervisionado de recuperação densa](https://arxiv.org/abs/2112.07577) 📄
-   [Mecanismos de pesquisa generativos: experimentos iniciais](https://computationalcreativity.net/iccc21/wp-content/uploads/2021/09/ICCC_2021_paper_50.pdf) 📷
-   [Repensando a pesquisa: transformando diletantes em especialistas em domínio](https://dl.acm.org/doi/10.1145/3476415.3476428) -[WhiteningBERT: uma abordagem fácil de incorporação de frases não supervisionadas](https://arxiv.org/abs/2104.01767)

### 2022

-   [Incorporações de texto e código por pré-treinamento contrastivo](https://arxiv.org/abs/2201.10005)📄
-   [RELIC: Recuperando evidências para reivindicações literárias](https://arxiv.org/abs/2203.10053)📄
-   [Trans-Encoder: modelagem não supervisionada de pares de frases por meio de destilações próprias e mútuas](https://arxiv.org/abs/2109.13059)📄
-   [SAMU-XLSR: Representação de fala interlingual em nível de expressão multimodal semanticamente alinhada](https://arxiv.org/abs/2205.08180)🔊
-   [Uma análise de funções de fusão para recuperação híbrida](https://arxiv.org/abs/2210.11934)📄
-   [Detecção fora de distribuição com vizinhos mais próximos](https://arxiv.org/abs/2204.06507)
-   [ESB: uma referência para reconhecimento de fala ponta a ponta em vários domínios](https://arxiv.org/abs/2210.13352)🔊
-   [Analisando incorporações de palavras acústicas a partir de modelos de fala auto-supervisionados pré-treinados](https://arxiv.org/pdf/2210.16043.pdf))🔊
-   [Repensando com recuperação: inferência fiel do modelo de linguagem grande](https://arxiv.org/abs/2301.00303)📄
-   [Recuperação densa precisa de tiro zero sem rótulos de relevância](https://arxiv.org/pdf/2212.10496.pdf)📄
-   [Memória do transformador como índice de pesquisa diferenciável](https://arxiv.org/abs/2202.06991)📄

### 2023

-   [FINGER: Inferência rápida para pesquisa aproximada de vizinho mais próximo baseada em gráfico](https://dl.acm.org/doi/10.1145/3543507.3583318)📄
-   [Classificação de texto de “baixos recursos”: um método de classificação sem parâmetros com compressores](https://aclanthology.org/2023.findings-acl.426/)📄
-   [SparseEmbed: aprendendo representações lexicais esparsas com incorporações contextuais para recuperação](https://dl.acm.org/doi/pdf/10.1145/3539618.3592065) 📄

## Artigos

-   [Combatendo a pesquisa semântica](https://adityamalte.substack.com/p/tackle-semantic-search/)
-   [Pesquisa semântica no Azure Cognitive Search](https://docs.microsoft.com/en-us/azure/search/semantic-search-overview)
-   [Como usamos a pesquisa semântica para tornar nossa pesquisa 10 vezes mais inteligente](https://zilliz.com/blog/How-we-used-semantic-search-to-make-our-search-10-x-smarter/)
-   [Stanford AI Blog: Construindo modelos de PNL escaláveis, explicáveis ​​e adaptativos com recuperação](https://ai.stanford.edu/blog/retrieval-based-NLP/)
-   [Construindo um mecanismo de pesquisa semântico com embeddings de palavras de espaço duplo](https://m.mage.ai/building-a-semantic-search-engine-with-dual-space-word-embeddings-f5a596eb6d90)
-   [Pesquisa de similaridade semântica em escala de bilhões com FAISS+SBERT](https://towardsdatascience.com/billion-scale-semantic-similarity-search-with-faiss-sbert-c845614962e2)
-   [Algumas observações sobre limites de pesquisa de similaridade](https://greglandrum.github.io/rdkit-blog/similarity/reference/2021/05/26/similarity-threshold-observations1.html)
-   [Pesquisa de imagens quase duplicadas usando hash sensível à localidade](https://keras.io/examples/vision/near_dup_search/)
-   [Curso gratuito sobre pesquisa de similaridade vetorial e Faiss](https://link.medium.com/HtFoFKlKvkb)
-   [Guia abrangente para algoritmos aproximados de vizinhos mais próximos](https://link.medium.com/V62Z8drvEkb)
-   [Apresentando o índice híbrido para permitir a pesquisa semântica com reconhecimento de palavras-chave](https://www.pinecone.io/learn/hybrid-search/?utm_medium=email&_hsmi=0&_hsenc=p2ANqtz--zLu9hiyh-y_XTa7FCEpi8JESJKmif5dhpYtAxTWka8PIttaTOGE21LMZlg9EOZyPYpCm6GDvYy57tlGRwH6TjgLCsJg&utm_content=231741722&utm_source=hs_email)
-   [Pesquisa Semântica Argilla](https://docs.argilla.io/en/latest/guides/features/semantic-search.html)
-   [Co: aqui está o modelo de compreensão de texto multilíngue](https://txt.cohere.ai/multilingual/)
-   [Simplifique a pesquisa com modelos de incorporação multilíngue](https://blog.vespa.ai/simplify-search-with-multilingual-embeddings/)

## Bibliotecas e ferramentas

-   [fastText](https://fasttext.cc/)
-   [Codificador de frase universal](https://tfhub.dev/google/universal-sentence-encoder/4)
-   [SBERT](https://www.sbert.net/)
-   [ELECTRA](https://github.com/google-research/electra)
-   [LaBSE](https://tfhub.dev/google/LaBSE/2)
-   [LASER](https://github.com/facebookresearch/LASER)
-   [Relevance AI - Plataforma vetorial da experimentação à implantação](https://relevance.ai)
-   [Palheiro](https://github.com/deepset-ai/haystack/)
-   [Jina.AI](https://jina.ai/)
-   [pinha](https://www.pinecone.io/)
-   [Kit de ferramentas SentEval](https://github.com/facebookresearch/SentEval?utm_source=catalyzex.com)
-   [ranx](https://github.com/AmenRa/ranx)
-   [BEIR: Comparativo de RI](https://github.com/UKPLab/beir)
-   [RELiC: recuperando evidências para conjunto de dados de reivindicações literárias](https://relic.cs.umass.edu/)
-   [matchzoo-py](https://github.com/NTMC-Community/MatchZoo-py)
-   [deep_text_matching](https://github.com/wangle1218/deep_text_matching)
-   [Qual quadro?](http://qualframe.com/)
-   [lexica.art](https://lexica.art/)
-   [pesquisa semântica de emoji](https://github.com/lilianweng/emoji-semantic-search)
-   [PySerini](https://github.com/castorini/pyserini)
-   [BERTSerini](https://github.com/rsvp-ai/bertserini)
-   [BERTSimilarity](https://github.com/Brokenwind/BertSimilarity)
-   [milvus](https://www.milvus.io/)
-   [NeuroNLP++](https://plusplus.neuronlp.fruitflybrain.org/)
-   [weaviate](https://github.com/semi-technologies/weaviate)
-   [pesquisa semântica através da wikipedia-com-weaviate](https://github.com/semi-technologies/semantic-search-through-wikipedia-with-weaviate)
-   [pesquisa em linguagem natural do YouTube](https://github.com/haltakov/linguagemnatural-youtube-search)
-   [same.energy](https://www.same.energy/about)
-   [ann benchmarks](http://ann-benchmarks.com/)
-   [scaNN](https://github.com/google-research/google-research/tree/master/scann)
-   [REALM](https://github.com/google-research/linguagem/tree/master/idioma/realm)
-   [irritante](https://github.com/spotify/annoy)
-   [pynndescente](https://github.com/lmcinnes/pynndescente)
-   [nsg](https://github.com/ZJULearning/nsg)
-   [FALCONN](https://github.com/FALCONN-LIB/FALCONN)
-   [redis HNSW](https://github.com/zhao-lang/redis_hnsw)
-   [autofaiss](https://github.com/criteo/autofaiss)
-   [DPR](https://github.com/facebookresearch/DPR)
-   [rank_BM25](https://github.com/dorianbrown/rank_bm25)
-   [nearPy](http://pixelogik.github.io/NearPy/)
-   [vearch](https://github.com/vearch/vearch)
-   [vespa](https://github.com/vespa-engine/vespa)
-   [PyNNDescent](https://github.com/lmcinnes/pynndescent)
-   [pgANN](https://github.com/netrasys/pgANN)
-   [Semelhança do Tensorflow](https://github.com/tensorflow/similarity)
-   [opensemanticsearch.org](https://www.opensemanticsearch.org/)
-   [Pesquisa Semântica GPT3](https://gpt3demo.com/category/semantic-search)
-   [pesquisar](https://github.com/lubianat/searchy)
-   [txtai](https://github.com/neuml/txtai)
-   [HyperTag](https://github.com/Ravn-Tech/HyperTag)
-   [vetorai](https://github.com/vector-ai/vectorai)
-   [embeddinghub](https://github.com/featureform/embeddinghub)
-   [AquilaDb](https://github.com/Aquila-Network/AquilaDB)
-   [STripNet](https://github.com/stephenleo/stripnet)

## Conjuntos de dados

-   [Hub de conjunto de dados de similaridade de texto semântico](https://github.com/brmson/dataset-sts)
-   [Desafio de similaridade de imagens de IA do Facebook](https://www.drivendata.org/competitions/79/competition-image-similarity-1-dev/?fbclid=IwAR31vRV0EdxRdrxtPy12neZtBJQ0H9qdLHm8Wl2DjHY09PtQdn1nEEIJVUo)
-   [WIT: conjunto de dados de texto de imagem baseado na Wikipédia](https://github.com/google-research-datasets/wit)
-   [BEIR](https://github.com/beir-cellar/beir)
-   MTEB

## Conquistas

Dê uma olhada no [quadro do projeto](https://github.com/Agrover112/awesome-semantic-search/projects/1) para ver a lista de tarefas para contribuir com qualquer uma das questões em aberto.
