# Impressionnant Recherche-Sémantique [![Impressionnant](https://awesome.re/badge.svg)](https://awesome.re) [![Commits Conventionnels](https://img.shields.io/badge/Commits%20Conventionnels-1.0.0-jaune.svg)](https://conventionalcommits.org)

<img src ="logo.svg" />

Logo réalisé par [@createdbytango](https://instagram.com/createdbytango).

**À la recherche d'ajouts de papiers supplémentaires.
PS : Soumettez une Pull Request**

Le référentiel suivant vise à servir de méta-référentiel pour les tâches liées à la [recherche sémantique](https://en.wikipedia.org/wiki/Semantic_search) et à la [similarité sémantique](http://nlpprogress.com/english/semantic_textual_similarity.html).

La recherche sémantique n'est pas limitée au texte ! Elle peut être réalisée avec des images, de la parole, etc. Il existe de nombreux cas d'utilisation et applications différents de la recherche sémantique.

N'hésitez pas à soumettre une [Pull Request](https://github.com/Agrover112/awesome-semantic-search/projects/1) sur ce référentiel !

## Contenu

- [Papiers](#papers)
    - [2014](#2014)
    - [2015](#2015)
    - [2016](#2016)
    - [2017](#2017)
    - [2018](#2018)
    - [2019](#2019)
    - [2020](#2020)
    - [2021](#2021)
    - [2022](#2022)
    - [2023](#2023)
- [Articles](#articles)
- [Bibliothèques et Outils](#libraries-and-tools)
- [Ensembles de données](#datasets)
- [Étapes Importantes](#milestones)

## Papiers

### 2010
- [Priority Range Trees](https://arxiv.org/abs/1009.3527)

### 2014 
- [Un Modèle Sémantique Latent avec une Structure de Convolutions-Pooling pour la Récupération d'Informations](https://www.microsoft.com/en-us/research/wp-content/uploads/2016/02/cikm2014_cdssm_final.pdf) 📄

### 2015
- [Vecteurs Skip-Thought](https://arxiv.org/pdf/1506.06726.pdf) 📄
- [LSH Pratique et Optimal pour la Distance Angulaire](https://proceedings.neurips.cc/paper/2015/hash/2823f4797102ce1a1aec05359cc16dd9-Abstract.html)

### 2016
- [Sac de Trucs pour la Classification Efficace du Texte](https://arxiv.org/abs/1607.01759) 📄
- [Enrichissement des Vecteurs de Mots avec des Informations Subword](https://arxiv.org/abs/1607.04606) 📄
- [Recherche de Voisin le Plus Proche Approximatif Efficace et Robuste en Utilisant des Graphes Mondiaux Navigables Hiérarchiques](https://arxiv.org/abs/1603.09320)
- [Recherche Approximative du Voisin le Plus Proche pour les Vecteurs de Mots Similaires - Expériences, Analyses et Amélioration](https://www.aclweb.org/anthology/P16-1214.pdf) 
- [Apprentissage de Représentations Distribuées de Phrases à Partir de Données Non Étiquetées](https://arxiv.org/abs/1602.03483) 📄
- [Recherche Approximative du Voisin le Plus Proche sur des Données de Grande Dimension --- Expériences, Analyses et Amélioration](https://arxiv.org/abs/1610.02455)

### 2017
- [Apprentissage Supervisé de Représentations Universelles de Phrases à Partir de Données d'Inférence en Langage Naturel](https://research.fb.com/wp-content/uploads/2017/09/emnlp2017.pdf) 📄
- [Similarité Textuelle Sémantique pour le Hindi](https://www.semanticscholar.org/paper/Semantic-Textual-Similarity-For-Hindi-Mujadia-Mamidi/372f615ce36d7543512b8e40d6de51d17f316e0b) 📄
- [Suggestion Efficace de Réponses en Langage Naturel pour Smart Reply](https://arxiv.org/abs/1705.00652) 📃

### 2018
- [Encodeur Universel de Phrases](https://arxiv.org/pdf/1803.11175.pdf) 📄
- [Apprentissage de la Similarité Textuelle Sémantique à Partir de Conversations](https://arxiv.org/pdf/1804.07754.pdf) 📄
- [Blog Google AI : Avancées dans la Similarité Textuelle Sémantique](https://ai.googleblog.com/2018/05/advances-in-semantic-textual-similarity.html) 📄
- [Speech2Vec : Un Cadre Séquence à Séquence pour Apprendre des Embarquements de Mots à Partir de la Parole](https://arxiv.org/abs/1803.08976)) 🔊
- [Optimisation de l'Indexation Basée sur le Graphique du Voisin le Plus Proche k pour la Recherche de Proximité dans des Données de Grande Dimension](https://arxiv.org/abs/1810.07355) 🔊
- [Recherche Efficace du Voisin le Plus Proche Approximatif avec le Graphique de Dissémination](http://www.vldb.org/pvldb/vol12/p461-fu.pdf)
- [Plaidoyer pour des Structures d'Indexation Apprises](https://dl.acm.org/doi/10.1145/3183713.3196909)

### 2019
- [LASER : Représentations de phrases indépendantes du langage](https://engineering.fb.com/2019/01/22/ai-research/laser-multilingual-sentence-embeddings/) 📄
- [Expansion de document par prédiction de requête](https://arxiv.org/abs/1904.08375) 📄
- [Sentence-BERT : Intégration de phrases à l'aide de réseaux Siamese BERT](https://arxiv.org/pdf/1908.10084.pdf) 📄
- [Classement de documents à plusieurs étapes avec BERT](https://arxiv.org/abs/1910.14424) 📄
- [Récupération latente pour le questionnement faiblement supervisé en domaine ouvert](https://arxiv.org/abs/1906.00300)
- [Question-réponse de bout en bout avec BERTserini](https://www.aclweb.org/anthology/N19-4013/)
- [BioBERT : un modèle de représentation linguistique biomédicale pré-entraîné pour l'extraction de texte biomédical](https://arxiv.org/abs/1901.08746)📄
- [Analyse et amélioration des représentations avec la perte douce du voisin le plus proche](https://arxiv.org/pdf/1902.01889.pdf)📷
- [DiskANN : Recherche rapide et précise du voisin le plus proche pour un milliard de points sur un seul nœud](https://proceedings.neurips.cc/paper/2019/file/09853c7fb1d3f8ee67a61b6bf4a7f8e6-Paper.pdf)

### 2020
- [Déploiement rapide d'un moteur de recherche neuronal pour le COVID-19 Open Research Dataset : Réflexions préliminaires et leçons apprises](https://arxiv.org/abs/2004.05125) 📄
- [RE-CLASSEMENT DE PASSAGE AVEC BERT](https://arxiv.org/pdf/1901.04085.pdf) 📄
- [CO-Search : Recherche d'informations sur le COVID-19 avec recherche sémantique, question-réponse et résumé abstrait](https://arxiv.org/pdf/2006.09595.pdf) 📄
- [LaBSE : Intégration de phrases sans langage](https://arxiv.org/abs/2007.01852) 📄
- [Covidex : Modèles de classement neuronal et infrastructure de recherche par mot-clé pour le COVID-19 Open Research Dataset](https://arxiv.org/abs/2007.07846) 📄
- [DeText : Un cadre d'IA profonde pour la compréhension intelligente du texte](https://engineering.linkedin.com/blog/2020/open-sourcing-detext) 📄
- [Rendre les plongements de phrases monolingues multilingues en utilisant la distillation des connaissances](https://arxiv.org/pdf/2004.09813.pdf) 📄
- [Transformateurs pré-entraînés pour le classement de texte : BERT et au-delà](https://arxiv.org/abs/2010.06467) 📄
- [REALM : Pré-entraînement d'un modèle linguistique augmenté par récupération](https://arxiv.org/abs/2002.08909)
- [ELECTRA : PRÉ-ENTRAÎNEMENT DES ENCODEURS DE TEXTE EN TANT QUE DISCRIMINATEURS PLUTÔT QUE DES GÉNÉRATEURS](https://openreview.net/pdf?id=r1xMH1BtvB)📄
- [Amélioration de l'apprentissage profond pour la recherche Airbnb](https://arxiv.org/pdf/2002.05515)
- [Gestion de la diversité dans la recherche Airbnb](https://arxiv.org/abs/2004.02621)📄
- [Apprentissage négatif de contraste approximatif du voisin le plus proche pour la recherche dense de texte](https://arxiv.org/abs/2007.00808v1)📄
- [Plongements d'images sans supervision pour les tâches de recherche et de reconnaissance](https://openaccess.thecvf.com/content_WACV_2020/papers/Gairola_Unsupervised_Image_Style_Embeddings_for_Retrieval_and_Recognition_Tasks_WACV_2020_paper.pdf)📷
- [DeCLUTR : Apprentissage en profondeur contrastif pour les représentations textuelles non supervisées](https://arxiv.org/abs/2006.03659)📄


### 2021
- [Approche hybride pour le calcul de similarité sémantique entre les mots tamouls](https://www.researchgate.net/publication/350112163_Hybrid_approach_for_semantic_similarity_calculation_between_Tamil_words) 📄
- [SBERT augmenté](https://arxiv.org/pdf/2010.08240.pdf) 📄
- [BEIR : un banc d'essai hétérogène pour l'évaluation sans tir préalable des modèles de recherche d'informations](https://arxiv.org/abs/2104.08663) 📄
- [Recherche visuelle hétérogène compatible](https://arxiv.org/abs/2105.06047) 📷
- [Apprentissage du style personnel à partir de quelques exemples](https://chuanenlin.com/personalstyle)📷
- [TSDAE : Utilisation d'un auto-encodeur de débruitage séquentiel basé sur un transformateur pour l'apprentissage non supervisé de l'intégration de phrases](https://arxiv.org/abs/2104.06979)📄
- [Une enquête sur les transformateurs](https://arxiv.org/abs/2106.04554)📄📷
- [SPLADE : Modèle lexical et d'expansion parcimonieux pour le classement de la première étape](https://dl.acm.org/doi/10.1145/3404835.3463098)📄
- [Suggestions de requêtes de recherche liées de haute qualité à l'aide de l'apprentissage en profondeur par renforcement](https://arxiv.org/abs/2108.04452v1)
- [Récupération de produits basée sur l'intégration dans la recherche Taobao](https://arxiv.org/pdf/2106.09297.pdf)📄📷
- [TPRM : Un modèle de classement personnalisé basé sur les sujets pour la recherche Web](https://arxiv.org/abs/2108.06014)📄
- [mMARCO : Une version multilingue de l'ensemble de données de classement de passages MS MARCO](https://arxiv.org/abs/2108.13897)📄
- [Raisonnement sur la base de données à partir du texte](https://aclanthology.org/2021.acl-long.241.pdf)📄
- [En quoi l'affinage adversarial profite-t-il à BERT ?](https://arxiv.org/abs/2108.13602))📄
- [Entraînement court, test long : l'attention avec des biais linéaires permet l'extrapolation de la longueur d'entrée](https://arxiv.org/abs/2108.12409)📄
- [Primer : Recherche d'architectures de transformateurs efficaces pour la modélisation linguistique](https://arxiv.org/abs/2109.08668)📄
- [À quel point cela semble-t-il familier ? Analyse de similarité représentationnelle interlingue des plongements acoustiques de mots](https://arxiv.org/pdf/2109.10179.pdf)🔊
- [SimCSE : Apprentissage contrastif simple des plongements de phrases](https://arxiv.org/abs/2104.08821#)📄
- [Attention compositionnelle : Désentrelacement de la recherche et de la récupération](https://arxiv.org/abs/2110.09419)📄📷
- [SPANN : Recherche de voisin le plus proche efficace à l'échelle du milliard](https://arxiv.org/abs/2111.08566)
- [GPL : Étiquetage pseudo-génératif pour l'adaptation de domaine non supervisée de la récupération dense](https://arxiv.org/abs/2112.07577) 📄
- [Moteurs de recherche génératifs : expériences initiales](https://computationalcreativity.net/iccc21/wp-content/uploads/2021/09/ICCC_2021_paper_50.pdf) 📷
- [Repenser la recherche : faire des experts de domaine à partir de dilettantes](https://dl.acm.org/doi/10.1145/3476415.3476428)
- [WhiteningBERT : Une approche facile d'intégration de phrases non supervisée](https://arxiv.org/abs/2104.01767)

### 2022
- [Intégration de textes et de codes par pré-entraînement contrastif](https://arxiv.org/abs/2201.10005)📄
- [RELIC : Récupération de preuves pour les revendications littéraires](https://arxiv.org/abs/2203.10053)📄
- [Trans-Encoder : Modélisation non supervisée de paires de phrases par auto-distillations mutuelles et mutuelles](https://arxiv.org/abs/2109.13059)📄
- [SAMU-XLSR : Représentation multimodale de l'énoncé interlingue alignée sémantiquement](https://arxiv.org/abs/2205.08180)🔊
- [Analyse des fonctions de fusion pour la recherche hybride](https://arxiv.org/abs/2210.11934)📄
- [Détection hors distribution avec des voisins les plus proches profonds](https://arxiv.org/abs/2204.06507)
- [ESB : Un banc d'essai pour la reconnaissance de la parole de bout en bout multi-domaines](https://arxiv.org/abs/2210.13352)🔊
- [Analyse des plongements acoustiques de mots à partir de modèles de parole auto-supervisés pré-entraînés](https://arxiv.org/pdf/2210.16043.pdf))🔊
- [Repenser avec la récupération : Inférence fidèle de grands modèles linguistiques](https://arxiv.org/abs/2301.00303)📄
- [Récupération dense précise sans étiquettes de pertinence](https://arxiv.org/pdf/2212.10496.pdf)📄
- [Mémoire du transformateur en tant qu'index de recherche différenciable](https://arxiv.org/abs/2202.06991)📄

### 2023
- [FINGER : Inférence rapide pour la recherche du voisin le plus proche approximatif basée sur un graphe](https://dl.acm.org/doi/10.1145/3543507.3583318)📄
- [Classification de texte "faible ressource" : une méthode de classification sans paramètre avec des compresseurs](https://aclanthology.org/2023.findings-acl.426/)📄
- [SparseEmbed : Apprentissage de représentations lexicales clairsemées avec des plongements contextuels pour la récupération](https://dl.acm.org/doi/pdf/10.1145/3539618.3592065) 📄

## Articles
- [Aborder la recherche sémantique](https://adityamalte.substack.com/p/tackle-semantic-search/)
- [Recherche sémantique dans Azure Cognitive Search](https://docs.microsoft.com/en-us/azure/search/semantic-search-overview)
- [Comment nous avons utilisé la recherche sémantique pour rendre notre recherche 10 fois plus intelligente](https://zilliz.com/blog/How-we-used-semantic-search-to-make-our-search-10-x-smarter/)
- [Stanford AI Blog : Construction de modèles NLP évolutifs, explicables et adaptatifs avec la récupération](https://ai.stanford.edu/blog/retrieval-based-NLP/)
- [Construction d'un moteur de recherche sémantique avec des plongements de mots à double espace](https://m.mage.ai/building-a-semantic-search-engine-with-dual-space-word-embeddings-f5a596eb6d90)
- [Recherche de similarité sémantique à l'échelle du milliard avec FAISS+SBERT](https://towardsdatascience.com/billion-scale-semantic-similarity-search-with-faiss-sbert-c845614962e2)
- [Quelques observations sur les seuils de recherche de similarité](https://greglandrum.github.io/rdkit-blog/similarity/reference/2021/05/26/similarity-threshold-observations1.html)
- [Recherche d'images quasi identiques avec Locality Sensitive Hashing](https://keras.io/examples/vision/near_dup_search/)
- [Cours gratuit sur la recherche de similarité vectorielle et Faiss](https://link.medium.com/HtFoFKlKvkb)
- [Guide complet des algorithmes de recherche des voisins les plus proches approximatifs](https://link.medium.com/V62Z8drvEkb)
- [Introduction de l'index hybride pour permettre la recherche sémantique consciente des mots-clés](https://www.pinecone.io/learn/hybrid-search/?utm_medium=email&_hsmi=0&_hsenc=p2ANqtz--zLu9hiyh-y_XTa7FCEpi8JESJKmif5dhpYtAxTWka8PIttaTOGE21LMZlg9EOZyPYpCm6GDvYy57tlGRwH6TjgLCsJg&utm_content=231741722&utm_source=hs_email)
- [Recherche sémantique Argilla](https://docs.argilla.io/en/latest/guides/features/semantic-search.html)
- [Modèle de compréhension textuelle multilingue de Co:here](https://txt.cohere.ai/multilingual/)
- [Simplifiez la recherche avec des modèles d'embedding multilingues](https://blog.vespa.ai/simplify-search-with-multilingual-embeddings/)

## Bibliothèques et Outils
- [fastText](https://fasttext.cc/)
- [Universal Sentence Encoder](https://tfhub.dev/google/universal-sentence-encoder/4)
- [SBERT](https://www.sbert.net/)
- [ELECTRA](https://github.com/google-research/electra)
- [LaBSE](https://tfhub.dev/google/LaBSE/2)
- [LASER](https://github.com/facebookresearch/LASER)
- [Relevance AI - Plateforme vectorielle de l'expérimentation au déploiement](https://relevance.ai)
- [Haystack](https://github.com/deepset-ai/haystack/)
- [Jina.AI](https://jina.ai/)
- [Pinecone](https://www.pinecone.io/)
- [SentEval Toolkit](https://github.com/facebookresearch/SentEval?utm_source=catalyzex.com)
- [ranx](https://github.com/AmenRa/ranx)
- [BEIR :Evaluation des IR](https://github.com/UKPLab/beir)
- [RELiC: Jeu de données de récupération d'éléments pour les revendications littéraires](https://relic.cs.umass.edu/)
- [matchzoo-py](https://github.com/NTMC-Community/MatchZoo-py)
- [deep_text_matching](https://github.com/wangle1218/deep_text_matching)
- [Quel cadre ?](http://whichframe.com/)
- [lexica.art](https://lexica.art/)
- [Recherche sémantique emoji](https://github.com/lilianweng/emoji-semantic-search)
- [PySerini](https://github.com/castorini/pyserini)
- [BERTSerini](https://github.com/rsvp-ai/bertserini)
- [BERTSimilarity](https://github.com/Brokenwind/BertSimilarity)
- [milvus](https://www.milvus.io/)
- [NeuroNLP++](https://plusplus.neuronlp.fruitflybrain.org/)
- [weaviate](https://github.com/semi-technologies/weaviate)
- [Recherche sémantique à travers Wikipedia avec Weaviate](https://github.com/semi-technologies/semantic-search-through-wikipedia-with-weaviate)
- [Recherche naturelle sur YouTube](https://github.com/haltakov/natural-language-youtube-search)
- [same.energy](https://www.same.energy/about)
- [Benchmarks ANN](http://ann-benchmarks.com/)
- [scaNN](https://github.com/google-research/google-research/tree/master/scann)
- [REALM](https://github.com/google-research/language/tree/master/language/realm)
- [annoy](https://github.com/spotify/annoy)
- [pynndescent](https://github.com/lmcinnes/pynndescent)
- [nsg](https://github.com/ZJULearning/nsg)
- [FALCONN](https://github.com/FALCONN-LIB/FALCONN)
- [redis HNSW](https://github.com/zhao-lang/redis_hnsw)
- [autofaiss](https://github.com/criteo/autofaiss)
- [DPR](https://github.com/facebookresearch/DPR)
- [rank_BM25](https://github.com/dorianbrown/rank_bm25)
- [nearPy](http://pixelogik.github.io/NearPy/)
- [vearch](https://github.com/vearch/vearch)
- [vespa](https://github.com/vespa-engine/vespa)
- [PyNNDescent](https://github.com/lmcinnes/pynndescent)
- [pgANN](https://github.com/netrasys/pgANN)
- [Tensorflow Similarity](https://github.com/tensorflow/similarity)
- [opensemanticsearch.org](https://www.opensemanticsearch.org/)
- [GPT3 Semantic Search](https://gpt3demo.com/category/semantic-search)
- [searchy](https://github.com/lubianat/searchy)
- [txtai](https://github.com/neuml/txtai)
- [HyperTag](https://github.com/Ravn-Tech/HyperTag)
- [vectorai](https://github.com/vector-ai/vectorai)
- [embeddinghub](https://github.com/featureform/embeddinghub)
- [AquilaDb](https://github.com/Aquila-Network/AquilaDB)
- [STripNet](https://github.com/stephenleo/stripnet)

## Ensembles-de-données
- [Semantic Text Similarity Dataset Hub](https://github.com/brmson/dataset-sts)
- [Facebook AI Image Similarity Challenge](https://www.drivendata.org/competitions/79/competition-image-similarity-1-dev/?fbclid=IwAR31vRV0EdxRdrxtPy12neZtBJQ0H9qdLHm8Wl2DjHY09PtQdn1nEEIJVUo)
- [WIT : Wikipedia-based Image Text Dataset](https://github.com/google-research-datasets/wit)
- [BEIR](https://github.com/beir-cellar/beir)
- MTEB

## Étapes Importantes

Consultez le [tableau du projet](https://github.com/Agrover112/awesome-semantic-search/projects/1) pour la liste des tâches afin de contribuer à l'une des issues ouvertes.

