# ForkTheCaptcha

Welcome to ForkTheCaptcha! 🎉
<br>
This repository is a simple web project made with HTML, CSS, and JavaScript where a CAPTCHA is displayed to verify user interaction. Feel free to explore, contribute, and fork it for Hacktoberfest 2024! 🚀

<br>

# 🎯 Project Overview
CAPTCHA (Completely Automated Public Turing test to tell Computers and Humans Apart) is a crucial feature used to prevent bots from abusing web forms and functionalities. This project is designed to demonstrate how to implement a basic CAPTCHA system using client-side technologies.

<br>

## 🌟 Features
- Dynamically generated CAPTCHA.
- Simple and clean UI.
- Designed for beginners to learn and contribute during Hacktoberfest 2024!

<br> 

## 🛠️ Tech Stack
- HTML: Structure of the webpage.
- CSS: Styling and layout.
- JavaScript: CAPTCHA generation and validation logic.

<br>

## 🚀 Getting Started
1. Fork this repository: Click the "Fork" button on the top right corner of this page and create your own copy of the repository.

2. Clone your fork:
```terminal
git clone https://github.com/your-username/ForkTheCaptcha.git
```

3. Navigate into the project directory:
```terminal
cd ForkTheCaptcha
```

4. Open the index.html file in your browser to see the CAPTCHA in action.

<br>

## 📝 How It Works
1. CAPTCHA Generation: The JavaScript function generates a random sequence of characters (alphanumeric) displayed as an image.

2. User Input: The user is prompted to enter the characters from the CAPTCHA image into a text field.

3. Validation: If the user input matches the CAPTCHA, the form is successfully submitted. Otherwise, the user is asked to try again.

<br>

## 🧑‍💻 How to Contribute
We'd love for you to contribute to ForkTheCaptcha and make it better! You can add new features, make desgin responsive, fix any issue or bug, change styling as long as code doesn't break!

To contribute:

1. Fork & Star⭐ this repository : [https://github.com/AdityaSinha2305/ForkTheCaptcha.git](https://github.com/AdityaSinha2305/ForkTheCaptcha.git)

2. Clone the forked repository :
```terminal
git clone https://github.com/your-username/ForkTheCaptcha.git
```

3. Navigate to project directory :
```terminal
cd ForkTheCaptcha
```

4. Create a new branch :
```terminal
git checkout -b your-feature-branch
```

5. Make your changes and commit :
```terminal
git add .
git commit -m "Proper commit message"
```

6. Push your fork :
```terminal
git push origin your-feature-branch
```

7. Open a pull request and we'll review it!

<br>

## 🛡️ Contribution Rules
To ensure a smooth contribution process, please follow these rules:
- **Create a separate branch** for each feature or fix to keep changes isolated.
- **Write clear and descriptive commit messages.**
- **Test** your changes before submitting a pull request.
- **Do not** add any build steps, e.g., npm install (I want to keep this repo simple and static)
- **Do not** remove other contents.
- **Try to keep pull requests small to minimize merge conflicts.**
- **Be respectful and constructive in your pull request comments and reviews.**

<br>

## 🔄 Sync Your Fork to Avoid Conflicts
To avoid merge conflicts, ensure your fork is up-to-date with the original repository before making any changes. Here’s how to sync your fork:

1. Add the original repository as a remote (if not already added):
```terminal
git remote add upstream https://github.com/AdityaSinha2305/ForkTheCaptcha.git
```

2. Merge the changes into your local fork:
```terminal
git checkout main
git pull upstream main
```

3. Push the updated main branch to your fork:
```terminal
git push origin main
```

After syncing, you can create a new branch from the updated main branch or can merge this updated main branch into your feature branch and start working on your changes!

<br>

## 🌱 Beginner-Friendly Contribution Guide
If you're new to open-source, Hacktoberfest is a great time to start! Here's a simple guide to contributing:

1. Find an Issue: Check out our Issues section for tasks tagged with 'good first issue'.
2. Comment: Leave a comment under the issue that you'd like to work on.
3. Submit a PR: Once you're done, submit a Pull Request (PR) and we'll review it.

<br>

## 🏷️ Labels for Issues
To help you get started quickly, we label issues with:

- good first issue: Simple tasks perfect for beginners.
- enhancement: Features and improvements that can be added.
- bug: Issues that need fixing.
- documentation: Help us with writing or improving docs.
- hacktoberfest: Tasks suitable for hacktoberfest.

<br>

## 🎉 Hacktoberfest 2024
This project is participating in Hacktoberfest 2024. Contribute to this repository and don't forget to register at [hacktoberfest.com](https://hacktoberfest.com/) and start submitting pull requests.

To make a valid contribution during Hacktoberfest:
1. Fork the repo and make at least four valid pull requests (PRs) in the month of October.
2. PRs must follow the Hacktoberfest Guidelines.

Your PRs don't need to be huge – small contributions count too! Fixing a typo, or adding a small feature is valuable!

<br>

## 💬 Connect With Us
Got questions? Suggestions? We'd love to hear from you!

- Issues: Check out our Issues Page to ask questions or report bugs.
- Discussions: Join the Discussion for project ideas, feedback, and collaboration.

<br>

## 🏆 Contributors
Thank you to everyone contributing to ForkTheCaptcha! Your efforts help make this project better. 💪

<br>

## 📄 License
This project is open source and available under the MIT License.

<br>

## 🎊 Don't forget to explore the other interesting [repo](https://github.com/AdityaSinha2305) !!
