# Complex struct getter detector

Name: `complex-struct-getter`

Solidity-generated getters for public state variables do not return array and mapping members of (possible nested) structs.
See the [Solidity docs](https://docs.soliditylang.org/en/latest/contracts.html#getter-functions) for more details.

## Example

```solidity hl_lines="6 8 11" linenums="1"
pragma solidity 0.8.0;

contract C {
    struct ComplexStruct {
        uint a;
        address[] b;  // (2)!
        string c;
        mapping(uint => uint) d;  // (3)!
    }

    ComplexStruct public s; // (1)!

    /* the generated getter for `s` looks like this: */
    function s1() public view returns (uint, string memory) {
        return (s.a, s.c);
    }
}
```

1. Getter for `s` is generated. Since the `ComplexStruct` contains an array and a mapping, the getter returns only the non-complex members `a` and `c` (as a tuple).
2. The array member `b` is not returned by the `s` getter.
3. The mapping member `d` is not returned by the `s` getter.

## Parameters

The detector does not accept any additional parameters.
