<p align="center">
  <a href="https://acecentre.org.uk/">
    <img src="https://raw.githubusercontent.com/AceCentre/TextAloud/main/readme-logo.png" alt="TextAloud logo" width="300" />
  </a>
</p>
<p align="center"><i>Reads out text - sentence by sentence, paragraph by paragraph or word by word.</i></p>

<p align="center">
  <img alt="GitHub" src="https://img.shields.io/github/license/AceCentre/TextAloud">
  <img alt="GitHub issues" src="https://img.shields.io/github/issues/AceCentre/TextAloud">
</p>

<p align="center">
  <img src="https://raw.githubusercontent.com/AceCentre/TextAloud/main/readme-demo.gif" alt="TextAloud demo" width="250" />
</p>

## How to use

- Set a voice. To do this go to System Settings -> Accessibility - Spoken Content -> and Voices. Select a voice - download voice data to get a higher quality voice.
- You need your iOS device not on Silent! (Obvious but seriously in testing I was always doing this)
- Import a text file
- Use a physical keyboard or switch box to control actions: Play: Space, Escape: Stop, 1: word, 2: sentence, 3: paragraph
- Select some text. Press Paragraph, word or sentence - or read all.

## Why?

Some people with disabilities use Text to Speech software to communicate long passages of text. To do this at a natural pace for some people they find it easier for the system to read it aloud sentence by sentence - pressing a button for each sentence - or each paragraph.

This technique is surprisingly not common amongst products such as Natural Reader and clones of this.

## What are the alternatives?

Remember that both Android and iOS have built in options to read out streams of text. As long as you have the accessibility settings enabled you can select some text and then select the option to read it aloud. But there are some apps that make the process even easier.

- [WordTalk](https://www.wordtalk.org.uk/) from CALL Scotland is amazing. The only problem is its now quite difficult to use on recent versions of word.
- [NaturalReader](https://www.naturalreaders.com/) is a really good, well designed reading software. A large range of voices and nice clean UI. We recommend looking at this if you need to read out text from a range of different formats across different operating systems
- [Speechify](https://speechify.com/) Similar to NaturalReader. Online and as an app. Basic features available for free.
- [Wrise](https://www.assistiveware.com/products/wrise). If you are on a Mac DEFINTLEY look at wrise. Its beautiful and allows for some markup of speech text
- [SprintPlus](https://www.jabbla.co.uk/software/sprintplus/). Does a lot more than just reading documents - has a web app that works across browsers, allows for marking up documents. A solid tool to look at if you are needing something to support students
- [Voice Dream Reader](https://www.voicedream.com/reader/). Read in a wide range of formats. Offline voices from Acapella.
- [Aloud!](https://appappworks.com/aloud/). Listen to PDFs. Nice simple UI. Save progress and Free.

And there are some AAC specific apps that kind of do this but generally not all three options. Eg

- [SayIt!](https://enaboapps.com/sayit-easy-aac/)
- [Proloquo4Text](https://www.assistiveware.com/products/proloquo4text)

# Whats next?

- SSML editing / markup support. So you can better indicate pauses, tone and expression.
- A range of online TTS systems to support a wider range of voices and demonstrate techniques to locally cache data.

## Releasing a new version

Put a commit on the main branch including either `[PATCH]`, `[MINOR]` or `[MAJOR]`. This will then release a new version accordingly

# Credits

- https://www.appcoda.com/text-to-speech-swiftui/ - this Tutorial formed an original base of code
- Daniil Balakiriev
- Icon from Canva (https://www.canva.com/p/qoolio/ - Paperclip and Bubble)
