<!DOCTYPE html>
<html>
<head>
    <title>Account Activation - Academix</title>
</head>

<style>
    a {
  text-decoration: none;
  outline: none;
}

@media (max-width: 649px) {
  .o_col-full {
    max-width: 100% !important;
  }

  .o_col-half {
    max-width: 50% !important;
  }

  .o_hide-lg {
    display: inline-block !important;
    font-size: inherit !important;
    max-height: none !important;
    line-height: inherit !important;
    overflow: visible !important;
    width: auto !important;
    visibility: visible !important;
  }

  .o_hide-xs,
  .o_hide-xs.o_col_i {
    display: none !important;
    font-size: 0 !important;
    max-height: 0 !important;
    width: 0 !important;
    line-height: 0 !important;
    overflow: hidden !important;
    visibility: hidden !important;
    height: 0 !important;
  }

  .o_xs-center {
    text-align: center !important;
  }

  .o_xs-left {
    text-align: left !important;
  }

  .o_xs-right {
    text-align: left !important;
  }

  table.o_xs-left {
    margin-left: 0 !important;
    margin-right: auto !important;
    float: none !important;
  }

  table.o_xs-right {
    margin-left: auto !important;
    margin-right: 0 !important;
    float: none !important;
  }

  table.o_xs-center {
    margin-left: auto !important;
    margin-right: auto !important;
    float: none !important;
  }

  h1.o_heading {
    font-size: 32px !important;
    line-height: 41px !important;
  }

  h2.o_heading {
    font-size: 26px !important;
    line-height: 37px !important;
  }

  h3.o_heading {
    font-size: 20px !important;
    line-height: 30px !important;
  }

  .o_xs-py-md {
    padding-top: 24px !important;
    padding-bottom: 24px !important;
  }

  .o_xs-pt-xs {
    padding-top: 8px !important;
  }

  .o_xs-pb-xs {
    padding-bottom: 8px !important;
  }
}

@media screen {
  @font-face {
    font-family: "Roboto";

    font-style: normal;

    font-weight: 400;

    src: local("Roboto"), local("Roboto-Regular"),
      url(https://fonts.gstatic.com/s/roboto/v18/KFOmCnqEu92Fr1Mu7GxKOzY.woff2)
        format("woff2");

    unicode-range: U+0100-024F, U+0259, U+1E00-1EFF, U+2020, U+20A0-20AB,
      U+20AD-20CF, U+2113, U+2C60-2C7F, U+A720-A7FF;
  }

  @font-face {
    font-family: "Roboto";

    font-style: normal;

    font-weight: 400;

    src: local("Roboto"), local("Roboto-Regular"),
      url(https://fonts.gstatic.com/s/roboto/v18/KFOmCnqEu92Fr1Mu4mxK.woff2)
        format("woff2");

    unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA,
      U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212,
      U+2215, U+FEFF, U+FFFD;
  }

  @font-face {
    font-family: "Roboto";

    font-style: normal;

    font-weight: 700;

    src: local("Roboto Bold"), local("Roboto-Bold"),
      url(https://fonts.gstatic.com/s/roboto/v18/KFOlCnqEu92Fr1MmWUlfChc4EsA.woff2)
        format("woff2");

    unicode-range: U+0100-024F, U+0259, U+1E00-1EFF, U+2020, U+20A0-20AB,
      U+20AD-20CF, U+2113, U+2C60-2C7F, U+A720-A7FF;
  }

  @font-face {
    font-family: "Roboto";

    font-style: normal;

    font-weight: 700;

    src: local("Roboto Bold"), local("Roboto-Bold"),
      url(https://fonts.gstatic.com/s/roboto/v18/KFOlCnqEu92Fr1MmWUlfBBc4.woff2)
        format("woff2");

    unicode-range: U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA,
      U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212,
      U+2215, U+FEFF, U+FFFD;
  }

  .o_sans,
  .o_heading {
    font-family: "Roboto", sans-serif !important;
  }

  .o_heading,
  strong,
  b {
    font-weight: 700 !important;
  }

  a[x-apple-data-detectors] {
    color: inherit !important;
    text-decoration: none !important;
  }
}

</style>

<body class="o_body o_bg-light" style="width: 100%;margin: 0px;padding: 0px;-webkit-text-size-adjust: 100%;-ms-text-size-adjust: 100%;background-color: #dbe5ea;">
    <!-- preview-text -->
    <table width="100%" cellspacing="0" cellpadding="0" border="0" role="presentation">
      <tbody>
        <tr>
          <td class="o_hide" align="center" style="display: none;font-size: 0;max-height: 0;width: 0;line-height: 0;
            overflow: hidden;mso-hide: all;visibility: hidden;">Thank you for signing up for Academix!</td>
        </tr>
      </tbody>
    </table>
    <!-- header-white -->
    <table width="100%" cellspacing="0" cellpadding="0" border="0" role="presentation">
      <tbody>
        <tr>
          <td class="o_bg-light o_px-xs o_pt-lg o_xs-pt-xs" align="center" style="background-color: #dbe5ea;padding-left: 8px;padding-right: 8px;padding-top: 32px;">
            <!--[if mso]>
            <table width="632" cellspacing="0" cellpadding="0" border="0" role="presentation">
              <tbody>
                <tr>
                  <td>
                    <![endif]-->
                    <table class="o_block" width="100%" cellspacing="0" cellpadding="0" border="0" role="presentation" style="max-width: 632px;margin: 0 auto;">
                      <tbody>
                        <tr>
                          <td class="o_re o_bg-white o_px o_pb-md o_br-t" align="center" style="font-size: 0;vertical-align: top;background-color: #ffffff;border-radius: 4px 4px 0px 0px;padding-left: 16px;padding-right: 16px;padding-bottom: 24px;">
                            <!--[if mso]>
                            <table cellspacing="0" cellpadding="0" border="0" role="presentation">
                              <tbody>
                                <tr>
                                  <td width="200" align="left" valign="top" style="padding:0px 8px;">
                                    <![endif]-->
                                    <div class="o_col o_col-2" style="display: inline-block;vertical-align: top;width: 100%;max-width: 200px;">
                                      <div style="font-size: 24px; line-height: 24px; height: 24px;">&nbsp; </div>
                                      <div class="o_px-xs o_sans o_text o_left o_xs-center" style="font-family: Helvetica, Arial, sans-serif;margin-top: 0px;margin-bottom: 0px;font-size: 16px;line-height: 24px;text-align: left;padding-left: 8px;padding-right: 8px;">
                                        <p style="margin-top: 0px;margin-bottom: 0px;"><a class="o_text-primary" href="http://159.223.164.253/" style="text-decoration:none;outline: none; color: #126de5;"><img src="https://i.postimg.cc/DZ4KbNBq/Academix-Logo.png" width="126" height="126" alt="Enfront logo" style="max-width: 106px;-ms-interpolation-mode:
                                          bicubic;vertical-align: middle;border: 0;line-height: 100%;height: auto;outline: none;text-decoration: none;"></a></p>
                                      </div>
                                    </div>
                                    <!--[if mso]>
                                  </td>
                                  <td width="400" align="right" valign="top" style="padding:0px 8px;">
                                    <![endif]-->
                                    <div class="o_col o_col-4" style="display: inline-block;vertical-align: top;width: 100%;max-width: 400px;">
                                      <div style="font-size: 22px; line-height: 22px; height: 22px;">&nbsp; </div>
                                      <div class="o_px-xs" style="padding-left: 8px;padding-right: 8px;">
                                        <table class="o_right o_xs-center" cellspacing="0" cellpadding="0" border="0" role="presentation" style="text-align: right;margin-left: auto;margin-right: 0;">
                                          <tbody>
                                            <tr>
                                              <td class="o_btn-b o_heading o_text-xs" align="center" style="font-family: Helvetica, Arial, sans-serif;font-weight: bold;margin-top: 0px;margin-bottom: 0px;font-size: 14px;line-height: 21px;mso-padding-alt: 7px 8px;">
                                                <span class="o_text-light" style="text-decoration: none;outline: none;color: #82899a;display: block;padding: 7px 8px;font-weight: bold;"><span style="mso-text-raise: 6px;display: inline;color: #82899a;">{{ $user->name }}</span></span>
                                              </td>
                                            </tr>
                                          </tbody>
                                        </table>
                                      </div>
                                    </div>
                                    <!--[if mso]>
                                  </td>
                                </tr>
                            </table>
                            <![endif]-->
                          </td>
                        </tr>
                      </tbody>
                    </table>
                    <!--[if mso]>
                  </td>
                </tr>
            </table>
            <![endif]-->
          </td>
        </tr>
      </tbody>
    </table>
    <!-- hero-white-button -->
    <table width="100%" cellspacing="0" cellpadding="0" border="0" role="presentation">
      <tbody>
        <tr>
          <td class="o_bg-light o_px-xs" align="center" style="background-color: #dbe5ea;padding-left: 8px;padding-right: 8px;">
            <!--[if mso]>
            <table width="632" cellspacing="0" cellpadding="0" border="0" role="presentation">
              <tbody>
                <tr>
                  <td>
                    <![endif]-->
                    <table class="o_block" width="100%" cellspacing="0" cellpadding="0" border="0" role="presentation" style="max-width: 632px;margin: 0 auto;">
                      <tbody>
                        <tr>
                          <td class="o_bg-white o_px-md o_py-xl o_xs-py-md o_sans o_text-md o_text-light" align="center" style="font-family: Helvetica, Arial, sans-serif;margin-top: 0px;margin-bottom: 0px;font-size: 19px;line-height: 28px;background-color: #ffffff;color: #82899a;padding-left: 24px;padding-right: 24px;padding-top: 64px;padding-bottom: 32px;">
                            <h2 class="o_heading o_text-dark o_mb-xxs" style="font-family: Helvetica, Arial, sans-serif;font-weight: bold;margin-top: 0px;margin-bottom: 4px;color: #1D3557;font-size: 30px;line-height: 39px;">You're almost there!</h2>
                            <p class="o_mb-md" style="margin-top: 0px;margin-bottom: 24px;">Thank you for signing up for
                              Enfront! Click the button below to verify your email, and we'll help you get started.
                            </p>
                            <table align="center" cellspacing="0" cellpadding="0" border="0" role="presentation">
                              <tbody>
                                <tr>
                                  <td width="300" class="o_btn o_bg-primary o_br o_heading o_text" align="center" style="font-family: Helvetica, Arial, sans-serif;font-weight: bold;margin-top: 0px;margin-bottom: 0px;font-size: 16px;line-height: 24px;mso-padding-alt: 12px 24px;background-color: #1D3557;border-radius: 4px;">

                                    <a class="o_text-white" href="{{ route('activate', ['token' => $user->confirmation_token]) }}" style="text-decoration: none;outline: none;color: #ffffff;display: block;padding: 12px 24px;mso-text-raise: 3px;">Activate Account</a>

                                  </td>
                                </tr>
                              </tbody>
                            </table>
                          </td>
                        </tr>
                      </tbody>
                    </table>
                    <!--[if mso]>
                  </td>
                </tr>
            </table>
            <![endif]-->
          </td>
        </tr>
      </tbody>
    </table>
    <!-- content -->
    <table width="100%" cellspacing="0" cellpadding="0" border="0" role="presentation">
      <tbody>
        <tr>
          <td class="o_bg-light o_px-xs" align="center" style="background-color: #dbe5ea;padding-left: 8px;padding-right: 8px;">
            <!--[if mso]>
            <table width="632" cellspacing="0" cellpadding="0" border="0" role="presentation">
              <tbody>
                <tr>
                  <td>
                    <![endif]-->
                    <table class="o_block" width="100%" cellspacing="0" cellpadding="0" border="0" role="presentation" style="max-width: 632px;margin: 0 auto;">
                      <tbody>
                        <tr>
                          <td class="o_bg-white o_px-md o_py o_sans o_text o_text-secondary" align="center" style="font-family: Helvetica, Arial, sans-serif;margin-top: 0px;margin-bottom: 0px;font-size: 14px;line-height: 24px;background-color: #ffffff;color: #82899a;padding-left: 24px;padding-right: 24px;padding-top: 16px;padding-bottom: 16px;">
                            <p style="margin-top: 0px;margin-bottom: 0px;">You have received this email
                              because an Academix account was created using this email address. If this was a
                              mistake, ignore this email -- the account hasn't been activated yet.
                            </p>
                          </td>
                        </tr>
                      </tbody>
                    </table>
                    <!--[if mso]>
                  </td>
                </tr>
            </table>
            <![endif]-->
          </td>
        </tr>
      </tbody>
    </table>
    <!-- spacer-lg -->
    <table width="100%" cellspacing="0" cellpadding="0" border="0" role="presentation">
      <tbody>
        <tr>
          <td class="o_bg-light o_px-xs" align="center" style="background-color: #dbe5ea;padding-left: 8px;padding-right: 8px;">
            <!--[if mso]>
            <table width="632" cellspacing="0" cellpadding="0" border="0" role="presentation">
              <tbody>
                <tr>
                  <td>
                    <![endif]-->
                    <table class="o_block" width="100%" cellspacing="0" cellpadding="0" border="0" role="presentation" style="max-width: 632px;margin: 0 auto;">
                      <tbody>
                        <tr>
                          <td class="o_bg-white" style="font-size: 16px;line-height: 16px;height: 16px;background-color: #ffffff;">&nbsp; </td>
                        </tr>
                      </tbody>
                    </table>
                    <!--[if mso]>
                  </td>
                </tr>
            </table>
            <![endif]-->
          </td>
        </tr>
      </tbody>
    </table>
    <!-- footer-light-2cols -->
    <table width="100%" cellspacing="0" cellpadding="0" border="0" role="presentation">
      <tbody>
        <tr>
          <td class="o_bg-light o_px-xs o_pb-lg o_xs-pb-xs" align="center" style="background-color: #dbe5ea;padding-left: 8px;padding-right: 8px;padding-bottom: 32px;">
            <!--[if mso]>
            <table width="632" cellspacing="0" cellpadding="0" border="0" role="presentation">
              <tbody>
                <tr>
                  <td>
                    <![endif]-->
                    <table class="o_block" width="100%" cellspacing="0" cellpadding="0" border="0" role="presentation" style="max-width: 632px;margin: 0 auto;">
                      <tbody>
                        <tr>
                          <td class="o_bg-white o_px-md o_py-lg o_bt-light o_br-b o_sans o_text-xs o_text-light" align="center" style="font-family: Helvetica, Arial, sans-serif;margin-top: 0px;margin-bottom: 0px;font-size: 14px;line-height: 21px;background-color: #ffffff;color: #82899a;border-top: 1px solid #d3dce0;border-radius: 0px 0px 4px 4px;padding-left: 24px;padding-right: 24px;padding-top: 32px;padding-bottom: 32px;">

                            <p class="o_mb" style="margin-top: 0px;margin-bottom: 16px;">
                                &copy; <?php echo date('Y') ?> Academix</p>
                            <p style="margin-top: 0px;margin-bottom: 0px;">
                              <a class="o_text-light o_underline" href="https://enfront.io" style="text-decoration: underline;outline: none;color: #82899a;">Home Page</a> <span class="o_hide-xs">&nbsp; • &nbsp;</span><br class="o_hide-lg" style="display: none;font-size: 0;max-height: 0;width: 0;line-height: 0;overflow: hidden;mso-hide: all;visibility: hidden;">
                              <a class="o_text-light o_underline" href="https://enfront.io" style="text-decoration: underline;outline: none;color: #82899a;">Pricing</a> <span class="o_hide-xs">&nbsp; • &nbsp;</span><br class="o_hide-lg" style="display: none;font-size: 0;max-height: 0;width: 0;line-height: 0;overflow: hidden;mso-hide: all;visibility: hidden;">
                              <a class="o_text-light o_underline" href="https://enfront.io" style="text-decoration: underline;outline: none;color: #82899a;">Help Center</a>
                            </p>
                          </td>
                        </tr>
                      </tbody>
                    </table>
                    <!--[if mso]>
                  </td>
                </tr>
            </table>
            <![endif]-->
            <div class="o_hide-xs" style="font-size: 64px; line-height: 64px; height: 64px;">&nbsp; </div>
          </td>
        </tr>
      </tbody>
    </table>
  </body>
</html>
