# Contributing to Langchain-rust

Thank you for your interest in contributing to Langchain-rust! We appreciate any contributions, whether it's bug fixes, new features, or documentation improvements. Here's how you can get started:

## Getting Started

1. Fork the Langchain-rust repository to your GitHub account.
2. Clone the forked repository to your local machine.
3. Create a new branch for your contributions: `git checkout -b my-contribution`.
4. Make your changes and improvements to the codebase.
5. Run the tests to ensure that everything is functioning correctly.
6. Commit your changes: `git commit -m "Add my contribution"`.
7. Push the changes to your forked repository: `git push origin my-contribution`.
8. Open a new pull request on the Langchain-rust repository.

## Guidelines

- Make sure your code follows the Rust programming style and conventions.
- Write clear and concise commit messages to describe your changes.
- Include appropriate documentation and tests for the changes you make.
- If your contribution includes new features or significant changes, please update the relevant documentation or README files.

## Code of Conduct

Langchain-rust follows a code of conduct to ensure a welcoming and inclusive environment for all contributors. Please review the CODE_OF_CONDUCT.md file in the repository to familiarize yourself with our expectations and guidelines.

## Communication

If you have any questions or need assistance with your contributions, feel free to reach out to us on our official Discord channel or open an issue on the repository.

We appreciate your support and look forward to your contributions!
