﻿using System;
using System.Collections.Generic;

namespace StylesheetNET
{
    internal static class Keywords
    {
        public static string GetPseudoByType(PseudoType type)
        {
            switch (type)
            {
                case PseudoType.Active:
                    return ":active";
                case PseudoType.Checked:
                    return ":checked";
                case PseudoType.Disabled:
                    return ":disabled";
                case PseudoType.Empty:
                    return ":empty";
                case PseudoType.Enabled:
                    return ":enabled";
                case PseudoType.FirstChild:
                    return ":first-child";
                case PseudoType.FirstOfType:
                    return ":first-of-type";
                case PseudoType.Focus:
                    return ":focus";
                case PseudoType.Hover:
                    return ":hover";
                case PseudoType.InRange:
                    return ":in-range";
                case PseudoType.Invalid:
                    return ":invalid";
                case PseudoType.Lang:
                    return ":lang";
                case PseudoType.LastChild:
                    return ":last-child";
                case PseudoType.LastOfType:
                    return ":last-of-type";
                case PseudoType.Link:
                    return ":link";
                case PseudoType.Not:
                    return ":not";
                case PseudoType.NthChild:
                    return ":nth-child";
                case PseudoType.NthLastChild:
                    return ":nth-last-child";
                case PseudoType.NthLastOfType:
                    return ":nth-last-of-type";
                case PseudoType.NthOfType:
                    return ":nth-of-type";
                case PseudoType.OnlyOfType:
                    return ":only-of-type";
                case PseudoType.OnlyChild:
                    return ":only-child";
                case PseudoType.OutOfRange:
                    return ":out-of-range";
                case PseudoType.ReadOnly:
                    return ":read-only";
                case PseudoType.ReadWrite:
                    return ":read-write";
                case PseudoType.Required:
                    return ":required";
                case PseudoType.Target:
                    return ":target";
                case PseudoType.Valid:
                    return ":valid";
                case PseudoType.Visited:
                    return ":visited";

                case PseudoType.After:
                    return "::after";
                case PseudoType.Before:
                    return "::before";
                case PseudoType.FirstLetter:
                    return "::first-letter";
                case PseudoType.FirstLine:
                    return "::first-line";
                case PseudoType.Marker:
                    return "::marker";
                case PseudoType.Selection:
                    return "::selection";

                case PseudoType.None:
                    return string.Empty;
                default:
                    return string.Empty;
            }
        }
        internal static string GetKeywordByOption(Enum option)
        {
            CssKeywords.TryGetValue(option, out var keyword);
            return keyword;
        }
        internal static Enum GetOptionByKeyword<T>(string keyword) where T : Enum
        {
            foreach (var item in CssKeywords)
            {
                if (keyword.Trim().ToLower() == item.Value.Trim().ToLower() && item.Key.GetType() == typeof(T))
                {
                    return (T)item.Key;
                }
            }
            return null;
        }
        internal static readonly Dictionary<Enum, string> CssKeywords = new Dictionary<Enum, string>()
        {
           { AlignContentOptions.Stretch, "stretch" },
           { AlignContentOptions.Center, "center" },
           { AlignContentOptions.FlexStart, "flex-start" },
           { AlignContentOptions.FlexEnd, "flex-end" },
           { AlignContentOptions.SpaceBetween, "space-between" },
           { AlignContentOptions.SpaceAround, "space-around" },
           { AlignContentOptions.Initial, "initial" },
           { AlignContentOptions.Inherit, "inherit" },
           { AlignItemsOptions.Stretch, "stretch" },
           { AlignItemsOptions.Center, "center" },
           { AlignItemsOptions.FlexStart, "flex-start" },
           { AlignItemsOptions.FlexEnd, "flex-end" },
           { AlignItemsOptions.Baseline, "baseline" },
           { AlignItemsOptions.Initial, "initial" },
           { AlignItemsOptions.Inherit, "inherit" },
           { AlignSelfOptions.Auto, "auto" },
           { AlignSelfOptions.Stretch, "stretch" },
           { AlignSelfOptions.Center, "center" },
           { AlignSelfOptions.FlexStart, "flex-start" },
           { AlignSelfOptions.FlexEnd, "flex-end" },
           { AlignSelfOptions.Baseline, "baseline" },
           { AlignSelfOptions.Initial, "initial" },
           { AlignSelfOptions.Inherit, "inherit" },
           { AllOptions.Initial, "initial" },
           { AllOptions.Inherit, "inherit" },
           { AllOptions.Unset, "unset" },
           { AnimationOptions.Initial, "initial" },
           { AnimationOptions.Inherit, "inherit" },
           { AnimationDelayOptions.Initial, "initial" },
           { AnimationDelayOptions.Inherit, "inherit" },
           { AnimationDirectionOptions.Normal, "normal" },
           { AnimationDirectionOptions.Reverse, "reverse" },
           { AnimationDirectionOptions.Alternate, "alternate" },
           { AnimationDirectionOptions.AlternateReverse, "alternate-reverse" },
           { AnimationDirectionOptions.Initial, "initial" },
           { AnimationDirectionOptions.Inherit, "inherit" },
           { AnimationDurationOptions.Initial, "initial" },
           { AnimationDurationOptions.Inherit, "inherit" },
           { AnimationFillModeOptions.None, "none" },
           { AnimationFillModeOptions.Forwards, "forwards" },
           { AnimationFillModeOptions.Backwards, "backwards" },
           { AnimationFillModeOptions.Both, "both" },
           { AnimationFillModeOptions.Initial, "initial" },
           { AnimationFillModeOptions.Inherit, "inherit" },
           { AnimationIterationCountOptions.Infinite, "infinite" },
           { AnimationIterationCountOptions.Initial, "initial" },
           { AnimationIterationCountOptions.Inherit, "inherit" },
           { AnimationNameOptions.None, "none" },
           { AnimationNameOptions.Initial, "initial" },
           { AnimationNameOptions.Inherit, "inherit" },
           { AnimationPlayStateOptions.Paused, "paused" },
           { AnimationPlayStateOptions.Running, "running" },
           { AnimationPlayStateOptions.Initial, "initial" },
           { AnimationPlayStateOptions.Inherit, "inherit" },
           { AnimationTimingFunctionOptions.Linear, "linear" },
           { AnimationTimingFunctionOptions.Ease, "ease" },
           { AnimationTimingFunctionOptions.EaseIn, "ease-in" },
           { AnimationTimingFunctionOptions.EaseOut, "ease-out" },
           { AnimationTimingFunctionOptions.EaseInOut, "ease-in-out" },
           { AnimationTimingFunctionOptions.StepStart, "step-start" },
           { AnimationTimingFunctionOptions.StepEnd, "step-end" },
           { AnimationTimingFunctionOptions.Initial, "initial" },
           { AnimationTimingFunctionOptions.Inherit, "inherit" },
           { BackfaceVisibilityOptions.Visible, "visible" },
           { BackfaceVisibilityOptions.Hidden, "hidden" },
           { BackfaceVisibilityOptions.Initial, "initial" },
           { BackfaceVisibilityOptions.Inherit, "inherit" },
           { BackgroundOptions.Initial, "initial" },
           { BackgroundOptions.Inherit, "inherit" },
           { BackgroundAttachmentOptions.Scroll, "scroll" },
           { BackgroundAttachmentOptions.Fixed, "fixed" },
           { BackgroundAttachmentOptions.Local, "local" },
           { BackgroundAttachmentOptions.Initial, "initial" },
           { BackgroundAttachmentOptions.Inherit, "inherit" },
           { BackgroundBlendModeOptions.Normal, "normal" },
           { BackgroundBlendModeOptions.Multiply, "multiply" },
           { BackgroundBlendModeOptions.Screen, "screen" },
           { BackgroundBlendModeOptions.Overlay, "overlay" },
           { BackgroundBlendModeOptions.Darken, "darken" },
           { BackgroundBlendModeOptions.Lighten, "lighten" },
           { BackgroundBlendModeOptions.ColorDodge, "color-dodge" },
           { BackgroundBlendModeOptions.Saturation, "saturation" },
           { BackgroundBlendModeOptions.Luminosity, "luminosity" },
           { BackgroundClipOptions.BorderBox, "border-box" },
           { BackgroundClipOptions.PaddingBox, "padding-box" },
           { BackgroundClipOptions.ContentBox, "content-box" },
           { BackgroundClipOptions.Initial, "initial" },
           { BackgroundClipOptions.Inherit, "inherit" },
           { BackgroundColorOptions.Transparent, "transparent" },
           { BackgroundColorOptions.Initial, "initial" },
           { BackgroundColorOptions.Inherit, "inherit" },
           { BackgroundImageOptions.None, "none" },
           { BackgroundImageOptions.Initial, "initial" },
           { BackgroundImageOptions.Inherit, "inherit" },
           { BackgroundOriginOptions.PaddingBox, "padding-box" },
           { BackgroundOriginOptions.BorderBox, "border-box" },
           { BackgroundOriginOptions.ContentBox, "content-box" },
           { BackgroundOriginOptions.Initial, "initial" },
           { BackgroundOriginOptions.Inherit, "inherit" },
           { BackgroundPositionOptions.Initial, "initial" },
           { BackgroundPositionOptions.Inherit, "inherit" },
           { BackgroundRepeatOptions.Repeat, "repeat" },
           { BackgroundRepeatOptions.RepeatX, "repeat-x" },
           { BackgroundRepeatOptions.RepeatY, "repeat-y" },
           { BackgroundRepeatOptions.NoRepeat, "no-repeat" },
           { BackgroundRepeatOptions.Space, "space" },
           { BackgroundRepeatOptions.Round, "round" },
           { BackgroundRepeatOptions.Initial, "initial" },
           { BackgroundRepeatOptions.Inherit, "inherit" },
           { BackgroundSizeOptions.Auto, "auto" },
           { BackgroundSizeOptions.Percentage, "percentage" },
           { BackgroundSizeOptions.Cover, "cover" },
           { BackgroundSizeOptions.Contain, "contain" },
           { BackgroundSizeOptions.Initial, "initial" },
           { BackgroundSizeOptions.Inherit, "inherit" },
           { BorderOptions.Initial, "initial" },
           { BorderOptions.Inherit, "inherit" },
           { BorderBottomOptions.Initial, "initial" },
           { BorderBottomOptions.Inherit, "inherit" },
           { BorderBottomColorOptions.Transparent, "transparent" },
           { BorderBottomColorOptions.Initial, "initial" },
           { BorderBottomColorOptions.Inherit, "inherit" },
           { BorderBottomLeftRadiusOptions.Initial, "initial" },
           { BorderBottomLeftRadiusOptions.Inherit, "inherit" },
           { BorderBottomRightRadiusOptions.Initial, "initial" },
           { BorderBottomRightRadiusOptions.Inherit, "inherit" },
           { BorderBottomStyleOptions.None, "none" },
           { BorderBottomStyleOptions.Hidden, "hidden" },
           { BorderBottomStyleOptions.Dotted, "dotted" },
           { BorderBottomStyleOptions.Dashed, "dashed" },
           { BorderBottomStyleOptions.Solid, "solid" },
           { BorderBottomStyleOptions.Double, "double" },
           { BorderBottomStyleOptions.Groove, "groove" },
           { BorderBottomStyleOptions.Ridge, "ridge" },
           { BorderBottomStyleOptions.Inset, "inset" },
           { BorderBottomStyleOptions.Outset, "outset" },
           { BorderBottomStyleOptions.Initial, "initial" },
           { BorderBottomStyleOptions.Inherit, "inherit" },
           { BorderBottomWidthOptions.Medium, "medium" },
           { BorderBottomWidthOptions.Thin, "thin" },
           { BorderBottomWidthOptions.Thick, "thick" },
           { BorderBottomWidthOptions.Initial, "initial" },
           { BorderBottomWidthOptions.Inherit, "inherit" },
           { BorderCollapseOptions.Separate, "separate" },
           { BorderCollapseOptions.Collapse, "collapse" },
           { BorderCollapseOptions.Initial, "initial" },
           { BorderCollapseOptions.Inherit, "inherit" },
           { BorderColorOptions.Transparent, "transparent" },
           { BorderColorOptions.Initial, "initial" },
           { BorderColorOptions.Inherit, "inherit" },
           { BorderImageOptions.Initial, "initial" },
           { BorderImageOptions.Inherit, "inherit" },
           { BorderImageOutsetOptions.Initial, "initial" },
           { BorderImageOutsetOptions.Inherit, "inherit" },
           { BorderImageRepeatOptions.Stretch, "stretch" },
           { BorderImageRepeatOptions.Repeat, "repeat" },
           { BorderImageRepeatOptions.Round, "round" },
           { BorderImageRepeatOptions.Space, "space" },
           { BorderImageRepeatOptions.Initial, "initial" },
           { BorderImageRepeatOptions.Inherit, "inherit" },
           { BorderImageSliceOptions.Fill, "fill" },
           { BorderImageSliceOptions.Initial, "initial" },
           { BorderImageSliceOptions.Inherit, "inherit" },
           { BorderImageSourceOptions.None, "none" },
           { BorderImageSourceOptions.Image, "image" },
           { BorderImageSourceOptions.Initial, "initial" },
           { BorderImageSourceOptions.Inherit, "inherit" },
           { BorderImageWidthOptions.Auto, "auto" },
           { BorderImageWidthOptions.Initial, "initial" },
           { BorderImageWidthOptions.Inherit, "inherit" },
           { BorderLeftOptions.Initial, "initial" },
           { BorderLeftOptions.Inherit, "inherit" },
           { BorderLeftColorOptions.Transparent, "transparent" },
           { BorderLeftColorOptions.Initial, "initial" },
           { BorderLeftColorOptions.Inherit, "inherit" },
           { BorderLeftStyleOptions.None, "none" },
           { BorderLeftStyleOptions.Hidden, "hidden" },
           { BorderLeftStyleOptions.Dotted, "dotted" },
           { BorderLeftStyleOptions.Dashed, "dashed" },
           { BorderLeftStyleOptions.Solid, "solid" },
           { BorderLeftStyleOptions.Double, "double" },
           { BorderLeftStyleOptions.Groove, "groove" },
           { BorderLeftStyleOptions.Ridge, "ridge" },
           { BorderLeftStyleOptions.Inset, "inset" },
           { BorderLeftStyleOptions.Outset, "outset" },
           { BorderLeftStyleOptions.Initial, "initial" },
           { BorderLeftStyleOptions.Inherit, "inherit" },
           { BorderLeftWidthOptions.Medium, "medium" },
           { BorderLeftWidthOptions.Thin, "thin" },
           { BorderLeftWidthOptions.Thick, "thick" },
           { BorderLeftWidthOptions.Initial, "initial" },
           { BorderLeftWidthOptions.Inherit, "inherit" },
           { BorderRadiusOptions.Initial, "initial" },
           { BorderRadiusOptions.Inherit, "inherit" },
           { BorderRightOptions.Initial, "initial" },
           { BorderRightOptions.Inherit, "inherit" },
           { BorderRightColorOptions.Transparent, "transparent" },
           { BorderRightColorOptions.Initial, "initial" },
           { BorderRightColorOptions.Inherit, "inherit" },
           { BorderRightStyleOptions.None, "none" },
           { BorderRightStyleOptions.Hidden, "hidden" },
           { BorderRightStyleOptions.Dotted, "dotted" },
           { BorderRightStyleOptions.Dashed, "dashed" },
           { BorderRightStyleOptions.Solid, "solid" },
           { BorderRightStyleOptions.Double, "double" },
           { BorderRightStyleOptions.Groove, "groove" },
           { BorderRightStyleOptions.Ridge, "ridge" },
           { BorderRightStyleOptions.Inset, "inset" },
           { BorderRightStyleOptions.Outset, "outset" },
           { BorderRightStyleOptions.Initial, "initial" },
           { BorderRightStyleOptions.Inherit, "inherit" },
           { BorderRightWidthOptions.Medium, "medium" },
           { BorderRightWidthOptions.Thin, "thin" },
           { BorderRightWidthOptions.Thick, "thick" },
           { BorderRightWidthOptions.Initial, "initial" },
           { BorderRightWidthOptions.Inherit, "inherit" },
           { BorderSpacingOptions.Initial, "initial" },
           { BorderSpacingOptions.Inherit, "inherit" },
           { BorderStyleOptions.None, "none" },
           { BorderStyleOptions.Hidden, "hidden" },
           { BorderStyleOptions.Dotted, "dotted" },
           { BorderStyleOptions.Dashed, "dashed" },
           { BorderStyleOptions.Solid, "solid" },
           { BorderStyleOptions.Double, "double" },
           { BorderStyleOptions.Groove, "groove" },
           { BorderStyleOptions.Ridge, "ridge" },
           { BorderStyleOptions.Inset, "inset" },
           { BorderStyleOptions.Outset, "outset" },
           { BorderStyleOptions.Initial, "initial" },
           { BorderStyleOptions.Inherit, "inherit" },
           { BorderTopOptions.Initial, "initial" },
           { BorderTopOptions.Inherit, "inherit" },
           { BorderTopColorOptions.Transparent, "transparent" },
           { BorderTopColorOptions.Initial, "initial" },
           { BorderTopColorOptions.Inherit, "inherit" },
           { BorderTopLeftRadiusOptions.Initial, "initial" },
           { BorderTopLeftRadiusOptions.Inherit, "inherit" },
           { BorderTopRightRadiusOptions.Initial, "initial" },
           { BorderTopRightRadiusOptions.Inherit, "inherit" },
           { BorderTopStyleOptions.None, "none" },
           { BorderTopStyleOptions.Hidden, "hidden" },
           { BorderTopStyleOptions.Dotted, "dotted" },
           { BorderTopStyleOptions.Dashed, "dashed" },
           { BorderTopStyleOptions.Solid, "solid" },
           { BorderTopStyleOptions.Double, "double" },
           { BorderTopStyleOptions.Groove, "groove" },
           { BorderTopStyleOptions.Ridge, "ridge" },
           { BorderTopStyleOptions.Inset, "inset" },
           { BorderTopStyleOptions.Outset, "outset" },
           { BorderTopStyleOptions.Initial, "initial" },
           { BorderTopStyleOptions.Inherit, "inherit" },
           { BorderTopWidthOptions.Medium, "medium" },
           { BorderTopWidthOptions.Thin, "thin" },
           { BorderTopWidthOptions.Thick, "thick" },
           { BorderTopWidthOptions.Initial, "initial" },
           { BorderTopWidthOptions.Inherit, "inherit" },
           { BorderWidthOptions.Medium, "medium" },
           { BorderWidthOptions.Thin, "thin" },
           { BorderWidthOptions.Thick, "thick" },
           { BorderWidthOptions.Initial, "initial" },
           { BorderWidthOptions.Inherit, "inherit" },
           { BottomOptions.Auto, "auto" },
           { BottomOptions.Initial, "initial" },
           { BottomOptions.Inherit, "inherit" },
           { BoxDecorationBreakOptions.Slice, "slice" },
           { BoxDecorationBreakOptions.Clone, "clone" },
           { BoxDecorationBreakOptions.Initial, "initial" },
           { BoxDecorationBreakOptions.Inherit, "inherit" },
           { BoxShadowOptions.None, "none" },
           { BoxShadowOptions.HOffset, "h-offset" },
           { BoxShadowOptions.VOffset, "v-offset" },
           { BoxShadowOptions.Blur, "blur" },
           { BoxShadowOptions.Spread, "spread" },
           { BoxShadowOptions.Inset, "inset" },
           { BoxShadowOptions.Initial, "initial" },
           { BoxShadowOptions.Inherit, "inherit" },
           { BoxSizingOptions.ContentBox, "content-box" },
           { BoxSizingOptions.BorderBox, "border-box" },
           { BoxSizingOptions.Initial, "initial" },
           { BoxSizingOptions.Inherit, "inherit" },
           { CaptionSideOptions.Top, "top" },
           { CaptionSideOptions.Bottom, "bottom" },
           { CaptionSideOptions.Initial, "initial" },
           { CaptionSideOptions.Inherit, "inherit" },
           { CaretColorOptions.Auto, "auto" },
           { ClearOptions.None, "none" },
           { ClearOptions.Left, "left" },
           { ClearOptions.Right, "right" },
           { ClearOptions.Both, "both" },
           { ClearOptions.Initial, "initial" },
           { ClearOptions.Inherit, "inherit" },
           { ClipOptions.Auto, "auto" },
           { ClipOptions.Shape, "shape" },
           { ClipOptions.Initial, "initial" },
           { ClipOptions.Inherit, "inherit" },
           { ColorOptions.Initial, "initial" },
           { ColorOptions.Inherit, "inherit" },
           { ColumnCountOptions.Auto, "auto" },
           { ColumnCountOptions.Initial, "initial" },
           { ColumnCountOptions.Inherit, "inherit" },
           { ColumnFillOptions.Balance, "balance" },
           { ColumnFillOptions.Auto, "auto" },
           { ColumnFillOptions.Initial, "initial" },
           { ColumnFillOptions.Inherit, "inherit" },
           { ColumnGapOptions.Normal, "normal" },
           { ColumnGapOptions.Initial, "initial" },
           { ColumnGapOptions.Inherit, "inherit" },
           { ColumnRuleOptions.Initial, "initial" },
           { ColumnRuleOptions.Inherit, "inherit" },
           { ColumnRuleColorOptions.Initial, "initial" },
           { ColumnRuleColorOptions.Inherit, "inherit" },
           { ColumnRuleStyleOptions.None, "none" },
           { ColumnRuleStyleOptions.Hidden, "hidden" },
           { ColumnRuleStyleOptions.Dotted, "dotted" },
           { ColumnRuleStyleOptions.Dashed, "dashed" },
           { ColumnRuleStyleOptions.Solid, "solid" },
           { ColumnRuleStyleOptions.Double, "double" },
           { ColumnRuleStyleOptions.Groove, "groove" },
           { ColumnRuleStyleOptions.Ridge, "ridge" },
           { ColumnRuleStyleOptions.Inset, "inset" },
           { ColumnRuleStyleOptions.Outset, "outset" },
           { ColumnRuleStyleOptions.Initial, "initial" },
           { ColumnRuleStyleOptions.Inherit, "inherit" },
           { ColumnRuleWidthOptions.Medium, "medium" },
           { ColumnRuleWidthOptions.Thin, "thin" },
           { ColumnRuleWidthOptions.Thick, "thick" },
           { ColumnRuleWidthOptions.Initial, "initial" },
           { ColumnRuleWidthOptions.Inherit, "inherit" },
           { ColumnSpanOptions.None, "none" },
           { ColumnSpanOptions.All, "all" },
           { ColumnSpanOptions.Initial, "initial" },
           { ColumnSpanOptions.Inherit, "inherit" },
           { ColumnWidthOptions.Auto, "auto" },
           { ColumnWidthOptions.Initial, "initial" },
           { ColumnWidthOptions.Inherit, "inherit" },
           { ColumnsOptions.Auto, "auto" },
           { ColumnsOptions.Initial, "initial" },
           { ColumnsOptions.Inherit, "inherit" },
           { ContentOptions.Normal, "normal" },
           { ContentOptions.None, "none" },
           { ContentOptions.Counter, "counter" },
           { ContentOptions.String, "string" },
           { ContentOptions.OpenQuote, "open-quote" },
           { ContentOptions.CloseQuote, "close-quote" },
           { ContentOptions.NoOpenQuote, "no-open-quote" },
           { ContentOptions.NoCloseQuote, "no-close-quote" },
           { ContentOptions.Initial, "initial" },
           { ContentOptions.Inherit, "inherit" },
           { CounterIncrementOptions.None, "none" },
           { CounterIncrementOptions.Initial, "initial" },
           { CounterIncrementOptions.Inherit, "inherit" },
           { CounterResetOptions.None, "none" },
           { CounterResetOptions.Initial, "initial" },
           { CounterResetOptions.Inherit, "inherit" },
           { CursorOptions.Alias, "alias" },
           { CursorOptions.AllScroll, "all-scroll" },
           { CursorOptions.Auto, "auto" },
           { CursorOptions.Cell, "cell" },
           { CursorOptions.ContextMenu, "context-menu" },
           { CursorOptions.ColResize, "col-resize" },
           { CursorOptions.Copy, "copy" },
           { CursorOptions.Crosshair, "crosshair" },
           { CursorOptions.Default, "default" },
           { CursorOptions.EResize, "e-resize" },
           { CursorOptions.EwResize, "ew-resize" },
           { CursorOptions.Grab, "grab" },
           { CursorOptions.Grabbing, "grabbing" },
           { CursorOptions.Help, "help" },
           { CursorOptions.Move, "move" },
           { CursorOptions.NResize, "n-resize" },
           { CursorOptions.NeResize, "ne-resize" },
           { CursorOptions.NeswResize, "nesw-resize" },
           { CursorOptions.NsResize, "ns-resize" },
           { CursorOptions.NwResize, "nw-resize" },
           { CursorOptions.NwseResize, "nwse-resize" },
           { CursorOptions.NoDrop, "no-drop" },
           { CursorOptions.None, "none" },
           { CursorOptions.NotAllowed, "not-allowed" },
           { CursorOptions.Pointer, "pointer" },
           { CursorOptions.Progress, "progress" },
           { CursorOptions.RowResize, "row-resize" },
           { CursorOptions.SResize, "s-resize" },
           { CursorOptions.SeResize, "se-resize" },
           { CursorOptions.SwResize, "sw-resize" },
           { CursorOptions.Text, "text" },
           { CursorOptions.URL, "URL" },
           { CursorOptions.VerticalText, "vertical-text" },
           { CursorOptions.WResize, "w-resize" },
           { CursorOptions.Wait, "wait" },
           { CursorOptions.ZoomIn, "zoom-in" },
           { CursorOptions.ZoomOut, "zoom-out" },
           { CursorOptions.Initial, "initial" },
           { CursorOptions.Inherit, "inherit" },
           { DirectionOptions.Ltr, "ltr" },
           { DirectionOptions.Rtl, "rtl" },
           { DirectionOptions.Initial, "initial" },
           { DirectionOptions.Inherit, "inherit" },
           { DisplayOptions.Inline, "inline" },
           { DisplayOptions.Block, "block" },
           { DisplayOptions.Contents, "contents" },
           { DisplayOptions.Flex, "flex" },
           { DisplayOptions.Grid, "grid" },
           { DisplayOptions.InlineBlock, "inline-block" },
           { DisplayOptions.InlineFlex, "inline-flex" },
           { DisplayOptions.InlineGrid, "inline-grid" },
           { DisplayOptions.InlineTable, "inline-table" },
           { DisplayOptions.ListItem, "list-item" },
           { DisplayOptions.RunIn, "run-in" },
           { DisplayOptions.Table, "table" },
           { DisplayOptions.TableCaption, "table-caption" },
           { DisplayOptions.TableColumnGroup, "table-column-group" },
           { DisplayOptions.TableHeaderGroup, "table-header-group" },
           { DisplayOptions.TableFooterGroup, "table-footer-group" },
           { DisplayOptions.TableRowGroup, "table-row-group" },
           { DisplayOptions.TableCell, "table-cell" },
           { DisplayOptions.TableColumn, "table-column" },
           { DisplayOptions.TableRow, "table-row" },
           { DisplayOptions.None, "none" },
           { DisplayOptions.Initial, "initial" },
           { DisplayOptions.Inherit, "inherit" },
           { EmptyCellsOptions.Show, "show" },
           { EmptyCellsOptions.Hide, "hide" },
           { EmptyCellsOptions.Initial, "initial" },
           { EmptyCellsOptions.Inherit, "inherit" },
           { FilterOptions.None, "none" },
           { FilterOptions.Initial, "initial" },
           { FilterOptions.Inherit, "inherit" },
           { FlexOptions.Auto, "auto" },
           { FlexOptions.Initial, "initial" },
           { FlexOptions.None, "none" },
           { FlexOptions.Inherit, "inherit" },
           { FlexBasisOptions.Auto, "auto" },
           { FlexBasisOptions.Initial, "initial" },
           { FlexBasisOptions.Inherit, "inherit" },
           { FlexDirectionOptions.Row, "row" },
           { FlexDirectionOptions.RowReverse, "row-reverse" },
           { FlexDirectionOptions.Column, "column" },
           { FlexDirectionOptions.ColumnReverse, "column-reverse" },
           { FlexDirectionOptions.Initial, "initial" },
           { FlexDirectionOptions.Inherit, "inherit" },
           { FlexFlowOptions.FlexDirection, "flex-direction" },
           { FlexFlowOptions.FlexWrap, "flex-wrap" },
           { FlexFlowOptions.Initial, "initial" },
           { FlexFlowOptions.Inherit, "inherit" },
           { FlexGrowOptions.Initial, "initial" },
           { FlexGrowOptions.Inherit, "inherit" },
           { FlexShrinkOptions.Initial, "initial" },
           { FlexShrinkOptions.Inherit, "inherit" },
           { FlexWrapOptions.Nowrap, "nowrap" },
           { FlexWrapOptions.Wrap, "wrap" },
           { FlexWrapOptions.WrapReverse, "wrap-reverse" },
           { FlexWrapOptions.Initial, "initial" },
           { FlexWrapOptions.Inherit, "inherit" },
           { FloatOptions.None, "none" },
           { FloatOptions.Left, "left" },
           { FloatOptions.Right, "right" },
           { FloatOptions.Initial, "initial" },
           { FloatOptions.Inherit, "inherit" },
           { FontOptions.Caption, "caption" },
           { FontOptions.Icon, "icon" },
           { FontOptions.Menu, "menu" },
           { FontOptions.MessageBox, "message-box" },
           { FontOptions.SmallCaption, "small-caption" },
           { FontOptions.StatusBar, "status-bar" },
           { FontOptions.Initial, "initial" },
           { FontOptions.Inherit, "inherit" },
           { FontFamilyOptions.Initial, "initial" },
           { FontFamilyOptions.Inherit, "inherit" },
           { FontKerningOptions.Auto, "auto" },
           { FontKerningOptions.Normal, "normal" },
           { FontKerningOptions.None, "none" },
           { FontSizeOptions.Medium, "medium" },
           { FontSizeOptions.XxSmall, "xx-small" },
           { FontSizeOptions.XSmall, "x-small" },
           { FontSizeOptions.Small, "small" },
           { FontSizeOptions.Large, "large" },
           { FontSizeOptions.XLarge, "x-large" },
           { FontSizeOptions.XxLarge, "xx-large" },
           { FontSizeOptions.Smaller, "smaller" },
           { FontSizeOptions.Larger, "larger" },
           { FontSizeOptions.Initial, "initial" },
           { FontSizeOptions.Inherit, "inherit" },
           { FontSizeAdjustOptions.None, "none" },
           { FontSizeAdjustOptions.Initial, "initial" },
           { FontSizeAdjustOptions.Inherit, "inherit" },
           { FontStretchOptions.UltraCondensed, "ultra-condensed" },
           { FontStretchOptions.ExtraCondensed, "extra-condensed" },
           { FontStretchOptions.Condensed, "condensed" },
           { FontStretchOptions.SemiCondensed, "semi-condensed" },
           { FontStretchOptions.Normal, "normal" },
           { FontStretchOptions.SemiExpanded, "semi-expanded" },
           { FontStretchOptions.Expanded, "expanded" },
           { FontStretchOptions.ExtraExpanded, "extra-expanded" },
           { FontStretchOptions.UltraExpanded, "ultra-expanded" },
           { FontStretchOptions.Initial, "initial" },
           { FontStretchOptions.Inherit, "inherit" },
           { FontStyleOptions.Normal, "normal" },
           { FontStyleOptions.Italic, "italic" },
           { FontStyleOptions.Oblique, "oblique" },
           { FontStyleOptions.Initial, "initial" },
           { FontStyleOptions.Inherit, "inherit" },
           { FontVariantOptions.Normal, "normal" },
           { FontVariantOptions.SmallCaps, "small-caps" },
           { FontVariantOptions.Initial, "initial" },
           { FontVariantOptions.Inherit, "inherit" },
           { FontWeightOptions.Normal, "normal" },
           { FontWeightOptions.Bold, "bold" },
           { FontWeightOptions.Bolder, "bolder" },
           { FontWeightOptions.Lighter, "lighter" },
           { FontWeightOptions._100, "100" },
           { FontWeightOptions._200, "200" },
           { FontWeightOptions._300, "300" },
           { FontWeightOptions._400, "400" },
           { FontWeightOptions._500, "500" },
           { FontWeightOptions._600, "600" },
           { FontWeightOptions._700, "700" },
           { FontWeightOptions._800, "800" },
           { FontWeightOptions._900, "900" },
           { FontWeightOptions.Initial, "initial" },
           { FontWeightOptions.Inherit, "inherit" },
           { GridOptions.None, "none" },
           { GridOptions.Initial, "initial" },
           { GridOptions.Inherit, "inherit" },
           { GridAutoColumnsOptions.Auto, "auto" },
           { GridAutoColumnsOptions.MaxContent, "max-content" },
           { GridAutoColumnsOptions.MinContent, "min-content" },
           { GridAutoFlowOptions.Row, "row" },
           { GridAutoFlowOptions.Column, "column" },
           { GridAutoFlowOptions.Dense, "dense" },
           { GridAutoRowsOptions.Auto, "auto" },
           { GridAutoRowsOptions.MaxContent, "max-content" },
           { GridAutoRowsOptions.MinContent, "min-content" },
           { GridColumnEndOptions.Auto, "auto" },
           { GridColumnStartOptions.Auto, "auto" },
           { GridRowEndOptions.Auto, "auto" },
           { GridRowStartOptions.Auto, "auto" },
           { GridTemplateOptions.None, "none" },
           { GridTemplateOptions.Initial, "initial" },
           { GridTemplateOptions.Inherit, "inherit" },
           { GridTemplateAreasOptions.None, "none" },
           { GridTemplateColumnsOptions.None, "none" },
           { GridTemplateColumnsOptions.Auto, "auto" },
           { GridTemplateColumnsOptions.MaxContent, "max-content" },
           { GridTemplateColumnsOptions.MinContent, "min-content" },
           { GridTemplateColumnsOptions.Initial, "initial" },
           { GridTemplateColumnsOptions.Inherit, "inherit" },
           { GridTemplateRowsOptions.None, "none" },
           { GridTemplateRowsOptions.Auto, "auto" },
           { GridTemplateRowsOptions.MaxContent, "max-content" },
           { GridTemplateRowsOptions.MinContent, "min-content" },
           { HangingPunctuationOptions.None, "none" },
           { HangingPunctuationOptions.First, "first" },
           { HangingPunctuationOptions.Last, "last" },
           { HangingPunctuationOptions.AllowEnd, "allow-end" },
           { HangingPunctuationOptions.ForceEnd, "force-end" },
           { HangingPunctuationOptions.Initial, "initial" },
           { HangingPunctuationOptions.Inherit, "inherit" },
           { HeightOptions.Auto, "auto" },
           { HeightOptions.Initial, "initial" },
           { HeightOptions.Inherit, "inherit" },
           { HyphensOptions.None, "none" },
           { HyphensOptions.Manual, "manual" },
           { HyphensOptions.Auto, "auto" },
           { HyphensOptions.Initial, "initial" },
           { HyphensOptions.Inherit, "inherit" },
           { IsolationOptions.Auto, "auto" },
           { IsolationOptions.Isolate, "isolate" },
           { IsolationOptions.Initial, "initial" },
           { IsolationOptions.Inherit, "inherit" },
           { JustifyContentOptions.FlexStart, "flex-start" },
           { JustifyContentOptions.FlexEnd, "flex-end" },
           { JustifyContentOptions.Center, "center" },
           { JustifyContentOptions.SpaceBetween, "space-between" },
           { JustifyContentOptions.SpaceAround, "space-around" },
           { JustifyContentOptions.Initial, "initial" },
           { JustifyContentOptions.Inherit, "inherit" },
           { LeftOptions.Auto, "auto" },
           { LeftOptions.Initial, "initial" },
           { LeftOptions.Inherit, "inherit" },
           { LetterSpacingOptions.Normal, "normal" },
           { LetterSpacingOptions.Initial, "initial" },
           { LetterSpacingOptions.Inherit, "inherit" },
           { LineHeightOptions.Normal, "normal" },
           { LineHeightOptions.Initial, "initial" },
           { LineHeightOptions.Inherit, "inherit" },
           { ListStyleOptions.Initial, "initial" },
           { ListStyleOptions.Inherit, "inherit" },
           { ListStyleImageOptions.None, "none" },
           { ListStyleImageOptions.Url, "url" },
           { ListStyleImageOptions.Initial, "initial" },
           { ListStyleImageOptions.Inherit, "inherit" },
           { ListStylePositionOptions.Inside, "inside" },
           { ListStylePositionOptions.Outside, "outside" },
           { ListStylePositionOptions.Initial, "initial" },
           { ListStylePositionOptions.Inherit, "inherit" },
           { ListStyleTypeOptions.Disc, "disc" },
           { ListStyleTypeOptions.Armenian, "armenian" },
           { ListStyleTypeOptions.Circle, "circle" },
           { ListStyleTypeOptions.CjkIdeographic, "cjk-ideographic" },
           { ListStyleTypeOptions.Decimal, "decimal" },
           { ListStyleTypeOptions.DecimalLeadingZero, "decimal-leading-zero" },
           { ListStyleTypeOptions.Georgian, "georgian" },
           { ListStyleTypeOptions.Hebrew, "hebrew" },
           { ListStyleTypeOptions.Hiragana, "hiragana" },
           { ListStyleTypeOptions.HiraganaIroha, "hiragana-iroha" },
           { ListStyleTypeOptions.Katakana, "katakana" },
           { ListStyleTypeOptions.KatakanaIroha, "katakana-iroha" },
           { ListStyleTypeOptions.LowerAlpha, "lower-alpha" },
           { ListStyleTypeOptions.LowerGreek, "lower-greek" },
           { ListStyleTypeOptions.LowerLatin, "lower-latin" },
           { ListStyleTypeOptions.LowerRoman, "lower-roman" },
           { ListStyleTypeOptions.None, "none" },
           { ListStyleTypeOptions.Square, "square" },
           { ListStyleTypeOptions.UpperAlpha, "upper-alpha" },
           { ListStyleTypeOptions.UpperGreek, "upper-greek" },
           { ListStyleTypeOptions.UpperLatin, "upper-latin" },
           { ListStyleTypeOptions.UpperRoman, "upper-roman" },
           { ListStyleTypeOptions.Initial, "initial" },
           { ListStyleTypeOptions.Inherit, "inherit" },
           { MarginOptions.Auto, "auto" },
           { MarginOptions.Initial, "initial" },
           { MarginOptions.Inherit, "inherit" },
           { MarginBottomOptions.Auto, "auto" },
           { MarginBottomOptions.Initial, "initial" },
           { MarginBottomOptions.Inherit, "inherit" },
           { MarginLeftOptions.Auto, "auto" },
           { MarginLeftOptions.Initial, "initial" },
           { MarginLeftOptions.Inherit, "inherit" },
           { MarginRightOptions.Auto, "auto" },
           { MarginRightOptions.Initial, "initial" },
           { MarginRightOptions.Inherit, "inherit" },
           { MarginTopOptions.Auto, "auto" },
           { MarginTopOptions.Initial, "initial" },
           { MarginTopOptions.Inherit, "inherit" },
           { MaxHeightOptions.None, "none" },
           { MaxHeightOptions.Initial, "initial" },
           { MaxHeightOptions.Inherit, "inherit" },
           { MaxWidthOptions.None, "none" },
           { MaxWidthOptions.Initial, "initial" },
           { MaxWidthOptions.Inherit, "inherit" },
           { MinHeightOptions.Initial, "initial" },
           { MinHeightOptions.Inherit, "inherit" },
           { MinWidthOptions.Initial, "initial" },
           { MinWidthOptions.Inherit, "inherit" },
           { MixBlendModeOptions.Normal, "normal" },
           { MixBlendModeOptions.Multiply, "multiply" },
           { MixBlendModeOptions.Screen, "screen" },
           { MixBlendModeOptions.Overlay, "overlay" },
           { MixBlendModeOptions.Darken, "darken" },
           { MixBlendModeOptions.Lighten, "lighten" },
           { MixBlendModeOptions.ColorDodge, "color-dodge" },
           { MixBlendModeOptions.ColorBurn, "color-burn" },
           { MixBlendModeOptions.Difference, "difference" },
           { MixBlendModeOptions.Exclusion, "exclusion" },
           { MixBlendModeOptions.Hue, "hue" },
           { MixBlendModeOptions.Saturation, "saturation" },
           { MixBlendModeOptions.Luminosity, "luminosity" },
           { ObjectFitOptions.Fill, "fill" },
           { ObjectFitOptions.Contain, "contain" },
           { ObjectFitOptions.Cover, "cover" },
           { ObjectFitOptions.None, "none" },
           { ObjectFitOptions.ScaleDown, "scale-down" },
           { ObjectFitOptions.Initial, "initial" },
           { ObjectFitOptions.Inherit, "inherit" },
           { ObjectPositionOptions.Position, "position" },
           { ObjectPositionOptions.Initial, "initial" },
           { ObjectPositionOptions.Inherit, "inherit" },
           { OpacityOptions.Initial, "initial" },
           { OpacityOptions.Inherit, "inherit" },
           { OrderOptions.Initial, "initial" },
           { OrderOptions.Inherit, "inherit" },
           { OutlineOptions.Initial, "initial" },
           { OutlineOptions.Inherit, "inherit" },
           { OutlineColorOptions.Invert, "invert" },
           { OutlineColorOptions.Initial, "initial" },
           { OutlineColorOptions.Inherit, "inherit" },
           { OutlineOffsetOptions.Initial, "initial" },
           { OutlineOffsetOptions.Inherit, "inherit" },
           { OutlineStyleOptions.None, "none" },
           { OutlineStyleOptions.Hidden, "hidden" },
           { OutlineStyleOptions.Dotted, "dotted" },
           { OutlineStyleOptions.Dashed, "dashed" },
           { OutlineStyleOptions.Solid, "solid" },
           { OutlineStyleOptions.Double, "double" },
           { OutlineStyleOptions.Groove, "groove" },
           { OutlineStyleOptions.Ridge, "ridge" },
           { OutlineStyleOptions.Inset, "inset" },
           { OutlineStyleOptions.Outset, "outset" },
           { OutlineStyleOptions.Initial, "initial" },
           { OutlineStyleOptions.Inherit, "inherit" },
           { OutlineWidthOptions.Medium, "medium" },
           { OutlineWidthOptions.Thin, "thin" },
           { OutlineWidthOptions.Thick, "thick" },
           { OutlineWidthOptions.Initial, "initial" },
           { OutlineWidthOptions.Inherit, "inherit" },
           { OverflowOptions.Visible, "visible" },
           { OverflowOptions.Hidden, "hidden" },
           { OverflowOptions.Scroll, "scroll" },
           { OverflowOptions.Auto, "auto" },
           { OverflowOptions.Initial, "initial" },
           { OverflowOptions.Inherit, "inherit" },
           { OverflowXOptions.Visible, "visible" },
           { OverflowXOptions.Hidden, "hidden" },
           { OverflowXOptions.Scroll, "scroll" },
           { OverflowXOptions.Auto, "auto" },
           { OverflowXOptions.Initial, "initial" },
           { OverflowXOptions.Inherit, "inherit" },
           { OverflowYOptions.Visible, "visible" },
           { OverflowYOptions.Hidden, "hidden" },
           { OverflowYOptions.Scroll, "scroll" },
           { OverflowYOptions.Auto, "auto" },
           { OverflowYOptions.Initial, "initial" },
           { OverflowYOptions.Inherit, "inherit" },
           { PaddingOptions.Initial, "initial" },
           { PaddingOptions.Inherit, "inherit" },
           { PaddingBottomOptions.Initial, "initial" },
           { PaddingBottomOptions.Inherit, "inherit" },
           { PaddingLeftOptions.Initial, "initial" },
           { PaddingLeftOptions.Inherit, "inherit" },
           { PaddingRightOptions.Initial, "initial" },
           { PaddingRightOptions.Inherit, "inherit" },
           { PaddingTopOptions.Initial, "initial" },
           { PaddingTopOptions.Inherit, "inherit" },
           { PageBreakAfterOptions.Auto, "auto" },
           { PageBreakAfterOptions.Always, "always" },
           { PageBreakAfterOptions.Avoid, "avoid" },
           { PageBreakAfterOptions.Left, "left" },
           { PageBreakAfterOptions.Right, "right" },
           { PageBreakAfterOptions.Initial, "initial" },
           { PageBreakAfterOptions.Inherit, "inherit" },
           { PageBreakBeforeOptions.Auto, "auto" },
           { PageBreakBeforeOptions.Always, "always" },
           { PageBreakBeforeOptions.Avoid, "avoid" },
           { PageBreakBeforeOptions.Left, "left" },
           { PageBreakBeforeOptions.Right, "right" },
           { PageBreakBeforeOptions.Initial, "initial" },
           { PageBreakBeforeOptions.Inherit, "inherit" },
           { PageBreakInsideOptions.Auto, "auto" },
           { PageBreakInsideOptions.Avoid, "avoid" },
           { PageBreakInsideOptions.Initial, "initial" },
           { PageBreakInsideOptions.Inherit, "inherit" },
           { PerspectiveOptions.None, "none" },
           { PerspectiveOptions.Initial, "initial" },
           { PerspectiveOptions.Inherit, "inherit" },
           { PerspectiveOriginOptions.XAxis, "x-axis" },
           { PerspectiveOriginOptions.YAxis, "y-axis" },
           { PerspectiveOriginOptions.Initial, "initial" },
           { PerspectiveOriginOptions.Inherit, "inherit" },
           { PointerEventsOptions.Auto, "auto" },
           { PointerEventsOptions.None, "none" },
           { PointerEventsOptions.Initial, "initial" },
           { PointerEventsOptions.Inherit, "inherit" },
           { PositionOptions.Static, "static" },
           { PositionOptions.Absolute, "absolute" },
           { PositionOptions.Fixed, "fixed" },
           { PositionOptions.Relative, "relative" },
           { PositionOptions.Sticky, "sticky" },
           { PositionOptions.Initial, "initial" },
           { PositionOptions.Inherit, "inherit" },
           { QuotesOptions.None, "none" },
           { QuotesOptions.Initial, "initial" },
           { QuotesOptions.Inherit, "inherit" },
           { ResizeOptions.None, "none" },
           { ResizeOptions.Both, "both" },
           { ResizeOptions.Horizontal, "horizontal" },
           { ResizeOptions.Vertical, "vertical" },
           { ResizeOptions.Initial, "initial" },
           { ResizeOptions.Inherit, "inherit" },
           { RightOptions.Auto, "auto" },
           { RightOptions.Initial, "initial" },
           { RightOptions.Inherit, "inherit" },
           { ScrollBehaviorOptions.Auto, "auto" },
           { ScrollBehaviorOptions.Smooth, "smooth" },
           { ScrollBehaviorOptions.Initial, "initial" },
           { ScrollBehaviorOptions.Inherit, "inherit" },
           { TabSizeOptions.Initial, "initial" },
           { TabSizeOptions.Inherit, "inherit" },
           { TableLayoutOptions.Auto, "auto" },
           { TableLayoutOptions.Fixed, "fixed" },
           { TableLayoutOptions.Initial, "initial" },
           { TableLayoutOptions.Inherit, "inherit" },
           { TextAlignOptions.Left, "left" },
           { TextAlignOptions.Right, "right" },
           { TextAlignOptions.Center, "center" },
           { TextAlignOptions.Justify, "justify" },
           { TextAlignOptions.Initial, "initial" },
           { TextAlignOptions.Inherit, "inherit" },
           { TextAlignLastOptions.Auto, "auto" },
           { TextAlignLastOptions.Left, "left" },
           { TextAlignLastOptions.Right, "right" },
           { TextAlignLastOptions.Center, "center" },
           { TextAlignLastOptions.Justify, "justify" },
           { TextAlignLastOptions.Start, "start" },
           { TextAlignLastOptions.End, "end" },
           { TextAlignLastOptions.Initial, "initial" },
           { TextAlignLastOptions.Inherit, "inherit" },
           { TextDecorationOptions.Initial, "initial" },
           { TextDecorationOptions.Inherit, "inherit" },
           { TextDecorationColorOptions.Initial, "initial" },
           { TextDecorationColorOptions.Inherit, "inherit" },
           { TextDecorationLineOptions.None, "none" },
           { TextDecorationLineOptions.Underline, "underline" },
           { TextDecorationLineOptions.Overline, "overline" },
           { TextDecorationLineOptions.LineThrough, "line-through" },
           { TextDecorationLineOptions.Initial, "initial" },
           { TextDecorationLineOptions.Inherit, "inherit" },
           { TextDecorationStyleOptions.Solid, "solid" },
           { TextDecorationStyleOptions.Double, "double" },
           { TextDecorationStyleOptions.Dotted, "dotted" },
           { TextDecorationStyleOptions.Dashed, "dashed" },
           { TextDecorationStyleOptions.Wavy, "wavy" },
           { TextDecorationStyleOptions.Initial, "initial" },
           { TextDecorationStyleOptions.Inherit, "inherit" },
           { TextIndentOptions.Initial, "initial" },
           { TextIndentOptions.Inherit, "inherit" },
           { TextJustifyOptions.Auto, "auto" },
           { TextJustifyOptions.InterWord, "inter-word" },
           { TextJustifyOptions.InterCharacter, "inter-character" },
           { TextJustifyOptions.None, "none" },
           { TextJustifyOptions.Initial, "initial" },
           { TextJustifyOptions.Inherit, "inherit" },
           { TextOverflowOptions.Clip, "clip" },
           { TextOverflowOptions.Ellipsis, "ellipsis" },
           { TextOverflowOptions.String, "string" },
           { TextOverflowOptions.Initial, "initial" },
           { TextOverflowOptions.Inherit, "inherit" },
           { TextShadowOptions.None, "none" },
           { TextShadowOptions.Initial, "initial" },
           { TextShadowOptions.Inherit, "inherit" },
           { TextTransformOptions.None, "none" },
           { TextTransformOptions.Capitalize, "capitalize" },
           { TextTransformOptions.Uppercase, "uppercase" },
           { TextTransformOptions.Lowercase, "lowercase" },
           { TextTransformOptions.Initial, "initial" },
           { TextTransformOptions.Inherit, "inherit" },
           { TopOptions.Auto, "auto" },
           { TopOptions.Initial, "initial" },
           { TopOptions.Inherit, "inherit" },
           { TransformOptions.None, "none" },
           { TransformOptions.Initial, "initial" },
           { TransformOptions.Inherit, "inherit" },
           { TransformOriginOptions.XAxis, "x-axis" },
           { TransformOriginOptions.YAxis, "y-axis" },
           { TransformOriginOptions.ZAxis, "z-axis" },
           { TransformOriginOptions.Initial, "initial" },
           { TransformOriginOptions.Inherit, "inherit" },
           { TransformStyleOptions.Flat, "flat" },
           { TransformStyleOptions.Preserve3d, "preserve-3d" },
           { TransformStyleOptions.Initial, "initial" },
           { TransformStyleOptions.Inherit, "inherit" },
           { TransitionOptions.Initial, "initial" },
           { TransitionOptions.Inherit, "inherit" },
           { TransitionDelayOptions.Initial, "initial" },
           { TransitionDelayOptions.Inherit, "inherit" },
           { TransitionDurationOptions.Initial, "initial" },
           { TransitionDurationOptions.Inherit, "inherit" },
           { TransitionPropertyOptions.None, "none" },
           { TransitionPropertyOptions.All, "all" },
           { TransitionPropertyOptions.Initial, "initial" },
           { TransitionPropertyOptions.Inherit, "inherit" },
           { TransitionTimingFunctionOptions.Ease, "ease" },
           { TransitionTimingFunctionOptions.Linear, "linear" },
           { TransitionTimingFunctionOptions.EaseIn, "ease-in" },
           { TransitionTimingFunctionOptions.EaseOut, "ease-out" },
           { TransitionTimingFunctionOptions.EaseInOut, "ease-in-out" },
           { TransitionTimingFunctionOptions.StepStart, "step-start" },
           { TransitionTimingFunctionOptions.StepEnd, "step-end" },
           { TransitionTimingFunctionOptions.Initial, "initial" },
           { TransitionTimingFunctionOptions.Inherit, "inherit" },
           { UnicodeBidiOptions.Normal, "normal" },
           { UnicodeBidiOptions.Embed, "embed" },
           { UnicodeBidiOptions.BidiOverride, "bidi-override" },
           { UnicodeBidiOptions.Isolate, "isolate" },
           { UnicodeBidiOptions.IsolateOverride, "isolate-override" },
           { UnicodeBidiOptions.Plaintext, "plaintext" },
           { UnicodeBidiOptions.Initial, "initial" },
           { UnicodeBidiOptions.Inherit, "inherit" },
           { UserSelectOptions.Auto, "auto" },
           { UserSelectOptions.None, "none" },
           { UserSelectOptions.Text, "text" },
           { UserSelectOptions.All, "all" },
           { VerticalAlignOptions.Baseline, "baseline" },
           { VerticalAlignOptions.Sub, "sub" },
           { VerticalAlignOptions.Super, "super" },
           { VerticalAlignOptions.Top, "top" },
           { VerticalAlignOptions.TextTop, "text-top" },
           { VerticalAlignOptions.Middle, "middle" },
           { VerticalAlignOptions.Bottom, "bottom" },
           { VerticalAlignOptions.TextBottom, "text-bottom" },
           { VerticalAlignOptions.Initial, "initial" },
           { VerticalAlignOptions.Inherit, "inherit" },
           { VisibilityOptions.Visible, "visible" },
           { VisibilityOptions.Hidden, "hidden" },
           { VisibilityOptions.Collapse, "collapse" },
           { VisibilityOptions.Initial, "initial" },
           { VisibilityOptions.Inherit, "inherit" },
           { WhiteSpaceOptions.Normal, "normal" },
           { WhiteSpaceOptions.Nowrap, "nowrap" },
           { WhiteSpaceOptions.Pre, "pre" },
           { WhiteSpaceOptions.PreLine, "pre-line" },
           { WhiteSpaceOptions.PreWrap, "pre-wrap" },
           { WhiteSpaceOptions.Initial, "initial" },
           { WhiteSpaceOptions.Inherit, "inherit" },
           { WidthOptions.Auto, "auto" },
           { WidthOptions.Initial, "initial" },
           { WidthOptions.Inherit, "inherit" },
           { WordBreakOptions.Normal, "normal" },
           { WordBreakOptions.BreakAll, "break-all" },
           { WordBreakOptions.KeepAll, "keep-all" },
           { WordBreakOptions.BreakWord, "break-word" },
           { WordBreakOptions.Initial, "initial" },
           { WordBreakOptions.Inherit, "inherit" },
           { WordSpacingOptions.Normal, "normal" },
           { WordSpacingOptions.Initial, "initial" },
           { WordSpacingOptions.Inherit, "inherit" },
           { WordWrapOptions.Normal, "normal" },
           { WordWrapOptions.BreakWord, "break-word" },
           { WordWrapOptions.Initial, "initial" },
           { WordWrapOptions.Inherit, "inherit" },
           { WritingModeOptions.HorizontalTb, "horizontal-tb" },
           { WritingModeOptions.VerticalRl, "vertical-rl" },
           { WritingModeOptions.VerticalLr, "vertical-lr" },
           { ZIndexOptions.Auto, "auto" },
           { ZIndexOptions.Initial, "initial" },
           { ZIndexOptions.Inherit, "inherit" }
        };
    }
}
