namespace StylesheetNET
{
    /// <summary>
    ///Gets predefined css keyword options for <see cref="TextAlign"/>
    /// </summary>
    public enum TextAlignOptions
    {
        /// <summary>
        ///Left align text
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'left'</c></list>
        /// </summary>
        Left,
        /// <summary>
        ///Right align text
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'right'</c></list>
        /// </summary>
        Right,
        /// <summary>
        ///Center align text
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'center'</c></list>
        /// </summary>
        Center,
        /// <summary>
        ///Justifies text making each line equal width
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'justify'</c></list>
        /// </summary>
        Justify,
        /// <summary>
        ///Sets the value to its default value value.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'initial'</c></list>
        /// </summary>
        Initial,
        /// <summary>
        ///Inherits the value from its parent element.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'inherit'</c></list>
        /// </summary>
        Inherit
    }
}