namespace StylesheetNET
{
    /// <summary>
    ///Gets predefined css keyword options for <see cref="TextAlignLast"/>
    /// </summary>
    public enum TextAlignLastOptions
    {
        /// <summary>
        ///Default. The last line will be justified and left-aligned.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'auto'</c></list>
        /// </summary>
        Auto,
        /// <summary>
        ///Left align last line text
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'left'</c></list>
        /// </summary>
        Left,
        /// <summary>
        ///Right align last line text
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'right'</c></list>
        /// </summary>
        Right,
        /// <summary>
        ///Center align last line text
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'center'</c></list>
        /// </summary>
        Center,
        /// <summary>
        ///Justifies last line text
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'justify'</c></list>
        /// </summary>
        Justify,
        /// <summary>
        ///Last line is aligned at the beginning of the line
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'start'</c></list>
        /// </summary>
        Start,
        /// <summary>
        ///Last line is aligned at the End of the line
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'end'</c></list>
        /// </summary>
        End,
        /// <summary>
        ///Sets the value to its default value
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'initial'</c></list>
        /// </summary>
        Initial,
        /// <summary>
        ///Inherits the vale from its parent element.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'inherit'</c></list>
        /// </summary>
        Inherit
    }
}