namespace StylesheetNET
{
    /// <summary>
    ///Gets predefined css keyword options for <see cref="PointerEvents"/>
    /// </summary>
    public enum PointerEventsOptions
    {
        /// <summary>
        ///Default. Element reacts to pointer events, like :hover and click.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'auto'</c></list>
        /// </summary>
        Auto,
        /// <summary>
        ///The element does not react to pointer events
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'none'</c></list>
        /// </summary>
        None,
        /// <summary>
        ///Sets the value to its default value.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'initial'</c></list>
        /// </summary>
        Initial,
        /// <summary>
        ///Inherits the value from its parent element.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'inherit'</c></list>
        /// </summary>
        Inherit
    }
}