namespace StylesheetNET
{
    /// <summary>
    ///Gets predefined css keyword options for <see cref="OutlineWidth"/>
    /// </summary>
    public enum OutlineWidthOptions
    {
        /// <summary>
        ///Default. Medium outline. 1 pixel wide.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'medium'</c></list>
        /// </summary>
        Medium,
        /// <summary>
        ///Thin outline
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'thin'</c></list>
        /// </summary>
        Thin,
        /// <summary>
        ///Thick outline
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'thick'</c></list>
        /// </summary>
        Thick,
        /// <summary>
        ///Sets the value to its default value.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'initial'</c></list>
        /// </summary>
        Initial,
        /// <summary>
        ///Inherits the value from its parent element.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'inherit'</c></list>
        /// </summary>
        Inherit
    }
}