namespace StylesheetNET
{
    /// <summary>
    ///Gets predefined css keyword options for <see cref="MixBlendMode"/>
    /// </summary>
    public enum MixBlendModeOptions
    {
        /// <summary>
        ///Default. Sets the blending mode to normal.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'normal'</c></list>
        /// </summary>
        Normal,
        /// <summary>
        ///Sets the blending mode to multiply.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'multiply'</c></list>
        /// </summary>
        Multiply,
        /// <summary>
        ///Sets the blending mode to screen.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'screen'</c></list>
        /// </summary>
        Screen,
        /// <summary>
        ///Sets the blending mode to overlay.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'overlay'</c></list>
        /// </summary>
        Overlay,
        /// <summary>
        ///Sets the blending mode to darken.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'darken'</c></list>
        /// </summary>
        Darken,
        /// <summary>
        ///Sets the blending mode to lighten.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'lighten'</c></list>
        /// </summary>
        Lighten,
        /// <summary>
        ///Sets the blending mode to color dodge.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'color-dodge'</c></list>
        /// </summary>
        ColorDodge,
        /// <summary>
        ///Sets the blending mode to color burn.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'color-burn'</c></list>
        /// </summary>
        ColorBurn,
        /// <summary>
        ///Sets the blending mode to color.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'color'</c></list>
        /// </summary>
        Color,
        /// <summary>
        ///Sets the blending mode to difference.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'difference'</c></list>
        /// </summary>
        Difference,
        /// <summary>
        ///	Sets the blending mode to exclusion.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'exclusion'</c></list>
        /// </summary>
        Exclusion,
        /// <summary>
        ///Sets the blending mode to hue.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'hue'</c></list>
        /// </summary>
        Hue,
        /// <summary>
        ///Sets the blending mode to saturation.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'saturation'</c></list>
        /// </summary>
        Saturation,
        /// <summary>
        ///Sets the blending mode to luminosity.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'luminosity'</c></list>
        /// </summary>
        Luminosity
    }
}