namespace StylesheetNET
{
    /// <summary>
    ///Gets predefined css keyword options for <see cref="ListStyleType"/>
    /// </summary>
    public enum ListStyleTypeOptions
    {
        /// <summary>
        ///Default. A solid circular marker.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'disc'</c></list>
        /// </summary>
        Disc,
        /// <summary>
        ///Traditional Armenian numbering
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'armenian'</c></list>
        /// </summary>
        Armenian,
        /// <summary>
        ///Circle marker
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'circle'</c></list>
        /// </summary>
        Circle,
        /// <summary>
        ///Ideographic numbers marker
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'cjk-ideographic'</c></list>
        /// </summary>
        CjkIdeographic,
        /// <summary>
        ///Number marker
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'decimal'</c></list>
        /// </summary>
        Decimal,
        /// <summary>
        ///A number with leading zeros (01, 02, 03, etc.)
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'decimal-leading-zero'</c></list>
        /// </summary>
        DecimalLeadingZero,
        /// <summary>
        ///Traditional Georgian numbering
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'georgian'</c></list>
        /// </summary>
        Georgian,
        /// <summary>
        ///Traditional Hebrew numbering
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'hebrew'</c></list>
        /// </summary>
        Hebrew,
        /// <summary>
        ///Traditional Hiragana numbering
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'hiragana'</c></list>
        /// </summary>
        Hiragana,
        /// <summary>
        ///Traditional Hiragana Iroha numbering
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'hiragana-iroha'</c></list>
        /// </summary>
        HiraganaIroha,
        /// <summary>
        ///Traditional Katakana numbering marker
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'katakana'</c></list>
        /// </summary>
        Katakana,
        /// <summary>
        ///Traditional Katakana Iroha numbering
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'katakana-iroha'</c></list>
        /// </summary>
        KatakanaIroha,
        /// <summary>
        ///Lower case alphanumeric letters (a, b, c, d, e, etc.)
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'lower-alpha'</c></list>
        /// </summary>
        LowerAlpha,
        /// <summary>
        ///Lower case greek characters
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'lower-greek'</c></list>
        /// </summary>
        LowerGreek,
        /// <summary>
        ///Lower case latin letters (a, b, c, d, e, etc.)
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'lower-latin'</c></list>
        /// </summary>
        LowerLatin,
        /// <summary>
        ///Lower case roman numerals (i, ii, iii, iv, v, etc.)
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'lower-roman'</c></list>
        /// </summary>
        LowerRoman,
        /// <summary>
        ///No marker
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'none'</c></list>
        /// </summary>
        None,
        /// <summary>
        ///Square marker
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'square'</c></list>
        /// </summary>
        Square,
        /// <summary>
        ///Upper case alphanumeric (A, B, C, D, E, etc.) 
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'upper-alpha'</c></list>
        /// </summary>
        UpperAlpha,
        /// <summary>
        ///Upper case greek characters
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'upper-greek'</c></list>
        /// </summary>
        UpperGreek,
        /// <summary>
        ///Upper case latin characters (A, B, C, D, E, etc.)
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'upper-latin'</c></list>
        /// </summary>
        UpperLatin,
        /// <summary>
        ///Upper case roman numerals (I, II, III, IV, V, etc.)
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'upper-roman'</c></list>
        /// </summary>
        UpperRoman,
        /// <summary>
        ///Sets the value to its default value.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'initial'</c></list>
        /// </summary>
        Initial,
        /// <summary>
        ///Inherits the value from its parent element.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'inherit'</c></list>
        /// </summary>
        Inherit
    }
}