namespace StylesheetNET
{
    /// <summary>
    ///Gets predefined css keyword options for <see cref="FontWeight"/>
    /// </summary>
    public enum FontWeightOptions
    {
        /// <summary>
        ///Default. Characters with Normal thickness.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'normal'</c></list>
        /// </summary>
        Normal,
        /// <summary>
        ///Thick characters.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'bold'</c></list>
        /// </summary>
        Bold,
        /// <summary>
        ///Thicker characters.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'bolder'</c></list>
        /// </summary>
        Bolder,
        /// <summary>
        ///Lighter characters.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'lighter'</c></list>
        /// </summary>
        Lighter,
        /// <summary>
        ///Thin (Hairline)
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'100'</c></list>
        /// </summary>
        _100,
        /// <summary>
        ///Extra Light (Ultra Light)
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'200'</c></list>
        /// </summary>
        _200,
        /// <summary>
        ///Light
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'300'</c></list>
        /// </summary>
        _300,
        /// <summary>
        ///Normal (Regular)
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'400'</c></list>
        /// </summary>
        _400,
        /// <summary>
        ///Medium
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'500'</c></list>
        /// </summary>
        _500,
        /// <summary>
        ///Semi Bold (Demi Bold)
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'600'</c></list>
        /// </summary>
        _600,
        /// <summary>
        ///Bold
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'700'</c></list>
        /// </summary>
        _700,
        /// <summary>
        ///Extra Bold (Ultra Bold)
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'800'</c></list>
        /// </summary>
        _800,
        /// <summary>
        ///Black (Heavy)
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'900'</c></list>
        /// </summary>
        _900,
        /// <summary>
        ///Sets the value to its default value.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'initial'</c></list>
        /// </summary>
        Initial,
        /// <summary>
        ///Inherits the value from its parent element.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'inherit'</c></list>
        /// </summary>
        Inherit
    }
}