namespace StylesheetNET
{
    /// <summary>
    ///Gets predefined css keyword options for <see cref="FontVariant"/>
    /// </summary>
    public enum FontVariantOptions
    {
        /// <summary>
        ///Default, displays a Normal font
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'normal'</c></list>
        /// </summary>
        Normal,
        /// <summary>
        ///Displays a SmallCaps font
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'small-caps'</c></list>
        /// </summary>
        SmallCaps,
        /// <summary>
        ///Sets the value to its default value.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'initial'</c></list>
        /// </summary>
        Initial,
        /// <summary>
        ///Inherits the value from its parent element.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'inherit'</c></list>
        /// </summary>
        Inherit
    }
}