namespace StylesheetNET
{
    /// <summary>
    ///Gets predefined css keyword options for <see cref="FontStretch"/>
    /// </summary>
    public enum FontStretchOptions
    {
        /// <summary>
        ///Very highly condensed text
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'ultra-condensed'</c></list>
        /// </summary>
        UltraCondensed,
        /// <summary>
        ///Highly condensed text
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'extra-condensed'</c></list>
        /// </summary>
        ExtraCondensed,
        /// <summary>
        ///Condensed text
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'condensed'</c></list>
        /// </summary>
        Condensed,
        /// <summary>
        ///Slightly condensed text
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'semi-condensed'</c></list>
        /// </summary>
        SemiCondensed,
        /// <summary>
        ///Default. Does not stretch font
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'normal'</c></list>
        /// </summary>
        Normal,
        /// <summary>
        ///Slightly expanded text
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'semi-expanded'</c></list>
        /// </summary>
        SemiExpanded,
        /// <summary>
        ///Expanded text
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'expanded'</c></list>
        /// </summary>
        Expanded,
        /// <summary>
        ///Highly expanded text
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'extra-expanded'</c></list>
        /// </summary>
        ExtraExpanded,
        /// <summary>
        ///Very highly expanded text
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'ultra-expanded'</c></list>
        /// </summary>
        UltraExpanded,
        /// <summary>
        ///Sets the value to its default value.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'initial'</c></list>
        /// </summary>
        Initial,
        /// <summary>
        ///Inherits the value from its parent element.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'inherit'</c></list>
        /// </summary>
        Inherit
    }
}