namespace StylesheetNET
{
    /// <summary>
    ///Gets predefined css keyword options for <see cref="FontSize"/>
    /// </summary>
    public enum FontSizeOptions
    {
        /// <summary>
        ///Default. Mediumn font size.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'medium'</c></list>
        /// </summary>
        Medium,
        /// <summary>
        ///Extra-extra-small font size.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'xx-small'</c></list>
        /// </summary>
        XxSmall,
        /// <summary>
        ///Extra small font size.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'x-small'</c></list>
        /// </summary>
        XSmall,
        /// <summary>
        ///Small font size.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'small'</c></list>
        /// </summary>
        Small,
        /// <summary>
        ///Large font size.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'large'</c></list>
        /// </summary>
        Large,
        /// <summary>
        ///Extra large font size.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'x-large'</c></list>
        /// </summary>
        XLarge,
        /// <summary>
        ///Extra-extra-large font size.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'xx-large'</c></list>
        /// </summary>
        XxLarge,
        /// <summary>
        ///Smaller font size than the parent element.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'smaller'</c></list>
        /// </summary>
        Smaller,
        /// <summary>
        ///Larger font size than the parent element.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'larger'</c></list>
        /// </summary>
        Larger,
        /// <summary>
        ///Sets the value to its default value.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'initial'</c></list>
        /// </summary>
        Initial,
        /// <summary>
        ///Inherits the value from its parent element.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'inherit'</c></list>
        /// </summary>
        Inherit
    }
}