namespace StylesheetNET
{
    /// <summary>
    ///Gets predefined css keyword options for <see cref="Font"/>
    /// </summary>
    public enum FontOptions
    {
        /// <summary>
        ///Built-in browser Font used for Captioned controls, such as, buttons.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'caption'</c></list>
        /// </summary>
        Caption,
        /// <summary>
        ///Built-in browser Font used for Icon labels.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'icon'</c></list>
        /// </summary>
        Icon,
        /// <summary>
        ///Built-in browser Font used for dropdown Menus.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'menu'</c></list>
        /// </summary>
        Menu,
        /// <summary>
        ///Built-in browser Fonts used for dialog boxes.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'message-box'</c></list>
        /// </summary>
        MessageBox,
        /// <summary>
        ///Built-in browser Fonts used for small control labels.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'small-caption'</c></list>
        /// </summary>
        SmallCaption,
        /// <summary>
        ///Built-in browser Font used in window status bar.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'status-bar'</c></list>
        /// </summary>
        StatusBar,
        /// <summary>
        ///Sets the value to its default value.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'initial'</c></list>
        /// </summary>
        Initial,
        /// <summary>
        ///Inherits the value from its parent element.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'inherit'</c></list>
        /// </summary>
        Inherit
    }
}