namespace StylesheetNET
{
    /// <summary>
    ///Gets predefined css keyword options for <see cref="ColumnRuleStyle"/>
    /// </summary>
    public enum ColumnRuleStyleOptions
    {
        /// <summary>
        ///Default, no style, i.e. no line.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'none'</c></list>
        /// </summary>
        None,
        /// <summary>
        ///Hidden style
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'hidden'</c></list>
        /// </summary>
        Hidden,
        /// <summary>
        ///Dotted style
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'dotted'</c></list>
        /// </summary>
        Dotted,
        /// <summary>
        ///Dashed style
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'dashed'</c></list>
        /// </summary>
        Dashed,
        /// <summary>
        ///Solid style
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'solid'</c></list>
        /// </summary>
        Solid,
        /// <summary>
        ///Double style
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'double'</c></list>
        /// </summary>
        Double,
        /// <summary>
        ///3D Grooved style. The effect depends on the width and color values
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'groove'</c></list>
        /// </summary>
        Groove,
        /// <summary>
        ///3D Ridged style. The effect depends on the width and color values
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'ridge'</c></list>
        /// </summary>
        Ridge,
        /// <summary>
        ///3D Inset style. The effect depends on the width and color values
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'inset'</c></list>
        /// </summary>
        Inset,
        /// <summary>
        ///3D Outset style. The effect depends on the width and color values
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'outset'</c></list>
        /// </summary>
        Outset,
        /// <summary>
        ///Sets the value to its default value.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'initial'</c></list>
        /// </summary>
        Initial,
        /// <summary>
        ///Inherits the value from its parent element.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'inherit'</c></list>
        /// </summary>
        Inherit
    }
}