namespace StylesheetNET
{
    /// <summary>
    ///Gets predefined css keyword options for <see cref="BackgroundBlendMode"/>
    /// </summary>
    public enum BackgroundBlendModeOptions
    {
        /// <summary>
        ///Default. Normal blending mode.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'normal'</c></list>
        /// </summary>
        Normal,
        /// <summary>
        ///Multiply blending mode.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'multiply'</c></list>
        /// </summary>
        Multiply,
        /// <summary>
        ///Screen blending mode.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'screen'</c></list>
        /// </summary>
        Screen,
        /// <summary>
        ///Overlay blending mode.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'overlay'</c></list>
        /// </summary>
        Overlay,
        /// <summary>
        ///Darken blending mode.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'darken'</c></list>
        /// </summary>
        Darken,
        /// <summary>
        ///Lighten blending mode.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'lighten'</c></list>
        /// </summary>
        Lighten,
        /// <summary>
        ///Color dodge blending mode.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'color-dodge'</c></list>
        /// </summary>
        ColorDodge,
        /// <summary>
        ///Saturation blending mode.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'saturation'</c></list>
        /// </summary>
        Saturation,
        /// <summary>
        ///Luminosity blending mode.
        ///<br/>
        ///<list type="bullet">It is equavalent to <c>'luminosity'</c></list>
        /// </summary>
        Luminosity
    }
}