import axios from 'axios'
import { Message, MessageBox } from 'element-ui'
import store from '../store'
import { getToken } from '@/utils/auth'
// 创建axios实例
const service = axios.create({
  baseURL: process.env.BASE_API, // api 的 base_url
  timeout: 20000 // 请求超时时间
})

// request拦截器
service.interceptors.request.use(
  config => {
    config.headers['Authorization'] = (getToken() == null || getToken() == undefined) ? '' : getToken()
    return config
  },
  error => {
    // Do something with request error
    Promise.reject(error)
  }
)

// response 拦截器
service.interceptors.response.use(
  response => {
    /**
     * code为非20000是抛错 可结合自己业务进行修改
     */
    const res = response.data
    // User.credentials.expired:非法的token; 50012:其他客户端登录了;  50014:Token 过期了;
    if (res.code == 'User.credentials.expired' || res.code == '50012' || res.code == '50014') {
      MessageBox.confirm(
        '你已被登出，可以取消继续留在该页面，或者重新登录',
        '重新登录',
        {
          confirmButtonText: '重新登录',
          cancelButtonText: '取消',
          type: 'warning'
        }
      ).then(() => {
        // sessionStorage.clear()
        // localStorage.clear()
        localStorage.removeItem('AJReportToken')
        window.location.href = "/";
      })
    }
    else if (res.code !== '200') {
      Message({
        message: res.message,
        type: 'error',
        duration: 5 * 1000
      })
      return response.data
    } else {
      return response.data
    }
  },
  error => {
    Message({
      message: error.message,
      type: 'error',
      duration: 5 * 1000
    })
    return Promise.reject(error)
  }
)

export default service
