
SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for aj_report_access
-- ----------------------------
DROP TABLE IF EXISTS `aj_report_init`.`aj_report_access`;
CREATE TABLE `aj_report_init`.`aj_report_access`  (
  `datetime` date NOT NULL,
  `access` int(11) NULL DEFAULT NULL COMMENT '访问量',
  `register` int(11) NULL DEFAULT NULL COMMENT '注册量',
  PRIMARY KEY (`datetime`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of aj_report_access
-- ----------------------------
INSERT INTO `aj_report_init`.`aj_report_access` VALUES ('2021-06-18', 1000, 12);
INSERT INTO `aj_report_init`.`aj_report_access` VALUES ('2021-06-19', 1200, 20);
INSERT INTO `aj_report_init`.`aj_report_access` VALUES ('2021-06-20', 1600, 40);
INSERT INTO `aj_report_init`.`aj_report_access` VALUES ('2021-06-21', 2000, 100);
INSERT INTO `aj_report_init`.`aj_report_access` VALUES ('2021-06-22', 800, 30);

-- ----------------------------
-- Table structure for aj_report_barstack
-- ----------------------------
DROP TABLE IF EXISTS `aj_report_init`.`aj_report_barstack`;
CREATE TABLE `aj_report_init`.`aj_report_barstack`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` date NULL DEFAULT NULL,
  `type` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `nums` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 8 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of aj_report_barstack
-- ----------------------------
INSERT INTO `aj_report_init`.`aj_report_barstack` VALUES (1, '2021-07-27', 'A', 12);
INSERT INTO `aj_report_init`.`aj_report_barstack` VALUES (2, '2021-07-27', 'B', 20);
INSERT INTO `aj_report_init`.`aj_report_barstack` VALUES (3, '2021-07-27', 'C', 11);
INSERT INTO `aj_report_init`.`aj_report_barstack` VALUES (4, '2021-07-26', 'A', 11);
INSERT INTO `aj_report_init`.`aj_report_barstack` VALUES (5, '2021-07-26', 'B', 30);
INSERT INTO `aj_report_init`.`aj_report_barstack` VALUES (6, '2021-07-25', 'B', 20);
INSERT INTO `aj_report_init`.`aj_report_barstack` VALUES (7, '2021-07-25', 'C', 15);

-- ----------------------------
-- Table structure for aj_report_common1
-- ----------------------------
DROP TABLE IF EXISTS `aj_report_init`.`aj_report_common1`;
CREATE TABLE `aj_report_init`.`aj_report_common1`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `nums` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 6 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of aj_report_common1
-- ----------------------------
INSERT INTO `aj_report_init`.`aj_report_common1` VALUES (1, '上海', 500);
INSERT INTO `aj_report_init`.`aj_report_common1` VALUES (2, '北京', 600);
INSERT INTO `aj_report_init`.`aj_report_common1` VALUES (3, '西安', 1000);
INSERT INTO `aj_report_init`.`aj_report_common1` VALUES (4, '河南', 1200);
INSERT INTO `aj_report_init`.`aj_report_common1` VALUES (5, '武汉', 2000);

-- ----------------------------
-- Table structure for aj_report_common2
-- ----------------------------
DROP TABLE IF EXISTS `aj_report_init`.`aj_report_common2`;
CREATE TABLE `aj_report_init`.`aj_report_common2`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `nums` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 11 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of aj_report_common2
-- ----------------------------
INSERT INTO `aj_report_init`.`aj_report_common2` VALUES (6, '上海', 200);
INSERT INTO `aj_report_init`.`aj_report_common2` VALUES (7, '北京', 100);
INSERT INTO `aj_report_init`.`aj_report_common2` VALUES (8, '西安', 70);
INSERT INTO `aj_report_init`.`aj_report_common2` VALUES (9, '河南', 50);
INSERT INTO `aj_report_init`.`aj_report_common2` VALUES (10, '武汉', 20);

-- ----------------------------
-- Table structure for aj_report_common3
-- ----------------------------
DROP TABLE IF EXISTS `aj_report_init`.`aj_report_common3`;
CREATE TABLE `aj_report_init`.`aj_report_common3`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `collect` int(11) NULL DEFAULT NULL,
  `start` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 25 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of aj_report_common3
-- ----------------------------
INSERT INTO `aj_report_init`.`aj_report_common3` VALUES (13, '1月', 10, 8);
INSERT INTO `aj_report_init`.`aj_report_common3` VALUES (14, '2月', 15, 12);
INSERT INTO `aj_report_init`.`aj_report_common3` VALUES (15, '3月', 20, 22);
INSERT INTO `aj_report_init`.`aj_report_common3` VALUES (16, '4月', 30, 28);
INSERT INTO `aj_report_init`.`aj_report_common3` VALUES (17, '5月', 28, 35);
INSERT INTO `aj_report_init`.`aj_report_common3` VALUES (18, '6月', 40, 38);
INSERT INTO `aj_report_init`.`aj_report_common3` VALUES (19, '7月', 80, 100);
INSERT INTO `aj_report_init`.`aj_report_common3` VALUES (20, '8月', 90, 120);
INSERT INTO `aj_report_init`.`aj_report_common3` VALUES (21, '9月', 65, 89);
INSERT INTO `aj_report_init`.`aj_report_common3` VALUES (22, '10月', 50, 50);
INSERT INTO `aj_report_init`.`aj_report_common3` VALUES (23, '11月', 35, 34);
INSERT INTO `aj_report_init`.`aj_report_common3` VALUES (24, '12月', 27, 23);

-- ----------------------------
-- Table structure for aj_report_comparestack
-- ----------------------------
DROP TABLE IF EXISTS `aj_report_init`.`aj_report_comparestack`;
CREATE TABLE `aj_report_init`.`aj_report_comparestack`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` date NULL DEFAULT NULL,
  `type` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `nums` bigint(11) NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 11 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of aj_report_comparestack
-- ----------------------------
INSERT INTO `aj_report_init`.`aj_report_comparestack` VALUES (1, '2021-08-23', '成功', 12);
INSERT INTO `aj_report_init`.`aj_report_comparestack` VALUES (2, '2021-08-23', '失败', 1);
INSERT INTO `aj_report_init`.`aj_report_comparestack` VALUES (3, '2021-08-24', '成功', 24);
INSERT INTO `aj_report_init`.`aj_report_comparestack` VALUES (4, '2021-08-24', '失败', 5);
INSERT INTO `aj_report_init`.`aj_report_comparestack` VALUES (5, '2021-08-25', '成功', 13);
INSERT INTO `aj_report_init`.`aj_report_comparestack` VALUES (6, '2021-08-25', '失败', 8);
INSERT INTO `aj_report_init`.`aj_report_comparestack` VALUES (7, '2021-08-26', '成功', 19);
INSERT INTO `aj_report_init`.`aj_report_comparestack` VALUES (8, '2021-08-26', '失败', 3);
INSERT INTO `aj_report_init`.`aj_report_comparestack` VALUES (9, '2021-08-27', '成功', 9);
INSERT INTO `aj_report_init`.`aj_report_comparestack` VALUES (10, '2021-08-27', '失败', 15);

-- ----------------------------
-- Table structure for aj_report_devices
-- ----------------------------
DROP TABLE IF EXISTS `aj_report_init`.`aj_report_devices`;
CREATE TABLE `aj_report_init`.`aj_report_devices`  (
  `device_id` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '设备编号',
  `device_name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '设备名称',
  `device_type` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '设备类型',
  `device_type_code` int(11) NULL DEFAULT NULL COMMENT '设备类型编号',
  `online_time` datetime NULL DEFAULT NULL COMMENT '上线日期',
  `device_state` int(255) NULL DEFAULT NULL COMMENT '1上线，0下线',
  PRIMARY KEY (`device_id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of aj_report_devices
-- ----------------------------
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('f00001', '11楼防火墙服务器f01A', '防火墙', 1, '2021-06-23 10:24:16', 1);
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('f00002', '11楼防火墙服务器f01B', '防火墙', 1, '2021-06-23 10:24:16', 1);
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('j00001', '1楼总交换机j102A', '交换机', 1, '2021-06-23 10:05:10', 1);
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('j00002', '1楼分交换机j104B', '交换机', 1, '2021-06-23 10:05:44', 1);
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('j00003', '1楼分交换机j106C', '交换机', 1, '2021-06-23 10:06:12', 1);
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('j00004', '1楼分交换机j109D', '交换机', 1, '2021-06-23 10:07:21', 1);
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('j00005', '2楼总交换机j202A', '交换机', 1, '2021-06-23 10:15:38', 1);
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('j00006', '2楼分交换机j204B', '交换机', 1, '2021-06-23 10:15:38', 1);
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('j00007', '2楼分交换机j206C', '交换机', 1, '2021-06-23 10:15:38', 1);
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('j00008', '2楼分交换机j209D', '交换机', 1, '2021-06-23 10:15:38', 1);
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('j00009', '3楼总交换机j302A', '交换机', 1, '2021-06-23 10:15:38', 1);
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('j00010', '3楼分交换机j304B', '交换机', 1, '2021-06-23 10:15:38', 1);
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('j00011', '4楼总交换机j402A', '交换机', 1, '2021-06-23 10:15:38', 1);
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('j00012', '4楼分交换机j409B', '交换机', 1, '2021-06-23 10:15:38', 1);
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('s00001', '1楼服务器s101A', '服务器', 1, '2021-06-23 09:55:35', 1);
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('s00002', '2楼服务器s201A', '服务器', 1, '2021-06-23 09:59:39', 1);
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('s00003', '3楼服务器s301A', '服务器', 1, '2021-06-23 10:00:02', 1);
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('s00004', '4楼服务器s401A', '服务器', 1, '2021-06-23 10:00:23', 1);
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('s00005', '4楼服务器s401B', '服务器', 1, '2021-06-23 10:01:10', 1);
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('s00006', '11楼服务器1101A', '服务器', 1, '2021-06-23 10:09:26', 1);
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('s00007', '11楼服务器1101B', '服务器', 1, '2021-06-23 10:09:26', 1);
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('s00008', '11楼服务器1101C', '服务器', 1, '2021-06-23 10:09:26', 1);
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('s00009', '11楼服务器1101D', '服务器', 1, '2021-06-23 10:09:26', 1);
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('s00010', '11楼服务器1101E', '服务器', 1, '2021-06-23 10:09:26', 1);
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('w00001', '1楼路由器', '路由器', 1, '2021-06-23 10:21:14', 1);
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('w00002', '2楼路由器', '路由器', 1, '2021-06-23 10:21:14', 1);
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('w00003', '3楼路由器', '路由器', 1, '2021-06-23 10:21:14', 1);
INSERT INTO `aj_report_init`.`aj_report_devices` VALUES ('w00004', '4楼路由器', '路由器', 1, '2021-06-23 10:21:14', 1);

-- ----------------------------
-- Table structure for aj_report_exper
-- ----------------------------
DROP TABLE IF EXISTS `aj_report_init`.`aj_report_exper`;
CREATE TABLE `aj_report_init`.`aj_report_exper`  (
  `datetime` date NOT NULL,
  `rt` double(11, 2) NULL DEFAULT NULL,
  `qps` bigint(11) NULL DEFAULT NULL,
  `error` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`datetime`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of aj_report_exper
-- ----------------------------
INSERT INTO `aj_report_init`.`aj_report_exper` VALUES ('2021-06-18', 90.92, 9000, 2);
INSERT INTO `aj_report_init`.`aj_report_exper` VALUES ('2021-06-19', 100.02, 10000, 3);
INSERT INTO `aj_report_init`.`aj_report_exper` VALUES ('2021-06-20', 98.89, 9560, 1);
INSERT INTO `aj_report_init`.`aj_report_exper` VALUES ('2021-06-21', 110.99, 13456, 9);
INSERT INTO `aj_report_init`.`aj_report_exper` VALUES ('2021-06-22', 89.78, 8990, 3);

-- ----------------------------
-- Table structure for aj_report_fireacl
-- ----------------------------
DROP TABLE IF EXISTS `aj_report_init`.`aj_report_fireacl`;
CREATE TABLE `aj_report_init`.`aj_report_fireacl`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `acl_type` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'acl类型',
  `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 203 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of aj_report_fireacl
-- ----------------------------
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (1, '网页浏览443', '2021-06-23 10:50:41');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (2, '网页浏览443', '2021-06-23 10:51:11');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (3, '网页浏览443', '2021-06-23 10:51:47');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (4, '网页浏览443', '2021-06-23 10:51:49');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (5, '网页浏览443', '2021-06-23 10:51:52');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (6, '网页浏览443', '2021-06-23 10:51:55');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (7, '网页浏览443', '2021-06-23 10:51:57');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (8, '网页浏览443', '2021-06-23 10:52:28');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (9, '网页浏览443', '2021-06-23 10:52:31');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (10, '网页浏览443', '2021-06-23 10:52:33');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (11, '网页浏览443', '2021-06-23 10:52:36');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (12, '网页浏览443', '2021-06-23 10:52:38');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (13, '网页浏览443', '2021-06-23 10:52:39');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (14, '网页浏览443', '2021-06-23 10:52:42');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (15, '网页浏览443', '2021-06-23 10:52:44');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (16, '网页浏览443', '2021-06-23 10:52:46');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (17, '网页浏览443', '2021-06-23 10:52:48');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (18, '网页浏览443', '2021-06-23 10:54:33');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (19, '网页浏览443', '2021-06-23 10:54:41');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (20, '网页浏览443', '2021-06-23 10:54:45');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (21, '网页浏览443', '2021-06-23 10:54:46');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (22, '网页浏览443', '2021-06-23 10:54:46');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (23, '网页浏览443', '2021-06-23 10:54:47');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (24, '网页浏览443', '2021-06-23 10:54:48');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (25, '网页浏览443', '2021-06-23 10:54:51');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (26, '网页浏览443', '2021-06-23 10:54:54');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (27, '共享文件445', '2021-06-23 10:57:14');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (28, 'LDAP389', '2021-06-23 10:57:14');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (29, '共享文件445', '2021-06-23 10:57:20');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (30, 'LDAP389', '2021-06-23 10:57:20');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (31, 'LDAP389', '2021-06-23 10:57:24');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (32, '网页浏览443', '2021-06-23 10:57:27');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (33, '共享文件445', '2021-06-23 10:57:27');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (34, 'LDAP389', '2021-06-23 10:57:27');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (35, 'LDAP389', '2021-06-23 10:57:30');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (36, '网页浏览443', '2021-06-23 10:57:53');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (37, '共享文件445', '2021-06-23 10:57:53');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (38, 'LDAP389', '2021-06-23 10:57:53');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (39, 'Server1433', '2021-06-23 10:57:53');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (40, '存储514', '2021-06-23 10:57:53');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (41, '网页浏览443', '2021-06-23 10:57:56');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (42, '共享文件445', '2021-06-23 10:57:56');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (43, 'LDAP389', '2021-06-23 10:57:56');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (44, 'Server1433', '2021-06-23 10:57:56');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (45, '存储514', '2021-06-23 10:57:56');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (46, '远程桌面3389', '2021-06-23 10:57:56');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (47, '远程登陆23', '2021-06-23 10:57:56');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (48, 'LDAP389', '2021-06-23 10:58:29');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (49, 'Server1433', '2021-06-23 10:58:29');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (50, '存储514', '2021-06-23 10:58:29');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (51, '远程桌面3389', '2021-06-23 10:58:32');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (52, '远程登陆23', '2021-06-23 10:58:32');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (53, 'LDAP389', '2021-06-23 10:58:51');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (54, 'Server1433', '2021-06-23 10:58:51');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (55, '存储514', '2021-06-23 10:58:51');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (56, '远程桌面3389', '2021-06-23 10:58:51');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (57, '网页浏览443', '2021-06-23 10:58:54');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (58, '共享文件445', '2021-06-23 10:58:54');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (59, 'LDAP389', '2021-06-23 10:58:54');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (60, 'Server1433', '2021-06-23 10:58:54');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (61, '存储514', '2021-06-23 10:58:57');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (62, '远程桌面3389', '2021-06-23 10:58:57');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (63, '远程登陆23', '2021-06-23 10:58:57');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (64, 'LDAP389', '2021-06-23 10:59:01');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (65, 'Server1433', '2021-06-23 10:59:01');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (66, '存储514', '2021-06-23 10:59:01');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (67, '网页浏览443', '2021-06-23 10:59:05');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (68, '共享文件445', '2021-06-23 10:59:05');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (69, 'LDAP389', '2021-06-23 10:59:05');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (70, 'Server1433', '2021-06-23 10:59:05');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (71, '存储514', '2021-06-23 10:59:05');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (72, '远程桌面3389', '2021-06-23 10:59:05');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (73, '远程桌面3389', '2021-06-23 10:59:08');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (74, '远程登陆23', '2021-06-23 10:59:08');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (75, '远程桌面3389', '2021-06-23 10:59:08');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (76, '远程登陆23', '2021-06-23 10:59:08');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (77, '远程桌面3389', '2021-06-23 10:59:09');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (78, '远程登陆23', '2021-06-23 10:59:09');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (79, '远程桌面3389', '2021-06-23 10:59:09');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (80, '远程登陆23', '2021-06-23 10:59:09');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (81, '远程桌面3389', '2021-06-23 10:59:09');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (82, '远程登陆23', '2021-06-23 10:59:09');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (83, '远程桌面3389', '2021-06-23 10:59:09');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (84, '远程登陆23', '2021-06-23 10:59:09');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (85, '远程桌面3389', '2021-06-23 10:59:10');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (86, '远程登陆23', '2021-06-23 10:59:10');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (87, '远程桌面3389', '2021-06-23 10:59:10');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (88, '远程登陆23', '2021-06-23 10:59:10');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (89, '远程桌面3389', '2021-06-23 10:59:10');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (90, '远程登陆23', '2021-06-23 10:59:10');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (91, '远程桌面3389', '2021-06-23 10:59:10');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (92, '远程登陆23', '2021-06-23 10:59:10');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (93, '远程桌面3389', '2021-06-23 10:59:11');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (94, '远程登陆23', '2021-06-23 10:59:11');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (95, '远程桌面3389', '2021-06-23 10:59:11');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (96, '远程登陆23', '2021-06-23 10:59:11');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (97, '远程桌面3389', '2021-06-23 10:59:11');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (98, '远程登陆23', '2021-06-23 10:59:11');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (99, '远程桌面3389', '2021-06-23 10:59:11');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (100, '远程登陆23', '2021-06-23 10:59:11');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (101, '远程桌面3389', '2021-06-23 10:59:12');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (102, '远程登陆23', '2021-06-23 10:59:12');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (103, '远程桌面3389', '2021-06-23 10:59:12');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (104, '远程登陆23', '2021-06-23 10:59:12');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (105, '远程桌面3389', '2021-06-23 10:59:12');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (106, '远程登陆23', '2021-06-23 10:59:12');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (107, '远程桌面3389', '2021-06-23 10:59:12');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (108, '远程登陆23', '2021-06-23 10:59:12');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (109, '远程桌面3389', '2021-06-23 10:59:12');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (110, '远程登陆23', '2021-06-23 10:59:12');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (111, '远程桌面3389', '2021-06-23 10:59:12');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (112, '远程登陆23', '2021-06-23 10:59:12');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (113, '远程桌面3389', '2021-06-23 10:59:13');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (114, '远程登陆23', '2021-06-23 10:59:13');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (115, '远程桌面3389', '2021-06-23 10:59:13');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (116, '远程登陆23', '2021-06-23 10:59:13');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (117, '远程桌面3389', '2021-06-23 10:59:13');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (118, '远程登陆23', '2021-06-23 10:59:13');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (119, '远程桌面3389', '2021-06-23 10:59:14');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (120, '远程登陆23', '2021-06-23 10:59:14');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (121, '远程桌面3389', '2021-06-23 10:59:14');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (122, '远程登陆23', '2021-06-23 10:59:14');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (123, '远程桌面3389', '2021-06-23 10:59:14');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (124, '远程登陆23', '2021-06-23 10:59:14');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (125, '远程桌面3389', '2021-06-23 10:59:14');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (126, '远程登陆23', '2021-06-23 10:59:14');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (127, '远程桌面3389', '2021-06-23 10:59:15');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (128, '远程登陆23', '2021-06-23 10:59:15');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (129, '远程桌面3389', '2021-06-23 10:59:15');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (130, '远程登陆23', '2021-06-23 10:59:15');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (131, '远程桌面3389', '2021-06-23 10:59:15');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (132, '远程登陆23', '2021-06-23 10:59:15');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (133, '远程桌面3389', '2021-06-23 10:59:16');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (134, '远程登陆23', '2021-06-23 10:59:16');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (135, '远程桌面3389', '2021-06-23 10:59:16');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (136, '远程登陆23', '2021-06-23 10:59:16');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (137, '远程桌面3389', '2021-06-23 10:59:17');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (138, '远程登陆23', '2021-06-23 10:59:17');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (139, '远程桌面3389', '2021-06-23 10:59:17');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (140, '远程登陆23', '2021-06-23 10:59:17');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (141, '远程桌面3389', '2021-06-23 10:59:17');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (142, '远程登陆23', '2021-06-23 10:59:17');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (143, '远程桌面3389', '2021-06-23 10:59:18');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (144, '远程登陆23', '2021-06-23 10:59:18');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (145, '远程桌面3389', '2021-06-23 10:59:18');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (146, '远程登陆23', '2021-06-23 10:59:18');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (147, '远程桌面3389', '2021-06-23 10:59:18');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (148, '远程登陆23', '2021-06-23 10:59:18');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (149, '远程桌面3389', '2021-06-23 10:59:18');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (150, '远程登陆23', '2021-06-23 10:59:18');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (151, '远程桌面3389', '2021-06-23 10:59:19');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (152, '远程登陆23', '2021-06-23 10:59:19');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (153, '远程桌面3389', '2021-06-23 10:59:19');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (154, '远程登陆23', '2021-06-23 10:59:19');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (155, '远程桌面3389', '2021-06-23 10:59:19');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (156, '远程登陆23', '2021-06-23 10:59:19');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (157, '远程桌面3389', '2021-06-23 10:59:19');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (158, '远程登陆23', '2021-06-23 10:59:19');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (159, '远程桌面3389', '2021-06-23 10:59:19');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (160, '远程登陆23', '2021-06-23 10:59:19');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (161, '存储514', '2021-06-23 10:59:22');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (162, '远程桌面3389', '2021-06-23 10:59:22');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (163, '远程登陆23', '2021-06-23 10:59:22');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (164, 'Server1433', '2021-06-23 10:59:24');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (165, '存储514', '2021-06-23 10:59:24');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (166, '远程桌面3389', '2021-06-23 10:59:24');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (167, '远程登陆23', '2021-06-23 10:59:28');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (168, '远程登陆23', '2021-06-23 10:59:29');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (169, '远程登陆23', '2021-06-23 10:59:29');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (170, '远程登陆23', '2021-06-23 10:59:29');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (171, '远程登陆23', '2021-06-23 10:59:29');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (172, '远程登陆23', '2021-06-23 10:59:29');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (173, '远程登陆23', '2021-06-23 10:59:30');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (174, '远程登陆23', '2021-06-23 10:59:30');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (175, '存储514', '2021-06-23 10:59:33');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (176, '远程桌面3389', '2021-06-23 10:59:33');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (177, 'LDAP389', '2021-06-23 10:59:36');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (178, 'Server1433', '2021-06-23 10:59:36');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (179, '存储514', '2021-06-23 10:59:39');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (180, '远程桌面3389', '2021-06-23 10:59:39');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (181, '远程登陆23', '2021-06-23 10:59:39');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (182, '存储514', '2021-06-23 10:59:40');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (183, '远程桌面3389', '2021-06-23 10:59:40');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (184, '远程登陆23', '2021-06-23 10:59:40');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (185, '存储514', '2021-06-23 10:59:40');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (186, '远程桌面3389', '2021-06-23 10:59:40');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (187, '远程登陆23', '2021-06-23 10:59:40');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (188, '存储514', '2021-06-23 10:59:40');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (189, '远程桌面3389', '2021-06-23 10:59:40');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (190, '远程登陆23', '2021-06-23 10:59:40');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (191, '远程桌面3389', '2021-06-23 10:59:43');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (192, '远程登陆23', '2021-06-23 10:59:43');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (193, '远程桌面3389', '2021-06-23 10:59:43');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (194, '远程登陆23', '2021-06-23 10:59:43');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (195, '远程桌面3389', '2021-06-23 10:59:44');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (196, '远程登陆23', '2021-06-23 10:59:44');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (197, '远程桌面3389', '2021-06-23 10:59:44');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (198, '远程登陆23', '2021-06-23 10:59:44');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (199, '远程桌面3389', '2021-06-23 10:59:44');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (200, '远程登陆23', '2021-06-23 10:59:44');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (201, '远程桌面3389', '2021-06-23 10:59:44');
INSERT INTO `aj_report_init`.`aj_report_fireacl` VALUES (202, '远程登陆23', '2021-06-23 10:59:44');

-- ----------------------------
-- Table structure for aj_report_fireattack
-- ----------------------------
DROP TABLE IF EXISTS `aj_report_init`.`aj_report_fireattack`;
CREATE TABLE `aj_report_init`.`aj_report_fireattack`  (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '事件编号',
  `attack_type` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '攻击类型',
  `create_time` datetime NULL DEFAULT NULL COMMENT '事件创建时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 101 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of aj_report_fireattack
-- ----------------------------
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (1, '僵尸网络', '2021-06-23 13:15:37');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (2, '僵尸网络', '2021-06-23 13:34:14');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (3, '超大ICMP', '2021-06-23 13:34:14');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (4, '端口扫描', '2021-06-23 13:34:14');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (5, '网站扫描', '2021-06-23 13:34:14');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (6, 'UDP', '2021-06-23 13:34:14');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (7, 'WEB', '2021-06-23 13:34:14');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (8, 'SQL注入', '2021-06-23 13:34:14');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (9, '弱口令', '2021-06-23 13:34:14');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (10, '僵尸网络', '2021-06-23 13:39:27');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (11, '超大ICMP', '2021-06-23 13:39:27');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (12, 'UDP', '2021-06-23 13:39:33');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (13, 'WEB', '2021-06-23 13:39:33');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (14, 'SQL注入', '2021-06-23 13:39:33');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (15, '弱口令', '2021-06-23 13:39:33');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (16, '僵尸网络', '2021-06-23 13:39:38');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (17, '超大ICMP', '2021-06-23 13:39:38');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (18, '端口扫描', '2021-06-23 13:39:38');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (19, '网站扫描', '2021-06-23 13:39:38');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (20, 'UDP', '2021-06-23 13:39:38');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (21, 'WEB', '2021-06-23 13:39:38');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (22, 'SQL注入', '2021-06-23 13:39:38');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (23, '僵尸网络', '2021-06-23 13:39:41');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (24, '超大ICMP', '2021-06-23 13:39:41');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (25, '端口扫描', '2021-06-23 13:39:41');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (26, '僵尸网络', '2021-06-23 13:39:42');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (27, '超大ICMP', '2021-06-23 13:39:42');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (28, '端口扫描', '2021-06-23 13:39:42');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (29, '僵尸网络', '2021-06-23 13:39:42');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (30, '超大ICMP', '2021-06-23 13:39:42');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (31, '端口扫描', '2021-06-23 13:39:42');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (32, '僵尸网络', '2021-06-23 13:39:43');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (33, '超大ICMP', '2021-06-23 13:39:43');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (34, '端口扫描', '2021-06-23 13:39:43');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (35, '僵尸网络', '2021-06-23 13:39:43');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (36, '超大ICMP', '2021-06-23 13:39:43');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (37, '端口扫描', '2021-06-23 13:39:43');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (38, '弱口令', '2021-06-23 13:39:46');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (39, 'WEB', '2021-06-23 13:39:49');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (40, 'SQL注入', '2021-06-23 13:39:49');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (41, '端口扫描', '2021-06-23 13:39:55');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (42, '网站扫描', '2021-06-23 13:39:55');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (43, 'UDP', '2021-06-23 13:39:55');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (44, '超大ICMP', '2021-06-23 13:39:58');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (45, '端口扫描', '2021-06-23 13:39:58');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (46, '僵尸网络', '2021-06-23 13:40:00');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (47, '僵尸网络', '2021-06-23 13:40:01');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (48, '僵尸网络', '2021-06-23 13:40:01');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (49, '僵尸网络', '2021-06-23 13:40:01');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (50, '弱口令', '2021-06-23 13:40:05');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (51, 'SQL注入', '2021-06-23 13:40:07');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (52, '网站扫描', '2021-06-23 13:40:13');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (53, '端口扫描', '2021-06-23 13:40:17');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (54, '僵尸网络', '2021-06-23 13:40:19');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (55, '僵尸网络', '2021-06-23 13:40:24');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (56, '超大ICMP', '2021-06-23 13:40:24');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (57, '端口扫描', '2021-06-23 13:40:24');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (58, '网站扫描', '2021-06-23 13:40:24');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (59, 'UDP', '2021-06-23 13:40:24');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (60, 'WEB', '2021-06-23 13:40:24');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (61, 'SQL注入', '2021-06-23 13:40:24');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (62, '弱口令', '2021-06-23 13:40:24');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (63, '僵尸网络', '2021-06-23 13:40:25');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (64, '超大ICMP', '2021-06-23 13:40:25');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (65, '端口扫描', '2021-06-23 13:40:25');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (66, '网站扫描', '2021-06-23 13:40:25');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (67, 'UDP', '2021-06-23 13:40:25');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (68, 'WEB', '2021-06-23 13:40:25');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (69, 'SQL注入', '2021-06-23 13:40:25');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (70, '弱口令', '2021-06-23 13:40:25');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (71, '网站扫描', '2021-06-23 13:40:29');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (72, 'UDP', '2021-06-23 13:40:29');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (73, 'WEB', '2021-06-23 13:40:29');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (74, 'SQL注入', '2021-06-23 13:40:29');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (75, '僵尸网络', '2021-06-23 13:40:32');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (76, '超大ICMP', '2021-06-23 13:40:32');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (77, '端口扫描', '2021-06-23 13:40:32');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (78, '僵尸网络', '2021-06-23 13:40:32');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (79, '超大ICMP', '2021-06-23 13:40:32');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (80, '端口扫描', '2021-06-23 13:40:32');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (81, '僵尸网络', '2021-06-23 13:40:32');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (82, '超大ICMP', '2021-06-23 13:40:32');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (83, '端口扫描', '2021-06-23 13:40:32');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (84, '僵尸网络', '2021-06-23 13:40:33');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (85, '超大ICMP', '2021-06-23 13:40:33');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (86, '端口扫描', '2021-06-23 13:40:33');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (87, '僵尸网络', '2021-06-23 13:40:36');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (88, '超大ICMP', '2021-06-23 13:40:36');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (89, '僵尸网络', '2021-06-23 13:40:36');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (90, '超大ICMP', '2021-06-23 13:40:36');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (91, '僵尸网络', '2021-06-23 13:40:36');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (92, '超大ICMP', '2021-06-23 13:40:36');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (93, '僵尸网络', '2021-06-23 13:40:37');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (94, '超大ICMP', '2021-06-23 13:40:37');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (95, '网站扫描', '2021-06-23 13:42:06');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (96, 'UDP', '2021-06-23 13:42:26');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (97, 'SQL注入', '2021-06-23 13:42:42');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (98, 'UDP', '2021-06-23 13:42:47');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (99, 'UDP', '2021-06-23 13:42:47');
INSERT INTO `aj_report_init`.`aj_report_fireattack` VALUES (100, 'UDP', '2021-06-23 13:42:48');

-- ----------------------------
-- Table structure for aj_report_mail
-- ----------------------------
DROP TABLE IF EXISTS `aj_report_init`.`aj_report_mail`;
CREATE TABLE `aj_report_init`.`aj_report_mail`  (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '事件id',
  `username` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '登陆用户',
  `status` int(11) NULL DEFAULT NULL COMMENT '1成功，0失败',
  `create_time` datetime NULL DEFAULT NULL COMMENT '事件时间',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 245 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of aj_report_mail
-- ----------------------------
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (1, 'zhangsi', 0, '2021-06-21 14:14:22');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (2, 'zhangsi', 0, '2021-06-21 14:18:01');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (3, 'zhangsi', 0, '2021-06-21 14:18:01');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (4, 'zhangsi', 0, '2021-06-22 14:18:02');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (5, 'zhangsi', 0, '2021-06-22 14:18:02');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (6, 'zhangsi', 0, '2021-06-22 14:18:02');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (7, 'zhangsi', 0, '2021-06-23 14:18:02');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (8, 'zhangsi', 0, '2021-06-23 14:18:03');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (9, 'zhangsi', 0, '2021-06-23 14:18:03');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (10, 'zhangsi', 0, '2021-06-23 14:18:03');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (11, 'zhangsi', 0, '2021-06-23 14:18:03');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (12, 'zhangsi', 0, '2021-06-23 14:18:04');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (13, 'zhangsi', 0, '2021-06-23 14:18:04');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (14, 'zhangsi', 0, '2021-06-23 14:18:09');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (15, 'zhangsi', 0, '2021-06-23 14:18:10');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (16, 'zhangsi', 0, '2021-06-23 14:18:10');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (17, 'zhangsi', 0, '2021-06-23 14:18:10');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (18, 'zhangsi', 0, '2021-06-23 14:18:10');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (19, 'zhangsi', 0, '2021-06-23 14:18:10');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (20, 'wangwu', 0, '2021-06-21 14:18:23');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (21, 'wangwu', 0, '2021-06-21 14:18:24');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (22, 'wangwu', 0, '2021-06-21 14:18:24');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (23, 'wangwu', 0, '2021-06-21 14:18:24');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (24, 'wangwu', 0, '2021-06-21 14:18:24');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (25, 'wangwu', 0, '2021-06-23 14:18:24');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (26, 'wangwu', 0, '2021-06-23 14:18:24');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (27, 'wangwu', 0, '2021-06-23 14:18:25');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (28, 'wangwu', 0, '2021-06-23 14:18:25');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (29, 'zhangsi', 0, '2021-06-23 14:18:31');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (30, 'wangwu', 0, '2021-06-23 14:18:31');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (31, 'zhangsi', 0, '2021-06-23 14:18:31');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (32, 'wangwu', 0, '2021-06-23 14:18:31');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (33, 'zhangsi', 0, '2021-06-23 14:18:31');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (34, 'wangwu', 0, '2021-06-23 14:18:31');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (35, 'zhangsi', 0, '2021-06-23 14:18:31');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (36, 'wangwu', 0, '2021-06-23 14:18:31');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (37, 'zhangsi', 0, '2021-06-23 14:18:32');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (38, 'wangwu', 0, '2021-06-23 14:18:32');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (39, 'zhangsi', 0, '2021-06-23 14:18:41');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (40, 'wangwu', 0, '2021-06-23 14:18:41');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (41, 'liliu', 0, '2021-06-23 14:18:41');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (42, 'zhangsi', 0, '2021-06-23 14:18:41');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (43, 'wangwu', 0, '2021-06-23 14:18:41');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (44, 'liliu', 0, '2021-06-23 14:18:41');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (45, 'liliu', 0, '2021-06-23 14:18:43');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (46, 'liliu', 0, '2021-06-21 14:18:43');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (47, 'liliu', 0, '2021-06-21 14:18:44');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (48, 'liliu', 0, '2021-06-23 14:18:44');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (49, 'IT1', 0, '2021-06-23 14:18:53');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (50, 'IT1', 0, '2021-06-23 14:18:53');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (51, 'IT1', 0, '2021-06-23 14:18:54');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (52, 'IT1', 0, '2021-06-21 14:18:54');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (53, 'zhangsi', 0, '2021-06-21 14:18:58');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (54, 'wangwu', 0, '2021-06-23 14:18:58');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (55, 'liliu', 0, '2021-06-23 14:18:58');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (56, 'IT1', 0, '2021-06-23 14:18:58');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (57, 'IT2', 0, '2021-06-23 14:19:07');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (58, 'IT1', 0, '2021-06-23 14:19:12');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (59, 'IT2', 0, '2021-06-23 14:19:12');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (60, 'IT1', 0, '2021-06-23 14:19:12');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (61, 'IT2', 0, '2021-06-22 14:19:12');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (62, 'IT1', 0, '2021-06-22 14:19:12');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (63, 'IT2', 0, '2021-06-22 14:19:12');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (64, 'IT2', 0, '2021-06-23 14:19:26');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (65, 'jiayi', 0, '2021-06-23 14:19:26');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (66, 'IT2', 0, '2021-06-23 14:19:27');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (67, 'jiayi', 0, '2021-06-23 14:19:27');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (68, 'IT2', 0, '2021-06-23 14:19:27');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (69, 'jiayi', 0, '2021-06-23 14:19:27');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (70, 'IT1', 0, '2021-06-23 14:19:30');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (71, 'IT2', 0, '2021-06-23 14:19:30');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (72, 'IT1', 0, '2021-06-23 14:19:30');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (73, 'IT2', 0, '2021-06-22 14:19:30');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (74, 'zhangsi', 0, '2021-06-22 14:19:33');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (75, 'wangwu', 0, '2021-06-22 14:19:33');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (76, 'liliu', 0, '2021-06-23 14:19:33');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (77, 'IT1', 0, '2021-06-23 14:19:33');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (78, 'IT2', 0, '2021-06-22 14:19:33');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (79, 'jiayi', 0, '2021-06-23 14:19:33');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (80, 'zhangsi', 0, '2021-06-23 14:19:33');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (81, 'wangwu', 0, '2021-06-23 14:19:33');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (82, 'liliu', 0, '2021-06-23 14:19:33');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (83, 'IT1', 0, '2021-06-23 14:19:33');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (84, 'IT2', 0, '2021-06-23 14:19:33');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (85, 'jiayi', 0, '2021-06-23 14:19:33');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (86, 'zhangsi', 0, '2021-06-23 14:19:33');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (87, 'wangwu', 0, '2021-06-23 14:19:33');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (88, 'liliu', 0, '2021-06-23 14:19:33');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (89, 'IT1', 0, '2021-06-23 14:19:33');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (90, 'IT2', 0, '2021-06-23 14:19:33');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (91, 'jiayi', 0, '2021-06-23 14:19:33');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (92, 'zhangsi', 0, '2021-06-21 14:19:34');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (93, 'wangwu', 0, '2021-06-21 14:19:34');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (94, 'liliu', 0, '2021-06-21 14:19:34');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (95, 'IT1', 0, '2021-06-23 14:19:34');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (96, 'IT2', 0, '2021-06-23 14:19:34');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (97, 'jiayi', 0, '2021-06-21 14:19:34');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (98, 'zhangsi', 0, '2021-06-23 14:19:34');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (99, 'wangwu', 0, '2021-06-23 14:19:34');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (100, 'liliu', 0, '2021-06-23 14:19:34');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (101, 'IT1', 0, '2021-06-23 14:19:34');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (102, 'IT2', 0, '2021-06-23 14:19:34');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (103, 'jiayi', 0, '2021-06-23 14:19:34');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (104, 'zhangsi', 0, '2021-06-23 14:19:34');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (105, 'wangwu', 0, '2021-06-23 14:19:34');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (106, 'liliu', 0, '2021-06-23 14:19:34');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (107, 'IT1', 0, '2021-06-23 14:19:34');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (108, 'IT2', 0, '2021-06-23 14:19:34');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (109, 'jiayi', 0, '2021-06-23 14:19:34');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (110, 'zhangsi', 0, '2021-06-24 09:39:28');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (111, 'wangwu', 0, '2021-06-24 09:39:28');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (112, 'liliu', 0, '2021-06-24 09:39:28');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (113, 'IT1', 0, '2021-06-24 09:39:28');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (114, 'IT2', 0, '2021-06-24 09:39:28');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (115, 'jiayi', 0, '2021-06-24 09:39:28');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (116, 'zhangsi', 0, '2021-06-24 09:39:35');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (117, 'wangwu', 0, '2021-06-24 09:39:35');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (118, 'liliu', 0, '2021-06-24 09:39:35');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (119, 'IT1', 0, '2021-06-24 09:39:35');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (120, 'IT2', 0, '2021-06-24 09:39:35');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (121, 'jiayi', 0, '2021-06-24 09:39:35');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (122, 'zhangsi', 0, '2021-06-24 09:39:36');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (123, 'wangwu', 0, '2021-06-24 09:39:36');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (124, 'liliu', 0, '2021-06-24 09:39:36');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (125, 'IT1', 0, '2021-06-24 09:39:36');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (126, 'IT2', 0, '2021-06-24 09:39:36');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (127, 'jiayi', 0, '2021-06-24 09:39:36');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (128, 'liliu', 0, '2021-06-24 09:39:39');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (129, 'IT1', 0, '2021-06-24 09:39:39');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (130, 'IT2', 0, '2021-06-24 09:39:39');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (131, 'zhangsi', 0, '2021-06-24 09:39:42');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (132, 'wangwu', 0, '2021-06-24 09:39:42');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (133, 'liliu', 0, '2021-06-24 09:39:42');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (134, 'IT1', 0, '2021-06-24 09:39:44');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (135, 'IT1', 0, '2021-06-24 09:39:44');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (136, 'IT1', 0, '2021-06-24 09:39:45');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (137, 'zhangsi', 0, '2021-06-24 09:39:47');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (138, 'zhangsi', 0, '2021-06-24 09:39:47');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (139, 'wangwu', 0, '2021-06-24 09:39:50');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (140, 'liliu', 0, '2021-06-24 09:39:50');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (141, 'wangwu', 0, '2021-06-24 09:39:50');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (142, 'liliu', 0, '2021-06-23 09:39:50');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (143, 'zhangsi', 0, '2021-06-23 09:39:53');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (144, 'wangwu', 0, '2021-06-24 09:39:53');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (145, 'liliu', 0, '2021-06-24 09:39:53');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (146, 'IT1', 0, '2021-06-24 09:39:53');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (147, 'IT2', 0, '2021-06-24 09:39:53');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (148, 'zhangsi', 0, '2021-06-24 09:39:54');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (149, 'wangwu', 0, '2021-06-23 09:39:54');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (150, 'liliu', 0, '2021-06-24 09:39:54');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (151, 'IT1', 0, '2021-06-24 09:39:54');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (152, 'IT2', 0, '2021-06-24 09:39:54');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (153, 'zhangsi', 0, '2021-06-24 09:39:56');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (154, 'wangwu', 0, '2021-06-24 09:39:56');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (155, 'zhangsi', 0, '2021-06-24 09:39:57');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (156, 'wangwu', 0, '2021-06-24 09:39:57');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (157, 'zhangsi', 0, '2021-06-24 09:39:57');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (158, 'wangwu', 0, '2021-06-24 09:39:57');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (159, 'zhangsi', 0, '2021-06-24 09:40:00');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (160, 'wangwu', 0, '2021-06-24 09:40:01');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (161, 'liliu', 0, '2021-06-24 09:40:01');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (162, 'zhangsi', 0, '2021-06-23 09:40:01');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (163, 'wangwu', 0, '2021-06-23 09:40:01');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (164, 'liliu', 0, '2021-06-24 09:40:01');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (165, 'liliu', 0, '2021-06-23 09:40:05');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (166, 'IT1', 0, '2021-06-24 09:40:05');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (167, 'IT2', 0, '2021-06-24 09:40:07');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (168, 'jiayi', 0, '2021-06-24 09:40:07');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (169, 'wangwu', 0, '2021-06-24 09:40:11');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (170, 'liliu', 0, '2021-06-24 09:40:11');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (171, 'zhangsi', 0, '2021-06-24 09:40:14');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (172, 'zhangsi', 0, '2021-06-24 09:40:14');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (173, 'zhangsi', 0, '2021-06-24 09:40:15');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (174, 'IT1', 0, '2021-06-24 09:40:18');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (175, 'liliu', 0, '2021-06-24 09:40:20');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (176, 'jiayi', 0, '2021-06-24 09:40:22');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (177, 'zhangsi', 0, '2021-06-25 09:55:00');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (178, 'wangwu', 0, '2021-06-25 09:55:00');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (179, 'liliu', 0, '2021-06-25 09:55:00');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (180, 'IT1', 0, '2021-06-25 09:55:00');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (181, 'IT2', 0, '2021-06-25 09:55:00');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (182, 'jiayi', 0, '2021-06-25 09:55:00');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (183, 'wangwu', 0, '2021-06-25 09:55:05');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (184, 'liliu', 0, '2021-06-25 09:55:05');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (185, 'zhangsi', 0, '2021-06-25 09:55:09');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (186, 'IT2', 0, '2021-06-25 09:55:12');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (187, 'liliu', 0, '2021-06-25 09:55:15');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (188, 'IT1', 0, '2021-06-25 09:55:15');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (189, 'IT2', 0, '2021-06-25 09:55:15');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (190, 'wangwu', 0, '2021-06-22 09:55:17');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (191, 'liliu', 0, '2021-06-25 09:55:17');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (192, 'jiayi', 0, '2021-06-25 09:55:20');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (193, 'liliu', 0, '2021-06-25 09:55:22');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (194, 'wangwu', 0, '2021-06-22 09:55:25');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (195, 'zhangsi', 0, '2021-06-22 09:55:27');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (196, 'IT1', 0, '2021-06-25 09:55:30');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (197, 'IT2', 0, '2021-06-21 09:55:33');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (198, 'zhangsi', 0, '2021-06-21 09:55:38');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (199, 'wangwu', 0, '2021-06-21 09:55:38');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (200, 'zhangsi', 0, '2021-06-25 09:55:38');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (201, 'wangwu', 0, '2021-06-25 09:55:38');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (202, 'zhangsi', 0, '2021-06-25 09:55:39');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (203, 'wangwu', 0, '2021-06-25 09:55:39');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (204, 'zhangsi', 0, '2021-06-25 09:55:39');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (205, 'wangwu', 0, '2021-06-25 09:55:39');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (206, 'zhangsi', 0, '2021-06-25 09:55:42');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (207, 'wangwu', 0, '2021-06-25 09:55:42');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (208, 'liliu', 0, '2021-06-25 09:55:42');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (209, 'IT1', 0, '2021-06-25 09:55:42');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (210, 'IT2', 0, '2021-06-25 09:55:42');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (211, 'zhangsi', 0, '2021-06-25 09:55:45');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (212, 'wangwu', 0, '2021-06-25 09:55:45');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (213, 'liliu', 0, '2021-06-25 09:55:45');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (214, 'IT1', 0, '2021-06-25 09:55:45');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (215, 'IT2', 0, '2021-06-25 09:55:45');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (216, 'jiayi', 0, '2021-06-25 09:55:45');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (217, 'IT1', 0, '2021-06-25 09:55:48');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (218, 'IT2', 0, '2021-06-21 09:55:48');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (219, 'zhangsi', 0, '2021-06-25 10:00:00');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (220, 'wangwu', 0, '2021-06-25 10:00:00');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (221, 'liliu', 0, '2021-06-25 10:00:00');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (222, 'IT1', 0, '2021-06-25 10:00:00');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (223, 'IT2', 0, '2021-06-22 10:00:00');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (224, 'jiayi', 0, '2021-06-25 10:00:00');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (225, 'jiayi', 0, '2021-06-25 10:00:03');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (226, 'jiayi', 0, '2021-06-25 10:00:03');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (227, 'jiayi', 0, '2021-06-21 10:00:04');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (228, 'IT1', 0, '2021-06-22 10:00:06');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (229, 'zhangsi', 0, '2021-06-22 10:00:14');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (230, 'wangwu', 0, '2021-06-25 10:00:14');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (231, 'liliu', 0, '2021-06-25 10:00:14');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (232, 'IT1', 0, '2021-06-21 10:00:14');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (233, 'zhangsi', 0, '2021-06-25 10:00:14');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (234, 'wangwu', 0, '2021-06-25 10:00:14');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (235, 'liliu', 0, '2021-06-25 10:00:14');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (236, 'IT1', 0, '2021-06-21 10:00:14');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (237, 'zhangsi', 0, '2021-06-25 10:00:14');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (238, 'wangwu', 0, '2021-06-25 10:00:14');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (239, 'liliu', 0, '2021-06-21 10:00:14');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (240, 'IT1', 0, '2021-06-21 10:00:14');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (241, 'zhangsi', 0, '2021-06-25 10:00:15');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (242, 'wangwu', 0, '2021-06-25 10:00:15');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (243, 'liliu', 0, '2021-06-25 10:00:15');
INSERT INTO `aj_report_init`.`aj_report_mail` VALUES (244, 'IT1', 0, '2021-06-25 10:00:15');

-- ----------------------------
-- Table structure for aj_report_manus
-- ----------------------------
DROP TABLE IF EXISTS `aj_report_init`.`aj_report_manus`;
CREATE TABLE `aj_report_init`.`aj_report_manus`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `datetime` date NULL DEFAULT NULL COMMENT '日期',
  `brand` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '系列',
  `manus` int(11) NULL DEFAULT NULL COMMENT '生产量',
  `sales` int(11) NULL DEFAULT NULL COMMENT '销售量',
  `unsales` int(11) NULL DEFAULT NULL COMMENT '滞销量',
  `rework` int(11) NULL DEFAULT NULL COMMENT '返修量',
  `return` int(11) NULL DEFAULT NULL COMMENT '退货量',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 36 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of aj_report_manus
-- ----------------------------
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (1, '2021-06-18', 'A-100', 12, 11, 1, 0, 0);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (2, '2021-06-18', 'A-110', 20, 15, 5, 1, 1);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (3, '2021-06-18', 'B-100', 20, 20, 0, 0, 0);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (4, '2021-06-18', 'B-110', 30, 25, 5, 2, 1);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (5, '2021-06-18', 'C-50', 60, 50, 10, 5, 3);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (6, '2021-06-18', 'D-40', 65, 65, 0, 10, 0);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (7, '2021-06-18', 'E-30', 45, 45, 0, 20, 2);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (8, '2021-06-19', 'A-100', 7, 7, 0, 1, 0);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (9, '2021-06-19', 'A-110', 10, 9, 1, 1, 0);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (10, '2021-06-19', 'B-100', 11, 10, 1, 1, 0);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (11, '2021-06-19', 'B-110', 15, 12, 3, 0, 0);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (12, '2021-06-19', 'C-50', 40, 40, 0, 5, 2);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (13, '2021-06-19', 'D-40', 35, 33, 2, 4, 2);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (14, '2021-06-19', 'E-30', 15, 29, 1, 10, 10);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (15, '2021-06-20', 'A-100', 17, 13, 4, 1, 0);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (16, '2021-06-20', 'A-110', 9, 8, 1, 0, 0);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (17, '2021-06-20', 'B-100', 18, 17, 1, 1, 0);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (18, '2021-06-20', 'B-110', 5, 5, 0, 0, 0);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (19, '2021-06-20', 'C-50', 60, 50, 10, 5, 2);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (20, '2021-06-20', 'D-40', 35, 33, 2, 7, 2);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (21, '2021-06-20', 'E-30', 45, 44, 1, 12, 3);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (22, '2021-06-21', 'A-100', 27, 20, 7, 1, 0);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (23, '2021-06-21', 'A-110', 39, 30, 9, 2, 0);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (24, '2021-06-21', 'B-100', 28, 25, 3, 1, 0);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (25, '2021-06-21', 'B-110', 15, 12, 3, 2, 0);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (26, '2021-06-21', 'C-50', 30, 30, 0, 5, 2);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (27, '2021-06-21', 'D-40', 25, 24, 1, 3, 1);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (28, '2021-06-21', 'E-30', 55, 50, 5, 7, 3);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (29, '2021-06-22', 'A-100', 37, 30, 7, 2, 0);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (30, '2021-06-22', 'A-110', 19, 15, 4, 1, 1);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (31, '2021-06-22', 'B-100', 8, 8, 0, 1, 0);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (32, '2021-06-22', 'B-110', 5, 5, 0, 1, 0);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (33, '2021-06-22', 'C-50', 20, 19, 1, 2, 1);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (34, '2021-06-22', 'D-40', 15, 14, 1, 3, 1);
INSERT INTO `aj_report_init`.`aj_report_manus` VALUES (35, '2021-06-22', 'E-30', 55, 53, 2, 9, 6);

-- ----------------------------
-- Table structure for aj_report_nums
-- ----------------------------
DROP TABLE IF EXISTS `aj_report_init`.`aj_report_nums`;
CREATE TABLE `aj_report_init`.`aj_report_nums`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `inter` int(11) NULL DEFAULT NULL,
  `doub` double NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 11 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of aj_report_nums
-- ----------------------------
INSERT INTO `aj_report_init`.`aj_report_nums` VALUES (9, 18, NULL);
INSERT INTO `aj_report_init`.`aj_report_nums` VALUES (10, NULL, 55.33);

-- ----------------------------
-- Table structure for aj_report_table
-- ----------------------------
DROP TABLE IF EXISTS `aj_report_init`.`aj_report_table`;
CREATE TABLE `aj_report_init`.`aj_report_table`  (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` date NULL DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `code` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  `address` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 15 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of aj_report_table
-- ----------------------------
INSERT INTO `aj_report_init`.`aj_report_table` VALUES (8, '2021-05-01', '上汽安吉', 'A00000001', '这是一条测试表格事件1');
INSERT INTO `aj_report_init`.`aj_report_table` VALUES (9, '2021-05-02', '上汽大通', 'A00000002', '这是一条测试表格事件2');
INSERT INTO `aj_report_init`.`aj_report_table` VALUES (10, '2021-05-03', '上汽智行', 'A00000003', '这是一条测试表格事件3');
INSERT INTO `aj_report_init`.`aj_report_table` VALUES (11, '2021-05-04', '上汽国际', 'A00000004', '这是一条测试表格事件4');
INSERT INTO `aj_report_init`.`aj_report_table` VALUES (12, '2021-05-05', '上汽国内', 'A00000005', '这是一条测试表格事件5');
INSERT INTO `aj_report_init`.`aj_report_table` VALUES (13, '2021-05-06', '上汽运输', 'A00000006', '这是一条测试表格事件6');
INSERT INTO `aj_report_init`.`aj_report_table` VALUES (14, '2021-05-07', '上汽大众', 'A00000007', '这是一条测试表格事件7');

-- ----------------------------
-- Table structure for aj_report_wifiamount
-- ----------------------------
DROP TABLE IF EXISTS `aj_report_init`.`aj_report_wifiamount`;
CREATE TABLE `aj_report_init`.`aj_report_wifiamount`  (
  `datetime` date NOT NULL,
  `success` int(11) NULL DEFAULT NULL COMMENT '成功次数',
  `fail` int(11) NULL DEFAULT NULL COMMENT '失败次数',
  PRIMARY KEY (`datetime`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of aj_report_wifiamount
-- ----------------------------
INSERT INTO `aj_report_init`.`aj_report_wifiamount` VALUES ('2021-06-17', 210, 15);
INSERT INTO `aj_report_init`.`aj_report_wifiamount` VALUES ('2021-06-18', 234, 43);
INSERT INTO `aj_report_init`.`aj_report_wifiamount` VALUES ('2021-06-19', 199, 28);
INSERT INTO `aj_report_init`.`aj_report_wifiamount` VALUES ('2021-06-20', 260, 80);
INSERT INTO `aj_report_init`.`aj_report_wifiamount` VALUES ('2021-06-21', 245, 45);
INSERT INTO `aj_report_init`.`aj_report_wifiamount` VALUES ('2021-06-22', 216, 26);
INSERT INTO `aj_report_init`.`aj_report_wifiamount` VALUES ('2021-06-23', 150, 10);

-- ----------------------------
-- Table structure for aj_report_city
-- ----------------------------
DROP TABLE IF EXISTS `aj_report_init`.`aj_report_city`;
CREATE TABLE `aj_report_init`.`aj_report_city` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `city_code` varchar(255) DEFAULT NULL COMMENT '城市code',
  `city_name` varchar(255) DEFAULT NULL COMMENT '城市名',
  `nums` int(11) DEFAULT NULL COMMENT '数量',
  `create_time` datetime DEFAULT NULL COMMENT '日期',
  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;
-- ----------------------------
-- Records of aj_report_city
-- ----------------------------
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (1, 'beijing', '北京', 25, '2023-05-05 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (2, 'tianjin', '天津', 15, '2023-05-05 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (3, 'shanghai', '上海', 20, '2023-05-05 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (4, 'hangzhou', '杭州', 9, '2023-05-05 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (5, 'guangzhou', '广州', 13, '2023-05-05 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (6, 'chongqing', '重庆', 16, '2023-05-05 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (7, 'chengdu', '成都', 19, '2023-05-05 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (8, 'beijing', '北京', 35, '2023-05-06 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (9, 'tianjin', '天津', 27, '2023-05-06 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (10, 'shanghai', '上海', 36, '2023-05-06 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (11, 'hangzhou', '杭州', 29, '2023-05-06 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (12, 'guangzhou', '广州', 23, '2023-05-06 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (13, 'chongqing', '重庆', 21, '2023-05-06 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (14, 'chengdu', '成都', 24, '2023-05-06 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (15, 'beijing', '北京', 45, '2023-05-07 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (16, 'tianjin', '天津', 21, '2023-05-07 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (17, 'shanghai', '上海', 23, '2023-05-07 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (18, 'hangzhou', '杭州', 21, '2023-05-07 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (19, 'guangzhou', '广州', 19, '2023-05-07 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (20, 'chongqing', '重庆', 17, '2023-05-07 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (21, 'chengdu', '成都', 14, '2023-05-07 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (22, 'beijing', '北京', 12, '2023-05-08 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (23, 'tianjin', '天津', 24, '2023-05-08 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (24, 'shanghai', '上海', 13, '2023-05-08 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (25, 'hangzhou', '杭州', 31, '2023-05-08 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (26, 'guangzhou', '广州', 29, '2023-05-08 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (27, 'chongqing', '重庆', 37, '2023-05-08 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (28, 'chengdu', '成都', 24, '2023-05-08 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (29, 'beijing', '北京', 44, '2023-05-09 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (30, 'tianjin', '天津', 32, '2023-05-09 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (31, 'shanghai', '上海', 33, '2023-05-09 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (32, 'hangzhou', '杭州', 29, '2023-05-09 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (33, 'guangzhou', '广州', 19, '2023-05-09 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (34, 'chongqing', '重庆', 17, '2023-05-09 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (35, 'chengdu', '成都', 34, '2023-05-09 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (36, 'beijing', '北京', 27, '2023-05-10 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (37, 'tianjin', '天津', 31, '2023-05-10 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (38, 'shanghai', '上海', 13, '2023-05-10 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (39, 'hangzhou', '杭州', 21, '2023-05-10 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (40, 'guangzhou', '广州', 31, '2023-05-10 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (41, 'chongqing', '重庆', 27, '2023-05-10 02:00:00');
INSERT INTO `aj_report_init`.`aj_report_city` VALUES (42, 'chengdu', '成都', 10, '2023-05-10 02:00:00');



INSERT INTO `aj_report`.`gaea_report`(`report_name`, `report_code`, `report_group`, `report_type`, `report_image`, `report_desc`, `report_author`, `download_count`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('日志大屏', 'log_ajreport', NULL, 'report_screen', NULL, '', NULL, NULL, 1, 0, 'admin', '2021-06-30 10:06:31', 'admin', '2021-06-30 10:06:31', 1);
INSERT INTO `aj_report`.`gaea_report`(`report_name`, `report_code`, `report_group`, `report_type`, `report_image`, `report_desc`, `report_author`, `download_count`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('汽车生产销售大屏', 'car_ajreport', NULL, 'report_screen', NULL, '', NULL, NULL, 1, 0, 'admin', '2021-06-30 14:32:53', 'admin', '2021-06-30 14:32:53', 1);
INSERT INTO `aj_report`.`gaea_report`(`report_name`, `report_code`, `report_group`, `report_type`, `report_image`, `report_desc`, `report_author`, `download_count`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('访问大屏', 'acc_ajreport', NULL, 'report_screen', NULL, '', NULL, NULL, 1, 0, 'admin', '2021-06-30 15:19:59', 'admin', '2021-06-30 15:19:59', 1);
INSERT INTO `aj_report`.`gaea_report`(`report_name`, `report_code`, `report_group`, `report_type`, `report_image`, `report_desc`, `report_author`, `download_count`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('空白大屏', 'blank', NULL, 'report_screen', '', '', NULL, NULL, 1, 0, 'admin', '2021-06-30 16:34:40', 'admin', '2021-07-01 15:19:56', 3);
INSERT INTO `aj_report`.`gaea_report`(`report_name`, `report_code`, `report_group`, `report_type`, `report_image`, `report_desc`, `report_author`, `download_count`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('物流大屏1', 'logistics_one', NULL, 'report_screen', '', '', NULL, NULL, 1, 0, 'admin', '2023-01-10 07:30:56', 'admin', '2023-01-10 07:30:56', 2);
INSERT INTO `aj_report`.`gaea_report`(`report_name`, `report_code`, `report_group`, `report_type`, `report_image`, `report_desc`, `report_author`, `download_count`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('表单测试', 'testForm', 'default', 'report_screen', null, null, null, null, 1, 0, 'admin', '2023-05-09 10:38:59', 'admin', '2023-05-09 10:38:59', 1);


INSERT INTO `aj_report`.`gaea_report_dashboard`(`report_code`, `title`, `width`, `height`, `background_color`, `background_image`, `preset_line`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('log_ajreport', '大屏', 1920, 1080, '#000', 'https://report.anji-plus.com/file/download/ee0de1b0-4cd3-4acd-886d-a60c054239a2', NULL, NULL, 1, 0, 0, 'admin', '2021-06-30 10:24:28', 'admin', '2021-07-02 16:13:04', 45);
INSERT INTO `aj_report`.`gaea_report_dashboard`(`report_code`, `title`, `width`, `height`, `background_color`, `background_image`, `preset_line`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('car_ajreport', '大屏', 1920, 1080, '#000', 'https://report.anji-plus.com/file/download/border2@2x', NULL, NULL, 1, 0, 0, 'admin', '2021-06-30 14:50:47', 'admin', '2021-07-02 16:10:09', 23);
INSERT INTO `aj_report`.`gaea_report_dashboard`(`report_code`, `title`, `width`, `height`, `background_color`, `background_image`, `preset_line`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('acc_ajreport', '大屏', 1920, 1080, '#000', 'https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b', NULL, NULL, 1, 0, 0, 'admin', '2021-06-30 15:29:16', 'admin', '2021-07-02 10:26:43', 5);
INSERT INTO `aj_report`.`gaea_report_dashboard`(`report_code`, `title`, `width`, `height`, `background_color`, `background_image`, `preset_line`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('blank', '大屏', 1920, 1080, '#000', 'https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b', NULL, NULL, 1, 0, 0, 'admin', '2021-06-30 16:58:51', 'admin', '2021-07-02 16:39:27', 11);
INSERT INTO `aj_report`.`gaea_report_dashboard`(`report_code`, `title`, `width`, `height`, `background_color`, `background_image`, `preset_line`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('test', '大屏', 1920, 1080, '#000', 'https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b', NULL, NULL, 1, 0, 0, 'admin', '2021-07-02 10:26:18', 'admin', '2021-07-02 10:26:18', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard`(`report_code`, `title`, `width`, `height`, `background_color`, `background_image`, `preset_line`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logn_ajreport', '大屏', 1920, 1080, '#000', 'https://report.anji-plus.com/file/download/3dcd98a1-c328-4e7d-9f24-bdc09f8553ea', NULL, NULL, 1, 0, 0, 'admin', '2021-07-02 16:14:26', 'admin', '2021-07-02 17:14:57', 32);
INSERT INTO `aj_report`.`gaea_report_dashboard`(`report_code`, `title`, `width`, `height`, `background_color`, `background_image`, `preset_line`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logistics_one', '大屏', 1920, 1080, '', 'https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b', NULL, NULL, 1, 0, 0, 'admin', '2023-01-10 07:30:56', 'admin', '2023-01-10 07:30:56', 30);
INSERT INTO `aj_report`.`gaea_report_dashboard`(`report_code`, `title`, `width`, `height`, `background_color`, `background_image`, `preset_line`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('testForm', '', 1920, 1080, 'rgba(52, 80, 106, 1)', '', null, null, 1, 0, 0, 'admin', '2023-05-09 10:39:18', 'admin', '2023-05-12 09:43:48', 45);


INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('test', 'widget-text', '{\"color\":\"#FAD400\",\"textAlign\":\"center\",\"background\":\"rgba(115,170,229,.0)\",\"letterSpacing\":\"0\",\"fontSize\":\"26\",\"layerName\":\"文本框\",\"text\":\"文本框\",\"fontWeight\":\"normal\"}', '{}', '', '{\"top\":0,\"left\":0,\"width\":100,\"height\":40,\"zIndex\":0}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"文本框\"},{\"type\":\"el-input-text\",\"label\":\"文本内容\",\"name\":\"text\",\"required\":false,\"placeholder\":\"\",\"value\":\"文本框\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":\"26\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"color\",\"required\":false,\"placeholder\":\"\",\"value\":\"#FAD400\"},{\"type\":\"el-input-number\",\"label\":\"字体间距\",\"name\":\"letterSpacing\",\"required\":false,\"placeholder\":\"\",\"value\":\"0\"},{\"type\":\"vue-color\",\"label\":\"字体背景\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(115,170,229,.0)\"},{\"type\":\"el-select\",\"label\":\"文字粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-select\",\"label\":\"对齐方式\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":0},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":0},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":100},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":40}]}', NULL, 1, 0, 1, 'admin', '2021-07-02 10:26:18', 'admin', '2021-07-02 10:26:18', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('acc_ajreport', 'widget-linechart', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"left\",\"reversalY\":false,\"reversalX\":false,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":false,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"系统ERROR\",\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"height\":1080,\"area\":true,\"textAlign\":\"center\",\"lineColor\":\"\",\"subTextColor\":\"#fff\",\"textColor\":\"##FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"\",\"fontSize\":0,\"marginBottom\":10,\"layerName\":\"折线图\",\"hideX\":true,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"http://10.108.26.197/business/file/download/adfc22ac-ed7f-4141-aeb9-ee81f16ac92d\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":9,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":16,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":false,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#1E90FF\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{\"dynamicData\":{\"chartProperties\":{\"datetime\":\"xAxis\",\"access\":\"line\"},\"setCode\":\"acc_ajacc\",\"chartType\":\"widget-linechart\",\"contextData\":{}},\"dataType\":\"dynamicData\",\"refreshTime\":50000,\"staticData\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1009,3409,2309,5409,3409]}]}\"}', '', '{\"top\":185,\"left\":3,\"width\":932,\"index\":0,\"height\":405}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"dynamicData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":50000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1009,3409,2309,5409,3409]}]}\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"chartType\":\"widget-linechart\",\"relactiveDomValue\":\"dynamicData\",\"value\":{\"chartProperties\":{\"datetime\":\"xAxis\",\"access\":\"line\"},\"setCode\":\"acc_ajacc\",\"chartType\":\"widget-linechart\",\"contextData\":{}}}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"折线图\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},[{\"name\":\"折线设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标记点\",\"name\":\"markPoint\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-slider\",\"label\":\"点大小\",\"name\":\"pointSize\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-switch\",\"label\":\"平滑曲线\",\"name\":\"smoothCurve\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-switch\",\"label\":\"面积堆积\",\"name\":\"area\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-slider\",\"label\":\"面积厚度\",\"name\":\"areaThickness\",\"required\":false,\"placeholder\":\"\",\"value\":16},{\"type\":\"el-slider\",\"label\":\"线条宽度\",\"name\":\"lineWidth\",\"required\":false,\"placeholder\":\"\",\"value\":9}]},{\"name\":\"标题设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标题\",\"name\":\"isNoTitle\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-input-text\",\"label\":\"标题\",\"name\":\"titleText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"textColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"##FFD700\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"textFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"textFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20},{\"type\":\"el-select\",\"label\":\"字体位置\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"},{\"type\":\"el-input-text\",\"label\":\"副标题\",\"name\":\"subText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"subTextFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"subTextFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20}]},{\"name\":\"X轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"xName\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"hideX\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"xNameColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"xNameFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-slider\",\"label\":\"文字角度\",\"name\":\"textAngle\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-input-number\",\"label\":\"文字间隔\",\"name\":\"textInterval\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalX\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"Xcolor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字号\",\"name\":\"fontSizeX\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineX\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"Y轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"textNameY\",\"require\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShowY\",\"require\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"NameColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字体大小\",\"name\":\"NameFontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalY\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"colorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字号\",\"name\":\"fontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineY\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"数值设定\",\"list\":[{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShow\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"}]},{\"name\":\"提示语设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lineColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"}]},{\"name\":\"坐标轴边距设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"左边距(像素)\",\"name\":\"marginLeft\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"顶边距(像素)\",\"name\":\"marginTop\",\"required\":false,\"placeholder\":\"\",\"value\":50},{\"type\":\"el-slider\",\"label\":\"右边距(像素)\",\"name\":\"marginRight\",\"required\":false,\"placeholder\":\"\",\"value\":40},{\"type\":\"el-slider\",\"label\":\"底边距(像素)\",\"name\":\"marginBottom\",\"required\":false,\"placeholder\":\"\",\"value\":10}]},{\"name\":\"图例操作\",\"list\":[{\"type\":\"el-switch\",\"label\":\"图例\",\"name\":\"isShowLegend\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lengedColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"lengedFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":16},{\"type\":\"el-input-number\",\"label\":\"图例宽度\",\"name\":\"lengedWidth\",\"required\":false,\"placeholder\":\"\",\"value\":15},{\"type\":\"el-select\",\"label\":\"横向位置\",\"name\":\"lateralPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"left\"},{\"type\":\"el-select\",\"label\":\"纵向位置\",\"name\":\"longitudinalPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"top\",\"name\":\"顶部\"},{\"code\":\"bottom\",\"name\":\"底部\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"布局前置\",\"name\":\"layoutFront\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"vertical\",\"name\":\"竖排\"},{\"code\":\"horizontal\",\"name\":\"横排\"}],\"value\":\"\"}]},{\"name\":\"自定义配色\",\"list\":[{\"type\":\"customColor\",\"label\":\"\",\"name\":\"customColor\",\"required\":false,\"value\":[{\"color\":\"#1E90FF\"}]}]}]],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":3},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":185},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":932},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":405}]}', NULL, 1, 0, 1, 'admin', '2021-07-02 10:26:43', 'admin', '2021-07-02 10:26:43', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('acc_ajreport', 'widget-linechart', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"left\",\"reversalY\":false,\"reversalX\":false,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":false,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"系统ERROR\",\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"height\":1080,\"area\":true,\"textAlign\":\"center\",\"lineColor\":\"\",\"subTextColor\":\"#fff\",\"textColor\":\"##FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"\",\"fontSize\":0,\"marginBottom\":10,\"layerName\":\"折线图\",\"hideX\":true,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"http://10.108.26.197/business/file/download/adfc22ac-ed7f-4141-aeb9-ee81f16ac92d\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":9,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":11,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#1E90FF\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{\"dynamicData\":{\"chartProperties\":{\"datetime\":\"xAxis\",\"register\":\"line\"},\"setCode\":\"acc_ajregister\",\"chartType\":\"widget-linechart\",\"contextData\":{}},\"dataType\":\"dynamicData\",\"refreshTime\":50000,\"staticData\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1009,3409,2309,5409,3409]}]}\"}', '', '{\"top\":186,\"left\":946,\"width\":929,\"index\":1,\"height\":402}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"dynamicData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":50000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1009,3409,2309,5409,3409]}]}\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"chartType\":\"widget-linechart\",\"relactiveDomValue\":\"dynamicData\",\"value\":{\"chartProperties\":{\"datetime\":\"xAxis\",\"register\":\"line\"},\"setCode\":\"acc_ajregister\",\"chartType\":\"widget-linechart\",\"contextData\":{}}}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"折线图\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},[{\"name\":\"折线设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标记点\",\"name\":\"markPoint\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-slider\",\"label\":\"点大小\",\"name\":\"pointSize\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-switch\",\"label\":\"平滑曲线\",\"name\":\"smoothCurve\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-switch\",\"label\":\"面积堆积\",\"name\":\"area\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-slider\",\"label\":\"面积厚度\",\"name\":\"areaThickness\",\"required\":false,\"placeholder\":\"\",\"value\":11},{\"type\":\"el-slider\",\"label\":\"线条宽度\",\"name\":\"lineWidth\",\"required\":false,\"placeholder\":\"\",\"value\":9}]},{\"name\":\"标题设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标题\",\"name\":\"isNoTitle\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-input-text\",\"label\":\"标题\",\"name\":\"titleText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"textColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"##FFD700\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"textFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"textFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20},{\"type\":\"el-select\",\"label\":\"字体位置\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"},{\"type\":\"el-input-text\",\"label\":\"副标题\",\"name\":\"subText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"subTextFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"subTextFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20}]},{\"name\":\"X轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"xName\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"hideX\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"xNameColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"xNameFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-slider\",\"label\":\"文字角度\",\"name\":\"textAngle\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-input-number\",\"label\":\"文字间隔\",\"name\":\"textInterval\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalX\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"Xcolor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字号\",\"name\":\"fontSizeX\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineX\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"Y轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"textNameY\",\"require\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShowY\",\"require\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"NameColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字体大小\",\"name\":\"NameFontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalY\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"colorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字号\",\"name\":\"fontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineY\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"数值设定\",\"list\":[{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShow\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"}]},{\"name\":\"提示语设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lineColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"}]},{\"name\":\"坐标轴边距设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"左边距(像素)\",\"name\":\"marginLeft\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"顶边距(像素)\",\"name\":\"marginTop\",\"required\":false,\"placeholder\":\"\",\"value\":50},{\"type\":\"el-slider\",\"label\":\"右边距(像素)\",\"name\":\"marginRight\",\"required\":false,\"placeholder\":\"\",\"value\":40},{\"type\":\"el-slider\",\"label\":\"底边距(像素)\",\"name\":\"marginBottom\",\"required\":false,\"placeholder\":\"\",\"value\":10}]},{\"name\":\"图例操作\",\"list\":[{\"type\":\"el-switch\",\"label\":\"图例\",\"name\":\"isShowLegend\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lengedColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"lengedFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":16},{\"type\":\"el-input-number\",\"label\":\"图例宽度\",\"name\":\"lengedWidth\",\"required\":false,\"placeholder\":\"\",\"value\":15},{\"type\":\"el-select\",\"label\":\"横向位置\",\"name\":\"lateralPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"left\"},{\"type\":\"el-select\",\"label\":\"纵向位置\",\"name\":\"longitudinalPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"top\",\"name\":\"顶部\"},{\"code\":\"bottom\",\"name\":\"底部\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"布局前置\",\"name\":\"layoutFront\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"vertical\",\"name\":\"竖排\"},{\"code\":\"horizontal\",\"name\":\"横排\"}],\"value\":\"\"}]},{\"name\":\"自定义配色\",\"list\":[{\"type\":\"customColor\",\"label\":\"\",\"name\":\"customColor\",\"required\":false,\"value\":[{\"color\":\"#1E90FF\"}]}]}]],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":946},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":186},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":929},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":402}]}', NULL, 1, 0, 2, 'admin', '2021-07-02 10:26:43', 'admin', '2021-07-02 10:26:43', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('acc_ajreport', 'widget-linechart', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"left\",\"reversalY\":false,\"reversalX\":false,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":false,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"系统ERROR\",\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"height\":1080,\"area\":false,\"textAlign\":\"center\",\"lineColor\":\"\",\"subTextColor\":\"#fff\",\"textColor\":\"##FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"\",\"fontSize\":0,\"marginBottom\":10,\"layerName\":\"折线图\",\"hideX\":true,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"http://10.108.26.197/business/file/download/adfc22ac-ed7f-4141-aeb9-ee81f16ac92d\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#1E90FF\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{\"dynamicData\":{\"chartProperties\":{\"datetime\":\"xAxis\",\"rt\":\"line\"},\"setCode\":\"acc_ajrt\",\"chartType\":\"widget-linechart\",\"contextData\":{}},\"dataType\":\"dynamicData\",\"refreshTime\":5000,\"staticData\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1009,3409,2309,5409,3409]}]}\"}', '', '{\"top\":663,\"left\":3,\"width\":603,\"index\":2,\"height\":378}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"dynamicData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":5000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1009,3409,2309,5409,3409]}]}\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"chartType\":\"widget-linechart\",\"relactiveDomValue\":\"dynamicData\",\"value\":{\"chartProperties\":{\"datetime\":\"xAxis\",\"rt\":\"line\"},\"setCode\":\"acc_ajrt\",\"chartType\":\"widget-linechart\",\"contextData\":{}}}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"折线图\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},[{\"name\":\"折线设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标记点\",\"name\":\"markPoint\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-slider\",\"label\":\"点大小\",\"name\":\"pointSize\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-switch\",\"label\":\"平滑曲线\",\"name\":\"smoothCurve\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-switch\",\"label\":\"面积堆积\",\"name\":\"area\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-slider\",\"label\":\"面积厚度\",\"name\":\"areaThickness\",\"required\":false,\"placeholder\":\"\",\"value\":5},{\"type\":\"el-slider\",\"label\":\"线条宽度\",\"name\":\"lineWidth\",\"required\":false,\"placeholder\":\"\",\"value\":4}]},{\"name\":\"标题设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标题\",\"name\":\"isNoTitle\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-input-text\",\"label\":\"标题\",\"name\":\"titleText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"textColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"##FFD700\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"textFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"textFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20},{\"type\":\"el-select\",\"label\":\"字体位置\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"},{\"type\":\"el-input-text\",\"label\":\"副标题\",\"name\":\"subText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"subTextFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"subTextFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20}]},{\"name\":\"X轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"xName\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"hideX\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"xNameColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"xNameFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-slider\",\"label\":\"文字角度\",\"name\":\"textAngle\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-input-number\",\"label\":\"文字间隔\",\"name\":\"textInterval\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalX\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"Xcolor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字号\",\"name\":\"fontSizeX\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineX\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"Y轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"textNameY\",\"require\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShowY\",\"require\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"NameColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字体大小\",\"name\":\"NameFontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalY\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"colorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字号\",\"name\":\"fontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineY\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"数值设定\",\"list\":[{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShow\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"}]},{\"name\":\"提示语设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lineColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"}]},{\"name\":\"坐标轴边距设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"左边距(像素)\",\"name\":\"marginLeft\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"顶边距(像素)\",\"name\":\"marginTop\",\"required\":false,\"placeholder\":\"\",\"value\":50},{\"type\":\"el-slider\",\"label\":\"右边距(像素)\",\"name\":\"marginRight\",\"required\":false,\"placeholder\":\"\",\"value\":40},{\"type\":\"el-slider\",\"label\":\"底边距(像素)\",\"name\":\"marginBottom\",\"required\":false,\"placeholder\":\"\",\"value\":10}]},{\"name\":\"图例操作\",\"list\":[{\"type\":\"el-switch\",\"label\":\"图例\",\"name\":\"isShowLegend\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lengedColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"lengedFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":16},{\"type\":\"el-input-number\",\"label\":\"图例宽度\",\"name\":\"lengedWidth\",\"required\":false,\"placeholder\":\"\",\"value\":15},{\"type\":\"el-select\",\"label\":\"横向位置\",\"name\":\"lateralPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"left\"},{\"type\":\"el-select\",\"label\":\"纵向位置\",\"name\":\"longitudinalPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"top\",\"name\":\"顶部\"},{\"code\":\"bottom\",\"name\":\"底部\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"布局前置\",\"name\":\"layoutFront\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"vertical\",\"name\":\"竖排\"},{\"code\":\"horizontal\",\"name\":\"横排\"}],\"value\":\"\"}]},{\"name\":\"自定义配色\",\"list\":[{\"type\":\"customColor\",\"label\":\"\",\"name\":\"customColor\",\"required\":false,\"value\":[{\"color\":\"#1E90FF\"}]}]}]],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":3},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":663},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":603},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":378}]}', NULL, 1, 0, 3, 'admin', '2021-07-02 10:26:43', 'admin', '2021-07-02 10:26:43', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('acc_ajreport', 'widget-linechart', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"left\",\"reversalY\":false,\"reversalX\":false,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":false,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"系统ERROR\",\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"height\":1080,\"area\":true,\"textAlign\":\"center\",\"lineColor\":\"\",\"subTextColor\":\"#fff\",\"textColor\":\"##FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"\",\"fontSize\":0,\"marginBottom\":10,\"layerName\":\"折线图\",\"hideX\":true,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"http://10.108.26.197/business/file/download/adfc22ac-ed7f-4141-aeb9-ee81f16ac92d\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":false,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#1E90FF\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{\"dynamicData\":{\"chartProperties\":{\"datetime\":\"xAxis\",\"qps\":\"line\"},\"setCode\":\"acc_ajqps\",\"chartType\":\"widget-linechart\",\"contextData\":{}},\"dataType\":\"dynamicData\",\"refreshTime\":50000,\"staticData\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1009,3409,2309,5409,3409]}]}\"}', '', '{\"top\":665,\"left\":617,\"width\":620,\"index\":3,\"height\":377}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"dynamicData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":50000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1009,3409,2309,5409,3409]}]}\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"chartType\":\"widget-linechart\",\"relactiveDomValue\":\"dynamicData\",\"value\":{\"chartProperties\":{\"datetime\":\"xAxis\",\"qps\":\"line\"},\"setCode\":\"acc_ajqps\",\"chartType\":\"widget-linechart\",\"contextData\":{}}}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"折线图\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},[{\"name\":\"折线设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标记点\",\"name\":\"markPoint\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-slider\",\"label\":\"点大小\",\"name\":\"pointSize\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-switch\",\"label\":\"平滑曲线\",\"name\":\"smoothCurve\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-switch\",\"label\":\"面积堆积\",\"name\":\"area\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-slider\",\"label\":\"面积厚度\",\"name\":\"areaThickness\",\"required\":false,\"placeholder\":\"\",\"value\":5},{\"type\":\"el-slider\",\"label\":\"线条宽度\",\"name\":\"lineWidth\",\"required\":false,\"placeholder\":\"\",\"value\":4}]},{\"name\":\"标题设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标题\",\"name\":\"isNoTitle\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-input-text\",\"label\":\"标题\",\"name\":\"titleText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"textColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"##FFD700\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"textFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"textFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20},{\"type\":\"el-select\",\"label\":\"字体位置\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"},{\"type\":\"el-input-text\",\"label\":\"副标题\",\"name\":\"subText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"subTextFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"subTextFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20}]},{\"name\":\"X轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"xName\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"hideX\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"xNameColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"xNameFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-slider\",\"label\":\"文字角度\",\"name\":\"textAngle\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-input-number\",\"label\":\"文字间隔\",\"name\":\"textInterval\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalX\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"Xcolor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字号\",\"name\":\"fontSizeX\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineX\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"Y轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"textNameY\",\"require\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShowY\",\"require\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"NameColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字体大小\",\"name\":\"NameFontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalY\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"colorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字号\",\"name\":\"fontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineY\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"数值设定\",\"list\":[{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShow\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"}]},{\"name\":\"提示语设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lineColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"}]},{\"name\":\"坐标轴边距设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"左边距(像素)\",\"name\":\"marginLeft\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"顶边距(像素)\",\"name\":\"marginTop\",\"required\":false,\"placeholder\":\"\",\"value\":50},{\"type\":\"el-slider\",\"label\":\"右边距(像素)\",\"name\":\"marginRight\",\"required\":false,\"placeholder\":\"\",\"value\":40},{\"type\":\"el-slider\",\"label\":\"底边距(像素)\",\"name\":\"marginBottom\",\"required\":false,\"placeholder\":\"\",\"value\":10}]},{\"name\":\"图例操作\",\"list\":[{\"type\":\"el-switch\",\"label\":\"图例\",\"name\":\"isShowLegend\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lengedColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"lengedFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":16},{\"type\":\"el-input-number\",\"label\":\"图例宽度\",\"name\":\"lengedWidth\",\"required\":false,\"placeholder\":\"\",\"value\":15},{\"type\":\"el-select\",\"label\":\"横向位置\",\"name\":\"lateralPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"left\"},{\"type\":\"el-select\",\"label\":\"纵向位置\",\"name\":\"longitudinalPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"top\",\"name\":\"顶部\"},{\"code\":\"bottom\",\"name\":\"底部\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"布局前置\",\"name\":\"layoutFront\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"vertical\",\"name\":\"竖排\"},{\"code\":\"horizontal\",\"name\":\"横排\"}],\"value\":\"\"}]},{\"name\":\"自定义配色\",\"list\":[{\"type\":\"customColor\",\"label\":\"\",\"name\":\"customColor\",\"required\":false,\"value\":[{\"color\":\"#1E90FF\"}]}]}]],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":617},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":665},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":620},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":377}]}', NULL, 1, 0, 4, 'admin', '2021-07-02 10:26:43', 'admin', '2021-07-02 10:26:43', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('acc_ajreport', 'widget-linechart', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"left\",\"reversalY\":false,\"reversalX\":false,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":false,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"系统ERROR\",\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"height\":1080,\"area\":true,\"textAlign\":\"center\",\"lineColor\":\"\",\"subTextColor\":\"#fff\",\"textColor\":\"##FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"\",\"fontSize\":0,\"marginBottom\":10,\"layerName\":\"折线图\",\"hideX\":true,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"http://10.108.26.197/business/file/download/adfc22ac-ed7f-4141-aeb9-ee81f16ac92d\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#FF8C00\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{\"dynamicData\":{\"chartProperties\":{\"datetime\":\"xAxis\",\"error\":\"bar\"},\"setCode\":\"acc_ajerror\",\"chartType\":\"widget-linechart\",\"contextData\":{}},\"dataType\":\"dynamicData\",\"refreshTime\":50000,\"staticData\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1009,3409,2309,5409,3409]}]}\"}', '', '{\"top\":666,\"left\":1248,\"width\":628,\"index\":4,\"height\":369}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"dynamicData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":50000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1009,3409,2309,5409,3409]}]}\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"chartType\":\"widget-linechart\",\"relactiveDomValue\":\"dynamicData\",\"value\":{\"chartProperties\":{\"datetime\":\"xAxis\",\"error\":\"bar\"},\"setCode\":\"acc_ajerror\",\"chartType\":\"widget-linechart\",\"contextData\":{}}}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"折线图\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},[{\"name\":\"折线设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标记点\",\"name\":\"markPoint\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-slider\",\"label\":\"点大小\",\"name\":\"pointSize\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-switch\",\"label\":\"平滑曲线\",\"name\":\"smoothCurve\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-switch\",\"label\":\"面积堆积\",\"name\":\"area\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-slider\",\"label\":\"面积厚度\",\"name\":\"areaThickness\",\"required\":false,\"placeholder\":\"\",\"value\":5},{\"type\":\"el-slider\",\"label\":\"线条宽度\",\"name\":\"lineWidth\",\"required\":false,\"placeholder\":\"\",\"value\":4}]},{\"name\":\"标题设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标题\",\"name\":\"isNoTitle\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-input-text\",\"label\":\"标题\",\"name\":\"titleText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"textColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"##FFD700\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"textFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"textFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20},{\"type\":\"el-select\",\"label\":\"字体位置\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"},{\"type\":\"el-input-text\",\"label\":\"副标题\",\"name\":\"subText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"subTextFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"subTextFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20}]},{\"name\":\"X轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"xName\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"hideX\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"xNameColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"xNameFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-slider\",\"label\":\"文字角度\",\"name\":\"textAngle\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-input-number\",\"label\":\"文字间隔\",\"name\":\"textInterval\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalX\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"Xcolor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字号\",\"name\":\"fontSizeX\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineX\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"Y轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"textNameY\",\"require\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShowY\",\"require\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"NameColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字体大小\",\"name\":\"NameFontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalY\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"colorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字号\",\"name\":\"fontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineY\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"数值设定\",\"list\":[{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShow\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"}]},{\"name\":\"提示语设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lineColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"}]},{\"name\":\"坐标轴边距设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"左边距(像素)\",\"name\":\"marginLeft\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"顶边距(像素)\",\"name\":\"marginTop\",\"required\":false,\"placeholder\":\"\",\"value\":50},{\"type\":\"el-slider\",\"label\":\"右边距(像素)\",\"name\":\"marginRight\",\"required\":false,\"placeholder\":\"\",\"value\":40},{\"type\":\"el-slider\",\"label\":\"底边距(像素)\",\"name\":\"marginBottom\",\"required\":false,\"placeholder\":\"\",\"value\":10}]},{\"name\":\"图例操作\",\"list\":[{\"type\":\"el-switch\",\"label\":\"图例\",\"name\":\"isShowLegend\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lengedColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"lengedFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":16},{\"type\":\"el-input-number\",\"label\":\"图例宽度\",\"name\":\"lengedWidth\",\"required\":false,\"placeholder\":\"\",\"value\":15},{\"type\":\"el-select\",\"label\":\"横向位置\",\"name\":\"lateralPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"left\"},{\"type\":\"el-select\",\"label\":\"纵向位置\",\"name\":\"longitudinalPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"top\",\"name\":\"顶部\"},{\"code\":\"bottom\",\"name\":\"底部\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"布局前置\",\"name\":\"layoutFront\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"vertical\",\"name\":\"竖排\"},{\"code\":\"horizontal\",\"name\":\"横排\"}],\"value\":\"\"}]},{\"name\":\"自定义配色\",\"list\":[{\"type\":\"customColor\",\"label\":\"\",\"name\":\"customColor\",\"required\":false,\"value\":[{\"color\":\"#FF8C00\"}]}]}]],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":1248},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":666},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":628},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":369}]}', NULL, 1, 0, 5, 'admin', '2021-07-02 10:26:43', 'admin', '2021-07-02 10:26:43', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('acc_ajreport', 'widget-text', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"left\",\"reversalY\":false,\"reversalX\":false,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":false,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"访问大屏\",\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"height\":1080,\"area\":true,\"textAlign\":\"center\",\"lineColor\":\"\",\"subTextColor\":\"#fff\",\"textColor\":\"##FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"rgba(115,170,229,.0)\",\"fontSize\":50,\"marginBottom\":10,\"layerName\":\"文本框\",\"hideX\":true,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"http://10.108.26.197/business/file/download/adfc22ac-ed7f-4141-aeb9-ee81f16ac92d\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":false,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#1E90FF\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":37,\"left\":790,\"width\":299,\"index\":5,\"height\":77}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"文本框\"},{\"type\":\"el-input-text\",\"label\":\"文本内容\",\"name\":\"text\",\"required\":false,\"placeholder\":\"\",\"value\":\"访问大屏\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":50},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"color\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(0, 206, 209, 1)\"},{\"type\":\"el-input-number\",\"label\":\"字体间距\",\"name\":\"letterSpacing\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体背景\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(115,170,229,.0)\"},{\"type\":\"el-select\",\"label\":\"文字粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-select\",\"label\":\"对齐方式\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":790},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":37},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":299},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":77}]}', NULL, 1, 0, 6, 'admin', '2021-07-02 10:26:43', 'admin', '2021-07-02 10:26:43', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('acc_ajreport', 'widget-text', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"left\",\"reversalY\":false,\"reversalX\":false,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":false,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"访问人数变化趋势\",\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"height\":1080,\"area\":true,\"textAlign\":\"center\",\"lineColor\":\"\",\"subTextColor\":\"#fff\",\"textColor\":\"##FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"rgba(115,170,229,.0)\",\"fontSize\":26,\"marginBottom\":10,\"layerName\":\"文本框\",\"hideX\":true,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"http://10.108.26.197/business/file/download/adfc22ac-ed7f-4141-aeb9-ee81f16ac92d\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":false,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#1E90FF\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":144,\"left\":341,\"width\":248,\"index\":6,\"height\":40}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"文本框\"},{\"type\":\"el-input-text\",\"label\":\"文本内容\",\"name\":\"text\",\"required\":false,\"placeholder\":\"\",\"value\":\"访问人数变化趋势\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":26},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"color\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(0, 206, 209, 1)\"},{\"type\":\"el-input-number\",\"label\":\"字体间距\",\"name\":\"letterSpacing\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体背景\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(115,170,229,.0)\"},{\"type\":\"el-select\",\"label\":\"文字粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-select\",\"label\":\"对齐方式\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":341},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":144},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":248},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":40}]}', NULL, 1, 0, 7, 'admin', '2021-07-02 10:26:43', 'admin', '2021-07-02 10:26:43', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('acc_ajreport', 'widget-text', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"left\",\"reversalY\":false,\"reversalX\":false,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":false,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"注册人数变化趋势\",\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"height\":1080,\"area\":true,\"textAlign\":\"center\",\"lineColor\":\"\",\"subTextColor\":\"#fff\",\"textColor\":\"##FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"rgba(115,170,229,.0)\",\"fontSize\":26,\"marginBottom\":10,\"layerName\":\"文本框\",\"hideX\":true,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"http://10.108.26.197/business/file/download/adfc22ac-ed7f-4141-aeb9-ee81f16ac92d\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":false,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#1E90FF\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":139,\"left\":1299,\"width\":249,\"index\":7,\"height\":40}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"文本框\"},{\"type\":\"el-input-text\",\"label\":\"文本内容\",\"name\":\"text\",\"required\":false,\"placeholder\":\"\",\"value\":\"注册人数变化趋势\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":26},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"color\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(0, 206, 209, 1)\"},{\"type\":\"el-input-number\",\"label\":\"字体间距\",\"name\":\"letterSpacing\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体背景\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(115,170,229,.0)\"},{\"type\":\"el-select\",\"label\":\"文字粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-select\",\"label\":\"对齐方式\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":1299},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":139},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":249},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":40}]}', NULL, 1, 0, 8, 'admin', '2021-07-02 10:26:43', 'admin', '2021-07-02 10:26:43', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('acc_ajreport', 'widget-text', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"left\",\"reversalY\":false,\"reversalX\":false,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":false,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"系统RT\",\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"height\":1080,\"area\":true,\"textAlign\":\"center\",\"lineColor\":\"\",\"subTextColor\":\"#fff\",\"textColor\":\"##FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"rgba(115,170,229,.0)\",\"fontSize\":26,\"marginBottom\":10,\"layerName\":\"文本框\",\"hideX\":true,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"http://10.108.26.197/business/file/download/adfc22ac-ed7f-4141-aeb9-ee81f16ac92d\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":false,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#1E90FF\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":620,\"left\":213,\"width\":113,\"index\":8,\"height\":40}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"文本框\"},{\"type\":\"el-input-text\",\"label\":\"文本内容\",\"name\":\"text\",\"required\":false,\"placeholder\":\"\",\"value\":\"系统RT\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":26},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"color\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(0, 206, 209, 1)\"},{\"type\":\"el-input-number\",\"label\":\"字体间距\",\"name\":\"letterSpacing\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体背景\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(115,170,229,.0)\"},{\"type\":\"el-select\",\"label\":\"文字粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-select\",\"label\":\"对齐方式\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":213},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":620},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":113},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":40}]}', NULL, 1, 0, 9, 'admin', '2021-07-02 10:26:43', 'admin', '2021-07-02 10:26:43', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('acc_ajreport', 'widget-text', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"left\",\"reversalY\":false,\"reversalX\":false,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":false,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"系统QPS\",\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"height\":1080,\"area\":true,\"textAlign\":\"center\",\"lineColor\":\"\",\"subTextColor\":\"#fff\",\"textColor\":\"##FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"rgba(115,170,229,.0)\",\"fontSize\":26,\"marginBottom\":10,\"layerName\":\"文本框\",\"hideX\":true,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"http://10.108.26.197/business/file/download/adfc22ac-ed7f-4141-aeb9-ee81f16ac92d\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":false,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#1E90FF\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":624,\"left\":854,\"width\":130,\"index\":9,\"height\":40}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"文本框\"},{\"type\":\"el-input-text\",\"label\":\"文本内容\",\"name\":\"text\",\"required\":false,\"placeholder\":\"\",\"value\":\"系统QPS\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":26},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"color\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(0, 206, 209, 1)\"},{\"type\":\"el-input-number\",\"label\":\"字体间距\",\"name\":\"letterSpacing\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体背景\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(115,170,229,.0)\"},{\"type\":\"el-select\",\"label\":\"文字粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-select\",\"label\":\"对齐方式\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":854},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":624},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":130},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":40}]}', NULL, 1, 0, 10, 'admin', '2021-07-02 10:26:43', 'admin', '2021-07-02 10:26:43', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('acc_ajreport', 'widget-text', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"left\",\"reversalY\":false,\"reversalX\":false,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":false,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"系统ERROR\",\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"height\":1080,\"area\":true,\"textAlign\":\"center\",\"lineColor\":\"\",\"subTextColor\":\"#fff\",\"textColor\":\"##FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"rgba(115,170,229,.0)\",\"fontSize\":26,\"marginBottom\":10,\"layerName\":\"文本框\",\"hideX\":true,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"http://10.108.26.197/business/file/download/adfc22ac-ed7f-4141-aeb9-ee81f16ac92d\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":false,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#1E90FF\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":624,\"left\":1467,\"width\":180,\"index\":10,\"height\":40}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"文本框\"},{\"type\":\"el-input-text\",\"label\":\"文本内容\",\"name\":\"text\",\"required\":false,\"placeholder\":\"\",\"value\":\"系统ERROR\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":26},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"color\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(0, 206, 209, 1)\"},{\"type\":\"el-input-number\",\"label\":\"字体间距\",\"name\":\"letterSpacing\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体背景\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(115,170,229,.0)\"},{\"type\":\"el-select\",\"label\":\"文字粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-select\",\"label\":\"对齐方式\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":1467},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":624},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":180},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":40}]}', NULL, 1, 0, 11, 'admin', '2021-07-02 10:26:43', 'admin', '2021-07-02 10:26:43', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('car_ajreport', 'widget-image', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"reversalX\":\"\",\"minHeight\":0,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"startRotate\":false,\"layoutFront\":\"\",\"text\":\"退货排名\",\"radius\":5,\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"imageAdress\":\"https://report.anji-plus.com/file/download/border9@2x\",\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"borderRadius\":0,\"transparency\":100,\"marginBottom\":10,\"layerName\":\"图片\",\"hideX\":true,\"verticalShow\":false,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"lengedFontSize\":16,\"areaThickness\":5,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"fontSizeY\":12,\"smoothCurve\":true,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"NameFontSizeY\":12,\"markPoint\":true,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":758,\"left\":49,\"width\":559,\"index\":21,\"height\":290}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"图片\"},{\"type\":\"el-switch\",\"label\":\"开启旋转\",\"name\":\"startRotate\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-slider\",\"label\":\"透明度\",\"name\":\"transparency\",\"required\":false,\"placeholder\":\"\",\"value\":100},{\"type\":\"el-input-number\",\"label\":\"圆角\",\"name\":\"borderRadius\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"custom-upload\",\"label\":\"图片地址\",\"name\":\"imageAdress\",\"required\":false,\"placeholder\":\"\",\"value\":\"https://report.anji-plus.com/file/download/border9@2x\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":49},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":758},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":559},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":290}]}', NULL, 1, 0, 1, 'admin', '2021-07-02 16:10:09', 'admin', '2021-07-02 16:10:09', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('car_ajreport', 'widget-image', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"reversalX\":\"\",\"minHeight\":0,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"startRotate\":false,\"layoutFront\":\"\",\"text\":\"退货排名\",\"radius\":5,\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"imageAdress\":\"https://report.anji-plus.com/file/download/border9@2x\",\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"borderRadius\":0,\"transparency\":100,\"marginBottom\":10,\"layerName\":\"图片\",\"hideX\":true,\"verticalShow\":false,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"lengedFontSize\":16,\"areaThickness\":5,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"fontSizeY\":12,\"smoothCurve\":true,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"NameFontSizeY\":12,\"markPoint\":true,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":748,\"left\":1259,\"width\":559,\"index\":4,\"height\":290}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"图片\"},{\"type\":\"el-switch\",\"label\":\"开启旋转\",\"name\":\"startRotate\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-slider\",\"label\":\"透明度\",\"name\":\"transparency\",\"required\":false,\"placeholder\":\"\",\"value\":100},{\"type\":\"el-input-number\",\"label\":\"圆角\",\"name\":\"borderRadius\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"custom-upload\",\"label\":\"图片地址\",\"name\":\"imageAdress\",\"required\":false,\"placeholder\":\"\",\"value\":\"https://report.anji-plus.com/file/download/border9@2x\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":1259},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":748},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":559},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":290}]}', NULL, 1, 0, 2, 'admin', '2021-07-02 16:10:09', 'admin', '2021-07-02 16:10:09', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('car_ajreport', 'widget-image', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":true,\"reversalX\":false,\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"startRotate\":false,\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"滞销排名\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"imageAdress\":\"https://report.anji-plus.com/file/download/border5@2x\",\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"borderRadius\":0,\"transparency\":100,\"fontSize\":26,\"marginBottom\":10,\"layerName\":\"图片\",\"hideX\":true,\"verticalShow\":true,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"},{\"color\":\"#90EE90\"},{\"color\":\"#A3E0E1\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":756,\"left\":646,\"width\":559,\"index\":0,\"height\":290}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"图片\"},{\"type\":\"el-switch\",\"label\":\"开启旋转\",\"name\":\"startRotate\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-slider\",\"label\":\"透明度\",\"name\":\"transparency\",\"required\":false,\"placeholder\":\"\",\"value\":100},{\"type\":\"el-input-number\",\"label\":\"圆角\",\"name\":\"borderRadius\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"custom-upload\",\"label\":\"图片地址\",\"name\":\"imageAdress\",\"required\":false,\"placeholder\":\"\",\"value\":\"https://report.anji-plus.com/file/download/border5@2x\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":646},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":756},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":559},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":290}]}', NULL, 1, 0, 3, 'admin', '2021-07-02 16:10:09', 'admin', '2021-07-02 16:10:09', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('car_ajreport', 'widget-image', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"reversalX\":\"\",\"minHeight\":0,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"startRotate\":false,\"layoutFront\":\"\",\"text\":\"销售趋势\",\"radius\":5,\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"imageAdress\":\"https://report.anji-plus.com/file/download/border10@1x\",\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"borderRadius\":0,\"transparency\":100,\"marginBottom\":10,\"layerName\":\"图片\",\"hideX\":true,\"verticalShow\":false,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"lengedFontSize\":16,\"areaThickness\":5,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"fontSizeY\":12,\"smoothCurve\":true,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"NameFontSizeY\":12,\"markPoint\":true,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":143,\"left\":55,\"width\":802,\"index\":3,\"height\":286}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"图片\"},{\"type\":\"el-switch\",\"label\":\"开启旋转\",\"name\":\"startRotate\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-slider\",\"label\":\"透明度\",\"name\":\"transparency\",\"required\":false,\"placeholder\":\"\",\"value\":100},{\"type\":\"el-input-number\",\"label\":\"圆角\",\"name\":\"borderRadius\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"custom-upload\",\"label\":\"图片地址\",\"name\":\"imageAdress\",\"required\":false,\"placeholder\":\"\",\"value\":\"https://report.anji-plus.com/file/download/border10@1x\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":55},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":143},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":802},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":286}]}', NULL, 1, 0, 4, 'admin', '2021-07-02 16:10:09', 'admin', '2021-07-02 16:10:09', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('car_ajreport', 'widget-image', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"reversalX\":\"\",\"minHeight\":0,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"startRotate\":false,\"layoutFront\":\"\",\"text\":\"生产趋势\",\"radius\":5,\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"imageAdress\":\"https://report.anji-plus.com/file/download/border8@1x\",\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"borderRadius\":0,\"transparency\":100,\"marginBottom\":10,\"layerName\":\"图片\",\"hideX\":true,\"verticalShow\":false,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"lengedFontSize\":16,\"areaThickness\":5,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"fontSizeY\":12,\"smoothCurve\":true,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"NameFontSizeY\":12,\"markPoint\":true,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":141,\"left\":948,\"width\":816,\"index\":4,\"height\":284}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"图片\"},{\"type\":\"el-switch\",\"label\":\"开启旋转\",\"name\":\"startRotate\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-slider\",\"label\":\"透明度\",\"name\":\"transparency\",\"required\":false,\"placeholder\":\"\",\"value\":100},{\"type\":\"el-input-number\",\"label\":\"圆角\",\"name\":\"borderRadius\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"custom-upload\",\"label\":\"图片地址\",\"name\":\"imageAdress\",\"required\":false,\"placeholder\":\"\",\"value\":\"https://report.anji-plus.com/file/download/border8@1x\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":948},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":141},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":816},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":284}]}', NULL, 1, 0, 5, 'admin', '2021-07-02 16:10:09', 'admin', '2021-07-02 16:10:09', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('car_ajreport', 'widget-image', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"reversalX\":\"\",\"minHeight\":0,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"startRotate\":false,\"layoutFront\":\"\",\"text\":\"生产TOP5\",\"radius\":5,\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"imageAdress\":\"https://report.anji-plus.com/file/download/border6@1x\",\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"borderRadius\":0,\"transparency\":100,\"marginBottom\":10,\"layerName\":\"图片\",\"hideX\":true,\"verticalShow\":false,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"lengedFontSize\":16,\"areaThickness\":5,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"fontSizeY\":12,\"smoothCurve\":true,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"NameFontSizeY\":12,\"markPoint\":true,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":447,\"left\":950,\"width\":813,\"index\":2,\"height\":291}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"图片\"},{\"type\":\"el-switch\",\"label\":\"开启旋转\",\"name\":\"startRotate\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-slider\",\"label\":\"透明度\",\"name\":\"transparency\",\"required\":false,\"placeholder\":\"\",\"value\":100},{\"type\":\"el-input-number\",\"label\":\"圆角\",\"name\":\"borderRadius\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"custom-upload\",\"label\":\"图片地址\",\"name\":\"imageAdress\",\"required\":false,\"placeholder\":\"\",\"value\":\"https://report.anji-plus.com/file/download/border6@1x\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":950},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":447},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":813},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":291}]}', NULL, 1, 0, 6, 'admin', '2021-07-02 16:10:09', 'admin', '2021-07-02 16:10:09', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('car_ajreport', 'widget-image', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"left\",\"reversalY\":false,\"reversalX\":false,\"minHeight\":0,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":false,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"startRotate\":false,\"layoutFront\":\"\",\"text\":\"销售趋势\",\"radius\":5,\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"imageAdress\":\"https://report.anji-plus.com/file/download/border7@1x\",\"textAlign\":\"center\",\"lineColor\":\"\",\"subTextColor\":\"#fff\",\"textColor\":\"##FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":22,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"borderRadius\":0,\"transparency\":100,\"fontSize\":0,\"marginBottom\":10,\"layerName\":\"图片\",\"hideX\":true,\"verticalShow\":false,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"lengedFontSize\":16,\"areaThickness\":5,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"fontSizeY\":12,\"smoothCurve\":true,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"NameFontSizeY\":12,\"markPoint\":true,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#1E90FF\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":455,\"left\":52,\"width\":810,\"index\":4,\"height\":279}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"图片\"},{\"type\":\"el-switch\",\"label\":\"开启旋转\",\"name\":\"startRotate\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-slider\",\"label\":\"透明度\",\"name\":\"transparency\",\"required\":false,\"placeholder\":\"\",\"value\":100},{\"type\":\"el-input-number\",\"label\":\"圆角\",\"name\":\"borderRadius\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"custom-upload\",\"label\":\"图片地址\",\"name\":\"imageAdress\",\"required\":false,\"placeholder\":\"\",\"value\":\"https://report.anji-plus.com/file/download/border7@1x\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":52},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":455},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":810},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":279}]}', NULL, 1, 0, 7, 'admin', '2021-07-02 16:10:09', 'admin', '2021-07-02 16:10:09', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('car_ajreport', 'widget-linechart', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"left\",\"reversalY\":false,\"reversalX\":false,\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":false,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"退货排名\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"center\",\"lineColor\":\"\",\"subTextColor\":\"#fff\",\"textColor\":\"##FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":22,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"\",\"fontSize\":0,\"marginBottom\":10,\"layerName\":\"折线图\",\"hideX\":true,\"verticalShow\":false,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"http://10.108.26.197/business/file/download/adfc22ac-ed7f-4141-aeb9-ee81f16ac92d\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#1E90FF\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{\"dynamicData\":{\"chartProperties\":{\"datetime\":\"xAxis\",\"nums\":\"line\"},\"setCode\":\"car_ajpro\",\"chartType\":\"widget-linechart\",\"contextData\":{}},\"dataType\":\"dynamicData\",\"refreshTime\":50000,\"staticData\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1009,3409,2309,5409,3409]}]}\"}', '', '{\"top\":187,\"left\":154,\"width\":610,\"index\":4,\"height\":207}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"dynamicData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":50000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1009,3409,2309,5409,3409]}]}\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"chartType\":\"widget-linechart\",\"relactiveDomValue\":\"dynamicData\",\"value\":{\"chartProperties\":{\"datetime\":\"xAxis\",\"nums\":\"line\"},\"setCode\":\"car_ajpro\",\"chartType\":\"widget-linechart\",\"contextData\":{}}}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"折线图\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},[{\"name\":\"折线设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标记点\",\"name\":\"markPoint\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-slider\",\"label\":\"点大小\",\"name\":\"pointSize\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-switch\",\"label\":\"平滑曲线\",\"name\":\"smoothCurve\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-switch\",\"label\":\"面积堆积\",\"name\":\"area\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-slider\",\"label\":\"面积厚度\",\"name\":\"areaThickness\",\"required\":false,\"placeholder\":\"\",\"value\":5},{\"type\":\"el-slider\",\"label\":\"线条宽度\",\"name\":\"lineWidth\",\"required\":false,\"placeholder\":\"\",\"value\":4}]},{\"name\":\"标题设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标题\",\"name\":\"isNoTitle\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-input-text\",\"label\":\"标题\",\"name\":\"titleText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"textColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"##FFD700\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"textFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"textFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20},{\"type\":\"el-select\",\"label\":\"字体位置\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"},{\"type\":\"el-input-text\",\"label\":\"副标题\",\"name\":\"subText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"subTextFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"subTextFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20}]},{\"name\":\"X轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"xName\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"hideX\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"xNameColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"xNameFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":22},{\"type\":\"el-slider\",\"label\":\"文字角度\",\"name\":\"textAngle\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-input-number\",\"label\":\"文字间隔\",\"name\":\"textInterval\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalX\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"Xcolor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字号\",\"name\":\"fontSizeX\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineX\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"Y轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"textNameY\",\"require\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShowY\",\"require\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"NameColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字体大小\",\"name\":\"NameFontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalY\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"colorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字号\",\"name\":\"fontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineY\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"数值设定\",\"list\":[{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShow\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"}]},{\"name\":\"提示语设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lineColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"}]},{\"name\":\"坐标轴边距设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"左边距(像素)\",\"name\":\"marginLeft\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"顶边距(像素)\",\"name\":\"marginTop\",\"required\":false,\"placeholder\":\"\",\"value\":50},{\"type\":\"el-slider\",\"label\":\"右边距(像素)\",\"name\":\"marginRight\",\"required\":false,\"placeholder\":\"\",\"value\":40},{\"type\":\"el-slider\",\"label\":\"底边距(像素)\",\"name\":\"marginBottom\",\"required\":false,\"placeholder\":\"\",\"value\":10}]},{\"name\":\"图例操作\",\"list\":[{\"type\":\"el-switch\",\"label\":\"图例\",\"name\":\"isShowLegend\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lengedColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"lengedFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":16},{\"type\":\"el-input-number\",\"label\":\"图例宽度\",\"name\":\"lengedWidth\",\"required\":false,\"placeholder\":\"\",\"value\":15},{\"type\":\"el-select\",\"label\":\"横向位置\",\"name\":\"lateralPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"left\"},{\"type\":\"el-select\",\"label\":\"纵向位置\",\"name\":\"longitudinalPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"top\",\"name\":\"顶部\"},{\"code\":\"bottom\",\"name\":\"底部\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"布局前置\",\"name\":\"layoutFront\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"vertical\",\"name\":\"竖排\"},{\"code\":\"horizontal\",\"name\":\"横排\"}],\"value\":\"\"}]},{\"name\":\"自定义配色\",\"list\":[{\"type\":\"customColor\",\"label\":\"\",\"name\":\"customColor\",\"required\":false,\"value\":[{\"color\":\"#1E90FF\"}]}]}]],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":154},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":187},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":610},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":207}]}', NULL, 1, 0, 8, 'admin', '2021-07-02 16:10:09', 'admin', '2021-07-02 16:10:09', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('car_ajreport', 'widget-linechart', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"left\",\"reversalY\":false,\"reversalX\":false,\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":false,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"退货排名\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"center\",\"lineColor\":\"\",\"subTextColor\":\"#fff\",\"textColor\":\"##FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"\",\"fontSize\":0,\"marginBottom\":10,\"layerName\":\"折线图\",\"hideX\":true,\"verticalShow\":false,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"http://10.108.26.197/business/file/download/adfc22ac-ed7f-4141-aeb9-ee81f16ac92d\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#1E90FF\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{\"dynamicData\":{\"chartProperties\":{\"datetime\":\"xAxis\",\"nums\":\"line\"},\"setCode\":\"car_ajsale\",\"chartType\":\"widget-linechart\",\"contextData\":{}},\"dataType\":\"dynamicData\",\"refreshTime\":50000,\"staticData\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1009,3409,2309,5409,3409]}]}\"}', '', '{\"top\":503,\"left\":1017,\"width\":691,\"index\":6,\"height\":196}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"dynamicData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":50000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1009,3409,2309,5409,3409]}]}\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"chartType\":\"widget-linechart\",\"relactiveDomValue\":\"dynamicData\",\"value\":{\"chartProperties\":{\"datetime\":\"xAxis\",\"nums\":\"line\"},\"setCode\":\"car_ajsale\",\"chartType\":\"widget-linechart\",\"contextData\":{}}}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"折线图\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},[{\"name\":\"折线设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标记点\",\"name\":\"markPoint\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-slider\",\"label\":\"点大小\",\"name\":\"pointSize\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-switch\",\"label\":\"平滑曲线\",\"name\":\"smoothCurve\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-switch\",\"label\":\"面积堆积\",\"name\":\"area\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-slider\",\"label\":\"面积厚度\",\"name\":\"areaThickness\",\"required\":false,\"placeholder\":\"\",\"value\":5},{\"type\":\"el-slider\",\"label\":\"线条宽度\",\"name\":\"lineWidth\",\"required\":false,\"placeholder\":\"\",\"value\":4}]},{\"name\":\"标题设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标题\",\"name\":\"isNoTitle\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-input-text\",\"label\":\"标题\",\"name\":\"titleText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"textColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"##FFD700\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"textFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"textFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20},{\"type\":\"el-select\",\"label\":\"字体位置\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"},{\"type\":\"el-input-text\",\"label\":\"副标题\",\"name\":\"subText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"subTextFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"subTextFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20}]},{\"name\":\"X轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"xName\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"hideX\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"xNameColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"xNameFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-slider\",\"label\":\"文字角度\",\"name\":\"textAngle\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-input-number\",\"label\":\"文字间隔\",\"name\":\"textInterval\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalX\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"Xcolor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字号\",\"name\":\"fontSizeX\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineX\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"Y轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"textNameY\",\"require\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShowY\",\"require\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"NameColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字体大小\",\"name\":\"NameFontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalY\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"colorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字号\",\"name\":\"fontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineY\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"数值设定\",\"list\":[{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShow\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"}]},{\"name\":\"提示语设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lineColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"}]},{\"name\":\"坐标轴边距设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"左边距(像素)\",\"name\":\"marginLeft\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"顶边距(像素)\",\"name\":\"marginTop\",\"required\":false,\"placeholder\":\"\",\"value\":50},{\"type\":\"el-slider\",\"label\":\"右边距(像素)\",\"name\":\"marginRight\",\"required\":false,\"placeholder\":\"\",\"value\":40},{\"type\":\"el-slider\",\"label\":\"底边距(像素)\",\"name\":\"marginBottom\",\"required\":false,\"placeholder\":\"\",\"value\":10}]},{\"name\":\"图例操作\",\"list\":[{\"type\":\"el-switch\",\"label\":\"图例\",\"name\":\"isShowLegend\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lengedColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"lengedFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":16},{\"type\":\"el-input-number\",\"label\":\"图例宽度\",\"name\":\"lengedWidth\",\"required\":false,\"placeholder\":\"\",\"value\":15},{\"type\":\"el-select\",\"label\":\"横向位置\",\"name\":\"lateralPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"left\"},{\"type\":\"el-select\",\"label\":\"纵向位置\",\"name\":\"longitudinalPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"top\",\"name\":\"顶部\"},{\"code\":\"bottom\",\"name\":\"底部\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"布局前置\",\"name\":\"layoutFront\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"vertical\",\"name\":\"竖排\"},{\"code\":\"horizontal\",\"name\":\"横排\"}],\"value\":\"\"}]},{\"name\":\"自定义配色\",\"list\":[{\"type\":\"customColor\",\"label\":\"\",\"name\":\"customColor\",\"required\":false,\"value\":[{\"color\":\"#1E90FF\"}]}]}]],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":1017},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":503},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":691},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":196}]}', NULL, 1, 0, 9, 'admin', '2021-07-02 16:10:09', 'admin', '2021-07-02 16:10:09', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('car_ajreport', 'widget-barchart', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"reversalX\":\"\",\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"退货排名\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"\",\"marginBottom\":10,\"layerName\":\"柱状图\",\"hideX\":true,\"verticalShow\":false,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"http://10.108.26.197/business/file/download/adfc22ac-ed7f-4141-aeb9-ee81f16ac92d\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{\"dynamicData\":{\"chartProperties\":{\"brand\":\"xAxis\",\"nums\":\"bar\"},\"setCode\":\"car_ajproTop5\",\"chartType\":\"widget-barchart\",\"contextData\":{}},\"dataType\":\"dynamicData\",\"refreshTime\":50000,\"staticData\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1000,2229,3879,2379,4079]}]}\"}', '', '{\"top\":506,\"left\":167,\"width\":604,\"index\":7,\"height\":178}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"dynamicData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":50000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1000,2229,3879,2379,4079]}]}\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"chartType\":\"widget-barchart\",\"value\":{\"chartProperties\":{\"brand\":\"xAxis\",\"nums\":\"bar\"},\"setCode\":\"car_ajproTop5\",\"chartType\":\"widget-barchart\",\"contextData\":{}}}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"柱状图\"},{\"type\":\"el-switch\",\"label\":\"竖展示\",\"name\":\"verticalShow\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},[{\"name\":\"柱体设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"最大宽度\",\"name\":\"maxWidth\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"圆角\",\"name\":\"radius\",\"require\":false,\"placeholder\":\"\",\"value\":5},{\"type\":\"el-slider\",\"label\":\"最小高度\",\"name\":\"minHeight\",\"require\":false,\"placeholder\":\"\",\"value\":0}]},{\"name\":\"标题设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标题\",\"name\":\"isNoTitle\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-text\",\"label\":\"标题\",\"name\":\"titleText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"textColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#FFD700\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"textFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"textFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20},{\"type\":\"el-select\",\"label\":\"字体位置\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"},{\"type\":\"el-input-text\",\"label\":\"副标题\",\"name\":\"subText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字体粗细\",\"name\":\"subTextFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"subTextFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20}]},{\"name\":\"X轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"xName\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"hideX\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"xNameColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"xNameFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-slider\",\"label\":\"文字角度\",\"name\":\"textAngle\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-input-number\",\"label\":\"文字间隔\",\"name\":\"textInterval\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalX\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"Xcolor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeX\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineX\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"Y轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"textNameY\",\"require\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShowY\",\"require\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"NameColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"NameFontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalY\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"colorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineY\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"数值设定\",\"list\":[{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShow\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":14},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"}]},{\"name\":\"提示语设置\",\"list\":[{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lineColor\",\"required\":false,\"placeholder\":\"\"}]},{\"name\":\"坐标轴边距设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"左边距(像素)\",\"name\":\"marginLeft\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"顶边距(像素)\",\"name\":\"marginTop\",\"required\":false,\"placeholder\":\"\",\"value\":50},{\"type\":\"el-slider\",\"label\":\"右边距(像素)\",\"name\":\"marginRight\",\"required\":false,\"placeholder\":\"\",\"value\":40},{\"type\":\"el-slider\",\"label\":\"底边距(像素)\",\"name\":\"marginBottom\",\"required\":false,\"placeholder\":\"\",\"value\":10}]},{\"name\":\"图例操作\",\"list\":[{\"type\":\"el-switch\",\"label\":\"图例\",\"name\":\"isShowLegend\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lengedColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"lengedFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":16},{\"type\":\"el-input-number\",\"label\":\"图例宽度\",\"name\":\"lengedWidth\",\"required\":false,\"placeholder\":\"\",\"value\":15},{\"type\":\"el-select\",\"label\":\"横向位置\",\"name\":\"lateralPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"纵向位置\",\"name\":\"longitudinalPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"top\",\"name\":\"顶部\"},{\"code\":\"bottom\",\"name\":\"底部\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"布局前置\",\"name\":\"layoutFront\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"vertical\",\"name\":\"竖排\"},{\"code\":\"horizontal\",\"name\":\"横排\"}],\"value\":\"\"}]},{\"name\":\"自定义配色\",\"list\":[{\"type\":\"customColor\",\"label\":\"\",\"name\":\"customColor\",\"required\":false,\"value\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}]}]}]],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":167},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":506},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":604},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":178}]}', NULL, 1, 0, 10, 'admin', '2021-07-02 16:10:09', 'admin', '2021-07-02 16:10:09', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('car_ajreport', 'widget-barchart', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"reversalX\":\"\",\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"退货排名\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"\",\"marginBottom\":10,\"layerName\":\"柱状图\",\"hideX\":true,\"verticalShow\":false,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"http://10.108.26.197/business/file/download/adfc22ac-ed7f-4141-aeb9-ee81f16ac92d\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{\"dynamicData\":{\"chartProperties\":{\"brand\":\"xAxis\",\"nums\":\"bar\"},\"setCode\":\"car_ajsaleTop5\",\"chartType\":\"widget-barchart\",\"contextData\":{}},\"dataType\":\"dynamicData\",\"refreshTime\":50000,\"staticData\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1000,2229,3879,2379,4079]}]}\"}', '', '{\"top\":150,\"left\":1011,\"width\":713,\"index\":8,\"height\":268}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"dynamicData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":50000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1000,2229,3879,2379,4079]}]}\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"chartType\":\"widget-barchart\",\"value\":{\"chartProperties\":{\"brand\":\"xAxis\",\"nums\":\"bar\"},\"setCode\":\"car_ajsaleTop5\",\"chartType\":\"widget-barchart\",\"contextData\":{}}}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"柱状图\"},{\"type\":\"el-switch\",\"label\":\"竖展示\",\"name\":\"verticalShow\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},[{\"name\":\"柱体设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"最大宽度\",\"name\":\"maxWidth\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"圆角\",\"name\":\"radius\",\"require\":false,\"placeholder\":\"\",\"value\":5},{\"type\":\"el-slider\",\"label\":\"最小高度\",\"name\":\"minHeight\",\"require\":false,\"placeholder\":\"\",\"value\":0}]},{\"name\":\"标题设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标题\",\"name\":\"isNoTitle\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-text\",\"label\":\"标题\",\"name\":\"titleText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"textColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#FFD700\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"textFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"textFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20},{\"type\":\"el-select\",\"label\":\"字体位置\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"},{\"type\":\"el-input-text\",\"label\":\"副标题\",\"name\":\"subText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字体粗细\",\"name\":\"subTextFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"subTextFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20}]},{\"name\":\"X轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"xName\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"hideX\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"xNameColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"xNameFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-slider\",\"label\":\"文字角度\",\"name\":\"textAngle\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-input-number\",\"label\":\"文字间隔\",\"name\":\"textInterval\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalX\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"Xcolor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeX\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineX\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"Y轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"textNameY\",\"require\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShowY\",\"require\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"NameColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"NameFontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalY\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"colorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineY\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"数值设定\",\"list\":[{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShow\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":14},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"}]},{\"name\":\"提示语设置\",\"list\":[{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lineColor\",\"required\":false,\"placeholder\":\"\"}]},{\"name\":\"坐标轴边距设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"左边距(像素)\",\"name\":\"marginLeft\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"顶边距(像素)\",\"name\":\"marginTop\",\"required\":false,\"placeholder\":\"\",\"value\":50},{\"type\":\"el-slider\",\"label\":\"右边距(像素)\",\"name\":\"marginRight\",\"required\":false,\"placeholder\":\"\",\"value\":40},{\"type\":\"el-slider\",\"label\":\"底边距(像素)\",\"name\":\"marginBottom\",\"required\":false,\"placeholder\":\"\",\"value\":10}]},{\"name\":\"图例操作\",\"list\":[{\"type\":\"el-switch\",\"label\":\"图例\",\"name\":\"isShowLegend\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lengedColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"lengedFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":16},{\"type\":\"el-input-number\",\"label\":\"图例宽度\",\"name\":\"lengedWidth\",\"required\":false,\"placeholder\":\"\",\"value\":15},{\"type\":\"el-select\",\"label\":\"横向位置\",\"name\":\"lateralPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"纵向位置\",\"name\":\"longitudinalPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"top\",\"name\":\"顶部\"},{\"code\":\"bottom\",\"name\":\"底部\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"布局前置\",\"name\":\"layoutFront\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"vertical\",\"name\":\"竖排\"},{\"code\":\"horizontal\",\"name\":\"横排\"}],\"value\":\"\"}]},{\"name\":\"自定义配色\",\"list\":[{\"type\":\"customColor\",\"label\":\"\",\"name\":\"customColor\",\"required\":false,\"value\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}]}]}]],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":1011},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":150},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":713},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":268}]}', NULL, 1, 0, 11, 'admin', '2021-07-02 16:10:09', 'admin', '2021-07-02 16:10:09', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('car_ajreport', 'widget-barchart', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":true,\"reversalX\":false,\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"退货排名\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"\",\"marginBottom\":10,\"layerName\":\"柱状图\",\"hideX\":true,\"verticalShow\":true,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"http://10.108.26.197/business/file/download/adfc22ac-ed7f-4141-aeb9-ee81f16ac92d\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"},{\"color\":\"#90EE90\"},{\"color\":\"#A3E0E1\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{\"dynamicData\":{\"chartProperties\":{\"brand\":\"xAxis\",\"nums\":\"bar\"},\"setCode\":\"car_ajunsale\",\"chartType\":\"widget-barchart\",\"contextData\":{}},\"dataType\":\"dynamicData\",\"refreshTime\":50000,\"staticData\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1000,2229,3879,2379,4079]}]}\"}', '', '{\"top\":801,\"left\":107,\"width\":457,\"index\":9,\"height\":219}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"dynamicData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":50000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1000,2229,3879,2379,4079]}]}\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"chartType\":\"widget-barchart\",\"value\":{\"chartProperties\":{\"brand\":\"xAxis\",\"nums\":\"bar\"},\"setCode\":\"car_ajunsale\",\"chartType\":\"widget-barchart\",\"contextData\":{}}}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"柱状图\"},{\"type\":\"el-switch\",\"label\":\"竖展示\",\"name\":\"verticalShow\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},[{\"name\":\"柱体设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"最大宽度\",\"name\":\"maxWidth\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"圆角\",\"name\":\"radius\",\"require\":false,\"placeholder\":\"\",\"value\":5},{\"type\":\"el-slider\",\"label\":\"最小高度\",\"name\":\"minHeight\",\"require\":false,\"placeholder\":\"\",\"value\":0}]},{\"name\":\"标题设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标题\",\"name\":\"isNoTitle\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-text\",\"label\":\"标题\",\"name\":\"titleText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"textColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#FFD700\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"textFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"textFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20},{\"type\":\"el-select\",\"label\":\"字体位置\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"},{\"type\":\"el-input-text\",\"label\":\"副标题\",\"name\":\"subText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字体粗细\",\"name\":\"subTextFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"subTextFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20}]},{\"name\":\"X轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"xName\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"hideX\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"xNameColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"xNameFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-slider\",\"label\":\"文字角度\",\"name\":\"textAngle\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-input-number\",\"label\":\"文字间隔\",\"name\":\"textInterval\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalX\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"Xcolor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeX\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineX\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"Y轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"textNameY\",\"require\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShowY\",\"require\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"NameColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"NameFontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalY\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"colorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineY\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"数值设定\",\"list\":[{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShow\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":14},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"}]},{\"name\":\"提示语设置\",\"list\":[{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lineColor\",\"required\":false,\"placeholder\":\"\"}]},{\"name\":\"坐标轴边距设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"左边距(像素)\",\"name\":\"marginLeft\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"顶边距(像素)\",\"name\":\"marginTop\",\"required\":false,\"placeholder\":\"\",\"value\":50},{\"type\":\"el-slider\",\"label\":\"右边距(像素)\",\"name\":\"marginRight\",\"required\":false,\"placeholder\":\"\",\"value\":40},{\"type\":\"el-slider\",\"label\":\"底边距(像素)\",\"name\":\"marginBottom\",\"required\":false,\"placeholder\":\"\",\"value\":10}]},{\"name\":\"图例操作\",\"list\":[{\"type\":\"el-switch\",\"label\":\"图例\",\"name\":\"isShowLegend\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lengedColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"lengedFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":16},{\"type\":\"el-input-number\",\"label\":\"图例宽度\",\"name\":\"lengedWidth\",\"required\":false,\"placeholder\":\"\",\"value\":15},{\"type\":\"el-select\",\"label\":\"横向位置\",\"name\":\"lateralPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"纵向位置\",\"name\":\"longitudinalPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"top\",\"name\":\"顶部\"},{\"code\":\"bottom\",\"name\":\"底部\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"布局前置\",\"name\":\"layoutFront\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"vertical\",\"name\":\"竖排\"},{\"code\":\"horizontal\",\"name\":\"横排\"}],\"value\":\"\"}]},{\"name\":\"自定义配色\",\"list\":[{\"type\":\"customColor\",\"label\":\"\",\"name\":\"customColor\",\"required\":false,\"value\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"},{\"color\":\"#90EE90\"},{\"color\":\"#A3E0E1\"}]}]}]],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":107},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":801},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":457},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":219}]}', NULL, 1, 0, 12, 'admin', '2021-07-02 16:10:09', 'admin', '2021-07-02 16:10:09', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('car_ajreport', 'widget-barchart', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"reversalX\":\"\",\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"退货排名\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"\",\"marginBottom\":10,\"layerName\":\"柱状图\",\"hideX\":true,\"verticalShow\":false,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"http://10.108.26.197/business/file/download/adfc22ac-ed7f-4141-aeb9-ee81f16ac92d\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{\"dynamicData\":{\"chartProperties\":{\"brand\":\"xAxis\",\"nums\":\"bar\"},\"setCode\":\"car_ajrework\",\"chartType\":\"widget-barchart\",\"contextData\":{}},\"dataType\":\"dynamicData\",\"refreshTime\":50000,\"staticData\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1000,2229,3879,2379,4079]}]}\"}', '', '{\"top\":828,\"left\":692,\"width\":456,\"index\":11,\"height\":184}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"dynamicData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":50000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1000,2229,3879,2379,4079]}]}\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"chartType\":\"widget-barchart\",\"value\":{\"chartProperties\":{\"brand\":\"xAxis\",\"nums\":\"bar\"},\"setCode\":\"car_ajrework\",\"chartType\":\"widget-barchart\",\"contextData\":{}}}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"柱状图\"},{\"type\":\"el-switch\",\"label\":\"竖展示\",\"name\":\"verticalShow\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},[{\"name\":\"柱体设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"最大宽度\",\"name\":\"maxWidth\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"圆角\",\"name\":\"radius\",\"require\":false,\"placeholder\":\"\",\"value\":5},{\"type\":\"el-slider\",\"label\":\"最小高度\",\"name\":\"minHeight\",\"require\":false,\"placeholder\":\"\",\"value\":0}]},{\"name\":\"标题设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标题\",\"name\":\"isNoTitle\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-text\",\"label\":\"标题\",\"name\":\"titleText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"textColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#FFD700\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"textFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"textFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20},{\"type\":\"el-select\",\"label\":\"字体位置\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"},{\"type\":\"el-input-text\",\"label\":\"副标题\",\"name\":\"subText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字体粗细\",\"name\":\"subTextFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"subTextFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20}]},{\"name\":\"X轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"xName\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"hideX\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"xNameColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"xNameFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-slider\",\"label\":\"文字角度\",\"name\":\"textAngle\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-input-number\",\"label\":\"文字间隔\",\"name\":\"textInterval\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalX\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"Xcolor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeX\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineX\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"Y轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"textNameY\",\"require\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShowY\",\"require\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"NameColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"NameFontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalY\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"colorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineY\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"数值设定\",\"list\":[{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShow\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":14},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"}]},{\"name\":\"提示语设置\",\"list\":[{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lineColor\",\"required\":false,\"placeholder\":\"\"}]},{\"name\":\"坐标轴边距设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"左边距(像素)\",\"name\":\"marginLeft\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"顶边距(像素)\",\"name\":\"marginTop\",\"required\":false,\"placeholder\":\"\",\"value\":50},{\"type\":\"el-slider\",\"label\":\"右边距(像素)\",\"name\":\"marginRight\",\"required\":false,\"placeholder\":\"\",\"value\":40},{\"type\":\"el-slider\",\"label\":\"底边距(像素)\",\"name\":\"marginBottom\",\"required\":false,\"placeholder\":\"\",\"value\":10}]},{\"name\":\"图例操作\",\"list\":[{\"type\":\"el-switch\",\"label\":\"图例\",\"name\":\"isShowLegend\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lengedColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"lengedFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":16},{\"type\":\"el-input-number\",\"label\":\"图例宽度\",\"name\":\"lengedWidth\",\"required\":false,\"placeholder\":\"\",\"value\":15},{\"type\":\"el-select\",\"label\":\"横向位置\",\"name\":\"lateralPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"纵向位置\",\"name\":\"longitudinalPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"top\",\"name\":\"顶部\"},{\"code\":\"bottom\",\"name\":\"底部\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"布局前置\",\"name\":\"layoutFront\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"vertical\",\"name\":\"竖排\"},{\"code\":\"horizontal\",\"name\":\"横排\"}],\"value\":\"\"}]},{\"name\":\"自定义配色\",\"list\":[{\"type\":\"customColor\",\"label\":\"\",\"name\":\"customColor\",\"required\":false,\"value\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}]}]}]],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":692},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":828},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":456},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":184}]}', NULL, 1, 0, 13, 'admin', '2021-07-02 16:10:09', 'admin', '2021-07-02 16:10:09', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('car_ajreport', 'widget-barchart', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":true,\"reversalX\":true,\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"退货排名\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"\",\"marginBottom\":10,\"layerName\":\"柱状图\",\"hideX\":true,\"verticalShow\":true,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"http://10.108.26.197/business/file/download/adfc22ac-ed7f-4141-aeb9-ee81f16ac92d\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{\"dynamicData\":{\"chartProperties\":{\"brand\":\"xAxis\",\"nums\":\"bar\"},\"setCode\":\"car_ajreturn\",\"chartType\":\"widget-barchart\",\"contextData\":{}},\"dataType\":\"dynamicData\",\"refreshTime\":50000,\"staticData\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1000,2229,3879,2379,4079]}]}\"}', '', '{\"top\":818,\"left\":1321,\"width\":442,\"index\":12,\"height\":188}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"dynamicData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":50000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1000,2229,3879,2379,4079]}]}\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"chartType\":\"widget-barchart\",\"value\":{\"chartProperties\":{\"brand\":\"xAxis\",\"nums\":\"bar\"},\"setCode\":\"car_ajreturn\",\"chartType\":\"widget-barchart\",\"contextData\":{}}}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"柱状图\"},{\"type\":\"el-switch\",\"label\":\"竖展示\",\"name\":\"verticalShow\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},[{\"name\":\"柱体设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"最大宽度\",\"name\":\"maxWidth\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"圆角\",\"name\":\"radius\",\"require\":false,\"placeholder\":\"\",\"value\":5},{\"type\":\"el-slider\",\"label\":\"最小高度\",\"name\":\"minHeight\",\"require\":false,\"placeholder\":\"\",\"value\":0}]},{\"name\":\"标题设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标题\",\"name\":\"isNoTitle\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-text\",\"label\":\"标题\",\"name\":\"titleText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"textColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#FFD700\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"textFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"textFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20},{\"type\":\"el-select\",\"label\":\"字体位置\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"},{\"type\":\"el-input-text\",\"label\":\"副标题\",\"name\":\"subText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字体粗细\",\"name\":\"subTextFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"subTextFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20}]},{\"name\":\"X轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"xName\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"hideX\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"xNameColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"xNameFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-slider\",\"label\":\"文字角度\",\"name\":\"textAngle\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-input-number\",\"label\":\"文字间隔\",\"name\":\"textInterval\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalX\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"Xcolor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeX\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineX\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"Y轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"textNameY\",\"require\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShowY\",\"require\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"NameColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"NameFontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalY\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"colorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineY\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"数值设定\",\"list\":[{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShow\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":14},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"}]},{\"name\":\"提示语设置\",\"list\":[{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lineColor\",\"required\":false,\"placeholder\":\"\"}]},{\"name\":\"坐标轴边距设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"左边距(像素)\",\"name\":\"marginLeft\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"顶边距(像素)\",\"name\":\"marginTop\",\"required\":false,\"placeholder\":\"\",\"value\":50},{\"type\":\"el-slider\",\"label\":\"右边距(像素)\",\"name\":\"marginRight\",\"required\":false,\"placeholder\":\"\",\"value\":40},{\"type\":\"el-slider\",\"label\":\"底边距(像素)\",\"name\":\"marginBottom\",\"required\":false,\"placeholder\":\"\",\"value\":10}]},{\"name\":\"图例操作\",\"list\":[{\"type\":\"el-switch\",\"label\":\"图例\",\"name\":\"isShowLegend\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lengedColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"lengedFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":16},{\"type\":\"el-input-number\",\"label\":\"图例宽度\",\"name\":\"lengedWidth\",\"required\":false,\"placeholder\":\"\",\"value\":15},{\"type\":\"el-select\",\"label\":\"横向位置\",\"name\":\"lateralPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"纵向位置\",\"name\":\"longitudinalPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"top\",\"name\":\"顶部\"},{\"code\":\"bottom\",\"name\":\"底部\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"布局前置\",\"name\":\"layoutFront\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"vertical\",\"name\":\"竖排\"},{\"code\":\"horizontal\",\"name\":\"横排\"}],\"value\":\"\"}]},{\"name\":\"自定义配色\",\"list\":[{\"type\":\"customColor\",\"label\":\"\",\"name\":\"customColor\",\"required\":false,\"value\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}]}]}]],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":1321},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":818},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":442},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":188}]}', NULL, 1, 0, 14, 'admin', '2021-07-02 16:10:09', 'admin', '2021-07-02 16:10:09', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('car_ajreport', 'widget-text', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"reversalX\":\"\",\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"汽车生产销售大屏\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"rgba(115,170,229,.0)\",\"fontSize\":50,\"marginBottom\":10,\"layerName\":\"文本框\",\"hideX\":true,\"verticalShow\":false,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"http://10.108.26.197/business/file/download/adfc22ac-ed7f-4141-aeb9-ee81f16ac92d\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":false,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":30,\"left\":718,\"width\":406,\"index\":7,\"height\":75}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"文本框\"},{\"type\":\"el-input-text\",\"label\":\"文本内容\",\"name\":\"text\",\"required\":false,\"placeholder\":\"\",\"value\":\"汽车生产销售大屏\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":50},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"color\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(0, 206, 209, 1)\"},{\"type\":\"el-input-number\",\"label\":\"字体间距\",\"name\":\"letterSpacing\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体背景\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(115,170,229,.0)\"},{\"type\":\"el-select\",\"label\":\"文字粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-select\",\"label\":\"对齐方式\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":718},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":30},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":406},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":75}]}', NULL, 1, 0, 15, 'admin', '2021-07-02 16:10:09', 'admin', '2021-07-02 16:10:09', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('car_ajreport', 'widget-text', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"reversalX\":\"\",\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"生产趋势\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"rgba(115,170,229,.0)\",\"fontSize\":26,\"marginBottom\":10,\"layerName\":\"文本框\",\"hideX\":true,\"verticalShow\":false,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"http://10.108.26.197/business/file/download/adfc22ac-ed7f-4141-aeb9-ee81f16ac92d\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":false,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":172,\"left\":320,\"width\":230,\"index\":13,\"height\":46}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"文本框\"},{\"type\":\"el-input-text\",\"label\":\"文本内容\",\"name\":\"text\",\"required\":false,\"placeholder\":\"\",\"value\":\"生产趋势\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":26},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"color\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(0, 206, 209, 1)\"},{\"type\":\"el-input-number\",\"label\":\"字体间距\",\"name\":\"letterSpacing\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体背景\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(115,170,229,.0)\"},{\"type\":\"el-select\",\"label\":\"文字粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-select\",\"label\":\"对齐方式\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":320},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":172},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":230},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":46}]}', NULL, 1, 0, 16, 'admin', '2021-07-02 16:10:09', 'admin', '2021-07-02 16:10:09', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('car_ajreport', 'widget-text', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"reversalX\":\"\",\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"销售趋势\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"rgba(115,170,229,.0)\",\"fontSize\":26,\"marginBottom\":10,\"layerName\":\"文本框\",\"hideX\":true,\"verticalShow\":false,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"http://10.108.26.197/business/file/download/adfc22ac-ed7f-4141-aeb9-ee81f16ac92d\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":false,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":488,\"left\":1328,\"width\":139,\"index\":13,\"height\":40}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"文本框\"},{\"type\":\"el-input-text\",\"label\":\"文本内容\",\"name\":\"text\",\"required\":false,\"placeholder\":\"\",\"value\":\"销售趋势\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":26},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"color\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(0, 206, 209, 1)\"},{\"type\":\"el-input-number\",\"label\":\"字体间距\",\"name\":\"letterSpacing\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体背景\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(115,170,229,.0)\"},{\"type\":\"el-select\",\"label\":\"文字粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-select\",\"label\":\"对齐方式\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":1328},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":488},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":139},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":40}]}', NULL, 1, 0, 17, 'admin', '2021-07-02 16:10:09', 'admin', '2021-07-02 16:10:09', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('car_ajreport', 'widget-text', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"reversalX\":\"\",\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"生产TOP5\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"rgba(115,170,229,.0)\",\"fontSize\":26,\"marginBottom\":10,\"layerName\":\"文本框\",\"hideX\":true,\"verticalShow\":false,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"http://10.108.26.197/business/file/download/adfc22ac-ed7f-4141-aeb9-ee81f16ac92d\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":false,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":493,\"left\":343,\"width\":157,\"index\":15,\"height\":40}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"文本框\"},{\"type\":\"el-input-text\",\"label\":\"文本内容\",\"name\":\"text\",\"required\":false,\"placeholder\":\"\",\"value\":\"生产TOP5\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":26},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"color\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(0, 206, 209, 1)\"},{\"type\":\"el-input-number\",\"label\":\"字体间距\",\"name\":\"letterSpacing\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体背景\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(115,170,229,.0)\"},{\"type\":\"el-select\",\"label\":\"文字粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-select\",\"label\":\"对齐方式\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":343},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":493},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":157},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":40}]}', NULL, 1, 0, 18, 'admin', '2021-07-02 16:10:09', 'admin', '2021-07-02 16:10:09', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('car_ajreport', 'widget-text', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"reversalX\":\"\",\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"销售TOP5\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"rgba(115,170,229,.0)\",\"fontSize\":26,\"marginBottom\":10,\"layerName\":\"文本框\",\"hideX\":true,\"verticalShow\":false,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"http://10.108.26.197/business/file/download/adfc22ac-ed7f-4141-aeb9-ee81f16ac92d\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":false,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":160,\"left\":1286,\"width\":131,\"index\":16,\"height\":40}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"文本框\"},{\"type\":\"el-input-text\",\"label\":\"文本内容\",\"name\":\"text\",\"required\":false,\"placeholder\":\"\",\"value\":\"销售TOP5\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":26},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"color\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(0, 206, 209, 1)\"},{\"type\":\"el-input-number\",\"label\":\"字体间距\",\"name\":\"letterSpacing\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体背景\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(115,170,229,.0)\"},{\"type\":\"el-select\",\"label\":\"文字粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-select\",\"label\":\"对齐方式\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":1286},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":160},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":131},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":40}]}', NULL, 1, 0, 19, 'admin', '2021-07-02 16:10:09', 'admin', '2021-07-02 16:10:09', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('car_ajreport', 'widget-text', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"reversalX\":\"\",\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"滞销排名\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"rgba(115,170,229,.0)\",\"fontSize\":26,\"marginBottom\":10,\"layerName\":\"文本框\",\"hideX\":true,\"verticalShow\":false,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"http://10.108.26.197/business/file/download/adfc22ac-ed7f-4141-aeb9-ee81f16ac92d\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":false,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":792,\"left\":241,\"width\":139,\"index\":19,\"height\":40}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"文本框\"},{\"type\":\"el-input-text\",\"label\":\"文本内容\",\"name\":\"text\",\"required\":false,\"placeholder\":\"\",\"value\":\"滞销排名\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":26},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"color\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(0, 206, 209, 1)\"},{\"type\":\"el-input-number\",\"label\":\"字体间距\",\"name\":\"letterSpacing\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体背景\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(115,170,229,.0)\"},{\"type\":\"el-select\",\"label\":\"文字粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-select\",\"label\":\"对齐方式\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":241},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":792},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":139},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":40}]}', NULL, 1, 0, 20, 'admin', '2021-07-02 16:10:09', 'admin', '2021-07-02 16:10:09', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('car_ajreport', 'widget-text', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"reversalX\":\"\",\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"返修排名\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"rgba(115,170,229,.0)\",\"fontSize\":26,\"marginBottom\":10,\"layerName\":\"文本框\",\"hideX\":true,\"verticalShow\":false,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"http://10.108.26.197/business/file/download/adfc22ac-ed7f-4141-aeb9-ee81f16ac92d\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":false,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":791,\"left\":824,\"width\":166,\"index\":20,\"height\":40}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"文本框\"},{\"type\":\"el-input-text\",\"label\":\"文本内容\",\"name\":\"text\",\"required\":false,\"placeholder\":\"\",\"value\":\"返修排名\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":26},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"color\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(0, 206, 209, 1)\"},{\"type\":\"el-input-number\",\"label\":\"字体间距\",\"name\":\"letterSpacing\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体背景\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(115,170,229,.0)\"},{\"type\":\"el-select\",\"label\":\"文字粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-select\",\"label\":\"对齐方式\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":824},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":791},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":166},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":40}]}', NULL, 1, 0, 21, 'admin', '2021-07-02 16:10:09', 'admin', '2021-07-02 16:10:09', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('car_ajreport', 'widget-text', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"reversalX\":\"\",\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"退货排名\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"rgba(115,170,229,.0)\",\"fontSize\":26,\"marginBottom\":10,\"layerName\":\"文本框\",\"hideX\":true,\"verticalShow\":false,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"http://10.108.26.197/business/file/download/adfc22ac-ed7f-4141-aeb9-ee81f16ac92d\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":false,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":792,\"left\":1456,\"width\":167,\"index\":21,\"height\":40}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"文本框\"},{\"type\":\"el-input-text\",\"label\":\"文本内容\",\"name\":\"text\",\"required\":false,\"placeholder\":\"\",\"value\":\"退货排名\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":26},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"color\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(0, 206, 209, 1)\"},{\"type\":\"el-input-number\",\"label\":\"字体间距\",\"name\":\"letterSpacing\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体背景\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(115,170,229,.0)\"},{\"type\":\"el-select\",\"label\":\"文字粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-select\",\"label\":\"对齐方式\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":1456},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":792},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":167},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":40}]}', NULL, 1, 0, 22, 'admin', '2021-07-02 16:10:09', 'admin', '2021-07-02 16:10:09', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('blank', 'widget-barchart', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"reversalX\":\"\",\"minHeight\":0,\"marginRight\":40,\"textInterval\":\"\",\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"radius\":5,\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"maxWidth\":10,\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"\",\"marginBottom\":10,\"layerName\":\"柱状图\",\"hideX\":true,\"verticalShow\":false,\"NameColorY\":\"#fff\",\"isShowSplitLineX\":false,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"fontSizeY\":12,\"fontSizeX\":12,\"colorY\":\"#fff\",\"NameFontSizeY\":12,\"isShow\":false,\"textFontSize\":20,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"isShowLegend\":true,\"marginTop\":50}', '{\"dataType\":\"staticData\",\"refreshTime\":5000,\"staticData\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1000,2229,3879,2379,4079]}]}\"}', '', '{\"top\":168,\"left\":202,\"width\":400,\"index\":0,\"height\":200}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"staticData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":5000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1000,2229,3879,2379,4079]}]}\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"chartType\":\"widget-barchart\",\"value\":\"\"}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"柱状图\"},{\"type\":\"el-switch\",\"label\":\"竖展示\",\"name\":\"verticalShow\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},[{\"name\":\"柱体设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"最大宽度\",\"name\":\"maxWidth\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"圆角\",\"name\":\"radius\",\"require\":false,\"placeholder\":\"\",\"value\":5},{\"type\":\"el-slider\",\"label\":\"最小高度\",\"name\":\"minHeight\",\"require\":false,\"placeholder\":\"\",\"value\":0}]},{\"name\":\"标题设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标题\",\"name\":\"isNoTitle\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-text\",\"label\":\"标题\",\"name\":\"titleText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"textColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#FFD700\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"textFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"textFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20},{\"type\":\"el-select\",\"label\":\"字体位置\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"},{\"type\":\"el-input-text\",\"label\":\"副标题\",\"name\":\"subText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字体粗细\",\"name\":\"subTextFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"subTextFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20}]},{\"name\":\"X轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"xName\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"hideX\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"xNameColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"xNameFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-slider\",\"label\":\"文字角度\",\"name\":\"textAngle\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-input-number\",\"label\":\"文字间隔\",\"name\":\"textInterval\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalX\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"Xcolor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeX\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineX\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"Y轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"textNameY\",\"require\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShowY\",\"require\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"NameColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"NameFontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalY\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"colorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineY\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"数值设定\",\"list\":[{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShow\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":14},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"}]},{\"name\":\"提示语设置\",\"list\":[{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lineColor\",\"required\":false,\"placeholder\":\"\"}]},{\"name\":\"坐标轴边距设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"左边距(像素)\",\"name\":\"marginLeft\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"顶边距(像素)\",\"name\":\"marginTop\",\"required\":false,\"placeholder\":\"\",\"value\":50},{\"type\":\"el-slider\",\"label\":\"右边距(像素)\",\"name\":\"marginRight\",\"required\":false,\"placeholder\":\"\",\"value\":40},{\"type\":\"el-slider\",\"label\":\"底边距(像素)\",\"name\":\"marginBottom\",\"required\":false,\"placeholder\":\"\",\"value\":10}]},{\"name\":\"图例操作\",\"list\":[{\"type\":\"el-switch\",\"label\":\"图例\",\"name\":\"isShowLegend\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lengedColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"lengedFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":16},{\"type\":\"el-input-number\",\"label\":\"图例宽度\",\"name\":\"lengedWidth\",\"required\":false,\"placeholder\":\"\",\"value\":15},{\"type\":\"el-select\",\"label\":\"横向位置\",\"name\":\"lateralPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"纵向位置\",\"name\":\"longitudinalPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"top\",\"name\":\"顶部\"},{\"code\":\"bottom\",\"name\":\"底部\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"布局前置\",\"name\":\"layoutFront\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"vertical\",\"name\":\"竖排\"},{\"code\":\"horizontal\",\"name\":\"横排\"}],\"value\":\"\"}]},{\"name\":\"自定义配色\",\"list\":[{\"type\":\"customColor\",\"label\":\"\",\"name\":\"customColor\",\"required\":false,\"value\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}]}]}]],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":202},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":168},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":400},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":200}]}', NULL, 1, 0, 1, 'admin', '2021-07-02 16:39:27', 'admin', '2021-07-02 16:39:27', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('blank', 'widget-map', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"barEnd\":\"#004DA7FF\",\"reversalX\":\"\",\"minHeight\":0,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"radius\":5,\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"textAlign\":\"center\",\"subTextColor\":\"#90979c\",\"textColor\":\"#fff\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"barStart\":\"#00F4FFFF\",\"subTextFontSize\":20,\"background\":\"\",\"marginBottom\":10,\"layerName\":\"地图完善中\",\"hideX\":true,\"videoAdress\":\"http://vd3.bdstatic.com/mda-mc9pbaqbdzd5hw41/mda-mc9pbaqbdzd5hw41.mp4?playlist=%5B%22hd%22%2C%22sc%22%5D\",\"verticalShow\":false,\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"NameFontSizeY\":12,\"isShow\":false,\"textFontSize\":22,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":208,\"left\":738,\"width\":836,\"index\":1,\"height\":565}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"地图完善中\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":738},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":208},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":836},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":565}]}', NULL, 1, 0, 2, 'admin', '2021-07-02 16:39:27', 'admin', '2021-07-02 16:39:27', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('blank', 'widget-gradient-color-barchart', '{\"NameColorY\":\"#fff\",\"isShowSplitLineX\":false,\"reversalY\":false,\"barEnd\":\"#004DA7FF\",\"reversalX\":\"\",\"isShowSplitLineY\":false,\"marginRight\":40,\"textInterval\":\"\",\"splitLineColorY\":\"#fff\",\"isNoTitle\":true,\"splitLineColorX\":\"#fff\",\"textFontWeight\":\"normal\",\"titleText\":\"\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xName\":\"\",\"isShowY\":true,\"xNameColor\":\"#fff\",\"fontSizeY\":12,\"fontSizeX\":12,\"textAlign\":\"center\",\"colorY\":\"#fff\",\"subTextColor\":\"#90979c\",\"textColor\":\"#fff\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"NameFontSizeY\":12,\"marginLeft\":10,\"textFontSize\":22,\"barStart\":\"#00F4FFFF\",\"subTextFontSize\":20,\"subTextFontWeight\":\"normal\",\"background\":\"\",\"marginBottom\":10,\"layerName\":\"柱状图\",\"hideX\":true,\"marginTop\":50}', '{\"dataType\":\"staticData\",\"refreshTime\":5000,\"staticData\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1000,2229,3879,2379,4079]}]}\"}', '', '{\"top\":633,\"left\":187,\"width\":400,\"index\":2,\"height\":200}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"staticData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":5000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1000,2229,3879,2379,4079]}]}\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"chartType\":\"widget-barchart\",\"value\":\"\"}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"柱状图\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},[{\"name\":\"标题设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标题\",\"name\":\"isNoTitle\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-text\",\"label\":\"标题\",\"name\":\"titleText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"textColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"textFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"textFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":22},{\"type\":\"el-select\",\"label\":\"字体位置\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"},{\"type\":\"el-input-text\",\"label\":\"副标题\",\"name\":\"subText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#90979c\"},{\"type\":\"el-input-text\",\"label\":\"字体粗细\",\"name\":\"subTextFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"subTextFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20}]},{\"name\":\"X轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"xName\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"hideX\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"xNameColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"xNameFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-slider\",\"label\":\"文字角度\",\"name\":\"textAngle\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-input-number\",\"label\":\"文字间隔\",\"name\":\"textInterval\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalX\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"Xcolor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeX\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineX\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"Y轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"textNameY\",\"require\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShowY\",\"require\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"NameColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"NameFontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalY\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"colorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineY\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"坐标轴边距设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"左边距(像素)\",\"name\":\"marginLeft\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"顶边距(像素)\",\"name\":\"marginTop\",\"required\":false,\"placeholder\":\"\",\"value\":50},{\"type\":\"el-slider\",\"label\":\"右边距(像素)\",\"name\":\"marginRight\",\"required\":false,\"placeholder\":\"\",\"value\":40},{\"type\":\"el-slider\",\"label\":\"底边距(像素)\",\"name\":\"marginBottom\",\"required\":false,\"placeholder\":\"\",\"value\":10}]},{\"name\":\"渐变色\",\"list\":[{\"type\":\"vue-color\",\"label\":\"0%处\",\"name\":\"barStart\",\"required\":false,\"placeholder\":\"\",\"value\":\"#00F4FFFF\"},{\"type\":\"vue-color\",\"label\":\"100%处\",\"name\":\"barEnd\",\"required\":false,\"placeholder\":\"\",\"value\":\"#004DA7FF\"}]}]],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":187},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":633},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":400},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":200}]}', NULL, 1, 0, 3, 'admin', '2021-07-02 16:39:27', 'admin', '2021-07-02 16:39:27', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logn_ajreport', 'widget-image', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"barEnd\":\"#004DA7FF\",\"reversalX\":\"\",\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"percentage\":true,\"startRotate\":false,\"layoutFront\":\"\",\"text\":\"日志大屏\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"imageAdress\":\"https://report.anji-plus.com/file/download/title2\",\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"barStart\":\"#00F4FFFF\",\"subTextFontSize\":20,\"borderRadius\":0,\"transparency\":100,\"fontSize\":60,\"marginBottom\":10,\"layerName\":\"图片\",\"hideX\":true,\"verticalShow\":true,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"numberValue\":false,\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"},{\"color\":\"#F2B1B1\"},{\"color\":\"#E4DAA5\"},{\"color\":\"#AAE8AA\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":0,\"left\":7,\"width\":1873,\"index\":19,\"height\":131}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"图片\"},{\"type\":\"el-switch\",\"label\":\"开启旋转\",\"name\":\"startRotate\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-slider\",\"label\":\"透明度\",\"name\":\"transparency\",\"required\":false,\"placeholder\":\"\",\"value\":100},{\"type\":\"el-input-number\",\"label\":\"圆角\",\"name\":\"borderRadius\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"custom-upload\",\"label\":\"图片地址\",\"name\":\"imageAdress\",\"required\":false,\"placeholder\":\"\",\"value\":\"https://report.anji-plus.com/file/download/title2\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":7},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":0},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":1873},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":131}]}', NULL, 1, 0, 1, 'admin', '2021-07-02 17:14:57', 'admin', '2021-07-02 17:14:57', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logn_ajreport', 'widget-image', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"left\",\"reversalY\":false,\"barEnd\":\"#004DA7FF\",\"reversalX\":false,\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":false,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"percentage\":true,\"startRotate\":false,\"layoutFront\":\"\",\"text\":\"文本框\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"imageAdress\":\"https://report.anji-plus.com/file/download/border2@2x\",\"textAlign\":\"center\",\"lineColor\":\"\",\"subTextColor\":\"#fff\",\"textColor\":\"##FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"barStart\":\"#00F4FFFF\",\"subTextFontSize\":20,\"borderRadius\":0,\"transparency\":100,\"fontSize\":26,\"marginBottom\":10,\"layerName\":\"图片\",\"hideX\":true,\"verticalShow\":true,\"color\":\"#FAD400\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"numberValue\":false,\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#1E90FF\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":133,\"left\":632,\"width\":620,\"index\":19,\"height\":440}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"图片\"},{\"type\":\"el-switch\",\"label\":\"开启旋转\",\"name\":\"startRotate\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-slider\",\"label\":\"透明度\",\"name\":\"transparency\",\"required\":false,\"placeholder\":\"\",\"value\":100},{\"type\":\"el-input-number\",\"label\":\"圆角\",\"name\":\"borderRadius\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"custom-upload\",\"label\":\"图片地址\",\"name\":\"imageAdress\",\"required\":false,\"placeholder\":\"\",\"value\":\"https://report.anji-plus.com/file/download/border2@2x\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":632},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":133},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":620},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":440}]}', NULL, 1, 0, 2, 'admin', '2021-07-02 17:14:57', 'admin', '2021-07-02 17:14:57', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logn_ajreport', 'widget-image', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"barEnd\":\"#004DA7FF\",\"reversalX\":\"\",\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"percentage\":true,\"startRotate\":false,\"layoutFront\":\"\",\"text\":\"日志大屏\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"imageAdress\":\"https://report.anji-plus.com/file/download/border3@2x\",\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"barStart\":\"#00F4FFFF\",\"subTextFontSize\":20,\"borderRadius\":0,\"transparency\":100,\"fontSize\":60,\"marginBottom\":10,\"layerName\":\"图片\",\"hideX\":true,\"verticalShow\":true,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"numberValue\":false,\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"},{\"color\":\"#F2B1B1\"},{\"color\":\"#E4DAA5\"},{\"color\":\"#AAE8AA\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":593,\"left\":4,\"width\":620,\"index\":19,\"height\":450}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"图片\"},{\"type\":\"el-switch\",\"label\":\"开启旋转\",\"name\":\"startRotate\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-slider\",\"label\":\"透明度\",\"name\":\"transparency\",\"required\":false,\"placeholder\":\"\",\"value\":100},{\"type\":\"el-input-number\",\"label\":\"圆角\",\"name\":\"borderRadius\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"custom-upload\",\"label\":\"图片地址\",\"name\":\"imageAdress\",\"required\":false,\"placeholder\":\"\",\"value\":\"https://report.anji-plus.com/file/download/border3@2x\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":4},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":593},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":620},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":450}]}', NULL, 1, 0, 3, 'admin', '2021-07-02 17:14:57', 'admin', '2021-07-02 17:14:57', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logn_ajreport', 'widget-image', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"barEnd\":\"#004DA7FF\",\"reversalX\":\"\",\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"percentage\":true,\"startRotate\":false,\"layoutFront\":\"\",\"text\":\"日志大屏\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"imageAdress\":\"https://report.anji-plus.com/file/download/border3@2x\",\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"barStart\":\"#00F4FFFF\",\"subTextFontSize\":20,\"borderRadius\":0,\"transparency\":100,\"fontSize\":60,\"marginBottom\":10,\"layerName\":\"图片\",\"hideX\":true,\"verticalShow\":true,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"numberValue\":false,\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"},{\"color\":\"#F2B1B1\"},{\"color\":\"#E4DAA5\"},{\"color\":\"#AAE8AA\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":590,\"left\":1261,\"width\":620,\"index\":1,\"height\":450}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"图片\"},{\"type\":\"el-switch\",\"label\":\"开启旋转\",\"name\":\"startRotate\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-slider\",\"label\":\"透明度\",\"name\":\"transparency\",\"required\":false,\"placeholder\":\"\",\"value\":100},{\"type\":\"el-input-number\",\"label\":\"圆角\",\"name\":\"borderRadius\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"custom-upload\",\"label\":\"图片地址\",\"name\":\"imageAdress\",\"required\":false,\"placeholder\":\"\",\"value\":\"https://report.anji-plus.com/file/download/border3@2x\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":1261},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":590},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":620},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":450}]}', NULL, 1, 0, 4, 'admin', '2021-07-02 17:14:57', 'admin', '2021-07-02 17:14:57', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logn_ajreport', 'widget-image', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"left\",\"reversalY\":false,\"barEnd\":\"#004DA7FF\",\"reversalX\":false,\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":false,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"percentage\":true,\"startRotate\":false,\"layoutFront\":\"\",\"text\":\"文本框\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"imageAdress\":\"https://report.anji-plus.com/file/download/border2@2x\",\"textAlign\":\"center\",\"lineColor\":\"\",\"subTextColor\":\"#fff\",\"textColor\":\"##FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"barStart\":\"#00F4FFFF\",\"subTextFontSize\":20,\"borderRadius\":0,\"transparency\":100,\"fontSize\":26,\"marginBottom\":10,\"layerName\":\"图片\",\"hideX\":true,\"verticalShow\":true,\"color\":\"#FAD400\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"numberValue\":false,\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#1E90FF\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":594,\"left\":633,\"width\":620,\"index\":3,\"height\":450}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"图片\"},{\"type\":\"el-switch\",\"label\":\"开启旋转\",\"name\":\"startRotate\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-slider\",\"label\":\"透明度\",\"name\":\"transparency\",\"required\":false,\"placeholder\":\"\",\"value\":100},{\"type\":\"el-input-number\",\"label\":\"圆角\",\"name\":\"borderRadius\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"custom-upload\",\"label\":\"图片地址\",\"name\":\"imageAdress\",\"required\":false,\"placeholder\":\"\",\"value\":\"https://report.anji-plus.com/file/download/border2@2x\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":633},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":594},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":620},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":450}]}', NULL, 1, 0, 5, 'admin', '2021-07-02 17:14:57', 'admin', '2021-07-02 17:14:57', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logn_ajreport', 'widget-image', '{\"color\":\"#FAD400\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"lengedColor\":\"#fff\",\"lateralPosition\":\"right\",\"title\":\"大屏\",\"isNoTitle\":true,\"lengedFontSize\":20,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"percentage\":true,\"startRotate\":false,\"layoutFront\":\"\",\"text\":\"文本框\",\"numberValue\":false,\"fontWeight\":\"normal\",\"lengedWidth\":10,\"height\":1080,\"imageAdress\":\"https://report.anji-plus.com/file/download/border@2x\",\"backgroundColor\":\"#000\",\"textAlign\":\"left\",\"letterSpacing\":0,\"lineColor\":\"\",\"subTextColor\":\"\",\"textColor\":\"\",\"subText\":\"\",\"isShow\":true,\"textFontSize\":20,\"subTextFontSize\":0,\"customColor\":[{\"color\":\"#0CD2E6\"},{\"color\":\"#00BFA5\"},{\"color\":\"#FFC722\"},{\"color\":\"#886EFF\"},{\"color\":\"#008DEC\"}],\"longitudinalPosition\":\"\",\"borderRadius\":0,\"subTextFontWeight\":\"normal\",\"transparency\":100,\"width\":1920,\"isShowLegend\":true,\"fontSize\":0,\"layerName\":\"图片\"}', '{}', '', '{\"top\":134,\"left\":5,\"width\":620,\"index\":1,\"height\":440}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"图片\"},{\"type\":\"el-switch\",\"label\":\"开启旋转\",\"name\":\"startRotate\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-slider\",\"label\":\"透明度\",\"name\":\"transparency\",\"required\":false,\"placeholder\":\"\",\"value\":100},{\"type\":\"el-input-number\",\"label\":\"圆角\",\"name\":\"borderRadius\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"custom-upload\",\"label\":\"图片地址\",\"name\":\"imageAdress\",\"required\":false,\"placeholder\":\"\",\"value\":\"https://report.anji-plus.com/file/download/border@2x\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":5},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":134},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":620},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":440}]}', NULL, 1, 0, 6, 'admin', '2021-07-02 17:14:57', 'admin', '2021-07-02 17:14:57', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logn_ajreport', 'widget-image', '{\"color\":\"#FAD400\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"lengedColor\":\"#fff\",\"lateralPosition\":\"right\",\"title\":\"大屏\",\"isNoTitle\":true,\"lengedFontSize\":20,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"percentage\":true,\"startRotate\":false,\"layoutFront\":\"\",\"text\":\"文本框\",\"numberValue\":false,\"fontWeight\":\"normal\",\"lengedWidth\":10,\"height\":1080,\"imageAdress\":\"https://report.anji-plus.com/file/download/border@2x\",\"backgroundColor\":\"#000\",\"textAlign\":\"left\",\"letterSpacing\":0,\"lineColor\":\"\",\"subTextColor\":\"\",\"textColor\":\"\",\"subText\":\"\",\"isShow\":true,\"textFontSize\":20,\"subTextFontSize\":0,\"customColor\":[{\"color\":\"#0CD2E6\"},{\"color\":\"#00BFA5\"},{\"color\":\"#FFC722\"},{\"color\":\"#886EFF\"},{\"color\":\"#008DEC\"}],\"longitudinalPosition\":\"\",\"borderRadius\":0,\"subTextFontWeight\":\"normal\",\"transparency\":100,\"width\":1920,\"isShowLegend\":true,\"fontSize\":0,\"layerName\":\"图片\"}', '{}', '', '{\"top\":134,\"left\":1264,\"width\":620,\"index\":1,\"height\":440}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"图片\"},{\"type\":\"el-switch\",\"label\":\"开启旋转\",\"name\":\"startRotate\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-slider\",\"label\":\"透明度\",\"name\":\"transparency\",\"required\":false,\"placeholder\":\"\",\"value\":100},{\"type\":\"el-input-number\",\"label\":\"圆角\",\"name\":\"borderRadius\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"custom-upload\",\"label\":\"图片地址\",\"name\":\"imageAdress\",\"required\":false,\"placeholder\":\"\",\"value\":\"https://report.anji-plus.com/file/download/border@2x\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":1264},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":134},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":620},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":440}]}', NULL, 1, 0, 7, 'admin', '2021-07-02 17:14:57', 'admin', '2021-07-02 17:14:57', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logn_ajreport', 'widget-hollow-piechart', '{\"color\":\"#FAD400\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"lengedColor\":\"#fff\",\"lateralPosition\":\"right\",\"title\":\"大屏\",\"isNoTitle\":true,\"lengedFontSize\":20,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"percentage\":true,\"layoutFront\":\"\",\"text\":\"文本框\",\"numberValue\":false,\"fontWeight\":\"normal\",\"lengedWidth\":10,\"height\":1080,\"backgroundColor\":\"#000\",\"textAlign\":\"left\",\"letterSpacing\":0,\"lineColor\":\"\",\"subTextColor\":\"\",\"textColor\":\"\",\"subText\":\"\",\"isShow\":true,\"textFontSize\":20,\"subTextFontSize\":0,\"customColor\":[{\"color\":\"#0CD2E6\"},{\"color\":\"#00BFA5\"},{\"color\":\"#FFC722\"},{\"color\":\"#886EFF\"},{\"color\":\"#008DEC\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"background\":\"\",\"width\":1920,\"isShowLegend\":true,\"fontSize\":0,\"layerName\":\"空心饼图\"}', '{\"dynamicData\":{\"chartProperties\":{\"device_type\":\"name\",\"nums\":\"value\"},\"setCode\":\"log_ajdevices\",\"chartType\":\"widget-hollow-piechart\",\"contextData\":{}},\"dataType\":\"dynamicData\",\"refreshTime\":50000,\"staticData\":\"[{\\\"value\\\": 1048,\\\"name\\\": \\\"搜索引擎\\\"},{\\\"value\\\": 735, \\\"name\\\": \\\"直接访问\\\"},{\\\"value\\\": 580, \\\"name\\\": \\\"邮件营销\\\"},{\\\"value\\\": 484,\\\"name\\\":\\\"联盟广告\\\"},{\\\"value\\\":300,\\\"name\\\":\\\"视频广告\\\"}]\"}', '', '{\"top\":199,\"left\":8,\"width\":610,\"index\":3,\"height\":360}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"dynamicData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":50000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"[{\\\"value\\\": 1048,\\\"name\\\": \\\"搜索引擎\\\"},{\\\"value\\\": 735, \\\"name\\\": \\\"直接访问\\\"},{\\\"value\\\": 580, \\\"name\\\": \\\"邮件营销\\\"},{\\\"value\\\": 484,\\\"name\\\":\\\"联盟广告\\\"},{\\\"value\\\":300,\\\"name\\\":\\\"视频广告\\\"}]\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"chartType\":\"widget-hollow-piechart\",\"relactiveDomValue\":\"dynamicData\",\"value\":{\"chartProperties\":{\"device_type\":\"name\",\"nums\":\"value\"},\"setCode\":\"log_ajdevices\",\"chartType\":\"widget-hollow-piechart\",\"contextData\":{}}}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"空心饼图\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},[{\"name\":\"标题设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标题\",\"name\":\"isNoTitle\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-text\",\"label\":\"标题\",\"name\":\"titleText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"textColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"textFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"textFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20},{\"type\":\"el-select\",\"label\":\"字体位置\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"left\"},{\"type\":\"el-input-text\",\"label\":\"副标题\",\"name\":\"subText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"subTextFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"subTextFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":0}]},{\"name\":\"数值设定\",\"list\":[{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShow\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-switch\",\"label\":\"数值\",\"name\":\"numberValue\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-switch\",\"label\":\"百分比\",\"name\":\"percentage\",\"require\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"}]},{\"name\":\"提示语设置\",\"list\":[{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"网格线颜色\",\"name\":\"lineColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"}]},{\"name\":\"图例操作\",\"list\":[{\"type\":\"el-switch\",\"label\":\"图例\",\"name\":\"isShowLegend\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lengedColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"lengedFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20},{\"type\":\"el-input-number\",\"label\":\"图例宽度\",\"name\":\"lengedWidth\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-select\",\"label\":\"横向位置\",\"name\":\"lateralPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"right\"},{\"type\":\"el-select\",\"label\":\"纵向位置\",\"name\":\"longitudinalPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"top\",\"name\":\"顶部\"},{\"code\":\"bottom\",\"name\":\"底部\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"布局前置\",\"name\":\"layoutFront\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"vertical\",\"name\":\"竖排\"},{\"code\":\"horizontal\",\"name\":\"横排\"}],\"value\":\"\"}]},{\"name\":\"自定义配色\",\"list\":[{\"type\":\"customColor\",\"label\":\"\",\"name\":\"customColor\",\"required\":false,\"value\":[{\"color\":\"#0CD2E6\"},{\"color\":\"#00BFA5\"},{\"color\":\"#FFC722\"},{\"color\":\"#886EFF\"},{\"color\":\"#008DEC\"}]}]}]],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":8},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":199},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":610},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":360}]}', NULL, 1, 0, 8, 'admin', '2021-07-02 17:14:57', 'admin', '2021-07-02 17:14:57', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logn_ajreport', 'widget-text', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"right\",\"reversalY\":false,\"barEnd\":\"#004DA7FF\",\"reversalX\":false,\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"percentage\":true,\"layoutFront\":\"\",\"text\":\"资产统计\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"center\",\"lineColor\":\"\",\"subTextColor\":\"\",\"textColor\":\"\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"barStart\":\"#00F4FFFF\",\"subTextFontSize\":0,\"background\":\"rgba(115,170,229,.0)\",\"fontSize\":30,\"marginBottom\":10,\"layerName\":\"文本框\",\"hideX\":true,\"verticalShow\":true,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":20,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"numberValue\":false,\"xNameColor\":\"#fff\",\"lengedWidth\":10,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#0CD2E6\"},{\"color\":\"#00BFA5\"},{\"color\":\"#FFC722\"},{\"color\":\"#886EFF\"},{\"color\":\"#008DEC\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":143,\"left\":222,\"width\":200,\"index\":8,\"height\":50}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"文本框\"},{\"type\":\"el-input-text\",\"label\":\"文本内容\",\"name\":\"text\",\"required\":false,\"placeholder\":\"\",\"value\":\"资产统计\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":30},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"color\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(0, 206, 209, 1)\"},{\"type\":\"el-input-number\",\"label\":\"字体间距\",\"name\":\"letterSpacing\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体背景\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(115,170,229,.0)\"},{\"type\":\"el-select\",\"label\":\"文字粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-select\",\"label\":\"对齐方式\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":222},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":143},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":200},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":50}]}', NULL, 1, 0, 9, 'admin', '2021-07-02 17:14:57', 'admin', '2021-07-02 17:14:57', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logn_ajreport', 'widget-gradient-color-barchart', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"left\",\"reversalY\":false,\"barEnd\":\"#004DA7FF\",\"reversalX\":false,\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"center\",\"lineColor\":\"\",\"subTextColor\":\"#90979c\",\"textColor\":\"#fff\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"barStart\":\"#00F4FFFF\",\"subTextFontSize\":20,\"background\":\"\",\"fontSize\":0,\"marginBottom\":10,\"layerName\":\"柱状图\",\"hideX\":true,\"verticalShow\":false,\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":15,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":false,\"textFontSize\":22,\"pointSize\":10,\"customColor\":[{\"color\":\"#1E90FF\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{\"dynamicData\":{\"chartProperties\":{\"acl_type\":\"xAxis\",\"nums\":\"bar\"},\"setCode\":\"log_ajfireacl\",\"chartType\":\"widget-barchart\",\"contextData\":{}},\"dataType\":\"dynamicData\",\"refreshTime\":50000,\"staticData\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1000,2229,3879,2379,4079]}]}\"}', '', '{\"top\":200,\"left\":640,\"width\":610,\"index\":4,\"height\":360}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"dynamicData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":50000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1000,2229,3879,2379,4079]}]}\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"chartType\":\"widget-barchart\",\"value\":{\"chartProperties\":{\"acl_type\":\"xAxis\",\"nums\":\"bar\"},\"setCode\":\"log_ajfireacl\",\"chartType\":\"widget-barchart\",\"contextData\":{}}}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"柱状图\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},[{\"name\":\"标题设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标题\",\"name\":\"isNoTitle\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-text\",\"label\":\"标题\",\"name\":\"titleText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"textColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"textFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"textFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":22},{\"type\":\"el-select\",\"label\":\"字体位置\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"},{\"type\":\"el-input-text\",\"label\":\"副标题\",\"name\":\"subText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#90979c\"},{\"type\":\"el-input-text\",\"label\":\"字体粗细\",\"name\":\"subTextFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"subTextFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20}]},{\"name\":\"X轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"xName\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"hideX\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"xNameColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"xNameFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-slider\",\"label\":\"文字角度\",\"name\":\"textAngle\",\"required\":false,\"placeholder\":\"\",\"value\":15},{\"type\":\"el-input-number\",\"label\":\"文字间隔\",\"name\":\"textInterval\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalX\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"Xcolor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeX\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineX\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"Y轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"textNameY\",\"require\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShowY\",\"require\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"NameColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"NameFontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalY\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"colorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineY\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"坐标轴边距设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"左边距(像素)\",\"name\":\"marginLeft\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"顶边距(像素)\",\"name\":\"marginTop\",\"required\":false,\"placeholder\":\"\",\"value\":50},{\"type\":\"el-slider\",\"label\":\"右边距(像素)\",\"name\":\"marginRight\",\"required\":false,\"placeholder\":\"\",\"value\":40},{\"type\":\"el-slider\",\"label\":\"底边距(像素)\",\"name\":\"marginBottom\",\"required\":false,\"placeholder\":\"\",\"value\":10}]},{\"name\":\"渐变色\",\"list\":[{\"type\":\"vue-color\",\"label\":\"0%处\",\"name\":\"barStart\",\"required\":false,\"placeholder\":\"\",\"value\":\"#00F4FFFF\"},{\"type\":\"vue-color\",\"label\":\"100%处\",\"name\":\"barEnd\",\"required\":false,\"placeholder\":\"\",\"value\":\"#004DA7FF\"}]}]],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":640},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":200},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":610},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":360}]}', NULL, 1, 0, 10, 'admin', '2021-07-02 17:14:57', 'admin', '2021-07-02 17:14:57', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logn_ajreport', 'widget-barchart', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"barEnd\":\"#004DA7FF\",\"reversalX\":\"\",\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"barStart\":\"#00F4FFFF\",\"subTextFontSize\":20,\"background\":\"\",\"marginBottom\":10,\"layerName\":\"柱状图\",\"hideX\":true,\"verticalShow\":true,\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":3,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"pointSize\":5,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"},{\"color\":\"#F2B1B1\"},{\"color\":\"#E4DAA5\"},{\"color\":\"#AAE8AA\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{\"dynamicData\":{\"chartProperties\":{\"attack_type\":\"xAxis\",\"nums\":\"bar\"},\"setCode\":\"log_ajattack\",\"chartType\":\"widget-barchart\",\"contextData\":{}},\"dataType\":\"dynamicData\",\"refreshTime\":5000,\"staticData\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1000,2229,3879,2379,4079]}]}\"}', '', '{\"top\":203,\"left\":1270,\"width\":610,\"index\":5,\"height\":360}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"dynamicData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":5000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1000,2229,3879,2379,4079]}]}\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"chartType\":\"widget-barchart\",\"value\":{\"chartProperties\":{\"attack_type\":\"xAxis\",\"nums\":\"bar\"},\"setCode\":\"log_ajattack\",\"chartType\":\"widget-barchart\",\"contextData\":{}}}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"柱状图\"},{\"type\":\"el-switch\",\"label\":\"竖展示\",\"name\":\"verticalShow\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},[{\"name\":\"柱体设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"最大宽度\",\"name\":\"maxWidth\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"圆角\",\"name\":\"radius\",\"require\":false,\"placeholder\":\"\",\"value\":5},{\"type\":\"el-slider\",\"label\":\"最小高度\",\"name\":\"minHeight\",\"require\":false,\"placeholder\":\"\",\"value\":0}]},{\"name\":\"标题设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标题\",\"name\":\"isNoTitle\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-text\",\"label\":\"标题\",\"name\":\"titleText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"textColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#FFD700\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"textFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"textFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20},{\"type\":\"el-select\",\"label\":\"字体位置\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"},{\"type\":\"el-input-text\",\"label\":\"副标题\",\"name\":\"subText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字体粗细\",\"name\":\"subTextFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"subTextFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20}]},{\"name\":\"X轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"xName\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"hideX\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"xNameColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"xNameFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-slider\",\"label\":\"文字角度\",\"name\":\"textAngle\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-input-number\",\"label\":\"文字间隔\",\"name\":\"textInterval\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalX\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"Xcolor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeX\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineX\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"Y轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"textNameY\",\"require\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShowY\",\"require\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"NameColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"NameFontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalY\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"colorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineY\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"数值设定\",\"list\":[{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShow\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":14},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"}]},{\"name\":\"提示语设置\",\"list\":[{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lineColor\",\"required\":false,\"placeholder\":\"\"}]},{\"name\":\"坐标轴边距设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"左边距(像素)\",\"name\":\"marginLeft\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"顶边距(像素)\",\"name\":\"marginTop\",\"required\":false,\"placeholder\":\"\",\"value\":50},{\"type\":\"el-slider\",\"label\":\"右边距(像素)\",\"name\":\"marginRight\",\"required\":false,\"placeholder\":\"\",\"value\":40},{\"type\":\"el-slider\",\"label\":\"底边距(像素)\",\"name\":\"marginBottom\",\"required\":false,\"placeholder\":\"\",\"value\":10}]},{\"name\":\"图例操作\",\"list\":[{\"type\":\"el-switch\",\"label\":\"图例\",\"name\":\"isShowLegend\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lengedColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"lengedFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":16},{\"type\":\"el-input-number\",\"label\":\"图例宽度\",\"name\":\"lengedWidth\",\"required\":false,\"placeholder\":\"\",\"value\":15},{\"type\":\"el-select\",\"label\":\"横向位置\",\"name\":\"lateralPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"纵向位置\",\"name\":\"longitudinalPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"top\",\"name\":\"顶部\"},{\"code\":\"bottom\",\"name\":\"底部\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"布局前置\",\"name\":\"layoutFront\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"vertical\",\"name\":\"竖排\"},{\"code\":\"horizontal\",\"name\":\"横排\"}],\"value\":\"\"}]},{\"name\":\"自定义配色\",\"list\":[{\"type\":\"customColor\",\"label\":\"\",\"name\":\"customColor\",\"required\":false,\"value\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"},{\"color\":\"#F2B1B1\"},{\"color\":\"#E4DAA5\"},{\"color\":\"#AAE8AA\"}]}]}]],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":1270},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":203},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":610},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":360}]}', NULL, 1, 0, 11, 'admin', '2021-07-02 17:14:57', 'admin', '2021-07-02 17:14:57', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logn_ajreport', 'widget-barchart', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":true,\"barEnd\":\"#004DA7FF\",\"reversalX\":false,\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"percentage\":true,\"startRotate\":false,\"layoutFront\":\"\",\"text\":\"资产统计\",\"xName\":\"\",\"isShowY\":true,\"radius\":15,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":27,\"area\":true,\"imageAdress\":\"https://report.anji-plus.com/file/download/border@2x\",\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"barStart\":\"#00F4FFFF\",\"subTextFontSize\":20,\"borderRadius\":0,\"background\":\"\",\"transparency\":100,\"marginBottom\":10,\"layerName\":\"柱状图\",\"hideX\":true,\"color\":\"#FAD400\",\"verticalShow\":true,\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":3,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"lengedFontSize\":16,\"areaThickness\":5,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"numberValue\":false,\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"fontSizeY\":12,\"smoothCurve\":true,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"NameFontSizeY\":12,\"markPoint\":true,\"isShow\":true,\"textFontSize\":20,\"pointSize\":5,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{\"dynamicData\":{\"chartProperties\":{\"nums\":\"bar\",\"username\":\"xAxis\"},\"setCode\":\"log_ajmailfailtop5\",\"chartType\":\"widget-barchart\",\"contextData\":{}},\"dataType\":\"dynamicData\",\"refreshTime\":50000,\"staticData\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1000,2229,3879,2379,4079]}]}\"}', '', '{\"top\":673,\"left\":7,\"width\":610,\"index\":8,\"height\":370}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"dynamicData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":50000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1000,2229,3879,2379,4079]}]}\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"chartType\":\"widget-barchart\",\"value\":{\"chartProperties\":{\"nums\":\"bar\",\"username\":\"xAxis\"},\"setCode\":\"log_ajmailfailtop5\",\"chartType\":\"widget-barchart\",\"contextData\":{}}}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"柱状图\"},{\"type\":\"el-switch\",\"label\":\"竖展示\",\"name\":\"verticalShow\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},[{\"name\":\"柱体设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"最大宽度\",\"name\":\"maxWidth\",\"required\":false,\"placeholder\":\"\",\"value\":27},{\"type\":\"el-slider\",\"label\":\"圆角\",\"name\":\"radius\",\"require\":false,\"placeholder\":\"\",\"value\":15},{\"type\":\"el-slider\",\"label\":\"最小高度\",\"name\":\"minHeight\",\"require\":false,\"placeholder\":\"\",\"value\":0}]},{\"name\":\"标题设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标题\",\"name\":\"isNoTitle\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-text\",\"label\":\"标题\",\"name\":\"titleText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"textColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#FFD700\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"textFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"textFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20},{\"type\":\"el-select\",\"label\":\"字体位置\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"},{\"type\":\"el-input-text\",\"label\":\"副标题\",\"name\":\"subText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字体粗细\",\"name\":\"subTextFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"subTextFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20}]},{\"name\":\"X轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"xName\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"hideX\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"xNameColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"xNameFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-slider\",\"label\":\"文字角度\",\"name\":\"textAngle\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-input-number\",\"label\":\"文字间隔\",\"name\":\"textInterval\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalX\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"Xcolor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeX\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineX\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"Y轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"textNameY\",\"require\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShowY\",\"require\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"NameColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"NameFontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalY\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"colorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineY\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"数值设定\",\"list\":[{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShow\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":14},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"}]},{\"name\":\"提示语设置\",\"list\":[{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lineColor\",\"required\":false,\"placeholder\":\"\"}]},{\"name\":\"坐标轴边距设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"左边距(像素)\",\"name\":\"marginLeft\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"顶边距(像素)\",\"name\":\"marginTop\",\"required\":false,\"placeholder\":\"\",\"value\":50},{\"type\":\"el-slider\",\"label\":\"右边距(像素)\",\"name\":\"marginRight\",\"required\":false,\"placeholder\":\"\",\"value\":40},{\"type\":\"el-slider\",\"label\":\"底边距(像素)\",\"name\":\"marginBottom\",\"required\":false,\"placeholder\":\"\",\"value\":10}]},{\"name\":\"图例操作\",\"list\":[{\"type\":\"el-switch\",\"label\":\"图例\",\"name\":\"isShowLegend\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lengedColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"lengedFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":16},{\"type\":\"el-input-number\",\"label\":\"图例宽度\",\"name\":\"lengedWidth\",\"required\":false,\"placeholder\":\"\",\"value\":15},{\"type\":\"el-select\",\"label\":\"横向位置\",\"name\":\"lateralPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"纵向位置\",\"name\":\"longitudinalPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"top\",\"name\":\"顶部\"},{\"code\":\"bottom\",\"name\":\"底部\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"布局前置\",\"name\":\"layoutFront\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"vertical\",\"name\":\"竖排\"},{\"code\":\"horizontal\",\"name\":\"横排\"}],\"value\":\"\"}]},{\"name\":\"自定义配色\",\"list\":[{\"type\":\"customColor\",\"label\":\"\",\"name\":\"customColor\",\"required\":false,\"value\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}]}]}]],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":7},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":673},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":610},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":370}]}', NULL, 1, 0, 12, 'admin', '2021-07-02 17:14:57', 'admin', '2021-07-02 17:14:57', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logn_ajreport', 'widget-linechart', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"left\",\"reversalY\":false,\"barEnd\":\"#004DA7FF\",\"reversalX\":false,\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":false,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"percentage\":true,\"layoutFront\":\"\",\"text\":\"文本框\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"center\",\"lineColor\":\"\",\"subTextColor\":\"#fff\",\"textColor\":\"##FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"barStart\":\"#00F4FFFF\",\"subTextFontSize\":20,\"background\":\"\",\"fontSize\":0,\"marginBottom\":10,\"layerName\":\"折线图\",\"hideX\":true,\"verticalShow\":true,\"color\":\"#FAD400\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"numberValue\":false,\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#1E90FF\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{\"dynamicData\":{\"chartProperties\":{\"date\":\"xAxis\",\"nums\":\"line\"},\"setCode\":\"log_ajmailfail\",\"chartType\":\"widget-linechart\",\"contextData\":{}},\"dataType\":\"dynamicData\",\"refreshTime\":50000,\"staticData\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1009,3409,2309,5409,3409]}]}\"}', '', '{\"top\":673,\"left\":638,\"width\":610,\"index\":9,\"height\":370}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"dynamicData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":50000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1009,3409,2309,5409,3409]}]}\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"chartType\":\"widget-linechart\",\"relactiveDomValue\":\"dynamicData\",\"value\":{\"chartProperties\":{\"date\":\"xAxis\",\"nums\":\"line\"},\"setCode\":\"log_ajmailfail\",\"chartType\":\"widget-linechart\",\"contextData\":{}}}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"折线图\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},[{\"name\":\"折线设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标记点\",\"name\":\"markPoint\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-slider\",\"label\":\"点大小\",\"name\":\"pointSize\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-switch\",\"label\":\"平滑曲线\",\"name\":\"smoothCurve\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-switch\",\"label\":\"面积堆积\",\"name\":\"area\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-slider\",\"label\":\"面积厚度\",\"name\":\"areaThickness\",\"required\":false,\"placeholder\":\"\",\"value\":5},{\"type\":\"el-slider\",\"label\":\"线条宽度\",\"name\":\"lineWidth\",\"required\":false,\"placeholder\":\"\",\"value\":4}]},{\"name\":\"标题设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标题\",\"name\":\"isNoTitle\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-input-text\",\"label\":\"标题\",\"name\":\"titleText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"textColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"##FFD700\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"textFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"textFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20},{\"type\":\"el-select\",\"label\":\"字体位置\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"},{\"type\":\"el-input-text\",\"label\":\"副标题\",\"name\":\"subText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"subTextFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"subTextFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20}]},{\"name\":\"X轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"xName\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"hideX\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"xNameColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"xNameFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-slider\",\"label\":\"文字角度\",\"name\":\"textAngle\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-input-number\",\"label\":\"文字间隔\",\"name\":\"textInterval\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalX\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"Xcolor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字号\",\"name\":\"fontSizeX\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineX\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"Y轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"textNameY\",\"require\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShowY\",\"require\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"NameColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字体大小\",\"name\":\"NameFontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalY\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"colorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字号\",\"name\":\"fontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineY\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"数值设定\",\"list\":[{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShow\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"}]},{\"name\":\"提示语设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lineColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"}]},{\"name\":\"坐标轴边距设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"左边距(像素)\",\"name\":\"marginLeft\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"顶边距(像素)\",\"name\":\"marginTop\",\"required\":false,\"placeholder\":\"\",\"value\":50},{\"type\":\"el-slider\",\"label\":\"右边距(像素)\",\"name\":\"marginRight\",\"required\":false,\"placeholder\":\"\",\"value\":40},{\"type\":\"el-slider\",\"label\":\"底边距(像素)\",\"name\":\"marginBottom\",\"required\":false,\"placeholder\":\"\",\"value\":10}]},{\"name\":\"图例操作\",\"list\":[{\"type\":\"el-switch\",\"label\":\"图例\",\"name\":\"isShowLegend\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lengedColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"lengedFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":16},{\"type\":\"el-input-number\",\"label\":\"图例宽度\",\"name\":\"lengedWidth\",\"required\":false,\"placeholder\":\"\",\"value\":15},{\"type\":\"el-select\",\"label\":\"横向位置\",\"name\":\"lateralPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"left\"},{\"type\":\"el-select\",\"label\":\"纵向位置\",\"name\":\"longitudinalPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"top\",\"name\":\"顶部\"},{\"code\":\"bottom\",\"name\":\"底部\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"布局前置\",\"name\":\"layoutFront\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"vertical\",\"name\":\"竖排\"},{\"code\":\"horizontal\",\"name\":\"横排\"}],\"value\":\"\"}]},{\"name\":\"自定义配色\",\"list\":[{\"type\":\"customColor\",\"label\":\"\",\"name\":\"customColor\",\"required\":false,\"value\":[{\"color\":\"#1E90FF\"}]}]}]],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":638},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":673},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":610},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":370}]}', NULL, 1, 0, 13, 'admin', '2021-07-02 17:14:57', 'admin', '2021-07-02 17:14:57', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logn_ajreport', 'widget-barlinechart', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":0,\"barEnd\":\"#004DA7FF\",\"reversalX\":0,\"marginRight\":40,\"minHeight\":0,\"textInterval\":1,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"percentage\":true,\"layoutFront\":\"\",\"text\":\"文本框\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"left\",\"lineColor\":\"#fff\",\"subTextColor\":\"#fff\",\"textColor\":\"#fff\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"barStart\":\"#00F4FFFF\",\"subTextFontSize\":20,\"background\":\"\",\"fontSize\":12,\"marginBottom\":10,\"layerName\":\"柱线图\",\"hideX\":true,\"verticalShow\":true,\"color\":\"#FAD400\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":3,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"numberValue\":false,\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":16,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"pointSize\":5,\"customColor\":[{\"color\":\"#EDAC94\"},{\"color\":\"#90EE90\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{\"dynamicData\":{\"chartProperties\":{\"fail\":\"line\",\"datetime\":\"xAxis\",\"success\":\"bar\"},\"setCode\":\"log_ajwifiamount\",\"chartType\":\"widget-barlinechart\",\"contextData\":{}},\"dataType\":\"dynamicData\",\"refreshTime\":50000,\"staticData\":\"{\\\"xAxis\\\": [\\\"1月\\\", \\\"2月\\\", \\\"3月\\\", \\\"4月\\\", \\\"5月\\\",\\\"6月\\\", \\\"7月\\\", \\\"8月\\\",\\\"9月\\\",\\\"10月\\\",\\\"11月\\\",\\\"12月\\\"],\\\"series\\\": [{\\\"type\\\": \\\"bar\\\",\\\"name\\\": \\\"货运量\\\",\\\"data\\\": [2.6,5.9,9,26.4,28.7,70.7,175.6,182.2,48.7,18.8,6,2.3]},{\\\"type\\\": \\\"line\\\",\\\"name\\\": \\\"货运总量\\\",\\\"yAxisIndex\\\": 1,\\\"data\\\": [2,2.2,3.3,4.5,6.3,10.2,20.3,23.4,23,16.5,12,6.2]}]}\"}', '', '{\"top\":675,\"left\":1272,\"width\":610,\"index\":7,\"height\":360}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"dynamicData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":50000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"{\\\"xAxis\\\": [\\\"1月\\\", \\\"2月\\\", \\\"3月\\\", \\\"4月\\\", \\\"5月\\\",\\\"6月\\\", \\\"7月\\\", \\\"8月\\\",\\\"9月\\\",\\\"10月\\\",\\\"11月\\\",\\\"12月\\\"],\\\"series\\\": [{\\\"type\\\": \\\"bar\\\",\\\"name\\\": \\\"货运量\\\",\\\"data\\\": [2.6,5.9,9,26.4,28.7,70.7,175.6,182.2,48.7,18.8,6,2.3]},{\\\"type\\\": \\\"line\\\",\\\"name\\\": \\\"货运总量\\\",\\\"yAxisIndex\\\": 1,\\\"data\\\": [2,2.2,3.3,4.5,6.3,10.2,20.3,23.4,23,16.5,12,6.2]}]}\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"chartType\":\"widget-barlinechart\",\"relactiveDomValue\":\"dynamicData\",\"value\":{\"chartProperties\":{\"fail\":\"line\",\"datetime\":\"xAxis\",\"success\":\"bar\"},\"setCode\":\"log_ajwifiamount\",\"chartType\":\"widget-barlinechart\",\"contextData\":{}}}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"柱线图\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},[{\"name\":\"折线设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标记点\",\"name\":\"markPoint\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-slider\",\"label\":\"点大小\",\"name\":\"pointSize\",\"required\":false,\"placeholder\":\"\",\"value\":5},{\"type\":\"el-switch\",\"label\":\"平滑曲线\",\"name\":\"smoothCurve\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-switch\",\"label\":\"面积堆积\",\"name\":\"area\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-slider\",\"label\":\"面积厚度\",\"name\":\"areaThickness\",\"required\":false,\"placeholder\":\"\",\"value\":5},{\"type\":\"el-slider\",\"label\":\"线条宽度\",\"name\":\"lineWidth\",\"required\":false,\"placeholder\":\"\",\"value\":3}]},{\"name\":\"柱体设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"最大宽度\",\"name\":\"maxWidth\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"圆角\",\"name\":\"radius\",\"require\":false,\"placeholder\":\"\",\"value\":5},{\"type\":\"el-slider\",\"label\":\"最小高度\",\"name\":\"minHeight\",\"require\":false,\"placeholder\":\"\",\"value\":0}]},{\"name\":\"标题设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标题\",\"name\":\"isNoTitle\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-text\",\"label\":\"标题\",\"name\":\"titleText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"textColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"textFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"textFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20},{\"type\":\"el-select\",\"label\":\"字体位置\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"left\"},{\"type\":\"el-input-text\",\"label\":\"副标题\",\"name\":\"subText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"subTextFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"subTextFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20}]},{\"name\":\"X轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"xName\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"hideX\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"xNameColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"xNameFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-slider\",\"label\":\"文字角度\",\"name\":\"textAngle\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-input-number\",\"label\":\"文字间隔\",\"name\":\"textInterval\",\"required\":false,\"placeholder\":\"\",\"value\":1},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalX\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"Xcolor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeX\",\"required\":false,\"placeholder\":\"\",\"value\":16},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineX\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"Y轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"textNameY\",\"require\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShowY\",\"require\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"NameColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"NameFontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalY\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"colorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineY\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"提示语设置\",\"list\":[{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lineColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"坐标轴边距设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"左边距(像素)\",\"name\":\"marginLeft\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"顶边距(像素)\",\"name\":\"marginTop\",\"required\":false,\"placeholder\":\"\",\"value\":50},{\"type\":\"el-slider\",\"label\":\"右边距(像素)\",\"name\":\"marginRight\",\"required\":false,\"placeholder\":\"\",\"value\":40},{\"type\":\"el-slider\",\"label\":\"底边距(像素)\",\"name\":\"marginBottom\",\"required\":false,\"placeholder\":\"\",\"value\":10}]},{\"name\":\"图例操作\",\"list\":[{\"type\":\"el-switch\",\"label\":\"图例\",\"name\":\"isShowLegend\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lengedColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字体大小\",\"name\":\"lengedFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":16},{\"type\":\"el-input-number\",\"label\":\"图例宽度\",\"name\":\"lengedWidth\",\"required\":false,\"placeholder\":\"\",\"value\":15},{\"type\":\"el-select\",\"label\":\"横向位置\",\"name\":\"lateralPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"纵向位置\",\"name\":\"longitudinalPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"top\",\"name\":\"顶部\"},{\"code\":\"bottom\",\"name\":\"底部\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"布局前置\",\"name\":\"layoutFront\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"vertical\",\"name\":\"竖排\"},{\"code\":\"horizontal\",\"name\":\"横排\"}],\"value\":\"\"}]},{\"name\":\"自定义配色\",\"list\":[{\"type\":\"customColor\",\"label\":\"\",\"name\":\"customColor\",\"required\":false,\"value\":[{\"color\":\"#EDAC94\"},{\"color\":\"#90EE90\"}]}]}]],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":1272},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":675},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":610},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":360}]}', NULL, 1, 0, 14, 'admin', '2021-07-02 17:14:57', 'admin', '2021-07-02 17:14:57', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logn_ajreport', 'widget-text', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"right\",\"reversalY\":false,\"barEnd\":\"#004DA7FF\",\"reversalX\":false,\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"percentage\":true,\"layoutFront\":\"\",\"text\":\"邮件认证失败TOP5\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"center\",\"lineColor\":\"\",\"subTextColor\":\"\",\"textColor\":\"\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"barStart\":\"#00F4FFFF\",\"subTextFontSize\":0,\"background\":\"rgba(115,170,229,.0)\",\"fontSize\":30,\"marginBottom\":10,\"layerName\":\"文本框\",\"hideX\":true,\"verticalShow\":true,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":20,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"numberValue\":false,\"xNameColor\":\"#fff\",\"lengedWidth\":10,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#0CD2E6\"},{\"color\":\"#00BFA5\"},{\"color\":\"#FFC722\"},{\"color\":\"#886EFF\"},{\"color\":\"#008DEC\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":620,\"left\":173,\"width\":267,\"index\":11,\"height\":50}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"文本框\"},{\"type\":\"el-input-text\",\"label\":\"文本内容\",\"name\":\"text\",\"required\":false,\"placeholder\":\"\",\"value\":\"邮件认证失败TOP5\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":30},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"color\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(0, 206, 209, 1)\"},{\"type\":\"el-input-number\",\"label\":\"字体间距\",\"name\":\"letterSpacing\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体背景\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(115,170,229,.0)\"},{\"type\":\"el-select\",\"label\":\"文字粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-select\",\"label\":\"对齐方式\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":173},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":620},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":267},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":50}]}', NULL, 1, 0, 15, 'admin', '2021-07-02 17:14:57', 'admin', '2021-07-02 17:14:57', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logn_ajreport', 'widget-text', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"right\",\"reversalY\":false,\"barEnd\":\"#004DA7FF\",\"reversalX\":false,\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"percentage\":true,\"layoutFront\":\"\",\"text\":\"防火墙ACL次数\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"center\",\"lineColor\":\"\",\"subTextColor\":\"\",\"textColor\":\"\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"barStart\":\"#00F4FFFF\",\"subTextFontSize\":0,\"background\":\"rgba(115,170,229,.0)\",\"fontSize\":30,\"marginBottom\":10,\"layerName\":\"文本框\",\"hideX\":true,\"verticalShow\":true,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":20,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"numberValue\":false,\"xNameColor\":\"#fff\",\"lengedWidth\":10,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#0CD2E6\"},{\"color\":\"#00BFA5\"},{\"color\":\"#FFC722\"},{\"color\":\"#886EFF\"},{\"color\":\"#008DEC\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":138,\"left\":809,\"width\":233,\"index\":9,\"height\":50}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"文本框\"},{\"type\":\"el-input-text\",\"label\":\"文本内容\",\"name\":\"text\",\"required\":false,\"placeholder\":\"\",\"value\":\"防火墙ACL次数\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":30},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"color\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(0, 206, 209, 1)\"},{\"type\":\"el-input-number\",\"label\":\"字体间距\",\"name\":\"letterSpacing\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体背景\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(115,170,229,.0)\"},{\"type\":\"el-select\",\"label\":\"文字粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-select\",\"label\":\"对齐方式\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":809},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":138},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":233},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":50}]}', NULL, 1, 0, 16, 'admin', '2021-07-02 17:14:57', 'admin', '2021-07-02 17:14:57', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logn_ajreport', 'widget-text', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"right\",\"reversalY\":false,\"barEnd\":\"#004DA7FF\",\"reversalX\":false,\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"percentage\":true,\"layoutFront\":\"\",\"text\":\"攻击占比\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"center\",\"lineColor\":\"\",\"subTextColor\":\"\",\"textColor\":\"\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"barStart\":\"#00F4FFFF\",\"subTextFontSize\":0,\"background\":\"rgba(115,170,229,.0)\",\"fontSize\":30,\"marginBottom\":10,\"layerName\":\"文本框\",\"hideX\":true,\"verticalShow\":true,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":20,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"numberValue\":false,\"xNameColor\":\"#fff\",\"lengedWidth\":10,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#0CD2E6\"},{\"color\":\"#00BFA5\"},{\"color\":\"#FFC722\"},{\"color\":\"#886EFF\"},{\"color\":\"#008DEC\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":141,\"left\":1512,\"width\":200,\"index\":10,\"height\":50}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"文本框\"},{\"type\":\"el-input-text\",\"label\":\"文本内容\",\"name\":\"text\",\"required\":false,\"placeholder\":\"\",\"value\":\"攻击占比\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":30},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"color\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(0, 206, 209, 1)\"},{\"type\":\"el-input-number\",\"label\":\"字体间距\",\"name\":\"letterSpacing\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体背景\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(115,170,229,.0)\"},{\"type\":\"el-select\",\"label\":\"文字粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-select\",\"label\":\"对齐方式\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":1512},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":141},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":200},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":50}]}', NULL, 1, 0, 17, 'admin', '2021-07-02 17:14:57', 'admin', '2021-07-02 17:14:57', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logn_ajreport', 'widget-text', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"right\",\"reversalY\":false,\"barEnd\":\"#004DA7FF\",\"reversalX\":false,\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"percentage\":true,\"layoutFront\":\"\",\"text\":\"邮件认证失败趋势\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"center\",\"lineColor\":\"\",\"subTextColor\":\"\",\"textColor\":\"\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"barStart\":\"#00F4FFFF\",\"subTextFontSize\":0,\"background\":\"rgba(115,170,229,.0)\",\"fontSize\":26,\"marginBottom\":10,\"layerName\":\"文本框\",\"hideX\":true,\"verticalShow\":true,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":20,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"numberValue\":false,\"xNameColor\":\"#fff\",\"lengedWidth\":10,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#0CD2E6\"},{\"color\":\"#00BFA5\"},{\"color\":\"#FFC722\"},{\"color\":\"#886EFF\"},{\"color\":\"#008DEC\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":602,\"left\":788,\"width\":300,\"index\":14,\"height\":50}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"文本框\"},{\"type\":\"el-input-text\",\"label\":\"文本内容\",\"name\":\"text\",\"required\":false,\"placeholder\":\"\",\"value\":\"邮件认证失败趋势\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":26},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"color\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(0, 206, 209, 1)\"},{\"type\":\"el-input-number\",\"label\":\"字体间距\",\"name\":\"letterSpacing\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体背景\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(115,170,229,.0)\"},{\"type\":\"el-select\",\"label\":\"文字粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-select\",\"label\":\"对齐方式\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":788},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":602},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":300},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":50}]}', NULL, 1, 0, 18, 'admin', '2021-07-02 17:14:57', 'admin', '2021-07-02 17:14:57', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logn_ajreport', 'widget-text', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"left\",\"reversalY\":false,\"barEnd\":\"#004DA7FF\",\"reversalX\":false,\"marginRight\":40,\"minHeight\":0,\"textInterval\":0,\"isNoTitle\":false,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"percentage\":true,\"layoutFront\":\"\",\"text\":\"wifi登陆趋势\",\"xName\":\"\",\"isShowY\":true,\"radius\":5,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"center\",\"lineColor\":\"\",\"subTextColor\":\"#fff\",\"textColor\":\"##FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"barStart\":\"#00F4FFFF\",\"subTextFontSize\":20,\"background\":\"rgba(115,170,229,.0)\",\"fontSize\":30,\"marginBottom\":10,\"layerName\":\"文本框\",\"hideX\":true,\"verticalShow\":true,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":4,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"numberValue\":false,\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":12,\"backgroundColor\":\"#000\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"pointSize\":10,\"customColor\":[{\"color\":\"#1E90FF\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":606,\"left\":1422,\"width\":300,\"index\":15,\"height\":50}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"文本框\"},{\"type\":\"el-input-text\",\"label\":\"文本内容\",\"name\":\"text\",\"required\":false,\"placeholder\":\"\",\"value\":\"wifi登陆趋势\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":30},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"color\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(0, 206, 209, 1)\"},{\"type\":\"el-input-number\",\"label\":\"字体间距\",\"name\":\"letterSpacing\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体背景\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(115,170,229,.0)\"},{\"type\":\"el-select\",\"label\":\"文字粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-select\",\"label\":\"对齐方式\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":1422},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":606},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":300},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":50}]}', NULL, 1, 0, 19, 'admin', '2021-07-02 17:14:57', 'admin', '2021-07-02 17:14:57', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logn_ajreport', 'widget-text', '{\"imageAdress\":\"https://report.anji-plus.com/file/download/title2\",\"backgroundColor\":\"#000\",\"color\":\"rgba(30, 144, 255, 1)\",\"textAlign\":\"center\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"letterSpacing\":0,\"title\":\"大屏\",\"borderRadius\":0,\"background\":\"rgba(115,170,229,.0)\",\"startRotate\":false,\"transparency\":100,\"width\":1920,\"fontSize\":60,\"layerName\":\"文本框\",\"text\":\"日志大屏\",\"fontWeight\":\"normal\",\"height\":1080}', '{}', '', '{\"top\":26,\"left\":771,\"width\":300,\"index\":19,\"height\":80}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"文本框\"},{\"type\":\"el-input-text\",\"label\":\"文本内容\",\"name\":\"text\",\"required\":false,\"placeholder\":\"\",\"value\":\"日志大屏\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":60},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"color\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(30, 144, 255, 1)\"},{\"type\":\"el-input-number\",\"label\":\"字体间距\",\"name\":\"letterSpacing\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体背景\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(115,170,229,.0)\"},{\"type\":\"el-select\",\"label\":\"文字粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-select\",\"label\":\"对齐方式\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":771},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":26},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":300},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":80}]}', NULL, 1, 0, 20, 'admin', '2021-07-02 17:14:57', 'admin', '2021-07-02 17:14:57', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logistics_one', 'widget-image', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"reversalX\":false,\"minHeight\":5,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"startRotate\":false,\"layoutFront\":\"\",\"radius\":9,\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":18,\"imageAdress\":\"https://report.anji-plus.com/file/download/border3@2x\",\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"borderRadius\":0,\"transparency\":100,\"marginBottom\":10,\"layerName\":\"图片\",\"hideX\":true,\"verticalShow\":true,\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"fontSizeY\":16,\"fontSizeX\":18,\"backgroundColor\":\"\",\"colorY\":\"#fff\",\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":729,\"left\":5,\"width\":530,\"index\":0,\"height\":345}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"图片\"},{\"type\":\"el-switch\",\"label\":\"开启旋转\",\"name\":\"startRotate\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-slider\",\"label\":\"透明度\",\"name\":\"transparency\",\"required\":false,\"placeholder\":\"\",\"value\":100},{\"type\":\"el-input-number\",\"label\":\"圆角\",\"name\":\"borderRadius\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"custom-upload\",\"label\":\"图片地址\",\"name\":\"imageAdress\",\"required\":false,\"placeholder\":\"\",\"value\":\"https://report.anji-plus.com/file/download/border3@2x\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":5},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":729},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":530},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":345}]}', NULL, 1, 0, 1, 'admin', '2021-07-15 17:40:33', 'admin', '2021-07-15 17:40:33', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logistics_one', 'widget-image', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"reversalX\":false,\"minHeight\":5,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"startRotate\":false,\"layoutFront\":\"\",\"radius\":9,\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":18,\"imageAdress\":\"https://report.anji-plus.com/file/download/border3@2x\",\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"borderRadius\":0,\"transparency\":100,\"marginBottom\":10,\"layerName\":\"图片\",\"hideX\":true,\"verticalShow\":true,\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"fontSizeY\":16,\"fontSizeX\":18,\"backgroundColor\":\"\",\"colorY\":\"#fff\",\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":368,\"left\":5,\"width\":530,\"index\":0,\"height\":355}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"图片\"},{\"type\":\"el-switch\",\"label\":\"开启旋转\",\"name\":\"startRotate\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-slider\",\"label\":\"透明度\",\"name\":\"transparency\",\"required\":false,\"placeholder\":\"\",\"value\":100},{\"type\":\"el-input-number\",\"label\":\"圆角\",\"name\":\"borderRadius\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"custom-upload\",\"label\":\"图片地址\",\"name\":\"imageAdress\",\"required\":false,\"placeholder\":\"\",\"value\":\"https://report.anji-plus.com/file/download/border3@2x\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":5},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":368},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":530},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":355}]}', NULL, 1, 0, 2, 'admin', '2021-07-15 17:40:33', 'admin', '2021-07-15 17:40:33', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logistics_one', 'widget-image', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"reversalX\":false,\"minHeight\":5,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"startRotate\":false,\"titleText\":\"\",\"layoutFront\":\"\",\"radius\":9,\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":18,\"imageAdress\":\"https://report.anji-plus.com/file/download/border3@1x\",\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"borderRadius\":0,\"transparency\":100,\"marginBottom\":10,\"layerName\":\"图片\",\"hideX\":true,\"verticalShow\":true,\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"fontSizeY\":16,\"fontSizeX\":18,\"backgroundColor\":\"\",\"colorY\":\"#fff\",\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":13,\"left\":5,\"width\":530,\"index\":0,\"height\":350}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"图片\"},{\"type\":\"el-switch\",\"label\":\"开启旋转\",\"name\":\"startRotate\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-slider\",\"label\":\"透明度\",\"name\":\"transparency\",\"required\":false,\"placeholder\":\"\",\"value\":100},{\"type\":\"el-input-number\",\"label\":\"圆角\",\"name\":\"borderRadius\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"custom-upload\",\"label\":\"图片地址\",\"name\":\"imageAdress\",\"required\":false,\"placeholder\":\"\",\"value\":\"https://report.anji-plus.com/file/download/border3@1x\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":5},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":13},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":530},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":350}]}', NULL, 1, 0, 3, 'admin', '2021-07-15 17:40:33', 'admin', '2021-07-15 17:40:33', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logistics_one', 'widget-barchart', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"reversalX\":false,\"minHeight\":5,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"startRotate\":false,\"titleText\":\"\",\"layoutFront\":\"\",\"radius\":9,\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":11,\"imageAdress\":\"https://report.anji-plus.com/file/download/border3@2x\",\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"borderRadius\":0,\"background\":\"\",\"transparency\":100,\"marginBottom\":10,\"layerName\":\"柱状图\",\"hideX\":true,\"verticalShow\":true,\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"fontSizeY\":16,\"fontSizeX\":18,\"backgroundColor\":\"\",\"colorY\":\"#fff\",\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"customColor\":[{\"color\":\"#97D0D0\"},{\"color\":\"#87cefa\"},{\"color\":\"#7BF3F5\"},{\"color\":\"#8AF9FB\"},{\"color\":\"#F59A79\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{\"dynamicData\":{\"chartProperties\":{\"name\":\"xAxis\",\"nums\":\"bar\"},\"setCode\":\"logis_1\",\"chartType\":\"widget-barchart\",\"contextData\":{}},\"dataType\":\"dynamicData\",\"refreshTime\":5000,\"staticData\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1000,2229,3879,2379,4079]}]}\"}', '', '{\"top\":75,\"left\":9,\"width\":525,\"index\":2,\"height\":282}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"dynamicData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":5000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1000,2229,3879,2379,4079]}]}\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"chartType\":\"widget-barchart\",\"value\":{\"chartProperties\":{\"name\":\"xAxis\",\"nums\":\"bar\"},\"setCode\":\"logis_1\",\"chartType\":\"widget-barchart\",\"contextData\":{}}}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"柱状图\"},{\"type\":\"el-switch\",\"label\":\"竖展示\",\"name\":\"verticalShow\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},[{\"name\":\"柱体设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"最大宽度\",\"name\":\"maxWidth\",\"required\":false,\"placeholder\":\"\",\"value\":11},{\"type\":\"el-slider\",\"label\":\"圆角\",\"name\":\"radius\",\"require\":false,\"placeholder\":\"\",\"value\":9},{\"type\":\"el-slider\",\"label\":\"最小高度\",\"name\":\"minHeight\",\"require\":false,\"placeholder\":\"\",\"value\":5}]},{\"name\":\"标题设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标题\",\"name\":\"isNoTitle\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-text\",\"label\":\"标题\",\"name\":\"titleText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"textColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#FFD700\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"textFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"textFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20},{\"type\":\"el-select\",\"label\":\"字体位置\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"},{\"type\":\"el-input-text\",\"label\":\"副标题\",\"name\":\"subText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字体粗细\",\"name\":\"subTextFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"subTextFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20}]},{\"name\":\"X轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"xName\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"hideX\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"xNameColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"xNameFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-slider\",\"label\":\"文字角度\",\"name\":\"textAngle\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-input-number\",\"label\":\"文字间隔\",\"name\":\"textInterval\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalX\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"Xcolor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeX\",\"required\":false,\"placeholder\":\"\",\"value\":18},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineX\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"Y轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"textNameY\",\"require\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShowY\",\"require\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"NameColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"NameFontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalY\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"colorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":16},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineY\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"数值设定\",\"list\":[{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShow\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":14},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"}]},{\"name\":\"提示语设置\",\"list\":[{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lineColor\",\"required\":false,\"placeholder\":\"\"}]},{\"name\":\"坐标轴边距设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"左边距(像素)\",\"name\":\"marginLeft\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"顶边距(像素)\",\"name\":\"marginTop\",\"required\":false,\"placeholder\":\"\",\"value\":50},{\"type\":\"el-slider\",\"label\":\"右边距(像素)\",\"name\":\"marginRight\",\"required\":false,\"placeholder\":\"\",\"value\":40},{\"type\":\"el-slider\",\"label\":\"底边距(像素)\",\"name\":\"marginBottom\",\"required\":false,\"placeholder\":\"\",\"value\":10}]},{\"name\":\"图例操作\",\"list\":[{\"type\":\"el-switch\",\"label\":\"图例\",\"name\":\"isShowLegend\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lengedColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"lengedFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":16},{\"type\":\"el-input-number\",\"label\":\"图例宽度\",\"name\":\"lengedWidth\",\"required\":false,\"placeholder\":\"\",\"value\":15},{\"type\":\"el-select\",\"label\":\"横向位置\",\"name\":\"lateralPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"纵向位置\",\"name\":\"longitudinalPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"top\",\"name\":\"顶部\"},{\"code\":\"bottom\",\"name\":\"底部\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"布局前置\",\"name\":\"layoutFront\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"vertical\",\"name\":\"竖排\"},{\"code\":\"horizontal\",\"name\":\"横排\"}],\"value\":\"\"}]},{\"name\":\"自定义配色\",\"list\":[{\"type\":\"customColor\",\"label\":\"\",\"name\":\"customColor\",\"required\":false,\"value\":[{\"color\":\"#97D0D0\"},{\"color\":\"#87cefa\"},{\"color\":\"#7BF3F5\"},{\"color\":\"#8AF9FB\"},{\"color\":\"#F59A79\"}]}]}]],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":9},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":75},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":525},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":282}]}', NULL, 1, 0, 4, 'admin', '2021-07-15 17:40:33', 'admin', '2021-07-15 17:40:33', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logistics_one', 'widget-map', '{\"layerName\":\"迁徙图\"}', '{}', '', '{\"top\":97,\"left\":542,\"width\":835,\"index\":2,\"height\":625}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"迁徙图\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":542},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":97},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":835},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":625}]}', NULL, 1, 0, 5, 'admin', '2021-07-15 17:40:33', 'admin', '2021-07-15 17:40:33', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logistics_one', 'widget-image', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"reversalX\":false,\"minHeight\":5,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"startRotate\":false,\"layoutFront\":\"\",\"radius\":9,\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":18,\"imageAdress\":\"https://report.anji-plus.com/file/download/border3@2x\",\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"borderRadius\":0,\"transparency\":100,\"marginBottom\":10,\"layerName\":\"图片\",\"hideX\":true,\"verticalShow\":true,\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"fontSizeY\":16,\"fontSizeX\":18,\"backgroundColor\":\"\",\"colorY\":\"#fff\",\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":730,\"left\":1384,\"width\":530,\"index\":3,\"height\":345}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"图片\"},{\"type\":\"el-switch\",\"label\":\"开启旋转\",\"name\":\"startRotate\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-slider\",\"label\":\"透明度\",\"name\":\"transparency\",\"required\":false,\"placeholder\":\"\",\"value\":100},{\"type\":\"el-input-number\",\"label\":\"圆角\",\"name\":\"borderRadius\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"custom-upload\",\"label\":\"图片地址\",\"name\":\"imageAdress\",\"required\":false,\"placeholder\":\"\",\"value\":\"https://report.anji-plus.com/file/download/border3@2x\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":1384},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":730},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":530},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":345}]}', NULL, 1, 0, 6, 'admin', '2021-07-15 17:40:33', 'admin', '2021-07-15 17:40:33', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logistics_one', 'widget-image', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"reversalX\":false,\"minHeight\":5,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"startRotate\":false,\"layoutFront\":\"\",\"radius\":9,\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":18,\"imageAdress\":\"https://report.anji-plus.com/file/download/border3@2x\",\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"borderRadius\":0,\"transparency\":100,\"marginBottom\":10,\"layerName\":\"图片\",\"hideX\":true,\"verticalShow\":true,\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"fontSizeY\":16,\"fontSizeX\":18,\"backgroundColor\":\"\",\"colorY\":\"#fff\",\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{}', '', '{\"top\":10,\"left\":1386,\"width\":530,\"index\":4,\"height\":345}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"图片\"},{\"type\":\"el-switch\",\"label\":\"开启旋转\",\"name\":\"startRotate\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-slider\",\"label\":\"透明度\",\"name\":\"transparency\",\"required\":false,\"placeholder\":\"\",\"value\":100},{\"type\":\"el-input-number\",\"label\":\"圆角\",\"name\":\"borderRadius\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"custom-upload\",\"label\":\"图片地址\",\"name\":\"imageAdress\",\"required\":false,\"placeholder\":\"\",\"value\":\"https://report.anji-plus.com/file/download/border3@2x\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":1386},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":10},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":530},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":345}]}', NULL, 1, 0, 7, 'admin', '2021-07-15 17:40:33', 'admin', '2021-07-15 17:40:33', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logistics_one', 'widget-image', '{\"imageAdress\":\"https://report.anji-plus.com/file/download/border8@1x\",\"backgroundColor\":\"\",\"borderRadius\":0,\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"startRotate\":false,\"transparency\":100,\"width\":1920,\"layerName\":\"图片\",\"title\":\"大屏\",\"height\":1080}', '{}', '', '{\"top\":731,\"left\":541,\"width\":839,\"index\":7,\"height\":344}', '{\"data\":[],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"图片\"},{\"type\":\"el-switch\",\"label\":\"开启旋转\",\"name\":\"startRotate\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"el-slider\",\"label\":\"透明度\",\"name\":\"transparency\",\"required\":false,\"placeholder\":\"\",\"value\":100},{\"type\":\"el-input-number\",\"label\":\"圆角\",\"name\":\"borderRadius\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"custom-upload\",\"label\":\"图片地址\",\"name\":\"imageAdress\",\"required\":false,\"placeholder\":\"\",\"value\":\"https://report.anji-plus.com/file/download/border8@1x\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":541},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":731},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":839},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":344}]}', NULL, 1, 0, 8, 'admin', '2021-07-15 17:40:33', 'admin', '2021-07-15 17:40:33', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logistics_one', 'widget-text', '{\"backgroundColor\":\"\",\"color\":\"rgba(0, 206, 209, 1)\",\"textAlign\":\"center\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"letterSpacing\":0,\"title\":\"大屏\",\"background\":\"rgba(115,170,229,.0)\",\"width\":1920,\"fontSize\":36,\"layerName\":\"文本框\",\"text\":\"实时库存TOP5\",\"fontWeight\":\"normal\",\"height\":1080}', '{\"dataType\":\"staticData\",\"refreshTime\":5000,\"staticData\":\"文本框\"}', '', '{\"top\":19,\"left\":157,\"width\":228,\"index\":8,\"height\":52}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"staticData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":5000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"文本框\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"chartType\":\"widget-text\",\"value\":\"\"}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"文本框\"},{\"type\":\"el-input-text\",\"label\":\"文本内容\",\"name\":\"text\",\"required\":false,\"placeholder\":\"\",\"value\":\"实时库存TOP5\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":36},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"color\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(0, 206, 209, 1)\"},{\"type\":\"el-input-number\",\"label\":\"字体间距\",\"name\":\"letterSpacing\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体背景\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(115,170,229,.0)\"},{\"type\":\"el-select\",\"label\":\"文字粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-select\",\"label\":\"对齐方式\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":157},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":19},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":228},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":52}]}', NULL, 1, 0, 9, 'admin', '2021-07-15 17:40:33', 'admin', '2021-07-15 17:40:33', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logistics_one', 'widget-barchart', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":false,\"reversalX\":false,\"minHeight\":0,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"startRotate\":false,\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"实时库存TOP5\",\"radius\":7,\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":16,\"imageAdress\":\"https://report.anji-plus.com/file/download/border3@2x\",\"textAlign\":\"center\",\"subTextColor\":\"#fff\",\"textColor\":\"#FFD700\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"borderRadius\":0,\"background\":\"\",\"transparency\":100,\"marginBottom\":10,\"layerName\":\"柱状图\",\"hideX\":true,\"verticalShow\":false,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"fontSizeY\":18,\"fontSizeX\":18,\"backgroundColor\":\"\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"NameFontSizeY\":12,\"isShow\":true,\"textFontSize\":20,\"customColor\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{\"dynamicData\":{\"chartProperties\":{\"name\":\"xAxis\",\"nums\":\"bar\"},\"setCode\":\"logis_2\",\"chartType\":\"widget-barchart\",\"contextData\":{}},\"dataType\":\"dynamicData\",\"refreshTime\":5000,\"staticData\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1000,2229,3879,2379,4079]}]}\"}', '', '{\"top\":434,\"left\":7,\"width\":525,\"height\":287}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"dynamicData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":5000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"{\\\"categories\\\": [\\\"苹果\\\",\\\"三星\\\",\\\"小米\\\",\\\"oppo\\\",\\\"vivo\\\"],\\\"series\\\": [{\\\"name\\\": \\\"手机品牌\\\",\\\"data\\\": [1000,2229,3879,2379,4079]}]}\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"chartType\":\"widget-barchart\",\"value\":{\"chartProperties\":{\"name\":\"xAxis\",\"nums\":\"bar\"},\"setCode\":\"logis_2\",\"chartType\":\"widget-barchart\",\"contextData\":{}}}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"柱状图\"},{\"type\":\"el-switch\",\"label\":\"竖展示\",\"name\":\"verticalShow\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},[{\"name\":\"柱体设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"最大宽度\",\"name\":\"maxWidth\",\"required\":false,\"placeholder\":\"\",\"value\":16},{\"type\":\"el-slider\",\"label\":\"圆角\",\"name\":\"radius\",\"require\":false,\"placeholder\":\"\",\"value\":7},{\"type\":\"el-slider\",\"label\":\"最小高度\",\"name\":\"minHeight\",\"require\":false,\"placeholder\":\"\",\"value\":0}]},{\"name\":\"标题设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标题\",\"name\":\"isNoTitle\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-text\",\"label\":\"标题\",\"name\":\"titleText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"textColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#FFD700\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"textFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"textFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20},{\"type\":\"el-select\",\"label\":\"字体位置\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"},{\"type\":\"el-input-text\",\"label\":\"副标题\",\"name\":\"subText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字体粗细\",\"name\":\"subTextFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"subTextFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20}]},{\"name\":\"X轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"xName\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"hideX\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"xNameColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"xNameFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-slider\",\"label\":\"文字角度\",\"name\":\"textAngle\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-input-number\",\"label\":\"文字间隔\",\"name\":\"textInterval\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalX\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"Xcolor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeX\",\"required\":false,\"placeholder\":\"\",\"value\":18},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineX\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"Y轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"textNameY\",\"require\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShowY\",\"require\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"NameColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"NameFontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalY\",\"required\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"colorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":18},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineY\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"数值设定\",\"list\":[{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShow\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":14},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"}]},{\"name\":\"提示语设置\",\"list\":[{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lineColor\",\"required\":false,\"placeholder\":\"\"}]},{\"name\":\"坐标轴边距设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"左边距(像素)\",\"name\":\"marginLeft\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"顶边距(像素)\",\"name\":\"marginTop\",\"required\":false,\"placeholder\":\"\",\"value\":50},{\"type\":\"el-slider\",\"label\":\"右边距(像素)\",\"name\":\"marginRight\",\"required\":false,\"placeholder\":\"\",\"value\":40},{\"type\":\"el-slider\",\"label\":\"底边距(像素)\",\"name\":\"marginBottom\",\"required\":false,\"placeholder\":\"\",\"value\":10}]},{\"name\":\"图例操作\",\"list\":[{\"type\":\"el-switch\",\"label\":\"图例\",\"name\":\"isShowLegend\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lengedColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"lengedFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":16},{\"type\":\"el-input-number\",\"label\":\"图例宽度\",\"name\":\"lengedWidth\",\"required\":false,\"placeholder\":\"\",\"value\":15},{\"type\":\"el-select\",\"label\":\"横向位置\",\"name\":\"lateralPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"纵向位置\",\"name\":\"longitudinalPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"top\",\"name\":\"顶部\"},{\"code\":\"bottom\",\"name\":\"底部\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"布局前置\",\"name\":\"layoutFront\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"vertical\",\"name\":\"竖排\"},{\"code\":\"horizontal\",\"name\":\"横排\"}],\"value\":\"\"}]},{\"name\":\"自定义配色\",\"list\":[{\"type\":\"customColor\",\"label\":\"\",\"name\":\"customColor\",\"required\":false,\"value\":[{\"color\":\"#ff7f50\"},{\"color\":\"#87cefa\"},{\"color\":\"#da70d6\"},{\"color\":\"#32cd32\"},{\"color\":\"#6495ed\"}]}]}]],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":7},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":434},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":525},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":287}]}', NULL, 1, 0, 10, 'admin', '2021-07-15 17:40:33', 'admin', '2021-07-15 17:40:33', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logistics_one', 'widget-text', '{\"backgroundColor\":\"\",\"color\":\"rgba(0, 206, 209, 1)\",\"textAlign\":\"center\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"letterSpacing\":0,\"title\":\"大屏\",\"background\":\"rgba(115,170,229,.0)\",\"width\":1920,\"fontSize\":36,\"layerName\":\"文本框\",\"text\":\"收车量TOP5\",\"fontWeight\":\"normal\",\"height\":1080}', '{\"dataType\":\"staticData\",\"refreshTime\":5000,\"staticData\":\"文本框\"}', '', '{\"top\":373,\"left\":151,\"width\":239,\"index\":10,\"height\":55}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"staticData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":5000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"文本框\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"chartType\":\"widget-text\",\"value\":\"\"}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"文本框\"},{\"type\":\"el-input-text\",\"label\":\"文本内容\",\"name\":\"text\",\"required\":false,\"placeholder\":\"\",\"value\":\"收车量TOP5\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":36},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"color\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(0, 206, 209, 1)\"},{\"type\":\"el-input-number\",\"label\":\"字体间距\",\"name\":\"letterSpacing\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体背景\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(115,170,229,.0)\"},{\"type\":\"el-select\",\"label\":\"文字粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-select\",\"label\":\"对齐方式\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":151},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":373},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":239},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":55}]}', NULL, 1, 0, 11, 'admin', '2021-07-15 17:40:33', 'admin', '2021-07-15 17:40:33', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logistics_one', 'widget-barlinechart', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":0,\"reversalX\":0,\"minHeight\":0,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"radius\":5,\"xName\":\"\",\"isShowY\":true,\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"left\",\"lineColor\":\"#fff\",\"subTextColor\":\"#fff\",\"textColor\":\"#fff\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"\",\"fontSize\":12,\"marginBottom\":10,\"layerName\":\"柱线图\",\"hideX\":true,\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":3,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":16,\"backgroundColor\":\"\",\"colorY\":\"#fff\",\"markPoint\":true,\"NameFontSizeY\":16,\"textFontSize\":20,\"pointSize\":5,\"customColor\":[{\"color\":\"#00F4FFFF\"},{\"color\":\"#9CA69C\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{\"dynamicData\":{\"chartProperties\":{\"start\":\"bar\",\"time\":\"xAxis\",\"collect\":\"line\"},\"setCode\":\"logis_3\",\"chartType\":\"widget-barlinechart\",\"contextData\":{}},\"dataType\":\"dynamicData\",\"refreshTime\":5000,\"staticData\":\"{\\\"xAxis\\\": [\\\"1月\\\", \\\"2月\\\", \\\"3月\\\", \\\"4月\\\", \\\"5月\\\",\\\"6月\\\", \\\"7月\\\", \\\"8月\\\",\\\"9月\\\",\\\"10月\\\",\\\"11月\\\",\\\"12月\\\"],\\\"series\\\": [{\\\"type\\\": \\\"bar\\\",\\\"name\\\": \\\"货运量\\\",\\\"data\\\": [2.6,5.9,9,26.4,28.7,70.7,175.6,182.2,48.7,18.8,6,2.3]},{\\\"type\\\": \\\"line\\\",\\\"name\\\": \\\"货运总量\\\",\\\"yAxisIndex\\\": 1,\\\"data\\\": [2,2.2,3.3,4.5,6.3,10.2,20.3,23.4,23,16.5,12,6.2]}]}\"}', '', '{\"top\":791,\"left\":2,\"width\":531,\"index\":11,\"height\":282}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"dynamicData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":5000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"{\\\"xAxis\\\": [\\\"1月\\\", \\\"2月\\\", \\\"3月\\\", \\\"4月\\\", \\\"5月\\\",\\\"6月\\\", \\\"7月\\\", \\\"8月\\\",\\\"9月\\\",\\\"10月\\\",\\\"11月\\\",\\\"12月\\\"],\\\"series\\\": [{\\\"type\\\": \\\"bar\\\",\\\"name\\\": \\\"货运量\\\",\\\"data\\\": [2.6,5.9,9,26.4,28.7,70.7,175.6,182.2,48.7,18.8,6,2.3]},{\\\"type\\\": \\\"line\\\",\\\"name\\\": \\\"货运总量\\\",\\\"yAxisIndex\\\": 1,\\\"data\\\": [2,2.2,3.3,4.5,6.3,10.2,20.3,23.4,23,16.5,12,6.2]}]}\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"chartType\":\"widget-barlinechart\",\"relactiveDomValue\":\"dynamicData\",\"value\":{\"chartProperties\":{\"start\":\"bar\",\"time\":\"xAxis\",\"collect\":\"line\"},\"setCode\":\"logis_3\",\"chartType\":\"widget-barlinechart\",\"contextData\":{}}}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"柱线图\"},{\"type\":\"vue-color\",\"label\":\"背景颜色\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},[{\"name\":\"折线设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标记点\",\"name\":\"markPoint\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-slider\",\"label\":\"点大小\",\"name\":\"pointSize\",\"required\":false,\"placeholder\":\"\",\"value\":5},{\"type\":\"el-switch\",\"label\":\"平滑曲线\",\"name\":\"smoothCurve\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-switch\",\"label\":\"面积堆积\",\"name\":\"area\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-slider\",\"label\":\"面积厚度\",\"name\":\"areaThickness\",\"required\":false,\"placeholder\":\"\",\"value\":5},{\"type\":\"el-slider\",\"label\":\"线条宽度\",\"name\":\"lineWidth\",\"required\":false,\"placeholder\":\"\",\"value\":3}]},{\"name\":\"柱体设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"最大宽度\",\"name\":\"maxWidth\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"圆角\",\"name\":\"radius\",\"require\":false,\"placeholder\":\"\",\"value\":5},{\"type\":\"el-slider\",\"label\":\"最小高度\",\"name\":\"minHeight\",\"require\":false,\"placeholder\":\"\",\"value\":0}]},{\"name\":\"标题设置\",\"list\":[{\"type\":\"el-switch\",\"label\":\"标题\",\"name\":\"isNoTitle\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"el-input-text\",\"label\":\"标题\",\"name\":\"titleText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"textColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"textFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"textFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20},{\"type\":\"el-select\",\"label\":\"字体位置\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"left\"},{\"type\":\"el-input-text\",\"label\":\"副标题\",\"name\":\"subText\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"subTextColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-select\",\"label\":\"字体粗细\",\"name\":\"subTextFontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"subTextFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":20}]},{\"name\":\"X轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"xName\",\"required\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"hideX\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"xNameColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"xNameFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"el-slider\",\"label\":\"文字角度\",\"name\":\"textAngle\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-input-number\",\"label\":\"文字间隔\",\"name\":\"textInterval\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalX\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"Xcolor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeX\",\"required\":false,\"placeholder\":\"\",\"value\":16},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineX\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorX\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"Y轴设置\",\"list\":[{\"type\":\"el-input-text\",\"label\":\"名称\",\"name\":\"textNameY\",\"require\":false,\"placeholder\":\"\",\"value\":\"\"},{\"type\":\"el-switch\",\"label\":\"显示\",\"name\":\"isShowY\",\"require\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"坐标名颜色\",\"name\":\"NameColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"NameFontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":16},{\"type\":\"el-switch\",\"label\":\"轴反转\",\"name\":\"reversalY\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"颜色\",\"name\":\"colorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-number\",\"label\":\"字号\",\"name\":\"fontSizeY\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"轴颜色\",\"name\":\"lineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-switch\",\"label\":\"分割线显示\",\"name\":\"isShowSplitLineY\",\"require\":false,\"placeholder\":\"\",\"value\":false},{\"type\":\"vue-color\",\"label\":\"分割线颜色\",\"name\":\"splitLineColorY\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"提示语设置\",\"list\":[{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":12},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lineColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"}]},{\"name\":\"坐标轴边距设置\",\"list\":[{\"type\":\"el-slider\",\"label\":\"左边距(像素)\",\"name\":\"marginLeft\",\"required\":false,\"placeholder\":\"\",\"value\":10},{\"type\":\"el-slider\",\"label\":\"顶边距(像素)\",\"name\":\"marginTop\",\"required\":false,\"placeholder\":\"\",\"value\":50},{\"type\":\"el-slider\",\"label\":\"右边距(像素)\",\"name\":\"marginRight\",\"required\":false,\"placeholder\":\"\",\"value\":40},{\"type\":\"el-slider\",\"label\":\"底边距(像素)\",\"name\":\"marginBottom\",\"required\":false,\"placeholder\":\"\",\"value\":10}]},{\"name\":\"图例操作\",\"list\":[{\"type\":\"el-switch\",\"label\":\"图例\",\"name\":\"isShowLegend\",\"required\":false,\"placeholder\":\"\",\"value\":true},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"lengedColor\",\"required\":false,\"placeholder\":\"\",\"value\":\"#fff\"},{\"type\":\"el-input-text\",\"label\":\"字体大小\",\"name\":\"lengedFontSize\",\"required\":false,\"placeholder\":\"\",\"value\":16},{\"type\":\"el-input-number\",\"label\":\"图例宽度\",\"name\":\"lengedWidth\",\"required\":false,\"placeholder\":\"\",\"value\":15},{\"type\":\"el-select\",\"label\":\"横向位置\",\"name\":\"lateralPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"纵向位置\",\"name\":\"longitudinalPosition\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"top\",\"name\":\"顶部\"},{\"code\":\"bottom\",\"name\":\"底部\"}],\"value\":\"\"},{\"type\":\"el-select\",\"label\":\"布局前置\",\"name\":\"layoutFront\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"vertical\",\"name\":\"竖排\"},{\"code\":\"horizontal\",\"name\":\"横排\"}],\"value\":\"\"}]},{\"name\":\"自定义配色\",\"list\":[{\"type\":\"customColor\",\"label\":\"\",\"name\":\"customColor\",\"required\":false,\"value\":[{\"color\":\"#00F4FFFF\"},{\"color\":\"#9CA69C\"}]}]}]],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":2},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":791},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":531},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":282}]}', NULL, 1, 0, 12, 'admin', '2021-07-15 17:40:33', 'admin', '2021-07-15 17:40:33', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logistics_one', 'widget-text', '{\"backgroundColor\":\"\",\"color\":\"rgba(0, 206, 209, 1)\",\"textAlign\":\"center\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"letterSpacing\":0,\"title\":\"大屏\",\"background\":\"rgba(115,170,229,.0)\",\"width\":1920,\"fontSize\":36,\"layerName\":\"文本框\",\"text\":\"收发车情况\",\"fontWeight\":\"normal\",\"height\":1080}', '{\"dataType\":\"staticData\",\"refreshTime\":5000,\"staticData\":\"文本框\"}', '', '{\"top\":732,\"left\":169,\"width\":209,\"index\":12,\"height\":57}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"staticData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":5000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"文本框\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"chartType\":\"widget-text\",\"value\":\"\"}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"文本框\"},{\"type\":\"el-input-text\",\"label\":\"文本内容\",\"name\":\"text\",\"required\":false,\"placeholder\":\"\",\"value\":\"收发车情况\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":36},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"color\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(0, 206, 209, 1)\"},{\"type\":\"el-input-number\",\"label\":\"字体间距\",\"name\":\"letterSpacing\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体背景\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(115,170,229,.0)\"},{\"type\":\"el-select\",\"label\":\"文字粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-select\",\"label\":\"对齐方式\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":169},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":732},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":209},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":57}]}', NULL, 1, 0, 13, 'admin', '2021-07-15 17:40:33', 'admin', '2021-07-15 17:40:33', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logistics_one', 'widget-text', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":0,\"reversalX\":0,\"minHeight\":0,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"发车\",\"radius\":5,\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"center\",\"lineColor\":\"#fff\",\"subTextColor\":\"#fff\",\"textColor\":\"#fff\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"rgba(115,170,229,.0)\",\"fontSize\":25,\"marginBottom\":10,\"layerName\":\"发车\",\"hideX\":true,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":3,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":16,\"backgroundColor\":\"\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":16,\"textFontSize\":20,\"pointSize\":5,\"customColor\":[{\"color\":\"#00F4FFFF\"},{\"color\":\"#9CA69C\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{\"dataType\":\"staticData\",\"refreshTime\":5000,\"staticData\":\"文本框\"}', '', '{\"top\":788,\"left\":423,\"width\":100,\"index\":13,\"height\":40}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"staticData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":5000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"文本框\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"chartType\":\"widget-text\",\"value\":\"\"}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"发车\"},{\"type\":\"el-input-text\",\"label\":\"文本内容\",\"name\":\"text\",\"required\":false,\"placeholder\":\"\",\"value\":\"发车\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":25},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"color\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(0, 206, 209, 1)\"},{\"type\":\"el-input-number\",\"label\":\"字体间距\",\"name\":\"letterSpacing\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体背景\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(115,170,229,.0)\"},{\"type\":\"el-select\",\"label\":\"文字粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-select\",\"label\":\"对齐方式\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":423},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":788},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":100},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":40}]}', NULL, 1, 0, 14, 'admin', '2021-07-15 17:40:33', 'admin', '2021-07-15 17:40:33', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('logistics_one', 'widget-text', '{\"lengedColor\":\"#fff\",\"lateralPosition\":\"\",\"reversalY\":0,\"reversalX\":0,\"minHeight\":0,\"marginRight\":40,\"textInterval\":0,\"isNoTitle\":true,\"textFontWeight\":\"normal\",\"titleText\":\"\",\"layoutFront\":\"\",\"text\":\"收车\",\"radius\":5,\"xName\":\"\",\"isShowY\":true,\"fontWeight\":\"normal\",\"height\":1080,\"maxWidth\":10,\"area\":true,\"textAlign\":\"center\",\"lineColor\":\"#fff\",\"subTextColor\":\"#fff\",\"textColor\":\"#fff\",\"subText\":\"\",\"lineColorY\":\"#fff\",\"xNameFontSize\":12,\"lineColorX\":\"#fff\",\"textNameY\":\"\",\"marginLeft\":10,\"subTextFontSize\":20,\"background\":\"rgba(115,170,229,.0)\",\"fontSize\":25,\"marginBottom\":10,\"layerName\":\"收车\",\"hideX\":true,\"color\":\"rgba(0, 206, 209, 1)\",\"backgroundImage\":\"https://report.anji-plus.com/file/download/bf566e48-ccad-40e1-8ee9-228427e5466b\",\"NameColorY\":\"#fff\",\"title\":\"大屏\",\"isShowSplitLineX\":false,\"lineWidth\":3,\"isShowSplitLineY\":false,\"splitLineColorY\":\"#fff\",\"areaThickness\":5,\"lengedFontSize\":16,\"splitLineColorX\":\"#fff\",\"textAngle\":0,\"Xcolor\":\"#fff\",\"xNameColor\":\"#fff\",\"lengedWidth\":15,\"smoothCurve\":true,\"fontSizeY\":12,\"fontSizeX\":16,\"backgroundColor\":\"\",\"colorY\":\"#fff\",\"letterSpacing\":0,\"markPoint\":true,\"NameFontSizeY\":16,\"textFontSize\":20,\"pointSize\":5,\"customColor\":[{\"color\":\"#00F4FFFF\"},{\"color\":\"#9CA69C\"}],\"longitudinalPosition\":\"\",\"subTextFontWeight\":\"normal\",\"width\":1920,\"isShowLegend\":true,\"marginTop\":50}', '{\"dataType\":\"staticData\",\"refreshTime\":5000,\"staticData\":\"文本框\"}', '', '{\"top\":787,\"left\":3,\"width\":100,\"index\":13,\"height\":40}', '{\"data\":[{\"type\":\"el-radio-group\",\"label\":\"数据类型\",\"name\":\"dataType\",\"require\":false,\"placeholder\":\"\",\"selectValue\":true,\"selectOptions\":[{\"code\":\"staticData\",\"name\":\"静态数据\"},{\"code\":\"dynamicData\",\"name\":\"动态数据\"}],\"value\":\"staticData\"},{\"type\":\"el-input-number\",\"label\":\"刷新时间(毫秒)\",\"name\":\"refreshTime\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"value\":5000},{\"type\":\"el-button\",\"label\":\"静态数据\",\"name\":\"staticData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"staticData\",\"value\":\"文本框\"},{\"type\":\"dycustComponents\",\"label\":\"\",\"name\":\"dynamicData\",\"required\":false,\"placeholder\":\"px\",\"relactiveDom\":\"dataType\",\"relactiveDomValue\":\"dynamicData\",\"chartType\":\"widget-text\",\"value\":\"\"}],\"setup\":[{\"type\":\"el-input-text\",\"label\":\"图层名称\",\"name\":\"layerName\",\"required\":false,\"placeholder\":\"\",\"value\":\"收车\"},{\"type\":\"el-input-text\",\"label\":\"文本内容\",\"name\":\"text\",\"required\":false,\"placeholder\":\"\",\"value\":\"收车\"},{\"type\":\"el-input-number\",\"label\":\"字体大小\",\"name\":\"fontSize\",\"required\":false,\"placeholder\":\"\",\"value\":25},{\"type\":\"vue-color\",\"label\":\"字体颜色\",\"name\":\"color\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(0, 206, 209, 1)\"},{\"type\":\"el-input-number\",\"label\":\"字体间距\",\"name\":\"letterSpacing\",\"required\":false,\"placeholder\":\"\",\"value\":0},{\"type\":\"vue-color\",\"label\":\"字体背景\",\"name\":\"background\",\"required\":false,\"placeholder\":\"\",\"value\":\"rgba(115,170,229,.0)\"},{\"type\":\"el-select\",\"label\":\"文字粗细\",\"name\":\"fontWeight\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"normal\",\"name\":\"正常\"},{\"code\":\"bold\",\"name\":\"粗体\"},{\"code\":\"bolder\",\"name\":\"特粗体\"},{\"code\":\"lighter\",\"name\":\"细体\"}],\"value\":\"normal\"},{\"type\":\"el-select\",\"label\":\"对齐方式\",\"name\":\"textAlign\",\"required\":false,\"placeholder\":\"\",\"selectOptions\":[{\"code\":\"center\",\"name\":\"居中\"},{\"code\":\"left\",\"name\":\"左对齐\"},{\"code\":\"right\",\"name\":\"右对齐\"}],\"value\":\"center\"}],\"position\":[{\"type\":\"el-input-number\",\"label\":\"左边距\",\"name\":\"left\",\"required\":false,\"placeholder\":\"px\",\"value\":3},{\"type\":\"el-input-number\",\"label\":\"上边距\",\"name\":\"top\",\"required\":false,\"placeholder\":\"px\",\"value\":787},{\"type\":\"el-input-number\",\"label\":\"宽度\",\"name\":\"width\",\"required\":false,\"placeholder\":\"该容器在1920px大屏中的宽度\",\"value\":100},{\"type\":\"el-input-number\",\"label\":\"高度\",\"name\":\"height\",\"required\":false,\"placeholder\":\"该容器在1080px大屏中的高度\",\"value\":40}]}', NULL, 1, 0, 15, 'admin', '2021-07-15 17:40:33', 'admin', '2021-07-15 17:40:33', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('testForm', 'widget-barchart', '{"textFontStyle":"normal","lateralPosition":"center","reversalY":false,"reversalX":false,"minHeight":0,"marginRight":40,"textInterval":0,"isNoTitle":true,"nameColorY":"#fff","nameColorX":"#fff","textFontWeight":"normal","nameX":"","titleText":"","percentage":false,"tipsFontSize":16,"layoutFront":"horizontal","radius":5,"isShowY":true,"legendColor":"#fff","splitLineWidthY":1,"fontWeight":"normal","height":1080,"maxWidth":10,"splitLineWidthX":1,"textAngleX":0,"textAngleY":0,"textAlign":"center","textPerFontSize":20,"textNumColor":"#fff","lineColor":"#061740","subTextColor":"#fff","textColor":"#FFD700","subText":"","lineColorY":"#fff","lineColorX":"#fff","textNameY":"","marginLeft":10,"subTextFontSize":20,"tipsColor":"#00FEFF","color0Start":"#4FADFD","background":"","fontSize":14,"marginBottom":10,"layerName":"柱状图-城市总览","hideX":true,"lineNumber":8,"textPerFontWeight":"normal","componentLinkage":[{"widgetValue":"1vzit52b5m3-$-柱状图-单一城市-$-1","paramsConfig":[{"originKey":"name","targetKey":"city_name"},{"originKey":"value","targetKey":""}]}],"verticalShow":false,"distance":5,"backgroundImage":"","textNumFontWeight":"normal","description":"","scale":false,"title":"","isShowSplitLineX":false,"select_color":"#FAD400","lineWidth":2,"isShowSplitLineY":false,"piechartStyle":"shixin","subTextFontStyle":"normal","splitLineColorY":"#fff","splitLineColorX":"#fff","legendWidth":15,"splitNumberY":0,"numberValue":true,"textPerColor":"#fff","select_background":"rgba(115,170,229,.5)","fontSizeY":14,"fontSizeX":14,"backgroundColor":"rgba(52, 80, 106, 1)","color100End":"#28E8FA","widgetId":"1wvwcqi4yvj","colorY":"#fff","colorX":"#fff","nameFontSizeX":14,"lineLength":19,"nameFontSizeY":14,"isShow":true,"textFontSize":20,"customColor":[{"color":"#ff7f50"},{"color":"#87cefa"},{"color":"#da70d6"},{"color":"#32cd32"},{"color":"#6495ed"}],"longitudinalPosition":"top","subTextFontWeight":"normal","lineWidthX":1,"lineWidthY":1,"textNumFontSize":40,"width":1920,"legendFontSize":12,"isShowLegend":true,"widgetCode":"widget-barchart","marginTop":50,"colorsurplus":"#173164"}', '{"dynamicData":{"chartProperties":{"city_name":"xAxis","sum_nums":"bar"},"setCode":"aj_report_city_total","chartType":"widget-barchart","contextData":{"startTime":"2023-05-12","endTime":"2023-05-13"}},"dataType":"dynamicData","refreshTime":600000,"staticData":[{"data":1000,"axis":"苹果"},{"data":2229,"axis":"三星"},{"data":3879,"axis":"小米"},{"data":2379,"axis":"oppo"},{"data":4079,"axis":"vivo"}]}', '', '{"top":427.37,"left":355.01,"width":579.96,"index":0,"height":262.3}', '{"data":[{"type":"el-radio-group","label":"数据类型","name":"dataType","require":false,"placeholder":"","selectValue":true,"selectOptions":[{"code":"staticData","name":"静态数据"},{"code":"dynamicData","name":"动态数据"}],"value":"dynamicData"},{"type":"el-input-number","label":"刷新时间(毫秒)","name":"refreshTime","relactiveDom":"dataType","relactiveDomValue":"dynamicData","value":600000},{"type":"el-button","label":"静态数据","name":"staticData","required":false,"placeholder":"","relactiveDom":"dataType","relactiveDomValue":"staticData","value":[{"data":1000,"axis":"苹果"},{"data":2229,"axis":"三星"},{"data":3879,"axis":"小米"},{"data":2379,"axis":"oppo"},{"data":4079,"axis":"vivo"}]},{"type":"dycustComponents","label":"","name":"dynamicData","required":false,"placeholder":"","relactiveDom":"dataType","relactiveDomValue":"dynamicData","chartType":"widget-barchart","dictKey":"BAR_PROPERTIES","value":{"chartProperties":{"city_name":"xAxis","sum_nums":"bar"},"setCode":"aj_report_city_total","chartType":"widget-barchart","contextData":{"startTime":"2023-05-12","endTime":"2023-05-13"}}}],"methods":[],"setup":[{"type":"el-input-text","label":"图层名称","name":"layerName","required":false,"placeholder":"","value":"柱状图-城市总览"},{"type":"el-switch","label":"竖展示","name":"verticalShow","required":false,"placeholder":"","value":false},{"type":"vue-color","label":"背景颜色","name":"background","required":false,"placeholder":"","value":""},[{"name":"柱体设置","list":[{"type":"el-slider","label":"最大宽度","name":"maxWidth","required":false,"placeholder":"","value":10},{"type":"el-slider","label":"圆角","name":"radius","require":false,"placeholder":"","value":5},{"type":"el-slider","label":"最小高度","name":"minHeight","require":false,"placeholder":"","value":0}]},{"name":"标题设置","list":[{"type":"el-switch","label":"标题显示","name":"isNoTitle","required":false,"placeholder":"","value":true},{"type":"el-input-text","label":"标题名","name":"titleText","required":false,"placeholder":"","value":""},{"type":"vue-color","label":"字体颜色","name":"textColor","required":false,"placeholder":"","value":"#FFD700"},{"type":"el-input-number","label":"字体字号","name":"textFontSize","required":false,"placeholder":"","value":20},{"type":"el-select","label":"字体粗细","name":"textFontWeight","required":false,"placeholder":"","selectOptions":[{"code":"normal","name":"正常"},{"code":"bold","name":"粗体"},{"code":"bolder","name":"特粗体"},{"code":"lighter","name":"细体"}],"value":"normal"},{"type":"el-select","label":"字体风格","name":"textFontStyle","required":false,"placeholder":"","selectOptions":[{"code":"normal","name":"正常"},{"code":"italic","name":"italic斜体"},{"code":"oblique","name":"oblique斜体"}],"value":"normal"},{"type":"el-select","label":"字体位置","name":"textAlign","required":false,"placeholder":"","selectOptions":[{"code":"center","name":"居中"},{"code":"left","name":"左对齐"},{"code":"right","name":"右对齐"}],"value":"center"},{"type":"el-input-text","label":"副标题名","name":"subText","required":false,"placeholder":"","value":""},{"type":"vue-color","label":"字体颜色","name":"subTextColor","required":false,"placeholder":"","value":"#fff"},{"type":"el-input-number","label":"字体字号","name":"subTextFontSize","required":false,"placeholder":"","value":20},{"type":"el-select","label":"字体粗细","name":"subTextFontWeight","required":false,"placeholder":"","selectOptions":[{"code":"normal","name":"正常"},{"code":"bold","name":"粗体"},{"code":"bolder","name":"特粗体"},{"code":"lighter","name":"细体"}],"value":"normal"},{"type":"el-select","label":"字体风格","name":"subTextFontStyle","required":false,"placeholder":"","selectOptions":[{"code":"normal","name":"正常"},{"code":"italic","name":"italic斜体"},{"code":"oblique","name":"oblique斜体"}],"value":"normal"}]},{"name":"X轴设置","list":[{"type":"el-switch","label":"显示","name":"hideX","required":false,"placeholder":"","value":true},{"type":"el-input-text","label":"坐标名","name":"nameX","required":false,"placeholder":"","value":""},{"type":"vue-color","label":"坐标名颜色","name":"nameColorX","required":false,"placeholder":"","value":"#fff"},{"type":"el-input-number","label":"坐标名字号","name":"nameFontSizeX","required":false,"placeholder":"","value":14},{"type":"vue-color","label":"数值颜色","name":"colorX","required":false,"placeholder":"","value":"#fff"},{"type":"el-input-number","label":"数值字号","name":"fontSizeX","required":false,"placeholder":"","value":14},{"type":"el-input-number","label":"数值间隔","name":"textInterval","required":false,"placeholder":"","value":0},{"type":"el-slider","label":"数值角度","name":"textAngleX","required":false,"placeholder":"","value":0},{"type":"el-switch","label":"坐标轴反转","name":"reversalX","required":false,"placeholder":"","value":false},{"type":"vue-color","label":"坐标轴颜色","name":"lineColorX","required":false,"placeholder":"","value":"#fff"},{"type":"el-input-number","label":"坐标轴宽度","name":"lineWidthX","required":false,"placeholder":"","value":1},{"type":"el-switch","label":"分割线显示","name":"isShowSplitLineX","require":false,"placeholder":"","value":false},{"type":"vue-color","label":"分割线颜色","name":"splitLineColorX","required":false,"placeholder":"","value":"#fff"},{"type":"el-input-number","label":"分割线宽度","name":"splitLineWidthX","required":false,"placeholder":"","value":1}]},{"name":"Y轴设置","list":[{"type":"el-switch","label":"显示","name":"isShowY","require":false,"placeholder":"","value":true},{"type":"el-input-text","label":"坐标名","name":"textNameY","require":false,"placeholder":"","value":""},{"type":"vue-color","label":"坐标名颜色","name":"nameColorY","required":false,"placeholder":"","value":"#fff"},{"type":"el-input-number","label":"坐标名字号","name":"nameFontSizeY","required":false,"placeholder":"","value":14},{"type":"vue-color","label":"数值颜色","name":"colorY","required":false,"placeholder":"","value":"#fff"},{"type":"el-input-number","label":"数值字号","name":"fontSizeY","required":false,"placeholder":"","value":14},{"type":"el-switch","label":"缩放","name":"scale","require":false,"placeholder":"","value":false},{"type":"el-input-number","label":"均分","name":"splitNumberY","required":false,"placeholder":"","value":0},{"type":"el-slider","label":"数值角度","name":"textAngleY","required":false,"placeholder":"","value":0},{"type":"el-switch","label":"坐标轴反转","name":"reversalY","required":false,"placeholder":"","value":false},{"type":"vue-color","label":"坐标轴颜色","name":"lineColorY","required":false,"placeholder":"","value":"#fff"},{"type":"el-input-number","label":"坐标轴宽度","name":"lineWidthY","required":false,"placeholder":"","value":1},{"type":"el-switch","label":"分割线显示","name":"isShowSplitLineY","require":false,"placeholder":"","value":false},{"type":"vue-color","label":"分割线颜色","name":"splitLineColorY","required":false,"placeholder":"","value":"#fff"},{"type":"el-input-number","label":"分割线宽度","name":"splitLineWidthY","required":false,"placeholder":"","value":1}]},{"name":"数值设定","list":[{"type":"el-switch","label":"显示","name":"isShow","required":false,"placeholder":"","value":true},{"type":"el-input-number","label":"距离","name":"distance","required":false,"placeholder":"","value":5},{"type":"el-input-number","label":"字体字号","name":"fontSize","required":false,"placeholder":"","value":14},{"type":"vue-color","label":"字体颜色","name":"subTextColor","required":false,"placeholder":"","value":"#fff"},{"type":"el-select","label":"字体粗细","name":"fontWeight","required":false,"placeholder":"","selectOptions":[{"code":"normal","name":"正常"},{"code":"bold","name":"粗体"},{"code":"bolder","name":"特粗体"},{"code":"lighter","name":"细体"}],"value":"normal"}]},{"name":"提示语设置","list":[{"type":"el-input-number","label":"字体字号","name":"tipsFontSize","required":false,"placeholder":"","value":16},{"type":"vue-color","label":"字体颜色","name":"tipsColor","required":false,"placeholder":"","value":"#00FEFF"}]},{"name":"坐标轴边距设置","list":[{"type":"el-slider","label":"左边距(像素)","name":"marginLeft","required":false,"placeholder":"","value":10},{"type":"el-slider","label":"顶边距(像素)","name":"marginTop","required":false,"placeholder":"","value":50},{"type":"el-slider","label":"右边距(像素)","name":"marginRight","required":false,"placeholder":"","value":40},{"type":"el-slider","label":"底边距(像素)","name":"marginBottom","required":false,"placeholder":"","value":10}]},{"name":"自定义配色","list":[{"type":"customColor","label":"","name":"customColor","required":false,"value":[{"color":"#ff7f50"},{"color":"#87cefa"},{"color":"#da70d6"},{"color":"#32cd32"},{"color":"#6495ed"}]}]},{"name":"组件联动","list":[{"type":"componentLinkage","label":"","name":"componentLinkage","required":false,"value":[{"widgetValue":"1vzit52b5m3-$-柱状图-单一城市-$-1","paramsConfig":[{"originKey":"name","targetKey":"city_name"},{"originKey":"value","targetKey":""}]}]}]}]],"position":[{"type":"el-input-number","label":"左边距","name":"left","required":false,"placeholder":"","value":355.01},{"type":"el-input-number","label":"上边距","name":"top","required":false,"placeholder":"","value":427.37},{"type":"el-input-number","label":"宽度","name":"width","required":false,"placeholder":"该容器在1920px大屏中的宽度","value":579.96},{"type":"el-input-number","label":"高度","name":"height","required":false,"placeholder":"该容器在1080px大屏中的高度","value":262.3}]}', null, 1, 0, 1, 'admin', '2023-05-12 09:43:48', 'admin', '2023-05-12 09:43:48', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('testForm', 'widget-barchart', '{"symbol":"circle","textFontStyle":"normal","reversalY":false,"reversalX":false,"minHeight":0,"marginRight":40,"textInterval":0,"isNoTitle":true,"nameColorY":"#fff","nameColorX":"#fff","textFontWeight":"normal","nameX":"","titleText":"","tipsFontSize":16,"radius":5,"isShowY":true,"splitLineWidthY":1,"fontWeight":"normal","height":1080,"maxWidth":10,"splitLineWidthX":1,"area":true,"textAngleX":0,"textAngleY":0,"textAlign":"center","subTextColor":"#fff","textColor":"#FFD700","subText":"","lineColorY":"#fff","lineColorX":"#fff","textNameY":"","marginLeft":10,"subTextFontSize":20,"tipsColor":"#00FEFF","background":"","fontSize":14,"marginBottom":10,"layerName":"柱状图-单一城市","hideX":true,"componentLinkage":[],"verticalShow":false,"distance":5,"backgroundImage":"","description":"","scale":false,"title":"","isShowSplitLineX":false,"select_color":"#FAD400","lineWidth":4,"isShowSplitLineY":false,"subTextFontStyle":"normal","splitLineColorY":"#fff","areaThickness":5,"splitLineColorX":"#fff","splitNumberY":0,"select_background":"rgba(115,170,229,.5)","fontSizeY":14,"smoothCurve":true,"fontSizeX":14,"backgroundColor":"rgba(52, 80, 106, 1)","widgetId":"1vzit52b5m3","colorY":"#fff","colorX":"#fff","nameFontSizeX":14,"markPoint":true,"nameFontSizeY":14,"isShow":true,"textFontSize":20,"pointSize":10,"customColor":[{"color":"#ff7f50"},{"color":"#87cefa"},{"color":"#da70d6"},{"color":"#32cd32"},{"color":"#6495ed"}],"subTextFontWeight":"normal","lineWidthX":1,"lineWidthY":1,"width":1920,"widgetCode":"widget-barchart","marginTop":50}', '{"dynamicData":{"chartProperties":{"create_time":"xAxis","sum_nums":"bar"},"setCode":"aj_report_single_city","chartType":"widget-barchart","contextData":{"city_name":"北京"}},"dataType":"dynamicData","refreshTime":600000,"staticData":[{"data":1000,"axis":"苹果"},{"data":2229,"axis":"三星"},{"data":3879,"axis":"小米"},{"data":2379,"axis":"oppo"},{"data":4079,"axis":"vivo"}]}', '', '{"top":470.44,"left":1209.26,"width":643.64,"index":1,"height":217.98}', '{"data":[{"type":"el-radio-group","label":"数据类型","name":"dataType","require":false,"placeholder":"","selectValue":true,"selectOptions":[{"code":"staticData","name":"静态数据"},{"code":"dynamicData","name":"动态数据"}],"value":"dynamicData"},{"type":"el-input-number","label":"刷新时间(毫秒)","name":"refreshTime","relactiveDom":"dataType","relactiveDomValue":"dynamicData","value":600000},{"type":"el-button","label":"静态数据","name":"staticData","required":false,"placeholder":"","relactiveDom":"dataType","relactiveDomValue":"staticData","value":[{"data":1000,"axis":"苹果"},{"data":2229,"axis":"三星"},{"data":3879,"axis":"小米"},{"data":2379,"axis":"oppo"},{"data":4079,"axis":"vivo"}]},{"type":"dycustComponents","label":"","name":"dynamicData","required":false,"placeholder":"","relactiveDom":"dataType","relactiveDomValue":"dynamicData","chartType":"widget-barchart","dictKey":"BAR_PROPERTIES","value":{"chartProperties":{"create_time":"xAxis","sum_nums":"bar"},"setCode":"aj_report_single_city","chartType":"widget-barchart","contextData":{"city_name":"北京"}}}],"methods":[],"setup":[{"type":"el-input-text","label":"图层名称","name":"layerName","required":false,"placeholder":"","value":"柱状图-单一城市"},{"type":"el-switch","label":"竖展示","name":"verticalShow","required":false,"placeholder":"","value":false},{"type":"vue-color","label":"背景颜色","name":"background","required":false,"placeholder":"","value":""},[{"name":"柱体设置","list":[{"type":"el-slider","label":"最大宽度","name":"maxWidth","required":false,"placeholder":"","value":10},{"type":"el-slider","label":"圆角","name":"radius","require":false,"placeholder":"","value":5},{"type":"el-slider","label":"最小高度","name":"minHeight","require":false,"placeholder":"","value":0}]},{"name":"标题设置","list":[{"type":"el-switch","label":"标题显示","name":"isNoTitle","required":false,"placeholder":"","value":true},{"type":"el-input-text","label":"标题名","name":"titleText","required":false,"placeholder":"","value":""},{"type":"vue-color","label":"字体颜色","name":"textColor","required":false,"placeholder":"","value":"#FFD700"},{"type":"el-input-number","label":"字体字号","name":"textFontSize","required":false,"placeholder":"","value":20},{"type":"el-select","label":"字体粗细","name":"textFontWeight","required":false,"placeholder":"","selectOptions":[{"code":"normal","name":"正常"},{"code":"bold","name":"粗体"},{"code":"bolder","name":"特粗体"},{"code":"lighter","name":"细体"}],"value":"normal"},{"type":"el-select","label":"字体风格","name":"textFontStyle","required":false,"placeholder":"","selectOptions":[{"code":"normal","name":"正常"},{"code":"italic","name":"italic斜体"},{"code":"oblique","name":"oblique斜体"}],"value":"normal"},{"type":"el-select","label":"字体位置","name":"textAlign","required":false,"placeholder":"","selectOptions":[{"code":"center","name":"居中"},{"code":"left","name":"左对齐"},{"code":"right","name":"右对齐"}],"value":"center"},{"type":"el-input-text","label":"副标题名","name":"subText","required":false,"placeholder":"","value":""},{"type":"vue-color","label":"字体颜色","name":"subTextColor","required":false,"placeholder":"","value":"#fff"},{"type":"el-input-number","label":"字体字号","name":"subTextFontSize","required":false,"placeholder":"","value":20},{"type":"el-select","label":"字体粗细","name":"subTextFontWeight","required":false,"placeholder":"","selectOptions":[{"code":"normal","name":"正常"},{"code":"bold","name":"粗体"},{"code":"bolder","name":"特粗体"},{"code":"lighter","name":"细体"}],"value":"normal"},{"type":"el-select","label":"字体风格","name":"subTextFontStyle","required":false,"placeholder":"","selectOptions":[{"code":"normal","name":"正常"},{"code":"italic","name":"italic斜体"},{"code":"oblique","name":"oblique斜体"}],"value":"normal"}]},{"name":"X轴设置","list":[{"type":"el-switch","label":"显示","name":"hideX","required":false,"placeholder":"","value":true},{"type":"el-input-text","label":"坐标名","name":"nameX","required":false,"placeholder":"","value":""},{"type":"vue-color","label":"坐标名颜色","name":"nameColorX","required":false,"placeholder":"","value":"#fff"},{"type":"el-input-number","label":"坐标名字号","name":"nameFontSizeX","required":false,"placeholder":"","value":14},{"type":"vue-color","label":"数值颜色","name":"colorX","required":false,"placeholder":"","value":"#fff"},{"type":"el-input-number","label":"数值字号","name":"fontSizeX","required":false,"placeholder":"","value":14},{"type":"el-input-number","label":"数值间隔","name":"textInterval","required":false,"placeholder":"","value":0},{"type":"el-slider","label":"数值角度","name":"textAngleX","required":false,"placeholder":"","value":0},{"type":"el-switch","label":"坐标轴反转","name":"reversalX","required":false,"placeholder":"","value":false},{"type":"vue-color","label":"坐标轴颜色","name":"lineColorX","required":false,"placeholder":"","value":"#fff"},{"type":"el-input-number","label":"坐标轴宽度","name":"lineWidthX","required":false,"placeholder":"","value":1},{"type":"el-switch","label":"分割线显示","name":"isShowSplitLineX","require":false,"placeholder":"","value":false},{"type":"vue-color","label":"分割线颜色","name":"splitLineColorX","required":false,"placeholder":"","value":"#fff"},{"type":"el-input-number","label":"分割线宽度","name":"splitLineWidthX","required":false,"placeholder":"","value":1}]},{"name":"Y轴设置","list":[{"type":"el-switch","label":"显示","name":"isShowY","require":false,"placeholder":"","value":true},{"type":"el-input-text","label":"坐标名","name":"textNameY","require":false,"placeholder":"","value":""},{"type":"vue-color","label":"坐标名颜色","name":"nameColorY","required":false,"placeholder":"","value":"#fff"},{"type":"el-input-number","label":"坐标名字号","name":"nameFontSizeY","required":false,"placeholder":"","value":14},{"type":"vue-color","label":"数值颜色","name":"colorY","required":false,"placeholder":"","value":"#fff"},{"type":"el-input-number","label":"数值字号","name":"fontSizeY","required":false,"placeholder":"","value":14},{"type":"el-switch","label":"缩放","name":"scale","require":false,"placeholder":"","value":false},{"type":"el-input-number","label":"均分","name":"splitNumberY","required":false,"placeholder":"","value":0},{"type":"el-slider","label":"数值角度","name":"textAngleY","required":false,"placeholder":"","value":0},{"type":"el-switch","label":"坐标轴反转","name":"reversalY","required":false,"placeholder":"","value":false},{"type":"vue-color","label":"坐标轴颜色","name":"lineColorY","required":false,"placeholder":"","value":"#fff"},{"type":"el-input-number","label":"坐标轴宽度","name":"lineWidthY","required":false,"placeholder":"","value":1},{"type":"el-switch","label":"分割线显示","name":"isShowSplitLineY","require":false,"placeholder":"","value":false},{"type":"vue-color","label":"分割线颜色","name":"splitLineColorY","required":false,"placeholder":"","value":"#fff"},{"type":"el-input-number","label":"分割线宽度","name":"splitLineWidthY","required":false,"placeholder":"","value":1}]},{"name":"数值设定","list":[{"type":"el-switch","label":"显示","name":"isShow","required":false,"placeholder":"","value":true},{"type":"el-input-number","label":"距离","name":"distance","required":false,"placeholder":"","value":5},{"type":"el-input-number","label":"字体字号","name":"fontSize","required":false,"placeholder":"","value":14},{"type":"vue-color","label":"字体颜色","name":"subTextColor","required":false,"placeholder":"","value":"#fff"},{"type":"el-select","label":"字体粗细","name":"fontWeight","required":false,"placeholder":"","selectOptions":[{"code":"normal","name":"正常"},{"code":"bold","name":"粗体"},{"code":"bolder","name":"特粗体"},{"code":"lighter","name":"细体"}],"value":"normal"}]},{"name":"提示语设置","list":[{"type":"el-input-number","label":"字体字号","name":"tipsFontSize","required":false,"placeholder":"","value":16},{"type":"vue-color","label":"字体颜色","name":"tipsColor","required":false,"placeholder":"","value":"#00FEFF"}]},{"name":"坐标轴边距设置","list":[{"type":"el-slider","label":"左边距(像素)","name":"marginLeft","required":false,"placeholder":"","value":10},{"type":"el-slider","label":"顶边距(像素)","name":"marginTop","required":false,"placeholder":"","value":50},{"type":"el-slider","label":"右边距(像素)","name":"marginRight","required":false,"placeholder":"","value":40},{"type":"el-slider","label":"底边距(像素)","name":"marginBottom","required":false,"placeholder":"","value":10}]},{"name":"自定义配色","list":[{"type":"customColor","label":"","name":"customColor","required":false,"value":[{"color":"#ff7f50"},{"color":"#87cefa"},{"color":"#da70d6"},{"color":"#32cd32"},{"color":"#6495ed"}]}]},{"name":"组件联动","list":[{"type":"componentLinkage","label":"","name":"componentLinkage","required":false,"value":[]}]}]],"position":[{"type":"el-input-number","label":"左边距","name":"left","required":false,"placeholder":"","value":1209.26},{"type":"el-input-number","label":"上边距","name":"top","required":false,"placeholder":"","value":470.44},{"type":"el-input-number","label":"宽度","name":"width","required":false,"placeholder":"该容器在1920px大屏中的宽度","value":643.64},{"type":"el-input-number","label":"高度","name":"height","required":false,"placeholder":"该容器在1080px大屏中的高度","value":217.98}]}', null, 1, 0, 2, 'admin', '2023-05-12 09:43:48', 'admin', '2023-05-12 09:43:48', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('testForm', 'widget-select', '{"symbol":"circle","textFontStyle":"normal","reversalY":false,"reversalX":false,"minHeight":0,"marginRight":40,"textInterval":0,"isNoTitle":true,"nameColorY":"#fff","nameColorX":"#fff","textFontWeight":"normal","nameX":"","titleText":"","tipsFontSize":16,"radius":5,"isShowY":true,"splitLineWidthY":1,"fontWeight":"normal","height":1080,"maxWidth":10,"splitLineWidthX":1,"area":true,"textAngleX":0,"textAngleY":0,"textAlign":"center","subTextColor":"#fff","textColor":"#FFD700","subText":"","lineColorY":"#fff","lineColorX":"#fff","textNameY":"","marginLeft":10,"subTextFontSize":20,"tipsColor":"#00FEFF","background":"","fontSize":14,"marginBottom":10,"layerName":"下拉框","hideX":true,"componentLinkage":[{"widgetValue":"1vzit52b5m3-$-柱状图-单一城市-$-1","paramsConfig":[{"originKey":"label","targetKey":""},{"originKey":"value","targetKey":"city_name"}]}],"verticalShow":false,"distance":5,"backgroundImage":"","description":"","scale":false,"title":"","isShowSplitLineX":false,"select_color":"#FAD400","lineWidth":4,"isShowSplitLineY":false,"subTextFontStyle":"normal","splitLineColorY":"#fff","areaThickness":5,"splitLineColorX":"#fff","splitNumberY":0,"select_background":"rgba(115,170,229,.5)","fontSizeY":14,"smoothCurve":true,"fontSizeX":14,"backgroundColor":"rgba(52, 80, 106, 1)","widgetId":"2myqugbvpzc","colorY":"#fff","colorX":"#fff","nameFontSizeX":14,"markPoint":true,"nameFontSizeY":14,"isShow":true,"textFontSize":20,"pointSize":10,"customColor":[{"color":"#ff7f50"},{"color":"#87cefa"},{"color":"#da70d6"},{"color":"#32cd32"},{"color":"#6495ed"}],"subTextFontWeight":"normal","lineWidthX":1,"lineWidthY":1,"width":1920,"widgetCode":"widget-select","marginTop":50}', '{"dynamicData":{"chartProperties":{"city_name":"value"},"setCode":"aj_report_city_select","chartType":"widget-select","contextData":{}},"dataType":"dynamicData","refreshTime":600000,"staticData":[{"label":"苹果","value":1000},{"label":"三星","value":2229},{"label":"小米","value":3879},{"label":"oppo","value":2379},{"label":"vivo","value":4079}]}', '', '{"top":38.08,"left":923.03,"width":200,"index":2,"height":40}', '{"data":[{"type":"el-radio-group","label":"数据类型","name":"dataType","require":false,"placeholder":"","selectValue":true,"selectOptions":[{"code":"staticData","name":"静态数据"},{"code":"dynamicData","name":"动态数据"}],"value":"dynamicData"},{"type":"el-input-number","label":"刷新时间(毫秒)","name":"refreshTime","relactiveDom":"dataType","relactiveDomValue":"dynamicData","value":600000},{"type":"el-button","label":"静态数据","name":"staticData","required":false,"placeholder":"","relactiveDom":"dataType","relactiveDomValue":"staticData","value":[{"label":"苹果","value":1000},{"label":"三星","value":2229},{"label":"小米","value":3879},{"label":"oppo","value":2379},{"label":"vivo","value":4079}]},{"type":"dycustComponents","label":"","name":"dynamicData","required":false,"placeholder":"","relactiveDom":"dataType","relactiveDomValue":"dynamicData","chartType":"widget-select","dictKey":"SELECT_PROPERTIES","value":{"chartProperties":{"city_name":"value"},"setCode":"aj_report_city_select","chartType":"widget-select","contextData":{}}}],"setup":[{"type":"el-input-text","label":"图层名称","name":"layerName","required":false,"placeholder":"","value":"下拉框"},{"type":"vue-color","label":"字体颜色","name":"select_color","required":false,"placeholder":"","value":"#FAD400"},{"type":"vue-color","label":"字体背景","name":"select_background","required":false,"placeholder":"","value":"rgba(115,170,229,.5)"},[{"name":"组件联动","list":[{"type":"componentLinkage","label":"","name":"componentLinkage","required":false,"value":[{"widgetValue":"1vzit52b5m3-$-柱状图-单一城市-$-1","paramsConfig":[{"originKey":"label","targetKey":""},{"originKey":"value","targetKey":"city_name"}]}]}]}]],"position":[{"type":"el-input-number","label":"左边距","name":"left","required":false,"placeholder":"","value":923.03},{"type":"el-input-number","label":"上边距","name":"top","required":false,"placeholder":"","value":38.08},{"type":"el-input-number","label":"宽度","name":"width","required":false,"placeholder":"该容器在1920px大屏中的宽度","value":200},{"type":"el-input-number","label":"高度","name":"height","required":false,"placeholder":"该容器在1080px大屏中的高度","value":40}]}', null, 1, 0, 3, 'admin', '2023-05-12 09:43:48', 'admin', '2023-05-12 09:43:48', 1);
INSERT INTO `aj_report`.`gaea_report_dashboard_widget`(`report_code`, `type`, `setup`, `data`, `collapse`, `position`, `options`, `refresh_seconds`, `enable_flag`, `delete_flag`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('testForm', 'widget-form-time', '{"textFontStyle":"normal","lateralPosition":"center","reversalY":false,"reversalX":false,"minHeight":0,"marginRight":40,"textInterval":0,"isNoTitle":true,"nameColorY":"#fff","nameColorX":"#fff","textFontWeight":"normal","nameX":"","titleText":"","percentage":false,"tipsFontSize":16,"layoutFront":"horizontal","radius":5,"isShowY":true,"legendColor":"#fff","splitLineWidthY":1,"fontWeight":"normal","height":1080,"maxWidth":10,"splitLineWidthX":1,"textAngleX":0,"textAngleY":0,"textAlign":"center","textPerFontSize":20,"textNumColor":"#fff","lineColor":"#061740","subTextColor":"#fff","textColor":"#FFD700","subText":"","lineColorY":"#fff","lineColorX":"#fff","textNameY":"","marginLeft":10,"subTextFontSize":20,"tipsColor":"#00FEFF","color0Start":"#4FADFD","background":"","fontSize":14,"marginBottom":10,"layerName":"时间筛选器","hideX":true,"lineNumber":8,"textPerFontWeight":"normal","componentLinkage":[{"widgetValue":"1wvwcqi4yvj-$-柱状图-城市总览-$-0","paramsConfig":[{"originKey":"startTime","targetKey":"startTime"},{"originKey":"endTime","targetKey":"endTime"}]}],"verticalShow":false,"distance":5,"backgroundImage":"","textNumFontWeight":"normal","description":"","scale":false,"title":"","isShowSplitLineX":false,"select_color":"#FAD400","lineWidth":2,"isShowSplitLineY":false,"piechartStyle":"shixin","subTextFontStyle":"normal","splitLineColorY":"#fff","splitLineColorX":"#fff","legendWidth":15,"splitNumberY":0,"numberValue":true,"textPerColor":"#fff","nightingleRosetype":"area","select_background":"rgba(115,170,229,.5)","fontSizeY":14,"fontSizeX":14,"backgroundColor":"rgba(52, 80, 106, 1)","color100End":"#28E8FA","widgetId":"742j246n1sg","colorY":"#fff","colorX":"#fff","nameFontSizeX":14,"lineLength":19,"nameFontSizeY":14,"isShow":true,"textFontSize":20,"customColor":[{"color":"#ff7f50"},{"color":"#87cefa"},{"color":"#da70d6"},{"color":"#32cd32"},{"color":"#6495ed"}],"longitudinalPosition":"top","subTextFontWeight":"normal","lineWidthX":1,"lineWidthY":1,"textNumFontSize":40,"width":1920,"legendFontSize":12,"isShowLegend":true,"widgetCode":"widget-form-time","marginTop":50,"colorsurplus":"#173164"}', '{}', '', '{"top":29.92,"left":1365.59,"width":400,"index":3,"height":40}', '{"data":[],"setup":[{"type":"el-input-text","label":"图层名称","name":"layerName","required":false,"placeholder":"","value":"时间筛选器"},{"type":"vue-color","label":"背景","name":"select_background","required":false,"placeholder":"","value":"rgba(115,170,229,.5)"},[{"name":"组件联动","list":[{"type":"componentLinkage","label":"","name":"componentLinkage","required":false,"value":[{"widgetValue":"1wvwcqi4yvj-$-柱状图-城市总览-$-0","paramsConfig":[{"originKey":"startTime","targetKey":"startTime"},{"originKey":"endTime","targetKey":"endTime"}]}]}]}]],"position":[{"type":"el-input-number","label":"左边距","name":"left","required":false,"placeholder":"","value":1365.59},{"type":"el-input-number","label":"上边距","name":"top","required":false,"placeholder":"","value":29.92},{"type":"el-input-number","label":"宽度","name":"width","required":false,"placeholder":"该容器在1920px大屏中的宽度","value":400},{"type":"el-input-number","label":"高度","name":"height","required":false,"placeholder":"该容器在1080px大屏中的高度","value":40}]}', null, 1, 0, 4, 'admin', '2023-05-12 09:43:48', 'admin', '2023-05-12 09:43:48', 1);


INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`, `set_type`) VALUES ('log_ajdevices', '日志-资产统计', '', 'mysql_ajreport', 'SELECT device_type,COUNT(device_id)as nums from aj_report_devices GROUP BY device_type;', '[{\"device_type\":\"交换机\",\"nums\":12},{\"device_type\":\"服务器\",\"nums\":10},{\"device_type\":\"路由器\",\"nums\":4},{\"device_type\":\"防火墙\",\"nums\":2}]', 1, 0, 'admin', '2021-06-30 09:57:47', 'admin', '2021-06-30 09:57:47', 1, 'sql');
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`, `set_type`) VALUES ('log_ajfireacl', '日志-防火墙ACL次数', '', 'mysql_ajreport', 'SELECT acl_type,COUNT(id) as nums from aj_report_init.aj_report_fireacl GROUP BY acl_type;', '[{\"acl_type\":\"LDAP389\",\"nums\":13},{\"acl_type\":\"Server1433\",\"nums\":9},{\"acl_type\":\"共享文件445\",\"nums\":7},{\"acl_type\":\"存储514\",\"nums\":14},{\"acl_type\":\"网页浏览443\",\"nums\":31},{\"acl_type\":\"远程桌面3389\",\"nums\":62},{\"acl_type\":\"远程登陆23\",\"nums\":66}]', 1, 0, 'admin', '2021-06-30 10:41:36', 'admin', '2021-06-30 10:41:36', 1, 'sql');
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`, `set_type`) VALUES ('log_ajattack', '日志-攻击占比', '', 'mysql_ajreport', 'SELECT attack_type,COUNT(id)as nums from aj_report_fireattack GROUP BY attack_type;', '[{\"attack_type\":\"SQL注入\",\"nums\":9},{\"attack_type\":\"UDP\",\"nums\":11},{\"attack_type\":\"WEB\",\"nums\":7},{\"attack_type\":\"僵尸网络\",\"nums\":24},{\"attack_type\":\"弱口令\",\"nums\":6},{\"attack_type\":\"端口扫描\",\"nums\":16},{\"attack_type\":\"网站扫描\",\"nums\":8},{\"attack_type\":\"超大ICMP\",\"nums\":19}]', 1, 0, 'admin', '2021-06-30 10:44:01', 'admin', '2021-06-30 13:13:56', 3, 'sql');
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`, `set_type`) VALUES ('log_ajmailfailtop5', '日志-邮件认证失败top5', '', 'mysql_ajreport', 'SELECT username,count(id)as nums from aj_report_mail WHERE status=0 GROUP BY username ORDER BY nums desc limit 5;', '[{\"nums\":63,\"username\":\"zhangsi\"},{\"nums\":52,\"username\":\"wangwu\"},{\"nums\":39,\"username\":\"liliu\"},{\"nums\":39,\"username\":\"IT1\"},{\"nums\":30,\"username\":\"IT2\"}]', 1, 0, 'admin', '2021-06-30 11:07:53', 'admin', '2021-06-30 11:07:53', 1, 'sql');
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`, `set_type`) VALUES ('log_ajmailfail', '日志-邮件认证失败趋势', '', 'mysql_ajreport', 'SELECT DATE_FORMAT(create_time,\'%Y-%m-%d\')as date,count(id)as nums from aj_report_mail WHERE status=0 \ngroup by date', '[{\"date\":\"2021-06-21\",\"nums\":25},{\"date\":\"2021-06-22\",\"nums\":16},{\"date\":\"2021-06-23\",\"nums\":89},{\"date\":\"2021-06-24\",\"nums\":61},{\"date\":\"2021-06-25\",\"nums\":53}]', 1, 0, 'admin', '2021-06-30 12:58:19', 'admin', '2021-06-30 12:58:19', 1, 'sql');
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`, `set_type`) VALUES ('log_ajwifiamount', '日志-wifi登陆趋势', '', 'mysql_ajreport', 'SELECT * from aj_report_wifiamount;', '[{\"fail\":15,\"datetime\":\"2021-06-17\",\"success\":210},{\"fail\":43,\"datetime\":\"2021-06-18\",\"success\":234},{\"fail\":28,\"datetime\":\"2021-06-19\",\"success\":199},{\"fail\":80,\"datetime\":\"2021-06-20\",\"success\":260},{\"fail\":45,\"datetime\":\"2021-06-21\",\"success\":245},{\"fail\":26,\"datetime\":\"2021-06-22\",\"success\":216},{\"fail\":10,\"datetime\":\"2021-06-23\",\"success\":150}]', 1, 0, 'admin', '2021-06-30 13:07:35', 'admin', '2021-06-30 13:07:35', 1, 'sql');
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`, `set_type`) VALUES ('car_ajpro', '汽车-生产趋势', '', 'mysql_ajreport', 'SELECT datetime,sum(manus)as nums from aj_report_manus GROUP BY datetime;', '[{\"datetime\":\"2021-06-18\",\"nums\":252},{\"datetime\":\"2021-06-19\",\"nums\":133},{\"datetime\":\"2021-06-20\",\"nums\":189},{\"datetime\":\"2021-06-21\",\"nums\":219},{\"datetime\":\"2021-06-22\",\"nums\":159}]', 1, 0, 'admin', '2021-06-30 14:23:02', 'admin', '2021-06-30 14:23:02', 1, 'sql');
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`, `set_type`) VALUES ('car_ajsale', '汽车-销售趋势', '', 'mysql_ajreport', 'SELECT datetime,sum(sales)as nums from aj_report_manus GROUP BY datetime;', '[{\"datetime\":\"2021-06-18\",\"nums\":231},{\"datetime\":\"2021-06-19\",\"nums\":140},{\"datetime\":\"2021-06-20\",\"nums\":170},{\"datetime\":\"2021-06-21\",\"nums\":191},{\"datetime\":\"2021-06-22\",\"nums\":144}]', 1, 0, 'admin', '2021-06-30 14:24:33', 'admin', '2021-06-30 14:24:33', 1, 'sql');
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`, `set_type`) VALUES ('car_ajproTop5', '汽车-生产TOP5', '', 'mysql_ajreport', 'SELECT brand,sum(manus)as nums from aj_report_manus GROUP BY brand ORDER BY nums desc limit 5;', '[{\"brand\":\"E-30\",\"nums\":215},{\"brand\":\"C-50\",\"nums\":210},{\"brand\":\"D-40\",\"nums\":175},{\"brand\":\"A-100\",\"nums\":100},{\"brand\":\"A-110\",\"nums\":97}]', 1, 0, 'admin', '2021-06-30 14:26:55', 'admin', '2021-06-30 14:26:55', 1, 'sql');
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`, `set_type`) VALUES ('car_ajsaleTop5', '汽车-销售TOP5', '', 'mysql_ajreport', 'SELECT brand,sum(sales)as nums from aj_report_manus GROUP BY brand ORDER BY nums desc limit 5;', '[{\"brand\":\"E-30\",\"nums\":221},{\"brand\":\"C-50\",\"nums\":189},{\"brand\":\"D-40\",\"nums\":169},{\"brand\":\"A-100\",\"nums\":81},{\"brand\":\"B-100\",\"nums\":80}]', 1, 0, 'admin', '2021-06-30 14:30:00', 'admin', '2021-06-30 14:30:00', 1, 'sql');
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`, `set_type`) VALUES ('car_ajunsale', '汽车-滞销', '', 'mysql_ajreport', 'SELECT brand,sum(unsales) as nums from aj_report_manus GROUP BY brand ORDER BY nums desc;', '[{\"brand\":\"C-50\",\"nums\":21},{\"brand\":\"A-110\",\"nums\":20},{\"brand\":\"A-100\",\"nums\":19},{\"brand\":\"B-110\",\"nums\":11},{\"brand\":\"E-30\",\"nums\":9},{\"brand\":\"D-40\",\"nums\":6},{\"brand\":\"B-100\",\"nums\":5}]', 1, 0, 'admin', '2021-06-30 14:30:46', 'admin', '2021-06-30 14:30:46', 1, 'sql');
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`, `set_type`) VALUES ('car_ajrework', '汽车-返修', '', 'mysql_ajreport', 'SELECT brand,sum(rework) as nums from aj_report_manus GROUP BY brand ORDER BY nums desc;', '[{\"brand\":\"E-30\",\"nums\":58},{\"brand\":\"D-40\",\"nums\":27},{\"brand\":\"C-50\",\"nums\":22},{\"brand\":\"A-100\",\"nums\":5},{\"brand\":\"A-110\",\"nums\":5},{\"brand\":\"B-110\",\"nums\":5},{\"brand\":\"B-100\",\"nums\":4}]', 1, 0, 'admin', '2021-06-30 14:31:16', 'admin', '2021-06-30 14:31:16', 1, 'sql');
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`, `set_type`) VALUES ('car_ajreturn', '汽车-退货', '', 'mysql_ajreport', 'SELECT brand,sum(`return`) as nums from aj_report_manus GROUP BY brand ORDER BY nums desc;', '[{\"brand\":\"E-30\",\"nums\":24},{\"brand\":\"C-50\",\"nums\":10},{\"brand\":\"D-40\",\"nums\":6},{\"brand\":\"A-110\",\"nums\":2},{\"brand\":\"B-110\",\"nums\":1},{\"brand\":\"A-100\",\"nums\":0},{\"brand\":\"B-100\",\"nums\":0}]', 1, 0, 'admin', '2021-06-30 14:31:45', 'admin', '2021-06-30 14:31:45', 1, 'sql');
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`, `set_type`) VALUES ('acc_ajacc', '访问-访问人数趋势', '', 'mysql_ajreport', 'SELECT datetime,access from aj_report_access ORDER BY datetime;', '[{\"datetime\":\"2021-06-18\",\"access\":1000},{\"datetime\":\"2021-06-19\",\"access\":1200},{\"datetime\":\"2021-06-20\",\"access\":1600},{\"datetime\":\"2021-06-21\",\"access\":2000},{\"datetime\":\"2021-06-22\",\"access\":800}]', 1, 0, 'admin', '2021-06-30 15:15:17', 'admin', '2021-06-30 15:16:04', 2, 'sql');
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`, `set_type`) VALUES ('acc_ajregister', '访问-注册人数趋势', '', 'mysql_ajreport', 'SELECT datetime,register from aj_report_access ORDER BY datetime;', '[{\"datetime\":\"2021-06-18\",\"register\":12},{\"datetime\":\"2021-06-19\",\"register\":20},{\"datetime\":\"2021-06-20\",\"register\":40},{\"datetime\":\"2021-06-21\",\"register\":100},{\"datetime\":\"2021-06-22\",\"register\":30}]', 1, 0, 'admin', '2021-06-30 15:15:55', 'admin', '2021-06-30 15:15:55', 1, 'sql');
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`, `set_type`) VALUES ('acc_ajrt', '访问-系统RT', '', 'mysql_ajreport', 'SELECT datetime,rt from aj_report_exper ORDER BY datetime;', '[{\"datetime\":\"2021-06-18\",\"rt\":90.92},{\"datetime\":\"2021-06-19\",\"rt\":100.02},{\"datetime\":\"2021-06-20\",\"rt\":98.89},{\"datetime\":\"2021-06-21\",\"rt\":110.99},{\"datetime\":\"2021-06-22\",\"rt\":89.78}]', 1, 0, 'admin', '2021-06-30 15:16:37', 'admin', '2021-07-01 16:06:00', 2, 'sql');
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`, `set_type`) VALUES ('acc_ajqps', '访问-系统QPS', '', 'mysql_ajreport', 'SELECT datetime,qps from aj_report_exper ORDER BY datetime;', '[{\"datetime\":\"2021-06-18\",\"qps\":9000},{\"datetime\":\"2021-06-19\",\"qps\":10000},{\"datetime\":\"2021-06-20\",\"qps\":9560},{\"datetime\":\"2021-06-21\",\"qps\":13456},{\"datetime\":\"2021-06-22\",\"qps\":8990}]', 1, 0, 'admin', '2021-06-30 15:19:06', 'admin', '2021-06-30 15:19:06', 1, 'sql');
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`, `set_type`) VALUES ('acc_ajerror', '访问-系统ERROR', '', 'mysql_ajreport', 'SELECT datetime,error from aj_report_exper ORDER BY datetime;', '[{\"datetime\":\"2021-06-18\",\"error\":2},{\"datetime\":\"2021-06-19\",\"error\":3},{\"datetime\":\"2021-06-20\",\"error\":1},{\"datetime\":\"2021-06-21\",\"error\":9},{\"datetime\":\"2021-06-22\",\"error\":3}]', 1, 0, 'admin', '2021-06-30 15:19:33', 'admin', '2021-06-30 15:19:33', 1, 'sql');
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`, `set_type`) VALUES ('amount_1', 'amount1', '', 'mysql_ajreport', 'SELECT sum(success)as nums from aj_report_wifiamount;', '[{\"nums\":1514}]', 1, 0, 'admin', '2021-07-05 15:00:18', 'admin', '2021-07-05 15:00:18', 1, 'sql');
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`, `set_type`) VALUES ('logis_1', '库存', '', 'mysql_ajreport', 'select name,nums from aj_report_common1 order by nums', '[{\"name\":\"上海\",\"nums\":500},{\"name\":\"北京\",\"nums\":600},{\"name\":\"西安\",\"nums\":1000},{\"name\":\"河南\",\"nums\":1200},{\"name\":\"武汉\",\"nums\":2000}]', 1, 0, 'admin', '2021-07-06 15:44:41', 'admin', '2021-07-06 15:54:16', 3, 'sql');
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`, `set_type`) VALUES ('logis_2', '收车量', '', 'mysql_ajreport', 'select name,nums from aj_report_common2 order by nums;', '[{\"name\":\"武汉\",\"nums\":20},{\"name\":\"河南\",\"nums\":50},{\"name\":\"西安\",\"nums\":70},{\"name\":\"北京\",\"nums\":100},{\"name\":\"上海\",\"nums\":200}]', 1, 0, 'admin', '2021-07-06 16:51:27', 'admin', '2021-07-06 16:51:27', 1, 'sql');
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`, `set_type`) VALUES ('logis_3', '收发车情况', '', 'mysql_ajreport', 'select time,collect,start from aj_report_common3;', '[{\"start\":8,\"time\":\"1月\",\"collect\":10},{\"start\":12,\"time\":\"2月\",\"collect\":15},{\"start\":22,\"time\":\"3月\",\"collect\":20},{\"start\":28,\"time\":\"4月\",\"collect\":30},{\"start\":35,\"time\":\"5月\",\"collect\":28},{\"start\":38,\"time\":\"6月\",\"collect\":40},{\"start\":100,\"time\":\"7月\",\"collect\":80},{\"start\":120,\"time\":\"8月\",\"collect\":90},{\"start\":89,\"time\":\"9月\",\"collect\":65},{\"start\":50,\"time\":\"10月\",\"collect\":50},{\"start\":34,\"time\":\"11月\",\"collect\":35},{\"start\":23,\"time\":\"12月\",\"collect\":27}]', 1, 0, 'admin', '2021-07-06 17:24:16', 'admin', '2021-07-06 17:30:15', 2, 'sql');
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`, `set_type`) VALUES ('logis_table', '表格测试', '', 'mysql_ajreport', 'select date,address,name from aj_report_table;', '[{\"date\":\"2021-05-01\",\"address\":\"这是一条测试表格事件1\",\"name\":\"上汽安吉\"},{\"date\":\"2021-05-02\",\"address\":\"这是一条测试表格事件2\",\"name\":\"上汽大通\"},{\"date\":\"2021-05-03\",\"address\":\"这是一条测试表格事件3\",\"name\":\"上汽智行\"},{\"date\":\"2021-05-04\",\"address\":\"这是一条测试表格事件4\",\"name\":\"上汽国际\"},{\"date\":\"2021-05-05\",\"address\":\"这是一条测试表格事件5\",\"name\":\"上汽国内\"},{\"date\":\"2021-05-06\",\"address\":\"这是一条测试表格事件6\",\"name\":\"上汽运输\"},{\"date\":\"2021-05-07\",\"address\":\"这是一条测试表格事件7\",\"name\":\"上汽大众\"}]', 1, 0, 'admin', '2021-07-06 17:56:23', 'admin', '2021-07-07 10:59:34', 4, 'sql');
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`, `set_type`) VALUES ('per', '百分比', '', 'mysql_ajreport', 'select doub from aj_report_nums where id =2;', '[{\"doub\":55.33}]', 1, 0, 'admin', '2021-07-14 16:17:14', 'admin', '2021-07-15 10:35:21', 2, 'sql');
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`, `set_type`) VALUES ('barstack_ajreport', '柱状堆叠数据', '', 'mysql_ajreport', 'select time,type,nums from aj_report_barstack', '[{\"time\":\"2021-07-27\",\"type\":\"A\",\"nums\":12},{\"time\":\"2021-07-27\",\"type\":\"B\",\"nums\":20},{\"time\":\"2021-07-27\",\"type\":\"C\",\"nums\":11},{\"time\":\"2021-07-26\",\"type\":\"A\",\"nums\":11},{\"time\":\"2021-07-26\",\"type\":\"B\",\"nums\":30},{\"time\":\"2021-07-25\",\"type\":\"B\",\"nums\":20},{\"time\":\"2021-07-25\",\"type\":\"C\",\"nums\":15}]', 1, 0, 'admin', '2021-07-27 19:50:52', 'admin', '2021-08-16 14:08:51', 7, 'sql');
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`, `set_type`) VALUES ('compare_ajreport', '柱状对比图示例数据', '', 'mysql_ajreport', 'SELECT time,type,nums from aj_report_comparestack', '[{\"time\":\"2021-08-23\",\"type\":\"成功\",\"nums\":12},{\"time\":\"2021-08-23\",\"type\":\"失败\",\"nums\":1},{\"time\":\"2021-08-24\",\"type\":\"成功\",\"nums\":24},{\"time\":\"2021-08-24\",\"type\":\"失败\",\"nums\":5},{\"time\":\"2021-08-25\",\"type\":\"成功\",\"nums\":13},{\"time\":\"2021-08-25\",\"type\":\"失败\",\"nums\":8},{\"time\":\"2021-08-26\",\"type\":\"成功\",\"nums\":19},{\"time\":\"2021-08-26\",\"type\":\"失败\",\"nums\":3},{\"time\":\"2021-08-27\",\"type\":\"成功\",\"nums\":9},{\"time\":\"2021-08-27\",\"type\":\"失败\",\"nums\":15}]', 1, 0, 'admin', '2021-08-27 13:48:33', 'admin', '2021-08-27 13:48:33', 1, 'sql');
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `set_type`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('aj_report_city_total', '城市数据总览', '', 'sql', 'mysql_ajreport', 'SELECT city_name,sum(nums) sum_nums  FROM aj_report_city where create_time>=\'${startTime}\' and create_time < \'${endTime}\' group by city_name', '[{"city_name":"上海","sum_nums":138},{"city_name":"北京","sum_nums":188},{"city_name":"天津","sum_nums":150},{"city_name":"广州","sum_nums":134},{"city_name":"成都","sum_nums":125},{"city_name":"杭州","sum_nums":140},{"city_name":"重庆","sum_nums":135}]', 1, 0, 'admin', '2023-05-10 16:10:27', 'admin', '2023-05-12 09:43:42', 9);
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `set_type`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('aj_report_single_city', '单一城市数据', '', 'sql', 'mysql_ajreport', 'SELECT DATE_FORMAT(create_time,\'%Y-%m-%d\') create_time,sum(nums) sum_nums  FROM aj_report_city where city_name =\'${city_name}\' group by create_time ;', '[{"create_time":"2023-05-05","sum_nums":25},{"create_time":"2023-05-06","sum_nums":35},{"create_time":"2023-05-07","sum_nums":45},{"create_time":"2023-05-08","sum_nums":12},{"create_time":"2023-05-09","sum_nums":44},{"create_time":"2023-05-10","sum_nums":27}]', 1, 0, 'admin', '2023-05-10 16:15:57', 'admin', '2023-05-10 16:15:57', 1);
INSERT INTO `aj_report`.`gaea_report_data_set`(`set_code`, `set_name`, `set_desc`, `set_type`, `source_code`, `dyn_sentence`, `case_result`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('aj_report_city_select', '城市名称下拉', '', 'sql', 'mysql_ajreport', 'SELECT DISTINCT(city_code)city_code ,city_name  FROM aj_report_city group by city_code,city_name  ;', '[{"city_name":"北京","city_code":"beijing"},{"city_name":"成都","city_code":"chengdu"},{"city_name":"重庆","city_code":"chongqing"},{"city_name":"广州","city_code":"guangzhou"},{"city_name":"杭州","city_code":"hangzhou"},{"city_name":"上海","city_code":"shanghai"},{"city_name":"天津","city_code":"tianjin"}]', 1, 0, 'admin', '2023-05-10 16:20:50', 'admin', '2023-05-10 16:20:50', 1);


INSERT INTO `aj_report`.`gaea_report_data_set_param` (set_code, param_name, param_desc, param_type, sample_item, required_flag, validation_rules, order_num, enable_flag, delete_flag, create_by, create_time, update_by, update_time, version) VALUES ('aj_report_single_city', 'city_name', '', '', '北京', 1, 'function verification(data){
	//自定义脚本内容
	//可返回true/false单纯校验键入的data正确性
	//可返回文本，实时替换,比如当前时间等
	//return "2099-01-01 00:00:00";
	return true;
}', null, 1, 0, 'admin', '2023-05-10 16:15:57', 'admin', '2023-05-10 16:15:57', 1);
INSERT INTO `aj_report`.`gaea_report_data_set_param` (set_code, param_name, param_desc, param_type, sample_item, required_flag, validation_rules, order_num, enable_flag, delete_flag, create_by, create_time, update_by, update_time, version) VALUES ('aj_report_city_total', 'startTime', '', '', '2023-05-12', 1, 'function verification(data){
	//自定义脚本内容
	//可返回true/false单纯校验键入的data正确性
	//可返回文本，实时替换,比如当前时间等
	//return "2099-01-01 00:00:00";
	//设置日期，当前日期的前七天
	data = data.sampleItem;
    if(data.length == 10){
		return getDay(-7);
	}
	return data;
}

function getDay(day){
　　var today = new Date();
　　var targetday_milliseconds=today.getTime() + 1000*60*60*24*day;
　　today.setTime(targetday_milliseconds); //注意，这行是关键代码
　　var tYear = today.getFullYear();
　　var tMonth = today.getMonth();
　　var tDate = today.getDate();
　　tMonth = doHandleMonth(tMonth + 1);
　　tDate = doHandleMonth(tDate);
　　return tYear+"-"+tMonth+"-"+tDate+" 00:00:00";
}

function doHandleMonth(month){
　　var m = month;
　　if(month.toString().length == 1){
　　　　m = "0" + month;
　　}
　　return m;
}', null, 1, 0, 'admin', '2023-05-12 09:43:42', 'admin', '2023-05-12 09:43:42', 1);
INSERT INTO `aj_report`.`gaea_report_data_set_param` (set_code, param_name, param_desc, param_type, sample_item, required_flag, validation_rules, order_num, enable_flag, delete_flag, create_by, create_time, update_by, update_time, version) VALUES ('aj_report_city_total', 'endTime', '', '', '2023-05-13', 1, 'function verification(data){
	//自定义脚本内容
	//可返回true/false单纯校验键入的data正确性
	//可返回文本，实时替换,比如当前时间等
	//return "2099-01-01 00:00:00";
	//设置日期，当前日期的前七天
	data = data.sampleItem;
    if(data.length == 10){
		return getDay(1);
	}
	return data;
}

function getDay(day){
　　var today = new Date();
　　var targetday_milliseconds=today.getTime() + 1000*60*60*24*day;
　　today.setTime(targetday_milliseconds); //注意，这行是关键代码
　　var tYear = today.getFullYear();
　　var tMonth = today.getMonth();
　　var tDate = today.getDate();
　　tMonth = doHandleMonth(tMonth + 1);
　　tDate = doHandleMonth(tDate);
　　return tYear+"-"+tMonth+"-"+tDate+" 00:00:00";
}

function doHandleMonth(month){
　　var m = month;
　　if(month.toString().length == 1){
　　　　m = "0" + month;
　　}
　　return m;
}', null, 1, 0, 'admin', '2023-05-12 09:43:42', 'admin', '2023-05-12 09:43:42', 1);


INSERT INTO `aj_report`.`gaea_report_data_source`(`source_code`, `source_name`, `source_desc`, `source_type`, `source_config`, `enable_flag`, `delete_flag`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('mysql_ajreport', 'mysql数据源', '', 'mysql', '{\"driverName\":\"com.mysql.cj.jdbc.Driver\",\"jdbcUrl\":\"jdbc:mysql://127.0.0.1:3306/aj_report_init?useUnicode=true&characterEncoding=UTF-8&serverTimezone=GMT%2B8\",\"username\":\"ajreport\",\"password\":\"ajreport\"}', 1, 0, 'admin', '2021-06-30 09:48:46', 'admin', '2021-06-30 09:48:46', 1);

SET FOREIGN_KEY_CHECKS = 1;
