## 注意事项

- 之前版本更新至本版本时，可能会遇到图表不显示静态、动态数据，需对该图表重新配置；如果已对旧版本进行二次开发，请谨慎更新。<br>
  跨版本更新可查对应版本的[releases](https://gitee.com/anji-plus/report/releases)。<br>

- 1.0版本调整了底层sql，具体位置是：report-core/src/main/resource/db.migration，
  删除了过往所有的sql，现在此目录下sql仅包含aj_report基础信息库的相关sql，sql文件的命名也会和版本号保持一致，
  提供的示例数据（aj_report_init数据库的sql），aj_report_init_example.sql 文件放置在 doc/example目录下。

- 如果需要将之前版本的示例数据删除，delete_aj_report_init_example.sql 文件放置在 doc/example目录下。

- 对于从之前版本升级到1.0.0版本，必须解决新旧sql的冲突问题，因为V1.0.0版本同样默认启用flyway，如果不解决冲突，代码启动flyway就会报错，
  从0.9.9版本更新到1.0.0版本的更新sql，请参照下面的步骤内容进行操作，
  如果从更低的版本升级到V1.0.0，请先升级到V0.9.9版本，可查对应版本的[releases](https://gitee.com/anji-plus/report/releases)。

**如果从V0.9.9版本更新至V1.0.0版本后需要继续使用flyway功能，必须解决新旧sql的冲突问题**

- 1、将自己系统的数据库数据进行备份
- 2、手动执行V0.9.9更新的V1.0.0增量sql <br>
  这样就可以使用V1.0.0全部的功能。

```
INSERT INTO `aj_report`.`gaea_dict`(`dict_name`, `dict_code`, `remark`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('下拉框属性', 'SELECT_PROPERTIES', '下拉框属性', 'admin', NOW(), 'admin', NOW(), 1);

INSERT INTO `aj_report`.`gaea_dict_item`(`dict_code`, `item_name`, `item_value`, `item_extend`, `enabled`, `locale`, `remark`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('SELECT_PROPERTIES', '显示值', 'label', NULL, 1, 'zh', NULL, NULL, 'admin', NOW(), 'admin', NOW(), 1);
INSERT INTO `aj_report`.`gaea_dict_item`(`dict_code`, `item_name`, `item_value`, `item_extend`, `enabled`, `locale`, `remark`, `sort`, `create_by`, `create_time`, `update_by`, `update_time`, `version`) VALUES ('SELECT_PROPERTIES', '提交值', 'value', NULL, 1, 'zh', NULL, NULL, 'admin', NOW(), 'admin', NOW(), 1);
```

- 3.清空flyway_schema_history表并插入一条数据到表中 <br>
  这样可以解决flyway的冲突问题，如果flyway一直都是禁用的，那这步可以不做。

```
truncate table aj_report.flyway_schema_history;

INSERT INTO aj_report.flyway_schema_history (installed_rank, version, description, type, script, checksum, installed_by, installed_on, execution_time, success) 
VALUES (1, '1.0.0', 'init', 'SQL', 'V1.0.0__init.sql', -1762151859, 'root', '2023-05-05 15:39:07', 588, 1);

```

<br>

**如果是直接使用V1.0.0版本，以上都不需要处理**

## 新增/修复

### 新增

- 1、图层唯一标识（页面不显示）
- 2、下拉框数据联动
- 3、时间筛选器联动
- 4、大屏设计器图表联动 --贡献人 程序员世林@cxysl
- 5、大屏设计器支持缩放
- 6、大屏设计器标尺更新
- 7、图层支持锁定、解锁
- 8、admin账号增加重置密码功能
- 9、增加双Y柱图
- 10、增加刻度尺

### 修复

- 1、柱状图渐变色提示语未生效
- 2、柱线图图例固定先柱后折
- 3、swagger界面（ip:port/swagger-ui.html）
- 4、雷达图动态数据不显示
- 5、权限管理查询不生效
- 6、刻度尺组件预览数据无显示

### 优化

- 1、大屏动态数据刷新时间-默认由5秒调整为10分钟
- 2、图例名称的调整
- 3、数据集-js可以解析页面自定义数组
- 4、柱/线图--XY配置项调整
- 5、数据集测试预览后，点击保存时将只会保存一条

### 其他

- 1、文档更新
- 2、移除Druid
