/*
 * Decompiled with CFR 0.152.
 */
package com.kingbase8.core;

import com.kingbase8.core.JdbcCallParseInfo;
import com.kingbase8.core.NativeQuery;
import com.kingbase8.core.SqlCommand;
import com.kingbase8.core.SqlCommandType;
import com.kingbase8.core.Utils;
import com.kingbase8.jdbc.EscapeSyntaxCallMode;
import com.kingbase8.jdbc.KBEscapedFunctions2;
import com.kingbase8.util.GT;
import com.kingbase8.util.KSQLException;
import com.kingbase8.util.KSQLState;
import com.kingbase8.util.TraceLogger;
import com.kingbase8.util.Word;
import com.kingbase8.util.Yylex;
import java.io.CharArrayReader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;

public class Parser {
    private static final int[] NO_BINDS = new int[0];
    private static final char[] QUOTE_OR_ALPHABETIC_MARKER_OR_PARENTHESIS_T = new char[]{'\"', '0', '('};
    private static final char[] QUOTE_OR_ALPHABETIC_MARKER_T = new char[]{'\"', '0'};
    private static final char[] SINGLE_QUOTE_T = new char[]{'\''};

    public static List<NativeQuery> parseJdbcSql(String queryStr, boolean standardConformingStr, boolean withParametersT, boolean splitStatementsT, boolean isBatchedReWriteConfiguredT, String compatibleLevel, String ... returningColNames) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!withParametersT && !splitStatementsT && returningColNames != null && returningColNames.length == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return Collections.singletonList(new NativeQuery(queryStr, SqlCommand.createStatementTypeInfo(SqlCommandType.BLANK)));
        }
        Vector<Integer> funbody_index = null;
        if ("oracle".equals(compatibleLevel) || "mysql".equals(compatibleLevel)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            funbody_index = Parser.findoutFunctionBodyRange_index(queryStr);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int fragmentStartT = 0;
        int inParenthesisT = 0;
        char[] arrayChars = queryStr.toCharArray();
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        StringBuilder _nativeSql = new StringBuilder(queryStr.length() + 10);
        ArrayList<String> bindParamNamesList = null;
        ArrayList<Integer> bindPositionsList = null;
        List<NativeQuery> nativeQueriesList = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean isCurrentReWriteCompatibleT = false;
        boolean isValuesFoundT = false;
        int valuesBraceOpenPositionT = -1;
        int valuesBraceClosePositionT = -1;
        boolean valuesBraceCloseFoundT = false;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean isInsertPresentT = false;
        boolean isReturningPresentT = false;
        boolean isReturningPresentPrevT = false;
        SqlCommandType curCommandTypeT = SqlCommandType.BLANK;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        SqlCommandType prevCommandTypeT = SqlCommandType.BLANK;
        int numberOfStatements = 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean whitespaceOnlyT = true;
        int _keyWordCount = 0;
        int _keywordStart = -1;
        int _keywordEnd = -1;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (int i = 0; i < arrayChars.length; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            char aChar = arrayChars[i];
            boolean isKeyWordChar = false;
            whitespaceOnlyT &= aChar == ';' || Character.isWhitespace(aChar);
            _keywordEnd = i;
            switch (aChar) {
                case '\'': {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    i = Parser.parseSingleQuotes(arrayChars, i, standardConformingStr);
                    break;
                }
                case '\"': {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    i = Parser.parseDoubleQuotes(arrayChars, i);
                    break;
                }
                case '-': {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    i = Parser.parseLineComment(arrayChars, i);
                    break;
                }
                case '/': {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    i = Parser.parseBlockComment(arrayChars, i);
                    break;
                }
                case '$': {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    i = Parser.parseDollarQuotes(arrayChars, i);
                    break;
                }
                case ')': {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (--inParenthesisT != 0 || !isValuesFoundT || valuesBraceCloseFoundT) break;
                    valuesBraceClosePositionT = _nativeSql.length() + i - fragmentStartT;
                    break;
                }
                case '?': {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _nativeSql.append(arrayChars, fragmentStartT, i - fragmentStartT);
                    if (i + 1 < arrayChars.length && arrayChars[i + 1] == '?') {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _nativeSql.append('?');
                        ++i;
                    } else {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if (!withParametersT) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            _nativeSql.append('?');
                        } else {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            if (bindPositionsList == null) {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                bindPositionsList = new ArrayList<Integer>();
                            }
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            bindPositionsList.add(_nativeSql.length());
                            int _bindIndex = bindPositionsList.size();
                            _nativeSql.append(NativeQuery._bindName(_bindIndex));
                        }
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    fragmentStartT = i + 1;
                    break;
                }
                case ':': {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (i + 1 < arrayChars.length && arrayChars[i + 1] == ':') {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        ++i;
                        break;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    int j = Parser.parseColonParamName(arrayChars, i);
                    if (j <= i) break;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _nativeSql.append(arrayChars, fragmentStartT, i - fragmentStartT);
                    if (!withParametersT) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _nativeSql.append(arrayChars, i, j - i);
                    } else {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if (bindPositionsList == null) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            bindPositionsList = new ArrayList();
                            bindParamNamesList = new ArrayList<String>();
                        }
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        bindParamNamesList.add(String.valueOf(arrayChars, i + 1, j - i - 1));
                        bindPositionsList.add(_nativeSql.length());
                        int _bindIndex = bindPositionsList.size();
                        _nativeSql.append(NativeQuery._bindName(_bindIndex));
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    i = j - 1;
                    fragmentStartT = j;
                    break;
                }
                case ';': {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (("oracle".equals(compatibleLevel) || "mysql".equals(compatibleLevel)) && Parser.isInfunctionbody(i, funbody_index)) break;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (inParenthesisT != 0) break;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (!whitespaceOnlyT) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        ++numberOfStatements;
                        _nativeSql.append(arrayChars, fragmentStartT, i - fragmentStartT);
                        whitespaceOnlyT = true;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    fragmentStartT = i + 1;
                    if (_nativeSql.length() > 0) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if (Parser.addReturning(_nativeSql, curCommandTypeT, returningColNames, isReturningPresentT)) {
                            isReturningPresentT = true;
                        }
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if (splitStatementsT) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            if (nativeQueriesList == null) {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                nativeQueriesList = new ArrayList<NativeQuery>();
                            }
                            if (!isValuesFoundT || !isCurrentReWriteCompatibleT || valuesBraceClosePositionT == -1 || bindPositionsList != null && valuesBraceClosePositionT < (Integer)bindPositionsList.get(bindPositionsList.size() - 1)) {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                valuesBraceOpenPositionT = -1;
                                valuesBraceClosePositionT = -1;
                            }
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            nativeQueriesList.add(new NativeQuery(_nativeSql.toString(), Parser.toIntArray(bindPositionsList), bindParamNamesList, false, SqlCommand.createStatementTypeInfo(curCommandTypeT, isBatchedReWriteConfiguredT, valuesBraceOpenPositionT, valuesBraceClosePositionT, isReturningPresentT, nativeQueriesList.size())));
                        }
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    prevCommandTypeT = curCommandTypeT;
                    isReturningPresentPrevT = isReturningPresentT;
                    curCommandTypeT = SqlCommandType.BLANK;
                    isReturningPresentT = false;
                    if (!splitStatementsT) break;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (bindPositionsList != null) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        bindPositionsList.clear();
                    }
                    if (bindParamNamesList != null) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        bindParamNamesList.clear();
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _nativeSql.setLength(0);
                    isValuesFoundT = false;
                    isCurrentReWriteCompatibleT = false;
                    valuesBraceOpenPositionT = -1;
                    valuesBraceClosePositionT = -1;
                    valuesBraceCloseFoundT = false;
                    break;
                }
                default: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (_keywordStart >= 0) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        isKeyWordChar = Parser.isIdentifierContChar(aChar);
                        break;
                    }
                    isKeyWordChar = Parser.isIdentifierStartChar(aChar);
                    if (!isKeyWordChar) break;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _keywordStart = i;
                    if (valuesBraceOpenPositionT == -1 || inParenthesisT != 0) break;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    valuesBraceCloseFoundT = true;
                }
            }
            if (!(_keywordStart < 0 || i != arrayChars.length - 1 && isKeyWordChar)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int wordLength = (isKeyWordChar ? i + 1 : _keywordEnd) - _keywordStart;
                if (curCommandTypeT == SqlCommandType.BLANK) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (wordLength == 6 && Parser.parseUpdateKeyword(arrayChars, _keywordStart)) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        curCommandTypeT = SqlCommandType.UPDATE;
                    } else if (wordLength == 6 && Parser.parseDeleteKeyword(arrayChars, _keywordStart)) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        curCommandTypeT = SqlCommandType.DELETE;
                    } else if (wordLength == 4 && Parser.parseMoveKeyword(arrayChars, _keywordStart)) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        curCommandTypeT = SqlCommandType.MOVE;
                    } else if (wordLength == 6 && Parser.parseSelectKeyword(arrayChars, _keywordStart)) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        curCommandTypeT = SqlCommandType.SELECT;
                    } else if (wordLength == 4 && Parser.parseWithKeyword(arrayChars, _keywordStart)) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        curCommandTypeT = SqlCommandType.WITH;
                    } else if (wordLength == 5 && Parser.parseMergeKeyword(arrayChars, _keywordStart)) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        curCommandTypeT = SqlCommandType.MERGE;
                    } else if (wordLength == 6 && Parser.parseInsertKeyword(arrayChars, _keywordStart)) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if (!isInsertPresentT && (nativeQueriesList == null || nativeQueriesList.isEmpty())) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            isCurrentReWriteCompatibleT = _keyWordCount == 0;
                            isInsertPresentT = true;
                            curCommandTypeT = SqlCommandType.INSERT;
                        } else {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            isCurrentReWriteCompatibleT = false;
                        }
                    }
                } else if (curCommandTypeT == SqlCommandType.WITH && inParenthesisT == 0) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    SqlCommandType command = Parser.parseWithCommandType(arrayChars, i, _keywordStart, wordLength);
                    if (command != null) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        curCommandTypeT = command;
                    }
                }
                if (inParenthesisT != 0 || aChar == ')') {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                } else if (wordLength == 9 && Parser.parseReturningKeyword(arrayChars, _keywordStart)) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    isReturningPresentT = true;
                } else if (wordLength == 6 && Parser.parseValuesKeyword(arrayChars, _keywordStart)) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    isValuesFoundT = true;
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                _keywordStart = -1;
                ++_keyWordCount;
            }
            if (aChar != '(') continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (++inParenthesisT != 1 || !isValuesFoundT || valuesBraceOpenPositionT != -1) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            valuesBraceOpenPositionT = _nativeSql.length() + i - fragmentStartT;
        }
        if (!isValuesFoundT || !isCurrentReWriteCompatibleT || valuesBraceClosePositionT == -1 || bindPositionsList != null && valuesBraceClosePositionT < (Integer)bindPositionsList.get(bindPositionsList.size() - 1)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            valuesBraceOpenPositionT = -1;
            valuesBraceClosePositionT = -1;
        }
        if (fragmentStartT < arrayChars.length && !whitespaceOnlyT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _nativeSql.append(arrayChars, fragmentStartT, arrayChars.length - fragmentStartT);
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (numberOfStatements > 1) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                isReturningPresentT = false;
                curCommandTypeT = SqlCommandType.BLANK;
            } else if (numberOfStatements == 1) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                isReturningPresentT = isReturningPresentPrevT;
                curCommandTypeT = prevCommandTypeT;
            }
        }
        if (_nativeSql.length() == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return nativeQueriesList != null ? nativeQueriesList : Collections.emptyList();
        }
        if (Parser.addReturning(_nativeSql, curCommandTypeT, returningColNames, isReturningPresentT)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            isReturningPresentT = true;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        NativeQuery lastQuery = new NativeQuery(_nativeSql.toString(), Parser.toIntArray((List<Integer>)bindPositionsList), bindParamNamesList, !splitStatementsT, SqlCommand.createStatementTypeInfo(curCommandTypeT, isBatchedReWriteConfiguredT, valuesBraceOpenPositionT, valuesBraceClosePositionT, isReturningPresentT, nativeQueriesList == null ? 0 : nativeQueriesList.size()));
        if (nativeQueriesList == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return Collections.singletonList(lastQuery);
        }
        if (!whitespaceOnlyT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            nativeQueriesList.add(lastQuery);
        }
        return nativeQueriesList;
    }

    private static SqlCommandType parseWithCommandType(char[] arrayChars, int i, int _keywordStart, int wordLength) {
        int nextIndexT;
        SqlCommandType sqlCommandType;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (wordLength == 6 && Parser.parseUpdateKeyword(arrayChars, _keywordStart)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sqlCommandType = SqlCommandType.UPDATE;
        } else if (wordLength == 6 && Parser.parseDeleteKeyword(arrayChars, _keywordStart)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sqlCommandType = SqlCommandType.DELETE;
        } else if (wordLength == 6 && Parser.parseInsertKeyword(arrayChars, _keywordStart)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sqlCommandType = SqlCommandType.INSERT;
        } else if (wordLength == 6 && Parser.parseSelectKeyword(arrayChars, _keywordStart)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sqlCommandType = SqlCommandType.SELECT;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return null;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (nextIndexT = i; nextIndexT < arrayChars.length; ++nextIndexT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            char nextCharT = arrayChars[nextIndexT];
            if (nextCharT == '-') {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                nextIndexT = Parser.parseLineComment(arrayChars, nextIndexT);
                continue;
            }
            if (nextCharT == '/') {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                nextIndexT = Parser.parseBlockComment(arrayChars, nextIndexT);
                continue;
            }
            if (Character.isWhitespace(nextCharT)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                continue;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            break;
        }
        if (nextIndexT + 2 >= arrayChars.length || !Parser.parseAsKeyword(arrayChars, nextIndexT) || Parser.isIdentifierContChar(arrayChars[nextIndexT + 2])) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return sqlCommandType;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return null;
    }

    private static boolean addReturning(StringBuilder nativeSqlStringBuilder, SqlCommandType curSqlCommandType, String[] returningColNameArray, boolean isReturningPresentT) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (isReturningPresentT || returningColNameArray.length == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        if (curSqlCommandType != SqlCommandType.INSERT && curSqlCommandType != SqlCommandType.UPDATE && curSqlCommandType != SqlCommandType.DELETE && curSqlCommandType != SqlCommandType.WITH) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        nativeSqlStringBuilder.append("\nRETURNING ");
        if (returningColNameArray.length == 1 && returningColNameArray[0].charAt(0) == '*') {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            nativeSqlStringBuilder.append('*');
            return true;
        }
        for (int colIndex = 0; colIndex < returningColNameArray.length; ++colIndex) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String _columnName = returningColNameArray[colIndex];
            if (colIndex > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                nativeSqlStringBuilder.append(", ");
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Utils.escapeIdentifier(nativeSqlStringBuilder, _columnName);
        }
        return true;
    }

    public static String removeCallRemarks(String callStatement) {
        StringBuilder sb = new StringBuilder();
        int length = callStatement.length();
        int remarkCount = 0;
        int index = 0;
        while (index < length) {
            if (index < length - 1) {
                char c = callStatement.charAt(index);
                char c2 = callStatement.charAt(index + 1);
                if (c == '/' && c2 == '*') {
                    ++remarkCount;
                    index += 2;
                    continue;
                }
                if (c == '*' && c2 == '/') {
                    --remarkCount;
                    index += 2;
                    continue;
                }
                if (remarkCount == 0) {
                    sb.append(c);
                }
            } else if (remarkCount == 0) {
                sb.append(callStatement.charAt(index));
            }
            ++index;
        }
        return sb.toString();
    }

    private static int[] toIntArray(List<Integer> _list) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_list == null || _list.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return NO_BINDS;
        }
        int[] res = new int[_list.size()];
        for (int i = 0; i < _list.size(); ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            res[i] = _list.get(i);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return res;
    }

    public static int parseSingleQuotes(char[] queryT, int offsetT, boolean standardConformingStrings) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (standardConformingStrings && offsetT >= 2 && (queryT[offsetT - 1] == 'e' || queryT[offsetT - 1] == 'E') && Parser.charTerminatesIdentifier(queryT[offsetT - 2])) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            standardConformingStrings = false;
        }
        if (standardConformingStrings) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            while (++offsetT < queryT.length) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                switch (queryT[offsetT]) {
                    case '\'': {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        return offsetT;
                    }
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            block8: while (++offsetT < queryT.length) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                switch (queryT[offsetT]) {
                    case '\'': {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        return offsetT;
                    }
                    case '\\': {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        ++offsetT;
                        continue block8;
                    }
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return queryT.length;
    }

    public static int parseDoubleQuotes(char[] query, int _offset) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        while (++_offset < query.length && query[_offset] != '\"') {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        return _offset;
    }

    public static int parseDollarQuotes(char[] queryCharArray, int offsetIndex) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (!(offsetIndex + 1 >= queryCharArray.length || offsetIndex != 0 && Parser.isIdentifierContChar(queryCharArray[offsetIndex - 1]))) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int endIndex = -1;
            if (queryCharArray[offsetIndex + 1] == '$') {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                endIndex = offsetIndex + 1;
            } else if (Parser.isDollarQuoteStartChar(queryCharArray[offsetIndex + 1])) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                for (int k = offsetIndex + 2; k < queryCharArray.length; ++k) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if ('$' == queryCharArray[k]) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        endIndex = k;
                        break;
                    }
                    if (Parser.isDollarQuoteContChar(queryCharArray[k])) continue;
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    break;
                }
            }
            if (endIndex > 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int tagIdx = offsetIndex;
                int tagLen = endIndex - offsetIndex + 1;
                offsetIndex = endIndex;
                ++offsetIndex;
                while (offsetIndex < queryCharArray.length) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (queryCharArray[offsetIndex] == '$' && Parser.subArraysEqual(queryCharArray, tagIdx, offsetIndex, tagLen)) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        offsetIndex += tagLen - 1;
                        break;
                    }
                    ++offsetIndex;
                }
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return offsetIndex;
    }

    public static int parseLineComment(char[] query, int _offset) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (_offset + 1 < query.length && query[_offset + 1] == '-') {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            while (_offset + 1 < query.length) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (query[++_offset] != '\r' && query[_offset] != '\n') continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                break;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return _offset;
    }

    public static int parseBlockComment(char[] queryT, int offsetT) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (offsetT + 1 < queryT.length && queryT[offsetT + 1] == '*') {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int levelT = 1;
            offsetT += 2;
            while (offsetT < queryT.length) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                switch (queryT[offsetT - 1]) {
                    case '*': {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if (queryT[offsetT] != '/') break;
                        --levelT;
                        ++offsetT;
                        break;
                    }
                    case '/': {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if (queryT[offsetT] != '*') break;
                        ++levelT;
                        ++offsetT;
                        break;
                    }
                    default: {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    }
                }
                if (levelT == 0) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    --offsetT;
                    break;
                }
                ++offsetT;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return offsetT;
    }

    public static boolean parseDeleteKeyword(char[] query, int _offset) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (query.length < _offset + 6) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (query[_offset] | 0x20) == 100 && (query[_offset + 1] | 0x20) == 101 && (query[_offset + 2] | 0x20) == 108 && (query[_offset + 3] | 0x20) == 101 && (query[_offset + 4] | 0x20) == 116 && (query[_offset + 5] | 0x20) == 101;
    }

    public static boolean parseInsertKeyword(char[] query, int _offset) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (query.length < _offset + 7) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (query[_offset] | 0x20) == 105 && (query[_offset + 1] | 0x20) == 110 && (query[_offset + 2] | 0x20) == 115 && (query[_offset + 3] | 0x20) == 101 && (query[_offset + 4] | 0x20) == 114 && (query[_offset + 5] | 0x20) == 116;
    }

    public static boolean parseMergeKeyword(char[] query, int _offset) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (query.length < _offset + 5) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (query[_offset] | 0x20) == 109 && (query[_offset + 1] | 0x20) == 101 && (query[_offset + 2] | 0x20) == 114 && (query[_offset + 3] | 0x20) == 103 && (query[_offset + 4] | 0x20) == 101;
    }

    public static boolean parseMoveKeyword(char[] query, int _offset) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (query.length < _offset + 4) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (query[_offset] | 0x20) == 109 && (query[_offset + 1] | 0x20) == 111 && (query[_offset + 2] | 0x20) == 118 && (query[_offset + 3] | 0x20) == 101;
    }

    public static boolean parseReturningKeyword(char[] query, int _offset) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (query.length < _offset + 9) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (query[_offset] | 0x20) == 114 && (query[_offset + 1] | 0x20) == 101 && (query[_offset + 2] | 0x20) == 116 && (query[_offset + 3] | 0x20) == 117 && (query[_offset + 4] | 0x20) == 114 && (query[_offset + 5] | 0x20) == 110 && (query[_offset + 6] | 0x20) == 105 && (query[_offset + 7] | 0x20) == 110 && (query[_offset + 8] | 0x20) == 103;
    }

    public static boolean parseSelectKeyword(char[] query, int _offset) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (query.length < _offset + 6) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (query[_offset] | 0x20) == 115 && (query[_offset + 1] | 0x20) == 101 && (query[_offset + 2] | 0x20) == 108 && (query[_offset + 3] | 0x20) == 101 && (query[_offset + 4] | 0x20) == 99 && (query[_offset + 5] | 0x20) == 116;
    }

    public static boolean parseUpdateKeyword(char[] query, int _offset) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (query.length < _offset + 6) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (query[_offset] | 0x20) == 117 && (query[_offset + 1] | 0x20) == 112 && (query[_offset + 2] | 0x20) == 100 && (query[_offset + 3] | 0x20) == 97 && (query[_offset + 4] | 0x20) == 116 && (query[_offset + 5] | 0x20) == 101;
    }

    public static boolean parseValuesKeyword(char[] query, int _offset) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (query.length < _offset + 6) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (query[_offset] | 0x20) == 118 && (query[_offset + 1] | 0x20) == 97 && (query[_offset + 2] | 0x20) == 108 && (query[_offset + 3] | 0x20) == 117 && (query[_offset + 4] | 0x20) == 101 && (query[_offset + 5] | 0x20) == 115;
    }

    public static long parseLong(String str, int beginIdx, int endIdx) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (endIdx - beginIdx > 16) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return Long.parseLong(str.substring(beginIdx, endIdx));
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        long result = Parser.digitAt(str, beginIdx);
        ++beginIdx;
        while (beginIdx < endIdx) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            result = (long)Parser.digitAt(str, beginIdx) + result * 10L;
            ++beginIdx;
        }
        return result;
    }

    public static boolean parseWithKeyword(char[] query, int _offset) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (query.length < _offset + 4) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (query[_offset] | 0x20) == 119 && (query[_offset + 1] | 0x20) == 105 && (query[_offset + 2] | 0x20) == 116 && (query[_offset + 3] | 0x20) == 104;
    }

    public static boolean parseAsKeyword(char[] query, int _offset) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (query.length < _offset + 2) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return (query[_offset] | 0x20) == 97 && (query[_offset + 1] | 0x20) == 115;
    }

    public static boolean isDigitAt(String s, int position) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return position > 0 && position < s.length() && Character.isDigit(s.charAt(position));
    }

    public static int digitAt(String s, int position) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int ch = s.charAt(position) - 48;
        if (ch < 0 || ch > 9) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new NumberFormatException("Input string: \"" + s + "\", position: " + position);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return ch;
    }

    public static boolean isSpace(char ch) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r' || ch == '\f';
    }

    public static boolean isOperatorChar(char ch) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return ",()[].;:+-*/%^<>=~!@#&|`?".indexOf(ch) != -1;
    }

    public static boolean isIdentifierStartChar(char ch) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return Character.isJavaIdentifierStart(ch);
    }

    public static boolean isIdentifierContChar(char ch) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return Character.isJavaIdentifierPart(ch);
    }

    public static boolean charTerminatesIdentifier(char ch) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return ch == '\"' || Parser.isSpace(ch) || Parser.isOperatorChar(ch);
    }

    public static boolean isDollarQuoteStartChar(char ch) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return ch != '$' && Parser.isIdentifierStartChar(ch);
    }

    public static boolean isDollarQuoteContChar(char ch) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return ch != '$' && Parser.isIdentifierContChar(ch);
    }

    private static boolean subArraysEqual(char[] arra, int offA, int offB, int leng) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (offA < 0 || offB < 0 || offA >= arra.length || offB >= arra.length || offA + leng > arra.length || offB + leng > arra.length) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        for (int i = 0; i < leng; ++i) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (arra[offA + i] == arra[offB + i]) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return false;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JdbcCallParseInfo modifyJdbcCall(String jdbcSql, boolean stdStrings, int serVersion, int protocolVersion, EscapeSyntaxCallMode escapeSyntaxCallMode, String storeCase) throws SQLException {
        String suffixT;
        String prefixT;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String _sql = jdbcSql;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean isFunction = false;
        boolean outParamBeforeFunc = false;
        String[] funName = new String[3];
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int leng = jdbcSql.length();
        int stateT = 1;
        boolean inQuotesT = false;
        boolean inEscapeT = false;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int startIdx = -1;
        int endIdx = -1;
        boolean isSynErrT = false;
        int k = 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        block21: while (k < leng && !isSynErrT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            char chrT = jdbcSql.charAt(k);
            switch (stateT) {
                case 1: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (chrT == '{') {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        ++k;
                        ++stateT;
                        continue block21;
                    }
                    if (Character.isWhitespace(chrT)) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        ++k;
                        continue block21;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    k = leng;
                    continue block21;
                }
                case 3: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (chrT == '=') {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        ++k;
                        ++stateT;
                        continue block21;
                    }
                    if (Character.isWhitespace(chrT)) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        ++k;
                        continue block21;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    isSynErrT = true;
                    continue block21;
                }
                case 2: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (chrT == '?') {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        isFunction = true;
                        outParamBeforeFunc = true;
                        ++k;
                        ++stateT;
                        continue block21;
                    }
                    if (chrT == 'c' || chrT == 'C') {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        stateT += 3;
                        continue block21;
                    }
                    if (Character.isWhitespace(chrT)) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        ++k;
                        continue block21;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    isSynErrT = true;
                    continue block21;
                }
                case 4: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (chrT == 'c' || chrT == 'C') {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        ++stateT;
                        continue block21;
                    }
                    if (Character.isWhitespace(chrT)) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        ++k;
                        continue block21;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    isSynErrT = true;
                    continue block21;
                }
                case 5: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if ((chrT == 'c' || chrT == 'C') && k + 4 <= leng && jdbcSql.substring(k, k + 4).equalsIgnoreCase("call")) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        isFunction = true;
                        k += 4;
                        ++stateT;
                        continue block21;
                    }
                    if (Character.isWhitespace(chrT)) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        ++k;
                        continue block21;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    isSynErrT = true;
                    continue block21;
                }
                case 6: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (Character.isWhitespace(chrT)) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        ++stateT;
                        startIdx = ++k;
                        continue block21;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    isSynErrT = true;
                    continue block21;
                }
                case 7: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (chrT == '\'') {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        inQuotesT = !inQuotesT;
                        ++k;
                        continue block21;
                    }
                    if (inQuotesT && chrT == '\\' && !stdStrings) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        k += 2;
                        continue block21;
                    }
                    if (!inQuotesT && chrT == '{') {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        inEscapeT = !inEscapeT;
                        ++k;
                        continue block21;
                    }
                    if (!inQuotesT && chrT == '}') {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if (!inEscapeT) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            endIdx = k++;
                            ++stateT;
                            continue block21;
                        }
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        inEscapeT = false;
                        continue block21;
                    }
                    if (!inQuotesT && chrT == ';') {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        isSynErrT = true;
                        continue block21;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    ++k;
                    continue block21;
                }
                case 8: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (Character.isWhitespace(chrT)) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        ++k;
                        continue block21;
                    }
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    isSynErrT = true;
                    continue block21;
                }
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new IllegalStateException("somehow got into bad state " + stateT);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (k == leng && !isSynErrT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (stateT == 1) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Yylex lex = null;
                boolean begin = false;
                try {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    lex = new Yylex(new CharArrayReader(_sql.toCharArray()));
                    while (true) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        Word w = lex.yylex();
                        if (w.getType() == 0) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            break;
                        }
                        if (begin) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            if (w.getType() != 10) {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                isFunction = true;
                            }
                            break;
                        }
                        if (w.getType() != 116) continue;
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        begin = true;
                    }
                }
                catch (Exception e) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    e.printStackTrace();
                }
                finally {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (lex != null) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        try {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            lex.yyclose();
                        }
                        catch (IOException e) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            e.printStackTrace();
                        }
                    }
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                for (k = 0; k < leng && Character.isWhitespace(jdbcSql.charAt(k)); ++k) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                }
                if (k < leng - 5) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    char chr = jdbcSql.charAt(k);
                    if ((chr == 'c' || chr == 'C') && jdbcSql.substring(k, k + 4).equalsIgnoreCase("call") && Character.isWhitespace(jdbcSql.charAt(k + 4))) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        isFunction = true;
                        funName = Parser.getFunctionName(jdbcSql, storeCase);
                    }
                }
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return new JdbcCallParseInfo(_sql, isFunction, outParamBeforeFunc, funName[0], funName[1], funName[2]);
            }
            if (stateT != 8) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                isSynErrT = true;
            }
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (isSynErrT) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Malformed function or procedure escape syntax at _offset {0}.", k), KSQLState.STATEMENT_NOT_ALLOWED_IN_FUNCTION_CALL);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (escapeSyntaxCallMode == EscapeSyntaxCallMode.E_SELECT_MODE || serVersion < 110000 || outParamBeforeFunc && escapeSyntaxCallMode == EscapeSyntaxCallMode.E_CALL_IF_NO_RETURN_MODE) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            prefixT = "select * from ";
            suffixT = " as result";
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            prefixT = "call ";
            suffixT = "";
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        String str = jdbcSql.substring(startIdx, endIdx);
        int prefixLengthT = prefixT.length();
        StringBuilder sbu = new StringBuilder(prefixLengthT + jdbcSql.length() + suffixT.length() + 10);
        sbu.append(prefixT);
        sbu.append(str);
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int opening = str.indexOf(40) + 1;
        if (opening == 0) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            sbu.append(outParamBeforeFunc ? "(?)" : "()");
        } else if (outParamBeforeFunc) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            boolean needComma = false;
            for (int j = opening + prefixLengthT; j < sbu.length(); ++j) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                char ch = sbu.charAt(j);
                if (ch == ')') {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    break;
                }
                if (Character.isWhitespace(ch)) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                needComma = true;
                break;
            }
            if (needComma) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                sbu.insert(opening + prefixLengthT, "?,");
            } else {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                sbu.insert(opening + prefixLengthT, "?");
            }
        }
        if (!suffixT.isEmpty()) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = sbu.append(suffixT).toString();
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            _sql = sbu.toString();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        funName = Parser.getFunctionName(jdbcSql, storeCase);
        return new JdbcCallParseInfo(_sql, isFunction, outParamBeforeFunc, funName[0], funName[1], funName[2]);
    }

    public static String[] getFunctionName(String _sql, String storeCase) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int beginIndex = _sql.toLowerCase().indexOf("call");
        beginIndex = Parser.skipBlank(_sql, beginIndex + 4);
        int endInd = _sql.indexOf("(");
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        endInd = endInd < 0 ? _sql.length() : endInd;
        String name = _sql.substring(beginIndex, endInd).trim();
        int i = name.indexOf(".");
        String schemaName = null;
        String functionName = null;
        String origFuncName = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (i == -1) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            schemaName = null;
            functionName = Parser.removeDQuotes(name, storeCase);
            origFuncName = name;
        } else {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (name.startsWith("\"")) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                int j = Parser.parseDoubleQuotes(name.toCharArray(), 0);
                if (i < j) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    i = name.indexOf(".", j);
                }
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            schemaName = Parser.removeDQuotes(name.substring(0, i), storeCase);
            functionName = Parser.removeDQuotes(name.substring(i + 1), storeCase);
            origFuncName = name.substring(i + 1);
        }
        return new String[]{schemaName, functionName, origFuncName};
    }

    private static String removeDQuotes(String str, String storeCase) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean hasDQuotes = false;
        if (str.startsWith("\"")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            hasDQuotes = true;
            str = str.substring(1);
        }
        if (str.endsWith("\"")) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            str = str.substring(0, str.length() - 1);
        }
        return hasDQuotes ? str : ("upper".equals(storeCase) ? str.toUpperCase() : str.toLowerCase());
    }

    public static String replaceProcessing(String _sql, boolean replaceProcessingEnabled, boolean standardConformingStrings) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (replaceProcessingEnabled) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            int leng = _sql.length();
            char[] characters = _sql.toCharArray();
            StringBuilder new_sql = new StringBuilder(leng);
            int i = 0;
            while (i < leng) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if ((i = Parser.parseSql(characters, i, new_sql, false, standardConformingStrings)) >= leng) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                new_sql.append(characters[i]);
                ++i;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return new_sql.toString();
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        return _sql;
    }

    private static int parseSql(char[] _sql, int index, StringBuilder new_sql, boolean stopOnComma, boolean stdStrings) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ESqlParseState sqlParseState = ESqlParseState.IN_SQLCODE_T;
        int leng = _sql.length;
        int nestedParenthesisT = 0;
        boolean endOfNestedT = false;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        --index;
        while (!endOfNestedT && ++index < leng) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            char ch = _sql[index];
            block0 : switch (sqlParseState) {
                case IN_SQLCODE_T: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (ch == '$') {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        int i0 = index;
                        index = Parser.parseDollarQuotes(_sql, index);
                        Parser.checkParsePosition(index, leng, i0, _sql, "Unterminated dollar quote started at position {0} in SQL {1}. Expected terminating $$");
                        new_sql.append(_sql, i0, index - i0 + 1);
                        break;
                    }
                    if (ch == '\'') {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        int i0 = index;
                        index = Parser.parseSingleQuotes(_sql, index, stdStrings);
                        Parser.checkParsePosition(index, leng, i0, _sql, "Unterminated string literal started at position {0} in SQL {1}. Expected ' char");
                        new_sql.append(_sql, i0, index - i0 + 1);
                        break;
                    }
                    if (ch == '\"') {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        int i0 = index;
                        index = Parser.parseDoubleQuotes(_sql, index);
                        Parser.checkParsePosition(index, leng, i0, _sql, "Unterminated identifier started at position {0} in SQL {1}. Expected \" char");
                        new_sql.append(_sql, i0, index - i0 + 1);
                        break;
                    }
                    if (ch == '/') {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        int i0 = index;
                        index = Parser.parseBlockComment(_sql, index);
                        Parser.checkParsePosition(index, leng, i0, _sql, "Unterminated block comment started at position {0} in SQL {1}. Expected */ sequence");
                        new_sql.append(_sql, i0, index - i0 + 1);
                        break;
                    }
                    if (ch == '-') {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        int i0 = index;
                        index = Parser.parseLineComment(_sql, index);
                        new_sql.append(_sql, i0, index - i0 + 1);
                        break;
                    }
                    if (ch == '(') {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        ++nestedParenthesisT;
                    } else if (ch == ')') {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        if (--nestedParenthesisT < 0) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            endOfNestedT = true;
                            break;
                        }
                    } else {
                        if (stopOnComma && ch == ',' && nestedParenthesisT == 0) {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            endOfNestedT = true;
                            break;
                        }
                        if (ch == '{') {
                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                            if (index + 1 < leng) {
                                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                ESqlParseState[] availableStates = ESqlParseState.VALUES;
                                for (int j = 1; j < availableStates.length; ++j) {
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                    ESqlParseState availableStateT = availableStates[j];
                                    int matchedPositionT = availableStateT.getMatchedPosition(_sql, index + 1);
                                    if (matchedPositionT != 0) {
                                        index += matchedPositionT;
                                        if (availableStateT.replaceKeywordT != null) {
                                            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                            new_sql.append(availableStateT.replaceKeywordT);
                                        }
                                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                        sqlParseState = availableStateT;
                                        break block0;
                                    }
                                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                                }
                            }
                        }
                    }
                    new_sql.append(ch);
                    break;
                }
                case ESC_FUNCTION_T: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    sqlParseState = ESqlParseState.IN_SQLCODE_T;
                    index = Parser.escapeFunction_(_sql, index, new_sql, stdStrings);
                    break;
                }
                case ESC_ESCAPECHAR_T: 
                case ESC_TIMESTAMP_T: 
                case ESC_DATE_T: 
                case ESC_OUTERJOIN_T: 
                case ESC_TIME_T: {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (ch == '}') {
                        sqlParseState = ESqlParseState.IN_SQLCODE_T;
                        break;
                    }
                    new_sql.append(ch);
                }
            }
        }
        return index;
    }

    private static int findOpenBrace(char[] _sql, int i) {
        int positionArgs;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        for (positionArgs = i; positionArgs < _sql.length && _sql[positionArgs] != '('; ++positionArgs) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }
        return positionArgs;
    }

    private static void checkParsePosition(int i, int leng, int i0, char[] _sql, String message) throws KSQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (i < leng) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return;
        }
        throw new KSQLException(GT.tr(message, i0, new String(_sql)), KSQLState.SYNTAX_ERROR);
    }

    private static int escapeFunction_(char[] _sql, int i, StringBuilder new_sql, boolean stdStrings) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        int argPos = Parser.findOpenBrace(_sql, i);
        if (argPos < _sql.length) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            String functionName = new String(_sql, i, argPos - i).trim();
            i = argPos + 1;
            i = Parser.escapeFunctionArguments(new_sql, functionName, _sql, i, stdStrings);
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ++i;
        while (i < _sql.length && _sql[i] != '}') {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            new_sql.append(_sql[i++]);
        }
        return i;
    }

    private static int escapeFunctionArguments(StringBuilder new_sql, String functionName, char[] _sql, int i, boolean stdStrings) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        ArrayList<StringBuilder> parsedArgsList = new ArrayList<StringBuilder>(3);
        while (true) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            StringBuilder stringBuilder = new StringBuilder();
            int lastPosT = ++i;
            i = Parser.parseSql(_sql, i, stringBuilder, true, stdStrings);
            if (i != lastPosT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                parsedArgsList.add(stringBuilder);
            }
            if (i >= _sql.length || _sql[i] != ',') break;
        }
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Method mtd = KBEscapedFunctions2.getFunction(functionName);
        if (mtd == null) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            new_sql.append(functionName);
            KBEscapedFunctions2.appendCall(new_sql, "(", ",", ")", parsedArgsList);
            return i;
        }
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            mtd.invoke(null, new_sql, parsedArgsList);
        }
        catch (InvocationTargetException invocationTargetException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            Throwable targetException = invocationTargetException.getTargetException();
            if (targetException instanceof SQLException) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                throw (SQLException)targetException;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(targetException.getMessage(), KSQLState.SYSTEM_ERROR);
        }
        catch (IllegalAccessException illegalAccessException) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(illegalAccessException.getMessage(), KSQLState.SYSTEM_ERROR);
        }
        return i;
    }

    public static int skipBlank(String sqstr, int temp_index) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        while (temp_index < sqstr.length() && (sqstr.charAt(temp_index) == ' ' || sqstr.charAt(temp_index) == '\n' || sqstr.charAt(temp_index) == '\t' || sqstr.charAt(temp_index) == '\r')) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            ++temp_index;
        }
        return temp_index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector<Integer> findoutFunctionBodyRange_index(String query) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        Vector<Integer> funbody_index = new Vector<Integer>(100);
        boolean _flag = false;
        Yylex lex = null;
        Word pre = null;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        try {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            lex = new Yylex(new CharArrayReader(query.toCharArray()));
            while (true) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                Word w = lex.yylex();
                if (w.getType() == 0) {
                    break;
                }
                if (w.getType() == 116) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    _flag = true;
                    break;
                }
                if (w.getType() == 200 && (w.getText().equalsIgnoreCase("package") || w.getText().equalsIgnoreCase("type"))) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    if (pre.getType() == 101 || pre.getType() == 200 && pre.getText().equalsIgnoreCase("replace")) {
                        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                        _flag = true;
                        break;
                    }
                }
                pre = w;
            }
        }
        catch (Exception e) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            e.printStackTrace();
        }
        finally {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (lex != null) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                try {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    lex.yyclose();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (_flag) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            funbody_index.add(0);
            funbody_index.add(query.length());
        }
        return funbody_index;
    }

    private static boolean isInfunctionbody(int i, Vector<Integer> funbody_index) {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        boolean bInfunbody = false;
        int funbodystart = 0;
        int funbodyend = 0;
        int looperation = 0;
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        while (looperation < funbody_index.size() && i >= funbody_index.get(looperation)) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (i == funbody_index.get(looperation)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                bInfunbody = false;
                break;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            funbodystart = looperation++;
            funbodyend = funbodystart + 1;
            if (funbodyend != 0 && funbodyend < funbody_index.size() && funbodyend % 2 != 0) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                bInfunbody = true;
                continue;
            }
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            bInfunbody = false;
        }
        return bInfunbody;
    }

    private static boolean isColonParamNameChar(char ch) {
        return Character.isLetterOrDigit(ch) || ch == '_';
    }

    private static int parseColonParamName(char[] query, int _offset) throws SQLException {
        TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        if (++_offset >= query.length || !Character.isLetterOrDigit(query[_offset])) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            return _offset - 1;
        }
        int length = 0;
        while (++_offset < query.length) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (!Parser.isColonParamNameChar(query[_offset])) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                break;
            }
            if (++length <= 62) continue;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            throw new KSQLException(GT.tr("Bind Param Name {0} Too Long", String.valueOf(query, _offset - (length + 1), length + 2)), KSQLState.INVALID_NAME);
        }
        return _offset;
    }

    static /* synthetic */ char[] access$300() {
        return SINGLE_QUOTE_T;
    }

    static /* synthetic */ char[] access$400() {
        return QUOTE_OR_ALPHABETIC_MARKER_T;
    }

    static /* synthetic */ char[] access$500() {
        return QUOTE_OR_ALPHABETIC_MARKER_OR_PARENTHESIS_T;
    }

    private static enum ESqlParseState {
        IN_SQLCODE_T,
        ESC_DATE_T("d", Parser.access$300(), "DATE "),
        ESC_TIME_T("t", Parser.access$300(), "TIME "),
        ESC_TIMESTAMP_T("ts", Parser.access$300(), "TIMESTAMP "),
        ESC_FUNCTION_T("fn", Parser.access$400(), null),
        ESC_OUTERJOIN_T("oj", Parser.access$500(), null),
        ESC_ESCAPECHAR_T("escape", Parser.access$300(), "ESCAPE ");

        private static final ESqlParseState[] VALUES;
        private final char[] escapeKeywordT;
        private final char[] allowedValuesT;
        private final String replaceKeywordT;

        private ESqlParseState() {
            this("", new char[0], null);
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
        }

        private ESqlParseState(String escapeKeyword, char[] allowedValues, String replaceKeyword) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            this.escapeKeywordT = escapeKeyword.toCharArray();
            this.allowedValuesT = allowedValues;
            this.replaceKeywordT = replaceKeyword;
        }

        private boolean startMatches(char[] _sql, int position) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            for (char ch : this.escapeKeywordT) {
                char curr;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (position >= _sql.length) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return false;
                }
                if ((curr = _sql[position++]) == ch || curr == Character.toUpperCase(ch)) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return false;
            }
            return position < _sql.length;
        }

        private int getMatchedPosition(char[] _sql, int position) {
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            if (!this.startMatches(_sql, position)) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return 0;
            }
            int newPos = position + this.escapeKeywordT.length;
            TraceLogger.logLineInfo(Level.ALL, "lineInfo");
            char curr = _sql[newPos];
            while (curr == ' ') {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (++newPos >= _sql.length) {
                    TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                    return 0;
                }
                curr = _sql[newPos];
            }
            for (char ch : this.allowedValuesT) {
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                if (curr != ch && (ch != '0' || !Character.isLetter(curr))) continue;
                TraceLogger.logLineInfo(Level.ALL, "lineInfo");
                return newPos - position;
            }
            return 0;
        }

        static {
            VALUES = ESqlParseState.values();
        }
    }
}

