/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import com.jcraft.jzlib.ZInputStream;
import com.jcraft.jzlib.ZOutputStream;
import dm.jdbc.driver.DBError;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xerial.snappy.Snappy;

public class JZipUtil {
    public static byte[] compress(byte[] object, int compressAlgorithm) {
        try {
            if (compressAlgorithm == 1) {
                return Snappy.compress((byte[])object);
            }
            return JZipUtil.jzlibCompress(object);
        }
        catch (Throwable e2) {
            DBError.throwRuntimeException("compress error!", e2);
            return new byte[0];
        }
    }

    public static byte[] uncompress(byte[] srcBytes, int compressID) {
        try {
            if (compressID == 1) {
                return Snappy.uncompress((byte[])srcBytes);
            }
            return JZipUtil.jzlibUncompress(srcBytes);
        }
        catch (Throwable e2) {
            DBError.throwRuntimeException("uncompress error!", e2);
            return new byte[0];
        }
    }

    public static byte[] jzlibCompress(byte[] srcBytes) {
        byte[] data = null;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ZOutputStream zOut = new ZOutputStream((OutputStream)out, -1);
            DataOutputStream objOut = new DataOutputStream((OutputStream)zOut);
            objOut.write(srcBytes);
            objOut.flush();
            zOut.close();
            data = out.toByteArray();
            out.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return data;
    }

    public static byte[] jzlibUncompress(byte[] srcBytes) {
        byte[] data = null;
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(srcBytes);
            ZInputStream zIn = new ZInputStream((InputStream)in);
            byte[] buf = new byte[1024];
            int num = -1;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((num = zIn.read(buf, 0, buf.length)) != -1) {
                baos.write(buf, 0, num);
            }
            data = baos.toByteArray();
            baos.flush();
            baos.close();
            zIn.close();
            in.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return data;
    }

    public static void main(String[] args) {
        String str = "\u4e2d\u56fd\u4e2d\u56fd\u4e2d\u56fd\u4e2d\u56fd\u4e2d\u56fd\u4e2d\u56fd\u4e2d\u56fd\u4e2d\u56fd\u4e2d\u56fd\u4e2d\u56fd\u4e2d\u56fd";
        byte[] original = str.getBytes();
        byte[] comp = new byte[100];
        byte[] compIn = null;
        byte[] uncomp = null;
        System.out.println("\u539f\u59cb\u6570\u636e\uff1a");
        int i2 = 0;
        while (i2 < original.length) {
            System.out.print(String.valueOf(original[i2]) + " ");
            ++i2;
        }
        System.out.println();
        System.out.println("<\u65b9\u6cd51>");
        comp = JZipUtil.jzlibCompress(original);
        long length = comp.length;
        System.out.println("\u538b\u7f29\u540e\u7684\u6570\u636e\uff1a");
        i2 = 0;
        while ((long)i2 < length) {
            System.out.print(String.valueOf(comp[i2]) + " ");
            ++i2;
        }
        compIn = new byte[(int)length];
        i2 = 0;
        while ((long)i2 < length) {
            compIn[i2] = comp[i2];
            ++i2;
        }
        uncomp = JZipUtil.jzlibUncompress(compIn);
        System.out.println("\n\u89e3\u538b\u540e\u7684\u6570\u636e\uff1a");
        i2 = 0;
        while (i2 < uncomp.length) {
            System.out.print(String.valueOf(uncomp[i2]) + " ");
            ++i2;
        }
        System.out.println();
        System.out.println("<\u65b9\u6cd52>");
        byte[] jzlib = JZipUtil.jzlibCompress(original);
        System.out.println("\u538b\u7f29\u540e\u7684\u6570\u636e\uff1a");
        int i3 = 0;
        while (i3 < jzlib.length) {
            System.out.print(String.valueOf(jzlib[i3]) + " ");
            ++i3;
        }
        byte[] unjzlib = JZipUtil.jzlibUncompress(jzlib);
        System.out.println("\n\u89e3\u538b\u540e\u7684\u6570\u636e\uff1a");
        int i4 = 0;
        while (i4 < unjzlib.length) {
            System.out.print(String.valueOf(unjzlib[i4]) + " ");
            ++i4;
        }
    }
}

