/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.sqlengine.aeprocessor.aebuilder.relation;

import com.cloudera.sqlengine.aeprocessor.AEQColumnName;
import com.cloudera.sqlengine.aeprocessor.aebuilder.AEBuilderBase;
import com.cloudera.sqlengine.aeprocessor.aebuilder.AEBuilderCheck;
import com.cloudera.sqlengine.aeprocessor.aebuilder.AEQueryScope;
import com.cloudera.sqlengine.aeprocessor.aebuilder.value.AEColumnReferenceBuilder;
import com.cloudera.sqlengine.aeprocessor.aebuilder.value.AEValueExprBuilder;
import com.cloudera.sqlengine.aeprocessor.aetree.AEDefaultVisitor;
import com.cloudera.sqlengine.aeprocessor.aetree.AESortSpec;
import com.cloudera.sqlengine.aeprocessor.aetree.IAENode;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AEProject;
import com.cloudera.sqlengine.aeprocessor.aetree.relation.AESort;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEColumnReference;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AECountStarAggrFn;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEGeneralAggrFn;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AELiteral;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEParameter;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AESearchedCase;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AESimpleCase;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEValueExpr;
import com.cloudera.sqlengine.aeprocessor.aetree.value.AEValueExprList;
import com.cloudera.sqlengine.exceptions.InvalidQueryException;
import com.cloudera.sqlengine.exceptions.SQLEngineException;
import com.cloudera.sqlengine.exceptions.SQLEngineExceptionFactory;
import com.cloudera.sqlengine.parser.parsetree.IPTNode;
import com.cloudera.sqlengine.parser.parsetree.PTFlagNode;
import com.cloudera.sqlengine.parser.parsetree.PTListNode;
import com.cloudera.sqlengine.parser.parsetree.PTNonterminalNode;
import com.cloudera.sqlengine.parser.type.PTFlagType;
import com.cloudera.sqlengine.parser.type.PTListType;
import com.cloudera.sqlengine.parser.type.PTLiteralType;
import com.cloudera.sqlengine.parser.type.PTNonterminalType;
import com.cloudera.sqlengine.parser.type.PTPositionalType;
import com.cloudera.sqlengine.utilities.SQLEngineMessageKey;
import com.cloudera.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AESortBuilder
extends AEBuilderBase<AESort> {
    private AEProject m_projectNode;

    public AESortBuilder(AEQueryScope aEQueryScope, AEProject aEProject) {
        super(aEQueryScope);
        if (null == aEProject) {
            throw new IllegalArgumentException("projectNode may not be null.");
        }
        this.m_projectNode = aEProject;
    }

    @Override
    public AESort visit(PTListNode pTListNode) throws ErrorException {
        if (null == this.m_projectNode) {
            throw new IllegalStateException("visit called more than once on AESortBuilder.");
        }
        AESortBuilder.checkProjectionListIsValid(pTListNode);
        this.getQueryScope().setCurrentClause(AEQueryScope.ClauseType.ORDER_BY);
        int n = this.m_projectNode.getColumnCount();
        List<AESortSpec> list = this.buildSortSpecificationList(pTListNode);
        AESort aESort = new AESort(this.m_projectNode, list, n);
        this.m_projectNode = null;
        return aESort;
    }

    private List<AESortSpec> buildSortSpecificationList(PTListNode pTListNode) throws ErrorException {
        AEValueExprList aEValueExprList = this.m_projectNode.getProjectionList();
        int n = aEValueExprList.getNumChildren();
        ArrayList<AESortSpec> arrayList = new ArrayList<AESortSpec>(pTListNode.numChildren());
        AEValueExprBuilder aEValueExprBuilder = new AEValueExprBuilder(this.getQueryScope());
        Iterator<IPTNode> iterator = pTListNode.getChildItr();
        while (iterator.hasNext()) {
            PTNonterminalNode pTNonterminalNode = (PTNonterminalNode)iterator.next();
            IPTNode iPTNode = pTNonterminalNode.getChild(PTPositionalType.SORT_KEY);
            boolean bl = AESortBuilder.isOrderSpecAscending(pTNonterminalNode.getChild(PTPositionalType.ORDER_SPEC));
            int n2 = this.findColumnInSelectList(aEValueExprList, iPTNode);
            if (0 > n2) {
                AEValueExpr aEValueExpr = (AEValueExpr)aEValueExprBuilder.build(iPTNode);
                if (aEValueExpr instanceof AELiteral) {
                    n2 = AESortBuilder.decodeColumnNumber((AELiteral)aEValueExpr);
                    if (n2 < 0 || n2 >= n) {
                        throw SQLEngineExceptionFactory.orderByPositionOutOfRangeException();
                    }
                } else {
                    if (aEValueExpr instanceof AEParameter) {
                        throw new SQLEngineException(SQLEngineMessageKey.DYN_PARAM_NOT_ALLOWED.name(), new String[]{"ORDER BY"});
                    }
                    this.validateSortKey(aEValueExpr);
                    n2 = this.resolveColumn(aEValueExprList, aEValueExpr);
                }
            }
            assert (n2 >= 0);
            arrayList.add(new AESortSpec(n2, bl));
        }
        return arrayList;
    }

    private int findColumnInSelectList(AEValueExprList aEValueExprList, IPTNode iPTNode) throws ErrorException {
        AEQColumnName aEQColumnName;
        int n = -1;
        try {
            aEQColumnName = AEColumnReferenceBuilder.buildQualifiedColumnName(this.getQueryScope().getDataEngine().getContext(), iPTNode);
        }
        catch (ErrorException errorException) {
            return n;
        }
        int n2 = aEValueExprList.getNumChildren();
        for (int i = 0; i < n2; ++i) {
            AEValueExpr aEValueExpr = (AEValueExpr)aEValueExprList.getChild(i);
            if (!aEValueExpr.matchesName(aEQColumnName, this.getQueryScope().isCaseSensitive())) continue;
            if (aEValueExpr.isSortable()) {
                if (-1 != n) {
                    throw SQLEngineExceptionFactory.columnReferenceNotUniqueException(aEQColumnName.toString());
                }
                n = i;
                continue;
            }
            throw SQLEngineExceptionFactory.invalidOrderByColumnException(aEQColumnName.toString());
        }
        return n;
    }

    private int resolveColumn(AEValueExprList aEValueExprList, AEValueExpr aEValueExpr) throws InvalidQueryException {
        int n = aEValueExprList.findNode(aEValueExpr);
        if (0 > n) {
            if (this.getQueryScope().hasDistinct()) {
                throw new InvalidQueryException(SQLEngineMessageKey.ORDERBY_EXPR_NOT_IN_SELECT_DISTINCT.name());
            }
            if (this.getQueryScope().hasSetOperation()) {
                throw new InvalidQueryException(SQLEngineMessageKey.ORDERBY_EXPR_NOT_IN_SELECTLIST.name());
            }
            n = aEValueExprList.getNumChildren();
            aEValueExprList.addNode(aEValueExpr);
        }
        return n;
    }

    private void validateSortKey(AEValueExpr aEValueExpr) throws ErrorException {
        AEDefaultVisitor<Boolean> aEDefaultVisitor = new AEDefaultVisitor<Boolean>(){

            @Override
            public Boolean visit(AESearchedCase aESearchedCase) throws ErrorException {
                throw SQLEngineExceptionFactory.invalidOrderByColumnException("CASE");
            }

            @Override
            public Boolean visit(AESimpleCase aESimpleCase) throws ErrorException {
                throw SQLEngineExceptionFactory.invalidOrderByColumnException("CASE");
            }

            @Override
            public Boolean visit(AEColumnReference aEColumnReference) throws ErrorException {
                if (!aEColumnReference.isSortable()) {
                    throw SQLEngineExceptionFactory.invalidOrderByColumnException(aEColumnReference.getQColumnName().toString());
                }
                return true;
            }

            @Override
            public Boolean visit(AEGeneralAggrFn aEGeneralAggrFn) throws ErrorException {
                switch (aEGeneralAggrFn.getAggrFnId()) {
                    case COUNT: 
                    case SUM: {
                        if (!AESortBuilder.this.getQueryScope().hasGroupingExpression()) break;
                        return true;
                    }
                }
                return aEGeneralAggrFn.getOperand().acceptVisitor(this);
            }

            @Override
            public Boolean visit(AECountStarAggrFn aECountStarAggrFn) throws ErrorException {
                return AESortBuilder.this.getQueryScope().hasGroupingExpression();
            }

            @Override
            protected Boolean defaultVisit(IAENode iAENode) throws ErrorException {
                boolean bl = false;
                Iterator<? extends IAENode> iterator = iAENode.getChildItr();
                while (iterator.hasNext()) {
                    IAENode iAENode2 = iterator.next();
                    bl = bl || iAENode2.acceptVisitor(this) != false;
                }
                return bl;
            }
        };
        if (!aEValueExpr.acceptVisitor(aEDefaultVisitor).booleanValue()) {
            throw SQLEngineExceptionFactory.invalidOrderByExprException();
        }
    }

    private static void checkProjectionListIsValid(PTListNode pTListNode) throws ErrorException {
        AEBuilderCheck.ParseTreeMatcher parseTreeMatcher = AEBuilderCheck.nonTerminal(PTNonterminalType.SORT_SPECIFICATION).withExactChildren(PTPositionalType.SORT_KEY, AEBuilderCheck.anything(), PTPositionalType.ORDER_SPEC, AEBuilderCheck.optional(AEBuilderCheck.instanceOf(PTFlagNode.class)));
        AEBuilderCheck.checkThat(pTListNode, AEBuilderCheck.is(AEBuilderCheck.list(PTListType.SORT_SPECIFICATION_LIST)).withChildren(parseTreeMatcher));
    }

    private static int decodeColumnNumber(AELiteral aELiteral) throws ErrorException {
        if (PTLiteralType.USINT != aELiteral.getLiteralType()) {
            throw SQLEngineExceptionFactory.invalidOrderByExprException();
        }
        try {
            int n = Integer.parseInt(aELiteral.getStringValue());
            return n - 1;
        }
        catch (NumberFormatException numberFormatException) {
            throw SQLEngineExceptionFactory.orderByPositionOutOfRangeException();
        }
    }

    private static boolean isOrderSpecAscending(IPTNode iPTNode) {
        if (iPTNode.isEmptyNode()) {
            return true;
        }
        assert (EnumSet.of(PTFlagType.ASC, PTFlagType.DESC).contains((Object)((PTFlagNode)iPTNode).getFlagType()));
        return PTFlagType.ASC == ((PTFlagNode)iPTNode).getFlagType();
    }
}

