/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.hivecommon.dataengine.metadata;

import com.cloudera.dsi.dataengine.filters.IFilter;
import com.cloudera.dsi.dataengine.interfaces.IMetadataSource;
import com.cloudera.dsi.dataengine.utilities.DSITypeUtilities;
import com.cloudera.dsi.dataengine.utilities.DataWrapper;
import com.cloudera.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.cloudera.hivecommon.HiveJDBCSettings;
import com.cloudera.hivecommon.api.IHiveClient;
import com.cloudera.hivecommon.core.HiveJDBCCommonDriver;
import com.cloudera.hivecommon.dataengine.filters.HiveJDBCFilter;
import com.cloudera.hivecommon.dataengine.metadata.HiveCommonTablesMetadataSourceRow;
import com.cloudera.hivecommon.dataengine.metadata.MetadataUtils;
import com.cloudera.hivecommon.exceptions.HiveJDBCMessageKey;
import com.cloudera.support.ILogger;
import com.cloudera.support.LogUtilities;
import com.cloudera.support.exceptions.ErrorException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class HiveJDBCTablesMetadataSource
implements IMetadataSource {
    private ILogger m_logger;
    private boolean m_hasStartedFetch = false;
    private final IHiveClient m_hiveClient;
    private int m_currentIndex = -1;
    private ArrayList<HiveCommonTablesMetadataSourceRow> m_tables = null;
    Map<MetadataSourceColumnTag, String> m_literalRestrictions;
    ArrayList<String> m_restrictionPatterns;
    ArrayList<IFilter> m_filters;
    HiveJDBCSettings m_settings;

    public HiveJDBCTablesMetadataSource(ILogger iLogger, Map<MetadataSourceColumnTag, String> map, ArrayList<String> arrayList, ArrayList<IFilter> arrayList2, IHiveClient iHiveClient, HiveJDBCSettings hiveJDBCSettings) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, iLogger);
        this.m_logger = iLogger;
        this.m_hiveClient = iHiveClient;
        this.m_literalRestrictions = map;
        this.m_restrictionPatterns = arrayList;
        this.m_filters = arrayList2;
        this.m_settings = hiveJDBCSettings;
        this.initTables();
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.closeCursor();
        }
        catch (ErrorException errorException) {
            // empty catch block
        }
    }

    @Override
    public void closeCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_hasStartedFetch = false;
    }

    @Override
    public boolean getMetadata(MetadataSourceColumnTag metadataSourceColumnTag, long l, long l2, DataWrapper dataWrapper) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[]{metadataSourceColumnTag, l, l2});
        switch (metadataSourceColumnTag) {
            case CATALOG_NAME: {
                if (this.m_hiveClient.isSwitchRestrict()) {
                    return DSITypeUtilities.outputVarCharStringData(this.m_tables.get(this.m_currentIndex).getSchemaName(), dataWrapper, l, l2);
                }
                return DSITypeUtilities.outputVarCharStringData(this.m_hiveClient.getCatalogs().get(0), dataWrapper, l, l2);
            }
            case SCHEMA_NAME: {
                if (this.m_hiveClient.isSwitchRestrict()) {
                    return false;
                }
                return DSITypeUtilities.outputVarCharStringData(this.m_tables.get(this.m_currentIndex).getSchemaName(), dataWrapper, l, l2);
            }
            case TABLE_NAME: {
                return DSITypeUtilities.outputVarCharStringData(this.m_tables.get(this.m_currentIndex).getTableName(), dataWrapper, l, l2);
            }
            case TABLE_TYPE: {
                return DSITypeUtilities.outputVarCharStringData(this.m_tables.get(this.m_currentIndex).getTableType(), dataWrapper, l, l2);
            }
            case REMARKS: {
                return DSITypeUtilities.outputVarCharStringData(this.m_tables.get(this.m_currentIndex).getComments(), dataWrapper, l, l2);
            }
        }
        throw HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.METADATA_COLUMN_NOT_FOUND.name(), new String[]{metadataSourceColumnTag.toString()});
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        return !this.m_hasStartedFetch;
    }

    private void initTables() throws ErrorException {
        try {
            if (this.m_settings.m_pushdownCatalogFunctionFilters) {
                this.m_tables = this.m_hiveClient.getTables(this.m_literalRestrictions, this.m_restrictionPatterns);
            }
            if (null != this.m_tables) {
                return;
            }
            String string = MetadataUtils.UnescapeWildCards(MetadataUtils.GetRestriction(this.m_literalRestrictions, this.m_hiveClient.isSwitchRestrict() ? MetadataSourceColumnTag.CATALOG_NAME : MetadataSourceColumnTag.SCHEMA_NAME));
            if (null != string) {
                this.m_tables = this.m_hiveClient.getTables(string);
            } else {
                HiveJDBCFilter hiveJDBCFilter = null;
                for (IFilter object2 : this.m_filters) {
                    if (object2.getColumnTag() != MetadataSourceColumnTag.SCHEMA_NAME) continue;
                    hiveJDBCFilter = new HiveJDBCFilter(object2);
                    break;
                }
                ArrayList<String> arrayList = this.m_hiveClient.getSchemas();
                ArrayList<HiveCommonTablesMetadataSourceRow> arrayList2 = new ArrayList<HiveCommonTablesMetadataSourceRow>();
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    if (!hiveJDBCFilter.filter(string2)) continue;
                    arrayList2.addAll(this.m_hiveClient.getTables(string2));
                }
                this.m_tables = arrayList2;
            }
        }
        catch (Exception exception) {
            if (MetadataUtils.checkForCommunicationLinkFailure(exception)) {
                throw (ErrorException)exception;
            }
            ErrorException errorException = HiveJDBCCommonDriver.s_HiveMessages.createGeneralException(HiveJDBCMessageKey.HIVE_METADATA_TABLE_ERR.name(), "Metadata Initialization Error");
            errorException.initCause(exception);
            throw errorException;
        }
    }

    @Override
    public boolean moveToNextRow() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_currentIndex >= this.m_tables.size() - 1) {
            return false;
        }
        ++this.m_currentIndex;
        if (!this.m_hasStartedFetch) {
            this.m_hasStartedFetch = true;
        }
        return true;
    }
}

