/*
 * Decompiled with CFR 0.152.
 */
package org.opengauss.readwritesplitting;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.opengauss.hostchooser.HostRequirement;
import org.opengauss.jdbc.PgConnection;
import org.opengauss.readwritesplitting.ForceExecuteTemplate;
import org.opengauss.readwritesplitting.MethodInvocationRecorder;
import org.opengauss.readwritesplitting.ReadWriteSplittingHostSpec;
import org.opengauss.readwritesplitting.ReadWriteSplittingPgConnection;
import org.opengauss.util.HostSpec;

public class PgConnectionManager
implements AutoCloseable {
    private final MethodInvocationRecorder<Connection> methodInvocationRecorder = new MethodInvocationRecorder();
    private final ForceExecuteTemplate<PgConnection> forceExecuteTemplate = new ForceExecuteTemplate();
    private final Map<String, PgConnection> cachedConnections = new ConcurrentHashMap<String, PgConnection>();
    private final AtomicReference<PgConnection> currentConnection = new AtomicReference();
    private final Properties props;
    private final String user;
    private final String database;
    private final String url;
    private final ReadWriteSplittingPgConnection readWriteSplittingPgConnection;

    public PgConnectionManager(Properties props, String user, String database, String url, ReadWriteSplittingPgConnection connection) {
        this.props = props;
        this.user = user;
        this.database = database;
        this.url = url;
        this.readWriteSplittingPgConnection = connection;
    }

    public synchronized PgConnection getConnection(HostSpec hostSpec) throws SQLException {
        String cacheKey = this.getCacheKey(hostSpec);
        PgConnection result = this.cachedConnections.get(cacheKey);
        if (result == null) {
            result = this.createConnection(hostSpec, cacheKey);
        }
        this.setCurrentConnection(result);
        return result;
    }

    private PgConnection createConnection(HostSpec hostSpec, String cacheKey) throws SQLException {
        PgConnection result = new PgConnection(new HostSpec[]{hostSpec}, this.user, this.database, this.props, this.url);
        this.methodInvocationRecorder.replay(result);
        this.cachedConnections.put(cacheKey, result);
        return result;
    }

    private void setCurrentConnection(PgConnection result) {
        this.currentConnection.set(result);
    }

    public PgConnection getCurrentConnection() throws SQLException {
        PgConnection result = this.currentConnection.get();
        return result == null ? this.getConnection(this.selectCurrentHostSpec()) : result;
    }

    private HostSpec selectCurrentHostSpec() {
        ReadWriteSplittingHostSpec readWriteHostSpec = this.readWriteSplittingPgConnection.getReadWriteSplittingHostSpec();
        if (HostRequirement.master == readWriteHostSpec.getTargetServerType()) {
            return readWriteHostSpec.getWriteHostSpec();
        }
        if (HostRequirement.secondary == readWriteHostSpec.getTargetServerType()) {
            return readWriteHostSpec.readLoadBalance();
        }
        return readWriteHostSpec.getWriteHostSpec();
    }

    private String getCacheKey(HostSpec hostSpec) {
        return hostSpec.getHost() + ":" + hostSpec.getPort();
    }

    @Override
    public void close() throws SQLException {
        try {
            this.forceExecuteTemplate.execute(this.cachedConnections.values(), PgConnection::close);
        }
        finally {
            this.cachedConnections.clear();
        }
    }

    public void setAutoCommit(boolean isAutoCommit) throws SQLException {
        this.methodInvocationRecorder.record("setAutoCommit", target -> target.setAutoCommit(isAutoCommit));
        this.forceExecuteTemplate.execute(this.cachedConnections.values(), connection -> connection.setAutoCommit(isAutoCommit));
    }

    public void setTransactionIsolation(int level) throws SQLException {
        this.methodInvocationRecorder.record("setTransactionIsolation", connection -> connection.setTransactionIsolation(level));
        this.forceExecuteTemplate.execute(this.cachedConnections.values(), connection -> connection.setTransactionIsolation(level));
    }

    public void setSchema(String schema) throws SQLException {
        this.methodInvocationRecorder.record("setSchema", connection -> connection.setSchema(schema));
        this.forceExecuteTemplate.execute(this.cachedConnections.values(), connection -> connection.setSchema(schema));
    }

    public void commit() throws SQLException {
        this.forceExecuteTemplate.execute(this.cachedConnections.values(), Connection::commit);
    }

    public void rollback() throws SQLException {
        this.forceExecuteTemplate.execute(this.cachedConnections.values(), Connection::rollback);
    }

    public void setReadOnly(boolean isReadOnly) throws SQLException {
        this.methodInvocationRecorder.record("setReadOnly", connection -> connection.setReadOnly(isReadOnly));
        this.forceExecuteTemplate.execute(this.cachedConnections.values(), connection -> connection.setReadOnly(isReadOnly));
    }

    public boolean isValid(int timeout) throws SQLException {
        for (Connection connection : this.cachedConnections.values()) {
            if (connection.isValid(timeout)) continue;
            return false;
        }
        return true;
    }
}

