The .env file is used to store environment variables for the backend server. it contains two sections: Text Processing Configuration and Image Processing Configuration:

## Text Processing Configuration

These variables are used for document (text) processing:

- TEXT_API_END_POINT: Specifies the API endpoint for text processing.
- TEXT_MODEL_NAME: Defines the model to be used for text processing.
- TEXT_API_KEYS: A list containing the API key(s) required for authentication when making requests to the text API
  endpoint. **`Using multiple keys will help in avoiding rate limits.`**

## Image Processing Configuration

These variables are used for image processing:

- IMAGE_API_END_POINT: Specifies the API endpoint for image processing.
- IMAGE_MODEL_NAME: Defines the model used for image processing.
- IMAGE_API_KEYS: A list containing the API key(s) for image processing requests. Using multiple keys will help in avoiding rate limits.


## Examples:

- **GROQ** (Recommended for text processing)

Get your free api key from here: https://console.groq.com/keys
```bash
# API and MODEL used for documents processing
TEXT_API_END_POINT=https://api.groq.com/openai/v1
TEXT_MODEL_NAME=llama3-70b-8192
TEXT_API_KEYS=["gsk_xxx","gsk_yyy"]

# API and MODEL used for images processing
IMAGE_API_END_POINT=https://api.groq.com/openai/v1
IMAGE_MODEL_NAME=llava-v1.5-7b-4096-preview
IMAGE_API_KEYS=["gsk_xxx","gsk_yyy"]
```

- **OPENAI**
```bash
# API and MODEL used for documents processing
TTEXT_API_END_POINT=https://api.openai.com/v1
TTEXT_MODEL_NAME=gpt-4o
TTEXT_API_KEYS=["sk-xxx","sk-yyy"]

# API and MODEL used for images processing
TIMAGE_API_END_POINT=https://api.openai.com/v1
TIMAGE_MODEL_NAME=gpt-4o
TIMAGE_API_KEYS=["sk-xxx","sk-yyy"]
```

- **OLLAMA**
```bash
# API and MODEL used for documents processing
TEXT_API_END_POINT=http://localhost:11434/v1
TEXT_MODEL_NAME=gemma2:latest
TEXT_API_KEYS=["ollama"]

# API and MODEL used for images processing
IMAGE_API_END_POINT=http://localhost:11434/v1
IMAGE_MODEL_NAME=moondream:latest
IMAGE_API_KEYS=["ollama"]
```


- **HUGGING FACE**

Get your free api key from here: https://huggingface.co/settings/tokens

```bash
# API and MODEL used for documents processing
TEXT_API_END_POINT=https://api-inference.huggingface.co/v1
TEXT_MODEL_NAME=microsoft/Phi-3-mini-4k-instruct
TEXT_API_KEYS=["hf_xxx","hf_yyy"]

# API and MODEL used for images processing
IMAGE_API_END_POINT=https://api-inference.huggingface.co/v1
IMAGE_MODEL_NAME=nlpconnect/vit-gpt2-image-captioning
IMAGE_API_KEYS=["hf_xxx","hf_yyy"]
```