package qiniu

import (
	"github.com/7sDream/rikka/plugins"
	"github.com/qiniu/go-sdk/v7/auth/qbox"
	"github.com/qiniu/go-sdk/v7/storage"
)

// plugin type
type qiniuPlugin struct{}

const (
	accessEnvKey = "RIKKA_QINIU_ACCESS"
	secretEnvKey = "RIKKA_QINIU_SECRET"
)

var (
	l = plugins.SubLogger("[Qiniu]")

	access       string
	secret       string
	bucketName   string
	bucketAddr   string
	bucketPrefix string

	conf = &storage.Config{
		Zone:          &storage.ZoneHuadong,
		UseHTTPS:      true,
		UseCdnDomains: true,
	}
	mac *qbox.Mac

	// Plugin is the main plugin instance
	Plugin = qiniuPlugin{}
)

func (qnp qiniuPlugin) ExtraHandlers() []plugins.HandlerWithPattern {
	return nil
}
